// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * An object that represents a scheduling policy.
 */
public class SchedulingPolicyDetail private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the scheduling policy. An example is `arn:<i>aws</i>:batch:<i>us-east-1</i>:<i>123456789012</i>:scheduling-policy/<i>HighPriority</i> `.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The fair share policy for the scheduling policy.
     */
    public val fairsharePolicy: aws.sdk.kotlin.services.batch.model.FairsharePolicy? = builder.fairsharePolicy
    /**
     * The name of the scheduling policy.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The tags that you apply to the scheduling policy to categorize and organize your resources. Each tag consists of a key and an optional value. For more information, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in *Amazon Web Services General Reference*.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.SchedulingPolicyDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SchedulingPolicyDetail(")
        append("arn=$arn,")
        append("fairsharePolicy=$fairsharePolicy,")
        append("name=$name,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (fairsharePolicy?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SchedulingPolicyDetail

        if (arn != other.arn) return false
        if (fairsharePolicy != other.fairsharePolicy) return false
        if (name != other.name) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.SchedulingPolicyDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the scheduling policy. An example is `arn:<i>aws</i>:batch:<i>us-east-1</i>:<i>123456789012</i>:scheduling-policy/<i>HighPriority</i> `.
         */
        public var arn: kotlin.String? = null
        /**
         * The fair share policy for the scheduling policy.
         */
        public var fairsharePolicy: aws.sdk.kotlin.services.batch.model.FairsharePolicy? = null
        /**
         * The name of the scheduling policy.
         */
        public var name: kotlin.String? = null
        /**
         * The tags that you apply to the scheduling policy to categorize and organize your resources. Each tag consists of a key and an optional value. For more information, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in *Amazon Web Services General Reference*.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.SchedulingPolicyDetail) : this() {
            this.arn = x.arn
            this.fairsharePolicy = x.fairsharePolicy
            this.name = x.name
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.SchedulingPolicyDetail = SchedulingPolicyDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.FairsharePolicy] inside the given [block]
         */
        public fun fairsharePolicy(block: aws.sdk.kotlin.services.batch.model.FairsharePolicy.Builder.() -> kotlin.Unit) {
            this.fairsharePolicy = aws.sdk.kotlin.services.batch.model.FairsharePolicy.invoke(block)
        }
    }
}
