// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * Specifies the weights for the fair share identifiers for the fair share policy. Fair share identifiers that aren't included have a default weight of `1.0`.
 */
public class ShareAttributes private constructor(builder: Builder) {
    /**
     * A fair share identifier or fair share identifier prefix. If the string ends with an asterisk (*), this entry specifies the weight factor to use for fair share identifiers that start with that prefix. The list of fair share identifiers in a fair share policy cannot overlap. For example, you can't have one that specifies a `shareIdentifier` of `UserA*` and another that specifies a `shareIdentifier` of `UserA-1`.
     *
     * There can be no more than 500 fair share identifiers active in a job queue.
     *
     * The string is limited to 255 alphanumeric characters, optionally followed by an asterisk (*).
     */
    public val shareIdentifier: kotlin.String? = builder.shareIdentifier
    /**
     * The weight factor for the fair share identifier. The default value is 1.0. A lower value has a higher priority for compute resources. For example, jobs that use a share identifier with a weight factor of 0.125 (1/8) get 8 times the compute resources of jobs that use a share identifier with a weight factor of 1.
     *
     * The smallest supported value is 0.0001, and the largest supported value is 999.9999.
     */
    public val weightFactor: kotlin.Float? = builder.weightFactor

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.ShareAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ShareAttributes(")
        append("shareIdentifier=$shareIdentifier,")
        append("weightFactor=$weightFactor)")
    }

    override fun hashCode(): kotlin.Int {
        var result = shareIdentifier?.hashCode() ?: 0
        result = 31 * result + (weightFactor?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ShareAttributes

        if (shareIdentifier != other.shareIdentifier) return false
        if (weightFactor != other.weightFactor) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.ShareAttributes = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A fair share identifier or fair share identifier prefix. If the string ends with an asterisk (*), this entry specifies the weight factor to use for fair share identifiers that start with that prefix. The list of fair share identifiers in a fair share policy cannot overlap. For example, you can't have one that specifies a `shareIdentifier` of `UserA*` and another that specifies a `shareIdentifier` of `UserA-1`.
         *
         * There can be no more than 500 fair share identifiers active in a job queue.
         *
         * The string is limited to 255 alphanumeric characters, optionally followed by an asterisk (*).
         */
        public var shareIdentifier: kotlin.String? = null
        /**
         * The weight factor for the fair share identifier. The default value is 1.0. A lower value has a higher priority for compute resources. For example, jobs that use a share identifier with a weight factor of 0.125 (1/8) get 8 times the compute resources of jobs that use a share identifier with a weight factor of 1.
         *
         * The smallest supported value is 0.0001, and the largest supported value is 999.9999.
         */
        public var weightFactor: kotlin.Float? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.ShareAttributes) : this() {
            this.shareIdentifier = x.shareIdentifier
            this.weightFactor = x.weightFactor
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.ShareAttributes = ShareAttributes(this)
    }
}
