// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * Contains the parameters for `SubmitJob`.
 */
public class SubmitJobRequest private constructor(builder: Builder) {
    /**
     * The array properties for the submitted job, such as the size of the array. The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. For more information, see [Array Jobs](https://docs.aws.amazon.com/batch/latest/userguide/array_jobs.html) in the *Batch User Guide*.
     */
    public val arrayProperties: aws.sdk.kotlin.services.batch.model.ArrayProperties? = builder.arrayProperties
    /**
     * A list of container overrides in the JSON format that specify the name of a container in the specified job definition and the overrides it receives. You can override the default command for a container, which is specified in the job definition or the Docker image, with a `command` override. You can also override existing environment variables on a container or add new environment variables to it with an `environment` override.
     */
    public val containerOverrides: aws.sdk.kotlin.services.batch.model.ContainerOverrides? = builder.containerOverrides
    /**
     * A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a `SEQUENTIAL` type dependency without specifying a job ID for array jobs so that each child array job completes sequentially, starting at index 0. You can also specify an `N_TO_N` type dependency with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding index child of each dependency to complete before it can begin.
     */
    public val dependsOn: List<JobDependency>? = builder.dependsOn
    /**
     * The job definition used by this job. This value can be one of `name`, `name:revision`, or the Amazon Resource Name (ARN) for the job definition. If `name` is specified without a revision then the latest active revision is used.
     */
    public val jobDefinition: kotlin.String? = builder.jobDefinition
    /**
     * The name of the job. It can be up to 128 letters long. The first character must be alphanumeric, can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * The job queue where the job is submitted. You can specify either the name or the Amazon Resource Name (ARN) of the queue.
     */
    public val jobQueue: kotlin.String? = builder.jobQueue
    /**
     * A list of node overrides in JSON format that specify the node range to target and the container overrides for that node range.
     *
     * This parameter isn't applicable to jobs that are running on Fargate resources; use `containerOverrides` instead.
     */
    public val nodeOverrides: aws.sdk.kotlin.services.batch.model.NodeOverrides? = builder.nodeOverrides
    /**
     * Additional parameters passed to the job that replace parameter substitution placeholders that are set in the job definition. Parameters are specified as a key and value pair mapping. Parameters in a `SubmitJob` request override any corresponding parameter defaults from the job definition.
     */
    public val parameters: Map<String, String>? = builder.parameters
    /**
     * Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task. If no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks during task creation. For tags with the same name, job tags are given priority over job definitions tags. If the total number of combined tags from the job and job definition is over 50, the job is moved to the `FAILED` state. When specified, this overrides the tag propagation setting in the job definition.
     */
    public val propagateTags: kotlin.Boolean? = builder.propagateTags
    /**
     * The retry strategy to use for failed jobs from this SubmitJob operation. When a retry strategy is specified here, it overrides the retry strategy defined in the job definition.
     */
    public val retryStrategy: aws.sdk.kotlin.services.batch.model.RetryStrategy? = builder.retryStrategy
    /**
     * The scheduling priority for the job. This will only affect jobs in job queues with a fair share policy. Jobs with a higher scheduling priority will be scheduled before jobs with a lower scheduling priority. This will override any scheduling priority in the job definition.
     *
     * The minimum supported value is 0 and the maximum supported value is 9999.
     */
    public val schedulingPriorityOverride: kotlin.Int? = builder.schedulingPriorityOverride
    /**
     * The share identifier for the job. If the job queue does not have a scheduling policy, then this parameter must not be specified. If the job queue has a scheduling policy, then this parameter must be specified.
     */
    public val shareIdentifier: kotlin.String? = builder.shareIdentifier
    /**
     * The tags that you apply to the job request to help you categorize and organize your resources. Each tag consists of a key and an optional value. For more information, see [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in *Amazon Web Services General Reference*.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The timeout configuration for this SubmitJob operation. You can specify a timeout duration after which Batch terminates your jobs if they haven't finished. If a job is terminated due to a timeout, it isn't retried. The minimum value for the timeout is 60 seconds. This configuration overrides any timeout configuration specified in the job definition. For array jobs, child jobs have the same timeout configuration as the parent job. For more information, see [Job Timeouts](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/job_timeouts.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val timeout: aws.sdk.kotlin.services.batch.model.JobTimeout? = builder.timeout

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.SubmitJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SubmitJobRequest(")
        append("arrayProperties=$arrayProperties,")
        append("containerOverrides=$containerOverrides,")
        append("dependsOn=$dependsOn,")
        append("jobDefinition=$jobDefinition,")
        append("jobName=$jobName,")
        append("jobQueue=$jobQueue,")
        append("nodeOverrides=$nodeOverrides,")
        append("parameters=$parameters,")
        append("propagateTags=$propagateTags,")
        append("retryStrategy=$retryStrategy,")
        append("schedulingPriorityOverride=$schedulingPriorityOverride,")
        append("shareIdentifier=$shareIdentifier,")
        append("tags=$tags,")
        append("timeout=$timeout)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arrayProperties?.hashCode() ?: 0
        result = 31 * result + (containerOverrides?.hashCode() ?: 0)
        result = 31 * result + (dependsOn?.hashCode() ?: 0)
        result = 31 * result + (jobDefinition?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (jobQueue?.hashCode() ?: 0)
        result = 31 * result + (nodeOverrides?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (propagateTags?.hashCode() ?: 0)
        result = 31 * result + (retryStrategy?.hashCode() ?: 0)
        result = 31 * result + (schedulingPriorityOverride ?: 0)
        result = 31 * result + (shareIdentifier?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (timeout?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SubmitJobRequest

        if (arrayProperties != other.arrayProperties) return false
        if (containerOverrides != other.containerOverrides) return false
        if (dependsOn != other.dependsOn) return false
        if (jobDefinition != other.jobDefinition) return false
        if (jobName != other.jobName) return false
        if (jobQueue != other.jobQueue) return false
        if (nodeOverrides != other.nodeOverrides) return false
        if (parameters != other.parameters) return false
        if (propagateTags != other.propagateTags) return false
        if (retryStrategy != other.retryStrategy) return false
        if (schedulingPriorityOverride != other.schedulingPriorityOverride) return false
        if (shareIdentifier != other.shareIdentifier) return false
        if (tags != other.tags) return false
        if (timeout != other.timeout) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.SubmitJobRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The array properties for the submitted job, such as the size of the array. The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. For more information, see [Array Jobs](https://docs.aws.amazon.com/batch/latest/userguide/array_jobs.html) in the *Batch User Guide*.
         */
        public var arrayProperties: aws.sdk.kotlin.services.batch.model.ArrayProperties? = null
        /**
         * A list of container overrides in the JSON format that specify the name of a container in the specified job definition and the overrides it receives. You can override the default command for a container, which is specified in the job definition or the Docker image, with a `command` override. You can also override existing environment variables on a container or add new environment variables to it with an `environment` override.
         */
        public var containerOverrides: aws.sdk.kotlin.services.batch.model.ContainerOverrides? = null
        /**
         * A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a `SEQUENTIAL` type dependency without specifying a job ID for array jobs so that each child array job completes sequentially, starting at index 0. You can also specify an `N_TO_N` type dependency with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding index child of each dependency to complete before it can begin.
         */
        public var dependsOn: List<JobDependency>? = null
        /**
         * The job definition used by this job. This value can be one of `name`, `name:revision`, or the Amazon Resource Name (ARN) for the job definition. If `name` is specified without a revision then the latest active revision is used.
         */
        public var jobDefinition: kotlin.String? = null
        /**
         * The name of the job. It can be up to 128 letters long. The first character must be alphanumeric, can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
         */
        public var jobName: kotlin.String? = null
        /**
         * The job queue where the job is submitted. You can specify either the name or the Amazon Resource Name (ARN) of the queue.
         */
        public var jobQueue: kotlin.String? = null
        /**
         * A list of node overrides in JSON format that specify the node range to target and the container overrides for that node range.
         *
         * This parameter isn't applicable to jobs that are running on Fargate resources; use `containerOverrides` instead.
         */
        public var nodeOverrides: aws.sdk.kotlin.services.batch.model.NodeOverrides? = null
        /**
         * Additional parameters passed to the job that replace parameter substitution placeholders that are set in the job definition. Parameters are specified as a key and value pair mapping. Parameters in a `SubmitJob` request override any corresponding parameter defaults from the job definition.
         */
        public var parameters: Map<String, String>? = null
        /**
         * Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task. If no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks during task creation. For tags with the same name, job tags are given priority over job definitions tags. If the total number of combined tags from the job and job definition is over 50, the job is moved to the `FAILED` state. When specified, this overrides the tag propagation setting in the job definition.
         */
        public var propagateTags: kotlin.Boolean? = null
        /**
         * The retry strategy to use for failed jobs from this SubmitJob operation. When a retry strategy is specified here, it overrides the retry strategy defined in the job definition.
         */
        public var retryStrategy: aws.sdk.kotlin.services.batch.model.RetryStrategy? = null
        /**
         * The scheduling priority for the job. This will only affect jobs in job queues with a fair share policy. Jobs with a higher scheduling priority will be scheduled before jobs with a lower scheduling priority. This will override any scheduling priority in the job definition.
         *
         * The minimum supported value is 0 and the maximum supported value is 9999.
         */
        public var schedulingPriorityOverride: kotlin.Int? = null
        /**
         * The share identifier for the job. If the job queue does not have a scheduling policy, then this parameter must not be specified. If the job queue has a scheduling policy, then this parameter must be specified.
         */
        public var shareIdentifier: kotlin.String? = null
        /**
         * The tags that you apply to the job request to help you categorize and organize your resources. Each tag consists of a key and an optional value. For more information, see [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in *Amazon Web Services General Reference*.
         */
        public var tags: Map<String, String>? = null
        /**
         * The timeout configuration for this SubmitJob operation. You can specify a timeout duration after which Batch terminates your jobs if they haven't finished. If a job is terminated due to a timeout, it isn't retried. The minimum value for the timeout is 60 seconds. This configuration overrides any timeout configuration specified in the job definition. For array jobs, child jobs have the same timeout configuration as the parent job. For more information, see [Job Timeouts](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/job_timeouts.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var timeout: aws.sdk.kotlin.services.batch.model.JobTimeout? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.SubmitJobRequest) : this() {
            this.arrayProperties = x.arrayProperties
            this.containerOverrides = x.containerOverrides
            this.dependsOn = x.dependsOn
            this.jobDefinition = x.jobDefinition
            this.jobName = x.jobName
            this.jobQueue = x.jobQueue
            this.nodeOverrides = x.nodeOverrides
            this.parameters = x.parameters
            this.propagateTags = x.propagateTags
            this.retryStrategy = x.retryStrategy
            this.schedulingPriorityOverride = x.schedulingPriorityOverride
            this.shareIdentifier = x.shareIdentifier
            this.tags = x.tags
            this.timeout = x.timeout
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.SubmitJobRequest = SubmitJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.ArrayProperties] inside the given [block]
         */
        public fun arrayProperties(block: aws.sdk.kotlin.services.batch.model.ArrayProperties.Builder.() -> kotlin.Unit) {
            this.arrayProperties = aws.sdk.kotlin.services.batch.model.ArrayProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.ContainerOverrides] inside the given [block]
         */
        public fun containerOverrides(block: aws.sdk.kotlin.services.batch.model.ContainerOverrides.Builder.() -> kotlin.Unit) {
            this.containerOverrides = aws.sdk.kotlin.services.batch.model.ContainerOverrides.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.NodeOverrides] inside the given [block]
         */
        public fun nodeOverrides(block: aws.sdk.kotlin.services.batch.model.NodeOverrides.Builder.() -> kotlin.Unit) {
            this.nodeOverrides = aws.sdk.kotlin.services.batch.model.NodeOverrides.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.RetryStrategy] inside the given [block]
         */
        public fun retryStrategy(block: aws.sdk.kotlin.services.batch.model.RetryStrategy.Builder.() -> kotlin.Unit) {
            this.retryStrategy = aws.sdk.kotlin.services.batch.model.RetryStrategy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.JobTimeout] inside the given [block]
         */
        public fun timeout(block: aws.sdk.kotlin.services.batch.model.JobTimeout.Builder.() -> kotlin.Unit) {
            this.timeout = aws.sdk.kotlin.services.batch.model.JobTimeout.invoke(block)
        }
    }
}
