// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.model



/**
 * Contains the parameters for `UpdateComputeEnvironment`.
 */
public class UpdateComputeEnvironmentRequest private constructor(builder: Builder) {
    /**
     * The name or full Amazon Resource Name (ARN) of the compute environment to update.
     */
    public val computeEnvironment: kotlin.String? = builder.computeEnvironment
    /**
     * Details of the compute resources managed by the compute environment. Required for a managed compute environment. For more information, see [Compute Environments](https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html) in the *Batch User Guide*.
     */
    public val computeResources: aws.sdk.kotlin.services.batch.model.ComputeResourceUpdate? = builder.computeResources
    /**
     * The full Amazon Resource Name (ARN) of the IAM role that allows Batch to make calls to other Amazon Web Services services on your behalf. For more information, see [Batch service IAM role](https://docs.aws.amazon.com/batch/latest/userguide/service_IAM_role.html) in the *Batch User Guide*.
     *
     * If the compute environment has a service-linked role, it can't be changed to use a regular IAM role. Likewise, if the compute environment has a regular IAM role, it can't be changed to use a service-linked role. To update the parameters for the compute environment that require an infrastructure update to change, the **AWSServiceRoleForBatch** service-linked role must be used. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
     *
     * If your specified role has a path other than `/`, then you must either specify the full role ARN (recommended) or prefix the role name with the path.
     *
     * Depending on how you created your Batch service role, its ARN might contain the `service-role` path prefix. When you only specify the name of the service role, Batch assumes that your ARN doesn't use the `service-role` path prefix. Because of this, we recommend that you specify the full ARN of your service role when you create compute environments.
     */
    public val serviceRole: kotlin.String? = builder.serviceRole
    /**
     * The state of the compute environment. Compute environments in the `ENABLED` state can accept jobs from a queue and scale in or out automatically based on the workload demand of its associated queues.
     *
     * If the state is `ENABLED`, then the Batch scheduler can attempt to place jobs from an associated job queue on the compute resources within the environment. If the compute environment is managed, then it can scale its instances out or in automatically, based on the job queue demand.
     *
     * If the state is `DISABLED`, then the Batch scheduler doesn't attempt to place jobs within the environment. Jobs in a `STARTING` or `RUNNING` state continue to progress normally. Managed compute environments in the `DISABLED` state don't scale out. However, they scale in to `minvCpus` value after instances become idle.
     */
    public val state: aws.sdk.kotlin.services.batch.model.CeState? = builder.state
    /**
     * The maximum number of vCPUs expected to be used for an unmanaged compute environment. Do not specify this parameter for a managed compute environment. This parameter is only used for fair share scheduling to reserve vCPU capacity for new share identifiers. If this parameter is not provided for a fair share job queue, no vCPU capacity will be reserved.
     */
    public val unmanagedvCpus: kotlin.Int? = builder.unmanagedvCpus
    /**
     * Specifies the updated infrastructure update policy for the compute environment. For more information about infrastructure updates, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
     */
    public val updatePolicy: aws.sdk.kotlin.services.batch.model.UpdatePolicy? = builder.updatePolicy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.batch.model.UpdateComputeEnvironmentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateComputeEnvironmentRequest(")
        append("computeEnvironment=$computeEnvironment,")
        append("computeResources=$computeResources,")
        append("serviceRole=$serviceRole,")
        append("state=$state,")
        append("unmanagedvCpus=$unmanagedvCpus,")
        append("updatePolicy=$updatePolicy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = computeEnvironment?.hashCode() ?: 0
        result = 31 * result + (computeResources?.hashCode() ?: 0)
        result = 31 * result + (serviceRole?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (unmanagedvCpus ?: 0)
        result = 31 * result + (updatePolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateComputeEnvironmentRequest

        if (computeEnvironment != other.computeEnvironment) return false
        if (computeResources != other.computeResources) return false
        if (serviceRole != other.serviceRole) return false
        if (state != other.state) return false
        if (unmanagedvCpus != other.unmanagedvCpus) return false
        if (updatePolicy != other.updatePolicy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.batch.model.UpdateComputeEnvironmentRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name or full Amazon Resource Name (ARN) of the compute environment to update.
         */
        public var computeEnvironment: kotlin.String? = null
        /**
         * Details of the compute resources managed by the compute environment. Required for a managed compute environment. For more information, see [Compute Environments](https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html) in the *Batch User Guide*.
         */
        public var computeResources: aws.sdk.kotlin.services.batch.model.ComputeResourceUpdate? = null
        /**
         * The full Amazon Resource Name (ARN) of the IAM role that allows Batch to make calls to other Amazon Web Services services on your behalf. For more information, see [Batch service IAM role](https://docs.aws.amazon.com/batch/latest/userguide/service_IAM_role.html) in the *Batch User Guide*.
         *
         * If the compute environment has a service-linked role, it can't be changed to use a regular IAM role. Likewise, if the compute environment has a regular IAM role, it can't be changed to use a service-linked role. To update the parameters for the compute environment that require an infrastructure update to change, the **AWSServiceRoleForBatch** service-linked role must be used. For more information, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
         *
         * If your specified role has a path other than `/`, then you must either specify the full role ARN (recommended) or prefix the role name with the path.
         *
         * Depending on how you created your Batch service role, its ARN might contain the `service-role` path prefix. When you only specify the name of the service role, Batch assumes that your ARN doesn't use the `service-role` path prefix. Because of this, we recommend that you specify the full ARN of your service role when you create compute environments.
         */
        public var serviceRole: kotlin.String? = null
        /**
         * The state of the compute environment. Compute environments in the `ENABLED` state can accept jobs from a queue and scale in or out automatically based on the workload demand of its associated queues.
         *
         * If the state is `ENABLED`, then the Batch scheduler can attempt to place jobs from an associated job queue on the compute resources within the environment. If the compute environment is managed, then it can scale its instances out or in automatically, based on the job queue demand.
         *
         * If the state is `DISABLED`, then the Batch scheduler doesn't attempt to place jobs within the environment. Jobs in a `STARTING` or `RUNNING` state continue to progress normally. Managed compute environments in the `DISABLED` state don't scale out. However, they scale in to `minvCpus` value after instances become idle.
         */
        public var state: aws.sdk.kotlin.services.batch.model.CeState? = null
        /**
         * The maximum number of vCPUs expected to be used for an unmanaged compute environment. Do not specify this parameter for a managed compute environment. This parameter is only used for fair share scheduling to reserve vCPU capacity for new share identifiers. If this parameter is not provided for a fair share job queue, no vCPU capacity will be reserved.
         */
        public var unmanagedvCpus: kotlin.Int? = null
        /**
         * Specifies the updated infrastructure update policy for the compute environment. For more information about infrastructure updates, see [Updating compute environments](https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html) in the *Batch User Guide*.
         */
        public var updatePolicy: aws.sdk.kotlin.services.batch.model.UpdatePolicy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.batch.model.UpdateComputeEnvironmentRequest) : this() {
            this.computeEnvironment = x.computeEnvironment
            this.computeResources = x.computeResources
            this.serviceRole = x.serviceRole
            this.state = x.state
            this.unmanagedvCpus = x.unmanagedvCpus
            this.updatePolicy = x.updatePolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.batch.model.UpdateComputeEnvironmentRequest = UpdateComputeEnvironmentRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.ComputeResourceUpdate] inside the given [block]
         */
        public fun computeResources(block: aws.sdk.kotlin.services.batch.model.ComputeResourceUpdate.Builder.() -> kotlin.Unit) {
            this.computeResources = aws.sdk.kotlin.services.batch.model.ComputeResourceUpdate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.batch.model.UpdatePolicy] inside the given [block]
         */
        public fun updatePolicy(block: aws.sdk.kotlin.services.batch.model.UpdatePolicy.Builder.() -> kotlin.Unit) {
            this.updatePolicy = aws.sdk.kotlin.services.batch.model.UpdatePolicy.invoke(block)
        }
    }
}
