// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.paginators

import aws.sdk.kotlin.services.batch.BatchClient
import aws.sdk.kotlin.services.batch.model.ComputeEnvironmentDetail
import aws.sdk.kotlin.services.batch.model.DescribeComputeEnvironmentsRequest
import aws.sdk.kotlin.services.batch.model.DescribeComputeEnvironmentsResponse
import aws.sdk.kotlin.services.batch.model.DescribeJobDefinitionsRequest
import aws.sdk.kotlin.services.batch.model.DescribeJobDefinitionsResponse
import aws.sdk.kotlin.services.batch.model.DescribeJobQueuesRequest
import aws.sdk.kotlin.services.batch.model.DescribeJobQueuesResponse
import aws.sdk.kotlin.services.batch.model.JobDefinition
import aws.sdk.kotlin.services.batch.model.JobQueueDetail
import aws.sdk.kotlin.services.batch.model.JobSummary
import aws.sdk.kotlin.services.batch.model.ListJobsRequest
import aws.sdk.kotlin.services.batch.model.ListJobsResponse
import aws.sdk.kotlin.services.batch.model.ListSchedulingPoliciesRequest
import aws.sdk.kotlin.services.batch.model.ListSchedulingPoliciesResponse
import aws.sdk.kotlin.services.batch.model.SchedulingPolicyListingDetail
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeComputeEnvironmentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeComputeEnvironmentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeComputeEnvironmentsResponse]
 */
public fun BatchClient.describeComputeEnvironmentsPaginated(initialRequest: DescribeComputeEnvironmentsRequest): Flow<DescribeComputeEnvironmentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeComputeEnvironmentsPaginated.describeComputeEnvironments(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeComputeEnvironmentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeComputeEnvironmentsResponse]
 */
public fun BatchClient.describeComputeEnvironmentsPaginated(block: DescribeComputeEnvironmentsRequest.Builder.() -> Unit): Flow<DescribeComputeEnvironmentsResponse> =
    describeComputeEnvironmentsPaginated(DescribeComputeEnvironmentsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeComputeEnvironmentsPaginated]
 * to access the nested member [ComputeEnvironmentDetail]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ComputeEnvironmentDetail]
 */
@JvmName("describeComputeEnvironmentsResponseComputeEnvironmentDetail")
public fun Flow<DescribeComputeEnvironmentsResponse>.computeEnvironments(): Flow<ComputeEnvironmentDetail> =
    transform() { response ->
        response.computeEnvironments?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeJobDefinitionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeJobDefinitionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeJobDefinitionsResponse]
 */
public fun BatchClient.describeJobDefinitionsPaginated(initialRequest: DescribeJobDefinitionsRequest): Flow<DescribeJobDefinitionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeJobDefinitionsPaginated.describeJobDefinitions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeJobDefinitionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeJobDefinitionsResponse]
 */
public fun BatchClient.describeJobDefinitionsPaginated(block: DescribeJobDefinitionsRequest.Builder.() -> Unit): Flow<DescribeJobDefinitionsResponse> =
    describeJobDefinitionsPaginated(DescribeJobDefinitionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeJobDefinitionsPaginated]
 * to access the nested member [JobDefinition]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [JobDefinition]
 */
@JvmName("describeJobDefinitionsResponseJobDefinition")
public fun Flow<DescribeJobDefinitionsResponse>.jobDefinitions(): Flow<JobDefinition> =
    transform() { response ->
        response.jobDefinitions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeJobQueuesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeJobQueuesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeJobQueuesResponse]
 */
public fun BatchClient.describeJobQueuesPaginated(initialRequest: DescribeJobQueuesRequest): Flow<DescribeJobQueuesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeJobQueuesPaginated.describeJobQueues(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeJobQueuesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeJobQueuesResponse]
 */
public fun BatchClient.describeJobQueuesPaginated(block: DescribeJobQueuesRequest.Builder.() -> Unit): Flow<DescribeJobQueuesResponse> =
    describeJobQueuesPaginated(DescribeJobQueuesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeJobQueuesPaginated]
 * to access the nested member [JobQueueDetail]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [JobQueueDetail]
 */
@JvmName("describeJobQueuesResponseJobQueueDetail")
public fun Flow<DescribeJobQueuesResponse>.jobQueues(): Flow<JobQueueDetail> =
    transform() { response ->
        response.jobQueues?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobsResponse]
 */
public fun BatchClient.listJobsPaginated(initialRequest: ListJobsRequest): Flow<ListJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listJobsPaginated.listJobs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobsResponse]
 */
public fun BatchClient.listJobsPaginated(block: ListJobsRequest.Builder.() -> Unit): Flow<ListJobsResponse> =
    listJobsPaginated(ListJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listJobsPaginated]
 * to access the nested member [JobSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [JobSummary]
 */
@JvmName("listJobsResponseJobSummary")
public fun Flow<ListJobsResponse>.jobSummaryList(): Flow<JobSummary> =
    transform() { response ->
        response.jobSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSchedulingPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSchedulingPoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSchedulingPoliciesResponse]
 */
public fun BatchClient.listSchedulingPoliciesPaginated(initialRequest: ListSchedulingPoliciesRequest): Flow<ListSchedulingPoliciesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSchedulingPoliciesPaginated.listSchedulingPolicies(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListSchedulingPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSchedulingPoliciesResponse]
 */
public fun BatchClient.listSchedulingPoliciesPaginated(block: ListSchedulingPoliciesRequest.Builder.() -> Unit): Flow<ListSchedulingPoliciesResponse> =
    listSchedulingPoliciesPaginated(ListSchedulingPoliciesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSchedulingPoliciesPaginated]
 * to access the nested member [SchedulingPolicyListingDetail]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SchedulingPolicyListingDetail]
 */
@JvmName("listSchedulingPoliciesResponseSchedulingPolicyListingDetail")
public fun Flow<ListSchedulingPoliciesResponse>.schedulingPolicies(): Flow<SchedulingPolicyListingDetail> =
    transform() { response ->
        response.schedulingPolicies?.forEach {
            emit(it)
        }
    }
