// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.transform

import aws.sdk.kotlin.services.batch.model.JobStatus
import aws.sdk.kotlin.services.batch.model.KeyValuesPair
import aws.sdk.kotlin.services.batch.model.ListJobsRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListJobsOperationSerializer: HttpSerialize<ListJobsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListJobsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/v1/listjobs"
        }

        val payload = serializeListJobsOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeListJobsOperationBody(context: ExecutionContext, input: ListJobsRequest): ByteArray {
    val serializer = JsonSerializer()
    val ARRAYJOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arrayJobId"))
    val FILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("filters"))
    val JOBQUEUE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobQueue"))
    val JOBSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobStatus"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("maxResults"))
    val MULTINODEJOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("multiNodeJobId"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARRAYJOBID_DESCRIPTOR)
        field(FILTERS_DESCRIPTOR)
        field(JOBQUEUE_DESCRIPTOR)
        field(JOBSTATUS_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(MULTINODEJOBID_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.arrayJobId?.let { field(ARRAYJOBID_DESCRIPTOR, it) }
        if (input.filters != null) {
            listField(FILTERS_DESCRIPTOR) {
                for (el0 in input.filters) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeKeyValuesPairDocument))
                }
            }
        }
        input.jobQueue?.let { field(JOBQUEUE_DESCRIPTOR, it) }
        input.jobStatus?.let { field(JOBSTATUS_DESCRIPTOR, it.value) }
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        input.multiNodeJobId?.let { field(MULTINODEJOBID_DESCRIPTOR, it) }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
