// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.batch.transform

import aws.sdk.kotlin.services.batch.model.ArrayProperties
import aws.sdk.kotlin.services.batch.model.ContainerOverrides
import aws.sdk.kotlin.services.batch.model.JobDependency
import aws.sdk.kotlin.services.batch.model.JobTimeout
import aws.sdk.kotlin.services.batch.model.NodeOverrides
import aws.sdk.kotlin.services.batch.model.RetryStrategy
import aws.sdk.kotlin.services.batch.model.SubmitJobRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SubmitJobOperationSerializer: HttpSerialize<SubmitJobRequest> {
    override suspend fun serialize(context: ExecutionContext, input: SubmitJobRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/v1/submitjob"
        }

        val payload = serializeSubmitJobOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeSubmitJobOperationBody(context: ExecutionContext, input: SubmitJobRequest): ByteArray {
    val serializer = JsonSerializer()
    val ARRAYPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("arrayProperties"))
    val CONTAINEROVERRIDES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("containerOverrides"))
    val DEPENDSON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("dependsOn"))
    val JOBDEFINITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobDefinition"))
    val JOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobName"))
    val JOBQUEUE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobQueue"))
    val NODEOVERRIDES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("nodeOverrides"))
    val PARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("parameters"))
    val PROPAGATETAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("propagateTags"))
    val RETRYSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("retryStrategy"))
    val SCHEDULINGPRIORITYOVERRIDE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("schedulingPriorityOverride"))
    val SHAREIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("shareIdentifier"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TIMEOUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("timeout"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARRAYPROPERTIES_DESCRIPTOR)
        field(CONTAINEROVERRIDES_DESCRIPTOR)
        field(DEPENDSON_DESCRIPTOR)
        field(JOBDEFINITION_DESCRIPTOR)
        field(JOBNAME_DESCRIPTOR)
        field(JOBQUEUE_DESCRIPTOR)
        field(NODEOVERRIDES_DESCRIPTOR)
        field(PARAMETERS_DESCRIPTOR)
        field(PROPAGATETAGS_DESCRIPTOR)
        field(RETRYSTRATEGY_DESCRIPTOR)
        field(SCHEDULINGPRIORITYOVERRIDE_DESCRIPTOR)
        field(SHAREIDENTIFIER_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TIMEOUT_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.arrayProperties?.let { field(ARRAYPROPERTIES_DESCRIPTOR, it, ::serializeArrayPropertiesDocument) }
        input.containerOverrides?.let { field(CONTAINEROVERRIDES_DESCRIPTOR, it, ::serializeContainerOverridesDocument) }
        if (input.dependsOn != null) {
            listField(DEPENDSON_DESCRIPTOR) {
                for (el0 in input.dependsOn) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeJobDependencyDocument))
                }
            }
        }
        input.jobDefinition?.let { field(JOBDEFINITION_DESCRIPTOR, it) }
        input.jobName?.let { field(JOBNAME_DESCRIPTOR, it) }
        input.jobQueue?.let { field(JOBQUEUE_DESCRIPTOR, it) }
        input.nodeOverrides?.let { field(NODEOVERRIDES_DESCRIPTOR, it, ::serializeNodeOverridesDocument) }
        if (input.parameters != null) {
            mapField(PARAMETERS_DESCRIPTOR) {
                input.parameters.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.propagateTags?.let { field(PROPAGATETAGS_DESCRIPTOR, it) }
        input.retryStrategy?.let { field(RETRYSTRATEGY_DESCRIPTOR, it, ::serializeRetryStrategyDocument) }
        input.schedulingPriorityOverride?.let { field(SCHEDULINGPRIORITYOVERRIDE_DESCRIPTOR, it) }
        input.shareIdentifier?.let { field(SHAREIDENTIFIER_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.timeout?.let { field(TIMEOUT_DESCRIPTOR, it, ::serializeJobTimeoutDocument) }
    }
    return serializer.toByteArray()
}
