// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.billingconductor.model



public class CreateBillingGroupRequest private constructor(builder: Builder) {
    /**
     * The set of accounts that will be under the billing group. The set of accounts resemble the linked accounts in a consolidated family.
     */
    public val accountGrouping: aws.sdk.kotlin.services.billingconductor.model.AccountGrouping? = builder.accountGrouping
    /**
     * The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group.
     */
    public val computationPreference: aws.sdk.kotlin.services.billingconductor.model.ComputationPreference? = builder.computationPreference
    /**
     * The description of the billing group.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The billing group name. The names must be unique.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The account ID that serves as the main account in a billing group.
     */
    public val primaryAccountId: kotlin.String? = builder.primaryAccountId
    /**
     * A map that contains tag keys and tag values that are attached to a billing group. This feature isn't available during the beta.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.billingconductor.model.CreateBillingGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateBillingGroupRequest(")
        append("accountGrouping=$accountGrouping,")
        append("clientToken=$clientToken,")
        append("computationPreference=$computationPreference,")
        append("description=*** Sensitive Data Redacted ***,")
        append("name=*** Sensitive Data Redacted ***,")
        append("primaryAccountId=$primaryAccountId,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountGrouping?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (computationPreference?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (primaryAccountId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateBillingGroupRequest

        if (accountGrouping != other.accountGrouping) return false
        if (clientToken != other.clientToken) return false
        if (computationPreference != other.computationPreference) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (primaryAccountId != other.primaryAccountId) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.billingconductor.model.CreateBillingGroupRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The set of accounts that will be under the billing group. The set of accounts resemble the linked accounts in a consolidated family.
         */
        public var accountGrouping: aws.sdk.kotlin.services.billingconductor.model.AccountGrouping? = null
        /**
         * The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group.
         */
        public var computationPreference: aws.sdk.kotlin.services.billingconductor.model.ComputationPreference? = null
        /**
         * The description of the billing group.
         */
        public var description: kotlin.String? = null
        /**
         * The billing group name. The names must be unique.
         */
        public var name: kotlin.String? = null
        /**
         * The account ID that serves as the main account in a billing group.
         */
        public var primaryAccountId: kotlin.String? = null
        /**
         * A map that contains tag keys and tag values that are attached to a billing group. This feature isn't available during the beta.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.billingconductor.model.CreateBillingGroupRequest) : this() {
            this.accountGrouping = x.accountGrouping
            this.clientToken = x.clientToken
            this.computationPreference = x.computationPreference
            this.description = x.description
            this.name = x.name
            this.primaryAccountId = x.primaryAccountId
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.billingconductor.model.CreateBillingGroupRequest = CreateBillingGroupRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.billingconductor.model.AccountGrouping] inside the given [block]
         */
        public fun accountGrouping(block: aws.sdk.kotlin.services.billingconductor.model.AccountGrouping.Builder.() -> kotlin.Unit) {
            this.accountGrouping = aws.sdk.kotlin.services.billingconductor.model.AccountGrouping.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.billingconductor.model.ComputationPreference] inside the given [block]
         */
        public fun computationPreference(block: aws.sdk.kotlin.services.billingconductor.model.ComputationPreference.Builder.() -> kotlin.Unit) {
            this.computationPreference = aws.sdk.kotlin.services.billingconductor.model.ComputationPreference.invoke(block)
        }
    }
}
