// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.billingconductor.model



public class CreatePricingRuleRequest private constructor(builder: Builder) {
    /**
     * The seller of services provided by Amazon Web Services, their affiliates, or third-party providers selling services via Amazon Web Services Marketplace.
     */
    public val billingEntity: kotlin.String? = builder.billingEntity
    /**
     * The token that's needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The pricing rule description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A percentage modifier that's applied on the public pricing rates.
     */
    public val modifierPercentage: kotlin.Double? = builder.modifierPercentage
    /**
     * The pricing rule name. The names must be unique to each pricing rule.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The scope of pricing rule that indicates if it's globally applicable, or it's service-specific.
     */
    public val scope: aws.sdk.kotlin.services.billingconductor.model.PricingRuleScope? = builder.scope
    /**
     * If the `Scope` attribute is set to `SERVICE`, the attribute indicates which service the `PricingRule` is applicable for.
     */
    public val service: kotlin.String? = builder.service
    /**
     * A map that contains tag keys and tag values that are attached to a pricing rule.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The type of pricing rule.
     */
    public val type: aws.sdk.kotlin.services.billingconductor.model.PricingRuleType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.billingconductor.model.CreatePricingRuleRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePricingRuleRequest(")
        append("billingEntity=$billingEntity,")
        append("clientToken=$clientToken,")
        append("description=*** Sensitive Data Redacted ***,")
        append("modifierPercentage=$modifierPercentage,")
        append("name=*** Sensitive Data Redacted ***,")
        append("scope=$scope,")
        append("service=$service,")
        append("tags=$tags,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = billingEntity?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (modifierPercentage?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        result = 31 * result + (service?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreatePricingRuleRequest

        if (billingEntity != other.billingEntity) return false
        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (modifierPercentage != other.modifierPercentage) return false
        if (name != other.name) return false
        if (scope != other.scope) return false
        if (service != other.service) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.billingconductor.model.CreatePricingRuleRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The seller of services provided by Amazon Web Services, their affiliates, or third-party providers selling services via Amazon Web Services Marketplace.
         */
        public var billingEntity: kotlin.String? = null
        /**
         * The token that's needed to support idempotency. Idempotency isn't currently supported, but will be implemented in a future update.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The pricing rule description.
         */
        public var description: kotlin.String? = null
        /**
         * A percentage modifier that's applied on the public pricing rates.
         */
        public var modifierPercentage: kotlin.Double? = null
        /**
         * The pricing rule name. The names must be unique to each pricing rule.
         */
        public var name: kotlin.String? = null
        /**
         * The scope of pricing rule that indicates if it's globally applicable, or it's service-specific.
         */
        public var scope: aws.sdk.kotlin.services.billingconductor.model.PricingRuleScope? = null
        /**
         * If the `Scope` attribute is set to `SERVICE`, the attribute indicates which service the `PricingRule` is applicable for.
         */
        public var service: kotlin.String? = null
        /**
         * A map that contains tag keys and tag values that are attached to a pricing rule.
         */
        public var tags: Map<String, String>? = null
        /**
         * The type of pricing rule.
         */
        public var type: aws.sdk.kotlin.services.billingconductor.model.PricingRuleType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.billingconductor.model.CreatePricingRuleRequest) : this() {
            this.billingEntity = x.billingEntity
            this.clientToken = x.clientToken
            this.description = x.description
            this.modifierPercentage = x.modifierPercentage
            this.name = x.name
            this.scope = x.scope
            this.service = x.service
            this.tags = x.tags
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.billingconductor.model.CreatePricingRuleRequest = CreatePricingRuleRequest(this)
    }
}
