// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.billingconductor.paginators

import aws.sdk.kotlin.services.billingconductor.BillingconductorClient
import aws.sdk.kotlin.services.billingconductor.model.AccountAssociationsListElement
import aws.sdk.kotlin.services.billingconductor.model.BillingGroupCostReportElement
import aws.sdk.kotlin.services.billingconductor.model.ListAccountAssociationsRequest
import aws.sdk.kotlin.services.billingconductor.model.ListAccountAssociationsResponse
import aws.sdk.kotlin.services.billingconductor.model.ListBillingGroupCostReportsRequest
import aws.sdk.kotlin.services.billingconductor.model.ListBillingGroupCostReportsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAccountAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccountAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccountAssociationsResponse]
 */
public fun BillingconductorClient.listAccountAssociationsPaginated(initialRequest: ListAccountAssociationsRequest): Flow<ListAccountAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccountAssociationsPaginated.listAccountAssociations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAccountAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccountAssociationsResponse]
 */
public fun BillingconductorClient.listAccountAssociationsPaginated(block: ListAccountAssociationsRequest.Builder.() -> Unit): Flow<ListAccountAssociationsResponse> =
    listAccountAssociationsPaginated(ListAccountAssociationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAccountAssociationsPaginated]
 * to access the nested member [AccountAssociationsListElement]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AccountAssociationsListElement]
 */
@JvmName("listAccountAssociationsResponseAccountAssociationsListElement")
public fun Flow<ListAccountAssociationsResponse>.linkedAccounts(): Flow<AccountAssociationsListElement> =
    transform() { response ->
        response.linkedAccounts?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListBillingGroupCostReportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBillingGroupCostReportsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBillingGroupCostReportsResponse]
 */
public fun BillingconductorClient.listBillingGroupCostReportsPaginated(initialRequest: ListBillingGroupCostReportsRequest): Flow<ListBillingGroupCostReportsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBillingGroupCostReportsPaginated.listBillingGroupCostReports(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListBillingGroupCostReportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBillingGroupCostReportsResponse]
 */
public fun BillingconductorClient.listBillingGroupCostReportsPaginated(block: ListBillingGroupCostReportsRequest.Builder.() -> Unit): Flow<ListBillingGroupCostReportsResponse> =
    listBillingGroupCostReportsPaginated(ListBillingGroupCostReportsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listBillingGroupCostReportsPaginated]
 * to access the nested member [BillingGroupCostReportElement]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [BillingGroupCostReportElement]
 */
@JvmName("listBillingGroupCostReportsResponseBillingGroupCostReportElement")
public fun Flow<ListBillingGroupCostReportsResponse>.billingGroupCostReports(): Flow<BillingGroupCostReportElement> =
    transform() { response ->
        response.billingGroupCostReports?.forEach {
            emit(it)
        }
    }
