// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.billingconductor.transform

import aws.sdk.kotlin.services.billingconductor.model.CreateCustomLineItemRequest
import aws.sdk.kotlin.services.billingconductor.model.CustomLineItemBillingPeriodRange
import aws.sdk.kotlin.services.billingconductor.model.CustomLineItemChargeDetails
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateCustomLineItemOperationSerializer: HttpSerialize<CreateCustomLineItemRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateCustomLineItemRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/create-custom-line-item"
        }

        builder.headers {
            append("X-Amzn-Client-Token", (input.clientToken ?: context.idempotencyTokenProvider.generateToken()))
        }

        val payload = serializeCreateCustomLineItemOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateCustomLineItemOperationBody(context: ExecutionContext, input: CreateCustomLineItemRequest): ByteArray {
    val serializer = JsonSerializer()
    val BILLINGGROUPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BillingGroupArn"))
    val BILLINGPERIODRANGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("BillingPeriodRange"))
    val CHARGEDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ChargeDetails"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BILLINGGROUPARN_DESCRIPTOR)
        field(BILLINGPERIODRANGE_DESCRIPTOR)
        field(CHARGEDETAILS_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.billingGroupArn?.let { field(BILLINGGROUPARN_DESCRIPTOR, it) }
        input.billingPeriodRange?.let { field(BILLINGPERIODRANGE_DESCRIPTOR, it, ::serializeCustomLineItemBillingPeriodRangeDocument) }
        input.chargeDetails?.let { field(CHARGEDETAILS_DESCRIPTOR, it, ::serializeCustomLineItemChargeDetailsDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
    }
    return serializer.toByteArray()
}
