// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.billingconductor.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.billingconductor.model.BillingGroupCostReportElement
import aws.sdk.kotlin.services.billingconductor.model.BillingconductorException
import aws.sdk.kotlin.services.billingconductor.model.ListBillingGroupCostReportsResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListBillingGroupCostReportsOperationDeserializer: HttpDeserialize<ListBillingGroupCostReportsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListBillingGroupCostReportsResponse {
        if (!response.status.isSuccess()) {
            throwListBillingGroupCostReportsError(context, response)
        }
        val builder = ListBillingGroupCostReportsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListBillingGroupCostReportsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListBillingGroupCostReportsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw BillingconductorException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> BillingconductorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListBillingGroupCostReportsOperationBody(builder: ListBillingGroupCostReportsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BILLINGGROUPCOSTREPORTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("BillingGroupCostReports"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BILLINGGROUPCOSTREPORTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BILLINGGROUPCOSTREPORTS_DESCRIPTOR.index -> builder.billingGroupCostReports =
                    deserializer.deserializeList(BILLINGGROUPCOSTREPORTS_DESCRIPTOR) {
                        val col0 = mutableListOf<BillingGroupCostReportElement>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBillingGroupCostReportElementDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
