// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.billingconductor.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.billingconductor.model.BillingGroupStatus
import aws.sdk.kotlin.services.billingconductor.model.BillingconductorException
import aws.sdk.kotlin.services.billingconductor.model.UpdateBillingGroupResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateBillingGroupOperationDeserializer: HttpDeserialize<UpdateBillingGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateBillingGroupResponse {
        if (!response.status.isSuccess()) {
            throwUpdateBillingGroupError(context, response)
        }
        val builder = UpdateBillingGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateBillingGroupOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateBillingGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw BillingconductorException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> BillingconductorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateBillingGroupOperationBody(builder: UpdateBillingGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("LastModifiedTime"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val PRICINGPLANARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PricingPlanArn"))
    val PRIMARYACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PrimaryAccountId"))
    val SIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("Size"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val STATUSREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StatusReason"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PRICINGPLANARN_DESCRIPTOR)
        field(PRIMARYACCOUNTID_DESCRIPTOR)
        field(SIZE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSREASON_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeLong()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PRICINGPLANARN_DESCRIPTOR.index -> builder.pricingPlanArn = deserializeString()
                PRIMARYACCOUNTID_DESCRIPTOR.index -> builder.primaryAccountId = deserializeString()
                SIZE_DESCRIPTOR.index -> builder.size = deserializeLong()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { BillingGroupStatus.fromValue(it) }
                STATUSREASON_DESCRIPTOR.index -> builder.statusReason = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
