// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.billingconductor.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.billingconductor.model.BillingconductorException
import aws.sdk.kotlin.services.billingconductor.model.PricingRuleScope
import aws.sdk.kotlin.services.billingconductor.model.PricingRuleType
import aws.sdk.kotlin.services.billingconductor.model.UpdatePricingRuleResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdatePricingRuleOperationDeserializer: HttpDeserialize<UpdatePricingRuleResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdatePricingRuleResponse {
        if (!response.status.isSuccess()) {
            throwUpdatePricingRuleError(context, response)
        }
        val builder = UpdatePricingRuleResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdatePricingRuleOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdatePricingRuleError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw BillingconductorException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> BillingconductorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdatePricingRuleOperationBody(builder: UpdatePricingRuleResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val ASSOCIATEDPRICINGPLANCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("AssociatedPricingPlanCount"))
    val BILLINGENTITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BillingEntity"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("LastModifiedTime"))
    val MODIFIERPERCENTAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Double, JsonSerialName("ModifierPercentage"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val SCOPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Scope"))
    val SERVICE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Service"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(ASSOCIATEDPRICINGPLANCOUNT_DESCRIPTOR)
        field(BILLINGENTITY_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(MODIFIERPERCENTAGE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(SCOPE_DESCRIPTOR)
        field(SERVICE_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                ASSOCIATEDPRICINGPLANCOUNT_DESCRIPTOR.index -> builder.associatedPricingPlanCount = deserializeLong()
                BILLINGENTITY_DESCRIPTOR.index -> builder.billingEntity = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeLong()
                MODIFIERPERCENTAGE_DESCRIPTOR.index -> builder.modifierPercentage = deserializeDouble()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                SCOPE_DESCRIPTOR.index -> builder.scope = deserializeString().let { PricingRuleScope.fromValue(it) }
                SERVICE_DESCRIPTOR.index -> builder.service = deserializeString()
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString().let { PricingRuleType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
