// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.chime.model.*
import aws.sdk.kotlin.services.chime.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "Chime"
public const val ServiceApiVersion: String = "2018-05-01"
public const val SdkVersion: String = "0.17.8-beta"

internal class DefaultChimeClient(override val config: ChimeClient.Config) : ChimeClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Associates a phone number with the specified Amazon Chime user.
     */
    override suspend fun associatePhoneNumberWithUser(input: AssociatePhoneNumberWithUserRequest): AssociatePhoneNumberWithUserResponse {
        val op = SdkHttpOperation.build<AssociatePhoneNumberWithUserRequest, AssociatePhoneNumberWithUserResponse> {
            serializer = AssociatePhoneNumberWithUserOperationSerializer()
            deserializer = AssociatePhoneNumberWithUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociatePhoneNumberWithUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates phone numbers with the specified Amazon Chime Voice Connector.
     */
    override suspend fun associatePhoneNumbersWithVoiceConnector(input: AssociatePhoneNumbersWithVoiceConnectorRequest): AssociatePhoneNumbersWithVoiceConnectorResponse {
        val op = SdkHttpOperation.build<AssociatePhoneNumbersWithVoiceConnectorRequest, AssociatePhoneNumbersWithVoiceConnectorResponse> {
            serializer = AssociatePhoneNumbersWithVoiceConnectorOperationSerializer()
            deserializer = AssociatePhoneNumbersWithVoiceConnectorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociatePhoneNumbersWithVoiceConnector"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates phone numbers with the specified Amazon Chime Voice Connector group.
     */
    override suspend fun associatePhoneNumbersWithVoiceConnectorGroup(input: AssociatePhoneNumbersWithVoiceConnectorGroupRequest): AssociatePhoneNumbersWithVoiceConnectorGroupResponse {
        val op = SdkHttpOperation.build<AssociatePhoneNumbersWithVoiceConnectorGroupRequest, AssociatePhoneNumbersWithVoiceConnectorGroupResponse> {
            serializer = AssociatePhoneNumbersWithVoiceConnectorGroupOperationSerializer()
            deserializer = AssociatePhoneNumbersWithVoiceConnectorGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociatePhoneNumbersWithVoiceConnectorGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates the specified sign-in delegate groups with the specified Amazon Chime account.
     */
    override suspend fun associateSigninDelegateGroupsWithAccount(input: AssociateSigninDelegateGroupsWithAccountRequest): AssociateSigninDelegateGroupsWithAccountResponse {
        val op = SdkHttpOperation.build<AssociateSigninDelegateGroupsWithAccountRequest, AssociateSigninDelegateGroupsWithAccountResponse> {
            serializer = AssociateSigninDelegateGroupsWithAccountOperationSerializer()
            deserializer = AssociateSigninDelegateGroupsWithAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateSigninDelegateGroupsWithAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates up to 100 new attendees for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide*.
     */
    override suspend fun batchCreateAttendee(input: BatchCreateAttendeeRequest): BatchCreateAttendeeResponse {
        val op = SdkHttpOperation.build<BatchCreateAttendeeRequest, BatchCreateAttendeeResponse> {
            serializer = BatchCreateAttendeeOperationSerializer()
            deserializer = BatchCreateAttendeeOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "BatchCreateAttendee"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds a specified number of users to a channel.
     */
    override suspend fun batchCreateChannelMembership(input: BatchCreateChannelMembershipRequest): BatchCreateChannelMembershipResponse {
        val op = SdkHttpOperation.build<BatchCreateChannelMembershipRequest, BatchCreateChannelMembershipResponse> {
            serializer = BatchCreateChannelMembershipOperationSerializer()
            deserializer = BatchCreateChannelMembershipOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchCreateChannelMembership"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds up to 50 members to a chat room in an Amazon Chime Enterprise account. Members can be users or bots. The member role designates whether the member is a chat room administrator or a general chat room member.
     */
    override suspend fun batchCreateRoomMembership(input: BatchCreateRoomMembershipRequest): BatchCreateRoomMembershipResponse {
        val op = SdkHttpOperation.build<BatchCreateRoomMembershipRequest, BatchCreateRoomMembershipResponse> {
            serializer = BatchCreateRoomMembershipOperationSerializer()
            deserializer = BatchCreateRoomMembershipOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "BatchCreateRoomMembership"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Moves phone numbers into the **Deletion queue**. Phone numbers must be disassociated from any users or Amazon Chime Voice Connectors before they can be deleted.
     *
     *  Phone numbers remain in the **Deletion queue** for 7 days before they are deleted permanently.
     */
    override suspend fun batchDeletePhoneNumber(input: BatchDeletePhoneNumberRequest): BatchDeletePhoneNumberResponse {
        val op = SdkHttpOperation.build<BatchDeletePhoneNumberRequest, BatchDeletePhoneNumberResponse> {
            serializer = BatchDeletePhoneNumberOperationSerializer()
            deserializer = BatchDeletePhoneNumberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDeletePhoneNumber"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Suspends up to 50 users from a `Team` or `EnterpriseLWA` Amazon Chime account. For more information about different account types, see [Managing Your Amazon Chime Accounts](https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html) in the *Amazon Chime Administration Guide*.
     *
     * Users suspended from a `Team` account are disassociated from the account,but they can continue to use Amazon Chime as free users. To remove the suspension from suspended `Team` account users, invite them to the `Team` account again. You can use the InviteUsers action to do so.
     *
     * Users suspended from an `EnterpriseLWA` account are immediately signed out of Amazon Chime and can no longer sign in. To remove the suspension from suspended `EnterpriseLWA` account users, use the BatchUnsuspendUser action.
     *
     *  To sign out users without suspending them, use the LogoutUser action.
     */
    override suspend fun batchSuspendUser(input: BatchSuspendUserRequest): BatchSuspendUserResponse {
        val op = SdkHttpOperation.build<BatchSuspendUserRequest, BatchSuspendUserResponse> {
            serializer = BatchSuspendUserOperationSerializer()
            deserializer = BatchSuspendUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchSuspendUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the suspension from up to 50 previously suspended users for the specified Amazon Chime `EnterpriseLWA` account. Only users on `EnterpriseLWA` accounts can be unsuspended using this action. For more information about different account types, see [ Managing Your Amazon Chime Accounts ](https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html) in the account types, in the *Amazon Chime Administration Guide*.
     *
     *  Previously suspended users who are unsuspended using this action are returned to `Registered` status. Users who are not previously suspended are ignored.
     */
    override suspend fun batchUnsuspendUser(input: BatchUnsuspendUserRequest): BatchUnsuspendUserResponse {
        val op = SdkHttpOperation.build<BatchUnsuspendUserRequest, BatchUnsuspendUserResponse> {
            serializer = BatchUnsuspendUserOperationSerializer()
            deserializer = BatchUnsuspendUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchUnsuspendUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates phone number product types or calling names. You can update one attribute at a time for each `UpdatePhoneNumberRequestItem`. For example, you can update the product type or the calling name.
     *
     * For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.
     *
     * Updates to outbound calling names can take up to 72 hours to complete. Pending updates to outbound calling names must be complete before you can request another update.
     */
    override suspend fun batchUpdatePhoneNumber(input: BatchUpdatePhoneNumberRequest): BatchUpdatePhoneNumberResponse {
        val op = SdkHttpOperation.build<BatchUpdatePhoneNumberRequest, BatchUpdatePhoneNumberResponse> {
            serializer = BatchUpdatePhoneNumberOperationSerializer()
            deserializer = BatchUpdatePhoneNumberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchUpdatePhoneNumber"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates user details within the UpdateUserRequestItem object for up to 20 users for the specified Amazon Chime account. Currently, only `LicenseType` updates are supported for this action.
     */
    override suspend fun batchUpdateUser(input: BatchUpdateUserRequest): BatchUpdateUserResponse {
        val op = SdkHttpOperation.build<BatchUpdateUserRequest, BatchUpdateUserResponse> {
            serializer = BatchUpdateUserOperationSerializer()
            deserializer = BatchUpdateUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchUpdateUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon Chime account under the administrator's AWS account. Only `Team` account types are currently supported for this action. For more information about different account types, see [Managing Your Amazon Chime Accounts](https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html) in the *Amazon Chime Administration Guide*.
     */
    override suspend fun createAccount(input: CreateAccountRequest): CreateAccountResponse {
        val op = SdkHttpOperation.build<CreateAccountRequest, CreateAccountResponse> {
            serializer = CreateAccountOperationSerializer()
            deserializer = CreateAccountOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon Chime SDK messaging `AppInstance` under an AWS account. Only SDK messaging customers use this API. `CreateAppInstance` supports idempotency behavior as described in the AWS API Standard.
     */
    override suspend fun createAppInstance(input: CreateAppInstanceRequest): CreateAppInstanceResponse {
        val op = SdkHttpOperation.build<CreateAppInstanceRequest, CreateAppInstanceResponse> {
            serializer = CreateAppInstanceOperationSerializer()
            deserializer = CreateAppInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateAppInstance"
                hostPrefix = "identity-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Promotes an `AppInstanceUser` to an `AppInstanceAdmin`. The promoted user can perform the following actions.
     * + `ChannelModerator` actions across all channels in the `AppInstance`.
     * + `DeleteChannelMessage` actions.
     *
     * Only an `AppInstanceUser` can be promoted to an `AppInstanceAdmin` role.
     */
    override suspend fun createAppInstanceAdmin(input: CreateAppInstanceAdminRequest): CreateAppInstanceAdminResponse {
        val op = SdkHttpOperation.build<CreateAppInstanceAdminRequest, CreateAppInstanceAdminResponse> {
            serializer = CreateAppInstanceAdminOperationSerializer()
            deserializer = CreateAppInstanceAdminOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateAppInstanceAdmin"
                hostPrefix = "identity-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a user under an Amazon Chime `AppInstance`. The request consists of a unique `appInstanceUserId` and `Name` for that user.
     */
    override suspend fun createAppInstanceUser(input: CreateAppInstanceUserRequest): CreateAppInstanceUserResponse {
        val op = SdkHttpOperation.build<CreateAppInstanceUserRequest, CreateAppInstanceUserResponse> {
            serializer = CreateAppInstanceUserOperationSerializer()
            deserializer = CreateAppInstanceUserOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateAppInstanceUser"
                hostPrefix = "identity-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new attendee for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide*.
     */
    override suspend fun createAttendee(input: CreateAttendeeRequest): CreateAttendeeResponse {
        val op = SdkHttpOperation.build<CreateAttendeeRequest, CreateAttendeeResponse> {
            serializer = CreateAttendeeOperationSerializer()
            deserializer = CreateAttendeeOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateAttendee"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a bot for an Amazon Chime Enterprise account.
     */
    override suspend fun createBot(input: CreateBotRequest): CreateBotResponse {
        val op = SdkHttpOperation.build<CreateBotRequest, CreateBotResponse> {
            serializer = CreateBotOperationSerializer()
            deserializer = CreateBotOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateBot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a channel to which you can add users and send messages.
     *
     * **Restriction**: You can't change a channel's privacy.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    override suspend fun createChannel(input: CreateChannelRequest): CreateChannelResponse {
        val op = SdkHttpOperation.build<CreateChannelRequest, CreateChannelResponse> {
            serializer = CreateChannelOperationSerializer()
            deserializer = CreateChannelOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateChannel"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Permanently bans a member from a channel. Moderators can't add banned members to a channel. To undo a ban, you first have to `DeleteChannelBan`, and then `CreateChannelMembership`. Bans are cleaned up when you delete users or channels.
     *
     * If you ban a user who is already part of a channel, that user is automatically kicked from the channel.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    override suspend fun createChannelBan(input: CreateChannelBanRequest): CreateChannelBanResponse {
        val op = SdkHttpOperation.build<CreateChannelBanRequest, CreateChannelBanResponse> {
            serializer = CreateChannelBanOperationSerializer()
            deserializer = CreateChannelBanOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateChannelBan"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds a user to a channel. The `InvitedBy` response field is derived from the request header. A channel member can:
     * + List messages
     * + Send messages
     * + Receive messages
     * + Edit their own messages
     * + Leave the channel
     *
     * Privacy settings impact this action as follows:
     * + Public Channels: You do not need to be a member to list messages, but you must be a member to send messages.
     * + Private Channels: You must be a member to list or send messages.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    override suspend fun createChannelMembership(input: CreateChannelMembershipRequest): CreateChannelMembershipResponse {
        val op = SdkHttpOperation.build<CreateChannelMembershipRequest, CreateChannelMembershipResponse> {
            serializer = CreateChannelMembershipOperationSerializer()
            deserializer = CreateChannelMembershipOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateChannelMembership"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new `ChannelModerator`. A channel moderator can:
     * + Add and remove other members of the channel.
     * + Add and remove other moderators of the channel.
     * + Add and remove user bans for the channel.
     * + Redact messages in the channel.
     * + List messages in the channel.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    override suspend fun createChannelModerator(input: CreateChannelModeratorRequest): CreateChannelModeratorResponse {
        val op = SdkHttpOperation.build<CreateChannelModeratorRequest, CreateChannelModeratorResponse> {
            serializer = CreateChannelModeratorOperationSerializer()
            deserializer = CreateChannelModeratorOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateChannelModerator"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a media capture pipeline.
     */
    override suspend fun createMediaCapturePipeline(input: CreateMediaCapturePipelineRequest): CreateMediaCapturePipelineResponse {
        val op = SdkHttpOperation.build<CreateMediaCapturePipelineRequest, CreateMediaCapturePipelineResponse> {
            serializer = CreateMediaCapturePipelineOperationSerializer()
            deserializer = CreateMediaCapturePipelineOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateMediaCapturePipeline"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Amazon Chime SDK meeting in the specified media Region with no initial attendees. For more information about specifying media Regions, see [Amazon Chime SDK Media Regions](https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html) in the *Amazon Chime Developer Guide* . For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide* .
     */
    override suspend fun createMeeting(input: CreateMeetingRequest): CreateMeetingResponse {
        val op = SdkHttpOperation.build<CreateMeetingRequest, CreateMeetingResponse> {
            serializer = CreateMeetingOperationSerializer()
            deserializer = CreateMeetingOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateMeeting"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Uses the join token and call metadata in a meeting request (From number, To number, and so forth) to initiate an outbound call to a public switched telephone network (PSTN) and join them into a Chime meeting. Also ensures that the From number belongs to the customer.
     *
     * To play welcome audio or implement an interactive voice response (IVR), use the `CreateSipMediaApplicationCall` action with the corresponding SIP media application ID.
     */
    override suspend fun createMeetingDialOut(input: CreateMeetingDialOutRequest): CreateMeetingDialOutResponse {
        val op = SdkHttpOperation.build<CreateMeetingDialOutRequest, CreateMeetingDialOutResponse> {
            serializer = CreateMeetingDialOutOperationSerializer()
            deserializer = CreateMeetingDialOutOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateMeetingDialOut"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Amazon Chime SDK meeting in the specified media Region, with attendees. For more information about specifying media Regions, see [Amazon Chime SDK Media Regions](https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html) in the *Amazon Chime Developer Guide* . For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide* .
     */
    override suspend fun createMeetingWithAttendees(input: CreateMeetingWithAttendeesRequest): CreateMeetingWithAttendeesResponse {
        val op = SdkHttpOperation.build<CreateMeetingWithAttendeesRequest, CreateMeetingWithAttendeesResponse> {
            serializer = CreateMeetingWithAttendeesOperationSerializer()
            deserializer = CreateMeetingWithAttendeesOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateMeetingWithAttendees"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an order for phone numbers to be provisioned. For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.
     */
    override suspend fun createPhoneNumberOrder(input: CreatePhoneNumberOrderRequest): CreatePhoneNumberOrderResponse {
        val op = SdkHttpOperation.build<CreatePhoneNumberOrderRequest, CreatePhoneNumberOrderResponse> {
            serializer = CreatePhoneNumberOrderOperationSerializer()
            deserializer = CreatePhoneNumberOrderOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreatePhoneNumberOrder"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a proxy session on the specified Amazon Chime Voice Connector for the specified participant phone numbers.
     */
    override suspend fun createProxySession(input: CreateProxySessionRequest): CreateProxySessionResponse {
        val op = SdkHttpOperation.build<CreateProxySessionRequest, CreateProxySessionResponse> {
            serializer = CreateProxySessionOperationSerializer()
            deserializer = CreateProxySessionOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateProxySession"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a chat room for the specified Amazon Chime Enterprise account.
     */
    override suspend fun createRoom(input: CreateRoomRequest): CreateRoomResponse {
        val op = SdkHttpOperation.build<CreateRoomRequest, CreateRoomResponse> {
            serializer = CreateRoomOperationSerializer()
            deserializer = CreateRoomOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateRoom"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds a member to a chat room in an Amazon Chime Enterprise account. A member can be either a user or a bot. The member role designates whether the member is a chat room administrator or a general chat room member.
     */
    override suspend fun createRoomMembership(input: CreateRoomMembershipRequest): CreateRoomMembershipResponse {
        val op = SdkHttpOperation.build<CreateRoomMembershipRequest, CreateRoomMembershipResponse> {
            serializer = CreateRoomMembershipOperationSerializer()
            deserializer = CreateRoomMembershipOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateRoomMembership"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a SIP media application.
     */
    override suspend fun createSipMediaApplication(input: CreateSipMediaApplicationRequest): CreateSipMediaApplicationResponse {
        val op = SdkHttpOperation.build<CreateSipMediaApplicationRequest, CreateSipMediaApplicationResponse> {
            serializer = CreateSipMediaApplicationOperationSerializer()
            deserializer = CreateSipMediaApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateSipMediaApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an outbound call to a phone number from the phone number specified in the request, and it invokes the endpoint of the specified `sipMediaApplicationId`.
     */
    override suspend fun createSipMediaApplicationCall(input: CreateSipMediaApplicationCallRequest): CreateSipMediaApplicationCallResponse {
        val op = SdkHttpOperation.build<CreateSipMediaApplicationCallRequest, CreateSipMediaApplicationCallResponse> {
            serializer = CreateSipMediaApplicationCallOperationSerializer()
            deserializer = CreateSipMediaApplicationCallOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateSipMediaApplicationCall"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a SIP rule which can be used to run a SIP media application as a target for a specific trigger type.
     */
    override suspend fun createSipRule(input: CreateSipRuleRequest): CreateSipRuleResponse {
        val op = SdkHttpOperation.build<CreateSipRuleRequest, CreateSipRuleResponse> {
            serializer = CreateSipRuleOperationSerializer()
            deserializer = CreateSipRuleOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateSipRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a user under the specified Amazon Chime account.
     */
    override suspend fun createUser(input: CreateUserRequest): CreateUserResponse {
        val op = SdkHttpOperation.build<CreateUserRequest, CreateUserResponse> {
            serializer = CreateUserOperationSerializer()
            deserializer = CreateUserOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon Chime Voice Connector under the administrator's AWS account. You can choose to create an Amazon Chime Voice Connector in a specific AWS Region.
     *
     *  Enabling CreateVoiceConnectorRequest$RequireEncryption configures your Amazon Chime Voice Connector to use TLS transport for SIP signaling and Secure RTP (SRTP) for media. Inbound calls use TLS transport, and unencrypted outbound calls are blocked.
     */
    override suspend fun createVoiceConnector(input: CreateVoiceConnectorRequest): CreateVoiceConnectorResponse {
        val op = SdkHttpOperation.build<CreateVoiceConnectorRequest, CreateVoiceConnectorResponse> {
            serializer = CreateVoiceConnectorOperationSerializer()
            deserializer = CreateVoiceConnectorOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateVoiceConnector"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon Chime Voice Connector group under the administrator's AWS account. You can associate Amazon Chime Voice Connectors with the Amazon Chime Voice Connector group by including `VoiceConnectorItems` in the request.
     *
     * You can include Amazon Chime Voice Connectors from different AWS Regions in your group. This creates a fault tolerant mechanism for fallback in case of availability events.
     */
    override suspend fun createVoiceConnectorGroup(input: CreateVoiceConnectorGroupRequest): CreateVoiceConnectorGroupResponse {
        val op = SdkHttpOperation.build<CreateVoiceConnectorGroupRequest, CreateVoiceConnectorGroupResponse> {
            serializer = CreateVoiceConnectorGroupOperationSerializer()
            deserializer = CreateVoiceConnectorGroupOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateVoiceConnectorGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified Amazon Chime account. You must suspend all users before deleting `Team` account. You can use the BatchSuspendUser action to dodo.
     *
     * For `EnterpriseLWA` and `EnterpriseAD` accounts, you must release the claimed domains for your Amazon Chime account before deletion. As soon as you release the domain, all users under that account are suspended.
     *
     * Deleted accounts appear in your `Disabled` accounts list for 90 days. To restore deleted account from your `Disabled` accounts list, you must contact AWS Support.
     *
     * After 90 days, deleted accounts are permanently removed from your `Disabled` accounts list.
     */
    override suspend fun deleteAccount(input: DeleteAccountRequest): DeleteAccountResponse {
        val op = SdkHttpOperation.build<DeleteAccountRequest, DeleteAccountResponse> {
            serializer = DeleteAccountOperationSerializer()
            deserializer = DeleteAccountOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an `AppInstance` and all associated data asynchronously.
     */
    override suspend fun deleteAppInstance(input: DeleteAppInstanceRequest): DeleteAppInstanceResponse {
        val op = SdkHttpOperation.build<DeleteAppInstanceRequest, DeleteAppInstanceResponse> {
            serializer = DeleteAppInstanceOperationSerializer()
            deserializer = DeleteAppInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteAppInstance"
                hostPrefix = "identity-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Demotes an `AppInstanceAdmin` to an `AppInstanceUser`. This action does not delete the user.
     */
    override suspend fun deleteAppInstanceAdmin(input: DeleteAppInstanceAdminRequest): DeleteAppInstanceAdminResponse {
        val op = SdkHttpOperation.build<DeleteAppInstanceAdminRequest, DeleteAppInstanceAdminResponse> {
            serializer = DeleteAppInstanceAdminOperationSerializer()
            deserializer = DeleteAppInstanceAdminOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteAppInstanceAdmin"
                hostPrefix = "identity-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the streaming configurations of an `AppInstance`.
     */
    override suspend fun deleteAppInstanceStreamingConfigurations(input: DeleteAppInstanceStreamingConfigurationsRequest): DeleteAppInstanceStreamingConfigurationsResponse {
        val op = SdkHttpOperation.build<DeleteAppInstanceStreamingConfigurationsRequest, DeleteAppInstanceStreamingConfigurationsResponse> {
            serializer = DeleteAppInstanceStreamingConfigurationsOperationSerializer()
            deserializer = DeleteAppInstanceStreamingConfigurationsOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteAppInstanceStreamingConfigurations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an `AppInstanceUser`.
     */
    override suspend fun deleteAppInstanceUser(input: DeleteAppInstanceUserRequest): DeleteAppInstanceUserResponse {
        val op = SdkHttpOperation.build<DeleteAppInstanceUserRequest, DeleteAppInstanceUserResponse> {
            serializer = DeleteAppInstanceUserOperationSerializer()
            deserializer = DeleteAppInstanceUserOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteAppInstanceUser"
                hostPrefix = "identity-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an attendee from the specified Amazon Chime SDK meeting and deletes their `JoinToken`. Attendees are automatically deleted when a Amazon Chime SDK meeting is deleted. For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide*.
     */
    override suspend fun deleteAttendee(input: DeleteAttendeeRequest): DeleteAttendeeResponse {
        val op = SdkHttpOperation.build<DeleteAttendeeRequest, DeleteAttendeeResponse> {
            serializer = DeleteAttendeeOperationSerializer()
            deserializer = DeleteAttendeeOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteAttendee"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Immediately makes a channel and its memberships inaccessible and marks them for deletion. This is an irreversible process.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    override suspend fun deleteChannel(input: DeleteChannelRequest): DeleteChannelResponse {
        val op = SdkHttpOperation.build<DeleteChannelRequest, DeleteChannelResponse> {
            serializer = DeleteChannelOperationSerializer()
            deserializer = DeleteChannelOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteChannel"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a user from a channel's ban list.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    override suspend fun deleteChannelBan(input: DeleteChannelBanRequest): DeleteChannelBanResponse {
        val op = SdkHttpOperation.build<DeleteChannelBanRequest, DeleteChannelBanResponse> {
            serializer = DeleteChannelBanOperationSerializer()
            deserializer = DeleteChannelBanOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteChannelBan"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a member from a channel.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    override suspend fun deleteChannelMembership(input: DeleteChannelMembershipRequest): DeleteChannelMembershipResponse {
        val op = SdkHttpOperation.build<DeleteChannelMembershipRequest, DeleteChannelMembershipResponse> {
            serializer = DeleteChannelMembershipOperationSerializer()
            deserializer = DeleteChannelMembershipOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteChannelMembership"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a channel message. Only admins can perform this action. Deletion makes messages inaccessible immediately. A background process deletes any revisions created by `UpdateChannelMessage`.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    override suspend fun deleteChannelMessage(input: DeleteChannelMessageRequest): DeleteChannelMessageResponse {
        val op = SdkHttpOperation.build<DeleteChannelMessageRequest, DeleteChannelMessageResponse> {
            serializer = DeleteChannelMessageOperationSerializer()
            deserializer = DeleteChannelMessageOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteChannelMessage"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a channel moderator.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    override suspend fun deleteChannelModerator(input: DeleteChannelModeratorRequest): DeleteChannelModeratorResponse {
        val op = SdkHttpOperation.build<DeleteChannelModeratorRequest, DeleteChannelModeratorResponse> {
            serializer = DeleteChannelModeratorOperationSerializer()
            deserializer = DeleteChannelModeratorOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteChannelModerator"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the events configuration that allows a bot to receive outgoing events.
     */
    override suspend fun deleteEventsConfiguration(input: DeleteEventsConfigurationRequest): DeleteEventsConfigurationResponse {
        val op = SdkHttpOperation.build<DeleteEventsConfigurationRequest, DeleteEventsConfigurationResponse> {
            serializer = DeleteEventsConfigurationOperationSerializer()
            deserializer = DeleteEventsConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteEventsConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the media capture pipeline.
     */
    override suspend fun deleteMediaCapturePipeline(input: DeleteMediaCapturePipelineRequest): DeleteMediaCapturePipelineResponse {
        val op = SdkHttpOperation.build<DeleteMediaCapturePipelineRequest, DeleteMediaCapturePipelineResponse> {
            serializer = DeleteMediaCapturePipelineOperationSerializer()
            deserializer = DeleteMediaCapturePipelineOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteMediaCapturePipeline"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified Amazon Chime SDK meeting. The operation deletes all attendees, disconnects all clients, and prevents new clients from joining the meeting. For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide*.
     */
    override suspend fun deleteMeeting(input: DeleteMeetingRequest): DeleteMeetingResponse {
        val op = SdkHttpOperation.build<DeleteMeetingRequest, DeleteMeetingResponse> {
            serializer = DeleteMeetingOperationSerializer()
            deserializer = DeleteMeetingOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteMeeting"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Moves the specified phone number into the **Deletion queue**. A phone number must be disassociated from any users or Amazon Chime Voice Connectors before it can be deleted.
     *
     * Deleted phone numbers remain in the **Deletion queue** for 7 days before they are deleted permanently.
     */
    override suspend fun deletePhoneNumber(input: DeletePhoneNumberRequest): DeletePhoneNumberResponse {
        val op = SdkHttpOperation.build<DeletePhoneNumberRequest, DeletePhoneNumberResponse> {
            serializer = DeletePhoneNumberOperationSerializer()
            deserializer = DeletePhoneNumberOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeletePhoneNumber"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified proxy session from the specified Amazon Chime Voice Connector.
     */
    override suspend fun deleteProxySession(input: DeleteProxySessionRequest): DeleteProxySessionResponse {
        val op = SdkHttpOperation.build<DeleteProxySessionRequest, DeleteProxySessionResponse> {
            serializer = DeleteProxySessionOperationSerializer()
            deserializer = DeleteProxySessionOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteProxySession"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a chat room in an Amazon Chime Enterprise account.
     */
    override suspend fun deleteRoom(input: DeleteRoomRequest): DeleteRoomResponse {
        val op = SdkHttpOperation.build<DeleteRoomRequest, DeleteRoomResponse> {
            serializer = DeleteRoomOperationSerializer()
            deserializer = DeleteRoomOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteRoom"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a member from a chat room in an Amazon Chime Enterprise account.
     */
    override suspend fun deleteRoomMembership(input: DeleteRoomMembershipRequest): DeleteRoomMembershipResponse {
        val op = SdkHttpOperation.build<DeleteRoomMembershipRequest, DeleteRoomMembershipResponse> {
            serializer = DeleteRoomMembershipOperationSerializer()
            deserializer = DeleteRoomMembershipOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteRoomMembership"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a SIP media application.
     */
    override suspend fun deleteSipMediaApplication(input: DeleteSipMediaApplicationRequest): DeleteSipMediaApplicationResponse {
        val op = SdkHttpOperation.build<DeleteSipMediaApplicationRequest, DeleteSipMediaApplicationResponse> {
            serializer = DeleteSipMediaApplicationOperationSerializer()
            deserializer = DeleteSipMediaApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteSipMediaApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a SIP rule. You must disable a SIP rule before you can delete it.
     */
    override suspend fun deleteSipRule(input: DeleteSipRuleRequest): DeleteSipRuleResponse {
        val op = SdkHttpOperation.build<DeleteSipRuleRequest, DeleteSipRuleResponse> {
            serializer = DeleteSipRuleOperationSerializer()
            deserializer = DeleteSipRuleOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteSipRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified Amazon Chime Voice Connector. Any phone numbers associated with the Amazon Chime Voice Connector must be disassociated from it before it can be deleted.
     */
    override suspend fun deleteVoiceConnector(input: DeleteVoiceConnectorRequest): DeleteVoiceConnectorResponse {
        val op = SdkHttpOperation.build<DeleteVoiceConnectorRequest, DeleteVoiceConnectorResponse> {
            serializer = DeleteVoiceConnectorOperationSerializer()
            deserializer = DeleteVoiceConnectorOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteVoiceConnector"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the emergency calling configuration details from the specified Amazon Chime Voice Connector.
     */
    override suspend fun deleteVoiceConnectorEmergencyCallingConfiguration(input: DeleteVoiceConnectorEmergencyCallingConfigurationRequest): DeleteVoiceConnectorEmergencyCallingConfigurationResponse {
        val op = SdkHttpOperation.build<DeleteVoiceConnectorEmergencyCallingConfigurationRequest, DeleteVoiceConnectorEmergencyCallingConfigurationResponse> {
            serializer = DeleteVoiceConnectorEmergencyCallingConfigurationOperationSerializer()
            deserializer = DeleteVoiceConnectorEmergencyCallingConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteVoiceConnectorEmergencyCallingConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified Amazon Chime Voice Connector group. Any `VoiceConnectorItems` and phone numbers associated with the group must be removed before it can be deleted.
     */
    override suspend fun deleteVoiceConnectorGroup(input: DeleteVoiceConnectorGroupRequest): DeleteVoiceConnectorGroupResponse {
        val op = SdkHttpOperation.build<DeleteVoiceConnectorGroupRequest, DeleteVoiceConnectorGroupResponse> {
            serializer = DeleteVoiceConnectorGroupOperationSerializer()
            deserializer = DeleteVoiceConnectorGroupOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteVoiceConnectorGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the origination settings for the specified Amazon Chime Voice Connector.
     *
     * If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to deleting the origination settings.
     */
    override suspend fun deleteVoiceConnectorOrigination(input: DeleteVoiceConnectorOriginationRequest): DeleteVoiceConnectorOriginationResponse {
        val op = SdkHttpOperation.build<DeleteVoiceConnectorOriginationRequest, DeleteVoiceConnectorOriginationResponse> {
            serializer = DeleteVoiceConnectorOriginationOperationSerializer()
            deserializer = DeleteVoiceConnectorOriginationOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteVoiceConnectorOrigination"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the proxy configuration from the specified Amazon Chime Voice Connector.
     */
    override suspend fun deleteVoiceConnectorProxy(input: DeleteVoiceConnectorProxyRequest): DeleteVoiceConnectorProxyResponse {
        val op = SdkHttpOperation.build<DeleteVoiceConnectorProxyRequest, DeleteVoiceConnectorProxyResponse> {
            serializer = DeleteVoiceConnectorProxyOperationSerializer()
            deserializer = DeleteVoiceConnectorProxyOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteVoiceConnectorProxy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the streaming configuration for the specified Amazon Chime Voice Connector.
     */
    override suspend fun deleteVoiceConnectorStreamingConfiguration(input: DeleteVoiceConnectorStreamingConfigurationRequest): DeleteVoiceConnectorStreamingConfigurationResponse {
        val op = SdkHttpOperation.build<DeleteVoiceConnectorStreamingConfigurationRequest, DeleteVoiceConnectorStreamingConfigurationResponse> {
            serializer = DeleteVoiceConnectorStreamingConfigurationOperationSerializer()
            deserializer = DeleteVoiceConnectorStreamingConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteVoiceConnectorStreamingConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the termination settings for the specified Amazon Chime Voice Connector.
     *
     * If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to deleting the termination settings.
     */
    override suspend fun deleteVoiceConnectorTermination(input: DeleteVoiceConnectorTerminationRequest): DeleteVoiceConnectorTerminationResponse {
        val op = SdkHttpOperation.build<DeleteVoiceConnectorTerminationRequest, DeleteVoiceConnectorTerminationResponse> {
            serializer = DeleteVoiceConnectorTerminationOperationSerializer()
            deserializer = DeleteVoiceConnectorTerminationOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteVoiceConnectorTermination"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified SIP credentials used by your equipment to authenticate during call termination.
     */
    override suspend fun deleteVoiceConnectorTerminationCredentials(input: DeleteVoiceConnectorTerminationCredentialsRequest): DeleteVoiceConnectorTerminationCredentialsResponse {
        val op = SdkHttpOperation.build<DeleteVoiceConnectorTerminationCredentialsRequest, DeleteVoiceConnectorTerminationCredentialsResponse> {
            serializer = DeleteVoiceConnectorTerminationCredentialsOperationSerializer()
            deserializer = DeleteVoiceConnectorTerminationCredentialsOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteVoiceConnectorTerminationCredentials"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the full details of an `AppInstance`.
     */
    override suspend fun describeAppInstance(input: DescribeAppInstanceRequest): DescribeAppInstanceResponse {
        val op = SdkHttpOperation.build<DescribeAppInstanceRequest, DescribeAppInstanceResponse> {
            serializer = DescribeAppInstanceOperationSerializer()
            deserializer = DescribeAppInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAppInstance"
                hostPrefix = "identity-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the full details of an `AppInstanceAdmin`.
     */
    override suspend fun describeAppInstanceAdmin(input: DescribeAppInstanceAdminRequest): DescribeAppInstanceAdminResponse {
        val op = SdkHttpOperation.build<DescribeAppInstanceAdminRequest, DescribeAppInstanceAdminResponse> {
            serializer = DescribeAppInstanceAdminOperationSerializer()
            deserializer = DescribeAppInstanceAdminOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAppInstanceAdmin"
                hostPrefix = "identity-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the full details of an `AppInstanceUser`.
     */
    override suspend fun describeAppInstanceUser(input: DescribeAppInstanceUserRequest): DescribeAppInstanceUserResponse {
        val op = SdkHttpOperation.build<DescribeAppInstanceUserRequest, DescribeAppInstanceUserResponse> {
            serializer = DescribeAppInstanceUserOperationSerializer()
            deserializer = DescribeAppInstanceUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAppInstanceUser"
                hostPrefix = "identity-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the full details of a channel in an Amazon Chime `AppInstance`.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    override suspend fun describeChannel(input: DescribeChannelRequest): DescribeChannelResponse {
        val op = SdkHttpOperation.build<DescribeChannelRequest, DescribeChannelResponse> {
            serializer = DescribeChannelOperationSerializer()
            deserializer = DescribeChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeChannel"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the full details of a channel ban.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    override suspend fun describeChannelBan(input: DescribeChannelBanRequest): DescribeChannelBanResponse {
        val op = SdkHttpOperation.build<DescribeChannelBanRequest, DescribeChannelBanResponse> {
            serializer = DescribeChannelBanOperationSerializer()
            deserializer = DescribeChannelBanOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeChannelBan"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the full details of a user's channel membership.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    override suspend fun describeChannelMembership(input: DescribeChannelMembershipRequest): DescribeChannelMembershipResponse {
        val op = SdkHttpOperation.build<DescribeChannelMembershipRequest, DescribeChannelMembershipResponse> {
            serializer = DescribeChannelMembershipOperationSerializer()
            deserializer = DescribeChannelMembershipOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeChannelMembership"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the details of a channel based on the membership of the specified `AppInstanceUser`.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    override suspend fun describeChannelMembershipForAppInstanceUser(input: DescribeChannelMembershipForAppInstanceUserRequest): DescribeChannelMembershipForAppInstanceUserResponse {
        val op = SdkHttpOperation.build<DescribeChannelMembershipForAppInstanceUserRequest, DescribeChannelMembershipForAppInstanceUserResponse> {
            serializer = DescribeChannelMembershipForAppInstanceUserOperationSerializer()
            deserializer = DescribeChannelMembershipForAppInstanceUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeChannelMembershipForAppInstanceUser"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the full details of a channel moderated by the specified `AppInstanceUser`.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    override suspend fun describeChannelModeratedByAppInstanceUser(input: DescribeChannelModeratedByAppInstanceUserRequest): DescribeChannelModeratedByAppInstanceUserResponse {
        val op = SdkHttpOperation.build<DescribeChannelModeratedByAppInstanceUserRequest, DescribeChannelModeratedByAppInstanceUserResponse> {
            serializer = DescribeChannelModeratedByAppInstanceUserOperationSerializer()
            deserializer = DescribeChannelModeratedByAppInstanceUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeChannelModeratedByAppInstanceUser"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the full details of a single ChannelModerator.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    override suspend fun describeChannelModerator(input: DescribeChannelModeratorRequest): DescribeChannelModeratorResponse {
        val op = SdkHttpOperation.build<DescribeChannelModeratorRequest, DescribeChannelModeratorResponse> {
            serializer = DescribeChannelModeratorOperationSerializer()
            deserializer = DescribeChannelModeratorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeChannelModerator"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates the primary provisioned phone number from the specified Amazon Chime user.
     */
    override suspend fun disassociatePhoneNumberFromUser(input: DisassociatePhoneNumberFromUserRequest): DisassociatePhoneNumberFromUserResponse {
        val op = SdkHttpOperation.build<DisassociatePhoneNumberFromUserRequest, DisassociatePhoneNumberFromUserResponse> {
            serializer = DisassociatePhoneNumberFromUserOperationSerializer()
            deserializer = DisassociatePhoneNumberFromUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociatePhoneNumberFromUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates the specified phone numbers from the specified Amazon Chime Voice Connector.
     */
    override suspend fun disassociatePhoneNumbersFromVoiceConnector(input: DisassociatePhoneNumbersFromVoiceConnectorRequest): DisassociatePhoneNumbersFromVoiceConnectorResponse {
        val op = SdkHttpOperation.build<DisassociatePhoneNumbersFromVoiceConnectorRequest, DisassociatePhoneNumbersFromVoiceConnectorResponse> {
            serializer = DisassociatePhoneNumbersFromVoiceConnectorOperationSerializer()
            deserializer = DisassociatePhoneNumbersFromVoiceConnectorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociatePhoneNumbersFromVoiceConnector"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates the specified phone numbers from the specified Amazon Chime Voice Connector group.
     */
    override suspend fun disassociatePhoneNumbersFromVoiceConnectorGroup(input: DisassociatePhoneNumbersFromVoiceConnectorGroupRequest): DisassociatePhoneNumbersFromVoiceConnectorGroupResponse {
        val op = SdkHttpOperation.build<DisassociatePhoneNumbersFromVoiceConnectorGroupRequest, DisassociatePhoneNumbersFromVoiceConnectorGroupResponse> {
            serializer = DisassociatePhoneNumbersFromVoiceConnectorGroupOperationSerializer()
            deserializer = DisassociatePhoneNumbersFromVoiceConnectorGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociatePhoneNumbersFromVoiceConnectorGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates the specified sign-in delegate groups from the specified Amazon Chime account.
     */
    override suspend fun disassociateSigninDelegateGroupsFromAccount(input: DisassociateSigninDelegateGroupsFromAccountRequest): DisassociateSigninDelegateGroupsFromAccountResponse {
        val op = SdkHttpOperation.build<DisassociateSigninDelegateGroupsFromAccountRequest, DisassociateSigninDelegateGroupsFromAccountResponse> {
            serializer = DisassociateSigninDelegateGroupsFromAccountOperationSerializer()
            deserializer = DisassociateSigninDelegateGroupsFromAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateSigninDelegateGroupsFromAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves details for the specified Amazon Chime account, such as account type and supported licenses.
     */
    override suspend fun getAccount(input: GetAccountRequest): GetAccountResponse {
        val op = SdkHttpOperation.build<GetAccountRequest, GetAccountResponse> {
            serializer = GetAccountOperationSerializer()
            deserializer = GetAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves account settings for the specified Amazon Chime account ID, such as remote control and dialout settings. For more information about these settings, see [Use the Policies Page](https://docs.aws.amazon.com/chime/latest/ag/policies.html) in the *Amazon Chime Administration Guide*.
     */
    override suspend fun getAccountSettings(input: GetAccountSettingsRequest): GetAccountSettingsResponse {
        val op = SdkHttpOperation.build<GetAccountSettingsRequest, GetAccountSettingsResponse> {
            serializer = GetAccountSettingsOperationSerializer()
            deserializer = GetAccountSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAccountSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the retention settings for an `AppInstance`.
     */
    override suspend fun getAppInstanceRetentionSettings(input: GetAppInstanceRetentionSettingsRequest): GetAppInstanceRetentionSettingsResponse {
        val op = SdkHttpOperation.build<GetAppInstanceRetentionSettingsRequest, GetAppInstanceRetentionSettingsResponse> {
            serializer = GetAppInstanceRetentionSettingsOperationSerializer()
            deserializer = GetAppInstanceRetentionSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAppInstanceRetentionSettings"
                hostPrefix = "identity-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the streaming settings for an `AppInstance`.
     */
    override suspend fun getAppInstanceStreamingConfigurations(input: GetAppInstanceStreamingConfigurationsRequest): GetAppInstanceStreamingConfigurationsResponse {
        val op = SdkHttpOperation.build<GetAppInstanceStreamingConfigurationsRequest, GetAppInstanceStreamingConfigurationsResponse> {
            serializer = GetAppInstanceStreamingConfigurationsOperationSerializer()
            deserializer = GetAppInstanceStreamingConfigurationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAppInstanceStreamingConfigurations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the Amazon Chime SDK attendee details for a specified meeting ID and attendee ID. For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide* .
     */
    override suspend fun getAttendee(input: GetAttendeeRequest): GetAttendeeResponse {
        val op = SdkHttpOperation.build<GetAttendeeRequest, GetAttendeeResponse> {
            serializer = GetAttendeeOperationSerializer()
            deserializer = GetAttendeeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAttendee"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves details for the specified bot, such as bot email address, bot type, status, and display name.
     */
    override suspend fun getBot(input: GetBotRequest): GetBotResponse {
        val op = SdkHttpOperation.build<GetBotRequest, GetBotResponse> {
            serializer = GetBotOperationSerializer()
            deserializer = GetBotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the full details of a channel message.
     *
     * The x-amz-chime-bearer request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    override suspend fun getChannelMessage(input: GetChannelMessageRequest): GetChannelMessageResponse {
        val op = SdkHttpOperation.build<GetChannelMessageRequest, GetChannelMessageResponse> {
            serializer = GetChannelMessageOperationSerializer()
            deserializer = GetChannelMessageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetChannelMessage"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets details for an events configuration that allows a bot to receive outgoing events, such as an HTTPS endpoint or Lambda function ARN.
     */
    override suspend fun getEventsConfiguration(input: GetEventsConfigurationRequest): GetEventsConfigurationResponse {
        val op = SdkHttpOperation.build<GetEventsConfigurationRequest, GetEventsConfigurationResponse> {
            serializer = GetEventsConfigurationOperationSerializer()
            deserializer = GetEventsConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEventsConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves global settings for the administrator's AWS account, such as Amazon Chime Business Calling and Amazon Chime Voice Connector settings.
     */
    override suspend fun getGlobalSettings(input: GetGlobalSettingsRequest): GetGlobalSettingsResponse {
        val op = SdkHttpOperation.build<GetGlobalSettingsRequest, GetGlobalSettingsResponse> {
            serializer = GetGlobalSettingsOperationSerializer()
            deserializer = GetGlobalSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetGlobalSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets an existing media capture pipeline.
     */
    override suspend fun getMediaCapturePipeline(input: GetMediaCapturePipelineRequest): GetMediaCapturePipelineResponse {
        val op = SdkHttpOperation.build<GetMediaCapturePipelineRequest, GetMediaCapturePipelineResponse> {
            serializer = GetMediaCapturePipelineOperationSerializer()
            deserializer = GetMediaCapturePipelineOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMediaCapturePipeline"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the Amazon Chime SDK meeting details for the specified meeting ID. For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide* .
     */
    override suspend fun getMeeting(input: GetMeetingRequest): GetMeetingResponse {
        val op = SdkHttpOperation.build<GetMeetingRequest, GetMeetingResponse> {
            serializer = GetMeetingOperationSerializer()
            deserializer = GetMeetingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMeeting"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The details of the endpoint for the messaging session.
     */
    override suspend fun getMessagingSessionEndpoint(input: GetMessagingSessionEndpointRequest): GetMessagingSessionEndpointResponse {
        val op = SdkHttpOperation.build<GetMessagingSessionEndpointRequest, GetMessagingSessionEndpointResponse> {
            serializer = GetMessagingSessionEndpointOperationSerializer()
            deserializer = GetMessagingSessionEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMessagingSessionEndpoint"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves details for the specified phone number ID, such as associations, capabilities, and product type.
     */
    override suspend fun getPhoneNumber(input: GetPhoneNumberRequest): GetPhoneNumberResponse {
        val op = SdkHttpOperation.build<GetPhoneNumberRequest, GetPhoneNumberResponse> {
            serializer = GetPhoneNumberOperationSerializer()
            deserializer = GetPhoneNumberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPhoneNumber"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves details for the specified phone number order, such as the order creation timestamp, phone numbers in E.164 format, product type, and order status.
     */
    override suspend fun getPhoneNumberOrder(input: GetPhoneNumberOrderRequest): GetPhoneNumberOrderResponse {
        val op = SdkHttpOperation.build<GetPhoneNumberOrderRequest, GetPhoneNumberOrderResponse> {
            serializer = GetPhoneNumberOrderOperationSerializer()
            deserializer = GetPhoneNumberOrderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPhoneNumberOrder"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the phone number settings for the administrator's AWS account, such as the default outbound calling name.
     */
    override suspend fun getPhoneNumberSettings(input: GetPhoneNumberSettingsRequest): GetPhoneNumberSettingsResponse {
        val op = SdkHttpOperation.build<GetPhoneNumberSettingsRequest, GetPhoneNumberSettingsResponse> {
            serializer = GetPhoneNumberSettingsOperationSerializer()
            deserializer = GetPhoneNumberSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPhoneNumberSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the specified proxy session details for the specified Amazon Chime Voice Connector.
     */
    override suspend fun getProxySession(input: GetProxySessionRequest): GetProxySessionResponse {
        val op = SdkHttpOperation.build<GetProxySessionRequest, GetProxySessionResponse> {
            serializer = GetProxySessionOperationSerializer()
            deserializer = GetProxySessionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetProxySession"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the retention settings for the specified Amazon Chime Enterprise account. For more information about retention settings, see [Managing Chat Retention Policies](https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html) in the *Amazon Chime Administration Guide*.
     */
    override suspend fun getRetentionSettings(input: GetRetentionSettingsRequest): GetRetentionSettingsResponse {
        val op = SdkHttpOperation.build<GetRetentionSettingsRequest, GetRetentionSettingsResponse> {
            serializer = GetRetentionSettingsOperationSerializer()
            deserializer = GetRetentionSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRetentionSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves room details, such as the room name, for a room in an Amazon Chime Enterprise account.
     */
    override suspend fun getRoom(input: GetRoomRequest): GetRoomResponse {
        val op = SdkHttpOperation.build<GetRoomRequest, GetRoomResponse> {
            serializer = GetRoomOperationSerializer()
            deserializer = GetRoomOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRoom"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the information for a SIP media application, including name, AWS Region, and endpoints.
     */
    override suspend fun getSipMediaApplication(input: GetSipMediaApplicationRequest): GetSipMediaApplicationResponse {
        val op = SdkHttpOperation.build<GetSipMediaApplicationRequest, GetSipMediaApplicationResponse> {
            serializer = GetSipMediaApplicationOperationSerializer()
            deserializer = GetSipMediaApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSipMediaApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the logging configuration for the specified SIP media application.
     */
    override suspend fun getSipMediaApplicationLoggingConfiguration(input: GetSipMediaApplicationLoggingConfigurationRequest): GetSipMediaApplicationLoggingConfigurationResponse {
        val op = SdkHttpOperation.build<GetSipMediaApplicationLoggingConfigurationRequest, GetSipMediaApplicationLoggingConfigurationResponse> {
            serializer = GetSipMediaApplicationLoggingConfigurationOperationSerializer()
            deserializer = GetSipMediaApplicationLoggingConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSipMediaApplicationLoggingConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the details of a SIP rule, such as the rule ID, name, triggers, and target endpoints.
     */
    override suspend fun getSipRule(input: GetSipRuleRequest): GetSipRuleResponse {
        val op = SdkHttpOperation.build<GetSipRuleRequest, GetSipRuleResponse> {
            serializer = GetSipRuleOperationSerializer()
            deserializer = GetSipRuleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSipRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves details for the specified user ID, such as primary email address, license type,and personal meeting PIN.
     *
     *  To retrieve user details with an email address instead of a user ID, use the ListUsers action, and then filter by email address.
     */
    override suspend fun getUser(input: GetUserRequest): GetUserResponse {
        val op = SdkHttpOperation.build<GetUserRequest, GetUserResponse> {
            serializer = GetUserOperationSerializer()
            deserializer = GetUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves settings for the specified user ID, such as any associated phone number settings.
     */
    override suspend fun getUserSettings(input: GetUserSettingsRequest): GetUserSettingsResponse {
        val op = SdkHttpOperation.build<GetUserSettingsRequest, GetUserSettingsResponse> {
            serializer = GetUserSettingsOperationSerializer()
            deserializer = GetUserSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetUserSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves details for the specified Amazon Chime Voice Connector, such as timestamps,name, outbound host, and encryption requirements.
     */
    override suspend fun getVoiceConnector(input: GetVoiceConnectorRequest): GetVoiceConnectorResponse {
        val op = SdkHttpOperation.build<GetVoiceConnectorRequest, GetVoiceConnectorResponse> {
            serializer = GetVoiceConnectorOperationSerializer()
            deserializer = GetVoiceConnectorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetVoiceConnector"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the emergency calling configuration details for the specified Amazon Chime Voice Connector.
     */
    override suspend fun getVoiceConnectorEmergencyCallingConfiguration(input: GetVoiceConnectorEmergencyCallingConfigurationRequest): GetVoiceConnectorEmergencyCallingConfigurationResponse {
        val op = SdkHttpOperation.build<GetVoiceConnectorEmergencyCallingConfigurationRequest, GetVoiceConnectorEmergencyCallingConfigurationResponse> {
            serializer = GetVoiceConnectorEmergencyCallingConfigurationOperationSerializer()
            deserializer = GetVoiceConnectorEmergencyCallingConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetVoiceConnectorEmergencyCallingConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves details for the specified Amazon Chime Voice Connector group, such as timestamps,name, and associated `VoiceConnectorItems`.
     */
    override suspend fun getVoiceConnectorGroup(input: GetVoiceConnectorGroupRequest): GetVoiceConnectorGroupResponse {
        val op = SdkHttpOperation.build<GetVoiceConnectorGroupRequest, GetVoiceConnectorGroupResponse> {
            serializer = GetVoiceConnectorGroupOperationSerializer()
            deserializer = GetVoiceConnectorGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetVoiceConnectorGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the logging configuration details for the specified Amazon Chime Voice Connector. Shows whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.
     */
    override suspend fun getVoiceConnectorLoggingConfiguration(input: GetVoiceConnectorLoggingConfigurationRequest): GetVoiceConnectorLoggingConfigurationResponse {
        val op = SdkHttpOperation.build<GetVoiceConnectorLoggingConfigurationRequest, GetVoiceConnectorLoggingConfigurationResponse> {
            serializer = GetVoiceConnectorLoggingConfigurationOperationSerializer()
            deserializer = GetVoiceConnectorLoggingConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetVoiceConnectorLoggingConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves origination setting details for the specified Amazon Chime Voice Connector.
     */
    override suspend fun getVoiceConnectorOrigination(input: GetVoiceConnectorOriginationRequest): GetVoiceConnectorOriginationResponse {
        val op = SdkHttpOperation.build<GetVoiceConnectorOriginationRequest, GetVoiceConnectorOriginationResponse> {
            serializer = GetVoiceConnectorOriginationOperationSerializer()
            deserializer = GetVoiceConnectorOriginationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetVoiceConnectorOrigination"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the proxy configuration details for the specified Amazon Chime Voice Connector.
     */
    override suspend fun getVoiceConnectorProxy(input: GetVoiceConnectorProxyRequest): GetVoiceConnectorProxyResponse {
        val op = SdkHttpOperation.build<GetVoiceConnectorProxyRequest, GetVoiceConnectorProxyResponse> {
            serializer = GetVoiceConnectorProxyOperationSerializer()
            deserializer = GetVoiceConnectorProxyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetVoiceConnectorProxy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the streaming configuration details for the specified Amazon Chime Voice Connector. Shows whether media streaming is enabled for sending to Amazon Kinesis. It also shows the retention period, in hours, for the Amazon Kinesis data.
     */
    override suspend fun getVoiceConnectorStreamingConfiguration(input: GetVoiceConnectorStreamingConfigurationRequest): GetVoiceConnectorStreamingConfigurationResponse {
        val op = SdkHttpOperation.build<GetVoiceConnectorStreamingConfigurationRequest, GetVoiceConnectorStreamingConfigurationResponse> {
            serializer = GetVoiceConnectorStreamingConfigurationOperationSerializer()
            deserializer = GetVoiceConnectorStreamingConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetVoiceConnectorStreamingConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves termination setting details for the specified Amazon Chime Voice Connector.
     */
    override suspend fun getVoiceConnectorTermination(input: GetVoiceConnectorTerminationRequest): GetVoiceConnectorTerminationResponse {
        val op = SdkHttpOperation.build<GetVoiceConnectorTerminationRequest, GetVoiceConnectorTerminationResponse> {
            serializer = GetVoiceConnectorTerminationOperationSerializer()
            deserializer = GetVoiceConnectorTerminationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetVoiceConnectorTermination"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the last time a SIP `OPTIONS` ping was received from your SIP infrastructure for the specified Amazon Chime Voice Connector.
     */
    override suspend fun getVoiceConnectorTerminationHealth(input: GetVoiceConnectorTerminationHealthRequest): GetVoiceConnectorTerminationHealthResponse {
        val op = SdkHttpOperation.build<GetVoiceConnectorTerminationHealthRequest, GetVoiceConnectorTerminationHealthResponse> {
            serializer = GetVoiceConnectorTerminationHealthOperationSerializer()
            deserializer = GetVoiceConnectorTerminationHealthOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetVoiceConnectorTerminationHealth"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sends email to a maximum of 50 users, inviting them to the specified Amazon Chime `Team` account. Only `Team` account types are currently supported for this action.
     */
    override suspend fun inviteUsers(input: InviteUsersRequest): InviteUsersResponse {
        val op = SdkHttpOperation.build<InviteUsersRequest, InviteUsersResponse> {
            serializer = InviteUsersOperationSerializer()
            deserializer = InviteUsersOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "InviteUsers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the Amazon Chime accounts under the administrator's AWS account. You can filter accounts by account name prefix. To find out which Amazon Chime account a user belongs to, you can filter by the user's email address, which returns one account result.
     */
    override suspend fun listAccounts(input: ListAccountsRequest): ListAccountsResponse {
        val op = SdkHttpOperation.build<ListAccountsRequest, ListAccountsResponse> {
            serializer = ListAccountsOperationSerializer()
            deserializer = ListAccountsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAccounts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the administrators in the `AppInstance`.
     */
    override suspend fun listAppInstanceAdmins(input: ListAppInstanceAdminsRequest): ListAppInstanceAdminsResponse {
        val op = SdkHttpOperation.build<ListAppInstanceAdminsRequest, ListAppInstanceAdminsResponse> {
            serializer = ListAppInstanceAdminsOperationSerializer()
            deserializer = ListAppInstanceAdminsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAppInstanceAdmins"
                hostPrefix = "identity-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List all `AppInstanceUsers` created under a single `AppInstance`.
     */
    override suspend fun listAppInstanceUsers(input: ListAppInstanceUsersRequest): ListAppInstanceUsersResponse {
        val op = SdkHttpOperation.build<ListAppInstanceUsersRequest, ListAppInstanceUsersResponse> {
            serializer = ListAppInstanceUsersOperationSerializer()
            deserializer = ListAppInstanceUsersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAppInstanceUsers"
                hostPrefix = "identity-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all Amazon Chime `AppInstance`s created under a single AWS account.
     */
    override suspend fun listAppInstances(input: ListAppInstancesRequest): ListAppInstancesResponse {
        val op = SdkHttpOperation.build<ListAppInstancesRequest, ListAppInstancesResponse> {
            serializer = ListAppInstancesOperationSerializer()
            deserializer = ListAppInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAppInstances"
                hostPrefix = "identity-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags applied to an Amazon Chime SDK attendee resource.
     */
    override suspend fun listAttendeeTags(input: ListAttendeeTagsRequest): ListAttendeeTagsResponse {
        val op = SdkHttpOperation.build<ListAttendeeTagsRequest, ListAttendeeTagsResponse> {
            serializer = ListAttendeeTagsOperationSerializer()
            deserializer = ListAttendeeTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAttendeeTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the attendees for the specified Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide*.
     */
    override suspend fun listAttendees(input: ListAttendeesRequest): ListAttendeesResponse {
        val op = SdkHttpOperation.build<ListAttendeesRequest, ListAttendeesResponse> {
            serializer = ListAttendeesOperationSerializer()
            deserializer = ListAttendeesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAttendees"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the bots associated with the administrator's Amazon Chime Enterprise account ID.
     */
    override suspend fun listBots(input: ListBotsRequest): ListBotsResponse {
        val op = SdkHttpOperation.build<ListBotsRequest, ListBotsResponse> {
            serializer = ListBotsOperationSerializer()
            deserializer = ListBotsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListBots"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the users banned from a particular channel.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    override suspend fun listChannelBans(input: ListChannelBansRequest): ListChannelBansResponse {
        val op = SdkHttpOperation.build<ListChannelBansRequest, ListChannelBansResponse> {
            serializer = ListChannelBansOperationSerializer()
            deserializer = ListChannelBansOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListChannelBans"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all channel memberships in a channel.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    override suspend fun listChannelMemberships(input: ListChannelMembershipsRequest): ListChannelMembershipsResponse {
        val op = SdkHttpOperation.build<ListChannelMembershipsRequest, ListChannelMembershipsResponse> {
            serializer = ListChannelMembershipsOperationSerializer()
            deserializer = ListChannelMembershipsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListChannelMemberships"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all channels that a particular `AppInstanceUser` is a part of. Only an `AppInstanceAdmin` can call the API with a user ARN that is not their own.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    override suspend fun listChannelMembershipsForAppInstanceUser(input: ListChannelMembershipsForAppInstanceUserRequest): ListChannelMembershipsForAppInstanceUserResponse {
        val op = SdkHttpOperation.build<ListChannelMembershipsForAppInstanceUserRequest, ListChannelMembershipsForAppInstanceUserResponse> {
            serializer = ListChannelMembershipsForAppInstanceUserOperationSerializer()
            deserializer = ListChannelMembershipsForAppInstanceUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListChannelMembershipsForAppInstanceUser"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List all the messages in a channel. Returns a paginated list of `ChannelMessages`. By default, sorted by creation timestamp in descending order.
     *
     * Redacted messages appear in the results as empty, since they are only redacted, not deleted. Deleted messages do not appear in the results. This action always returns the latest version of an edited message.
     *
     * Also, the x-amz-chime-bearer request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    override suspend fun listChannelMessages(input: ListChannelMessagesRequest): ListChannelMessagesResponse {
        val op = SdkHttpOperation.build<ListChannelMessagesRequest, ListChannelMessagesResponse> {
            serializer = ListChannelMessagesOperationSerializer()
            deserializer = ListChannelMessagesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListChannelMessages"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the moderators for a channel.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    override suspend fun listChannelModerators(input: ListChannelModeratorsRequest): ListChannelModeratorsResponse {
        val op = SdkHttpOperation.build<ListChannelModeratorsRequest, ListChannelModeratorsResponse> {
            serializer = ListChannelModeratorsOperationSerializer()
            deserializer = ListChannelModeratorsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListChannelModerators"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all Channels created under a single Chime App as a paginated list. You can specify filters to narrow results.
     *
     * **Functionality & restrictions**
     * + Use privacy = `PUBLIC` to retrieve all public channels in the account.
     * + Only an `AppInstanceAdmin` can set privacy = `PRIVATE` to list the private channels in an account.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    override suspend fun listChannels(input: ListChannelsRequest): ListChannelsResponse {
        val op = SdkHttpOperation.build<ListChannelsRequest, ListChannelsResponse> {
            serializer = ListChannelsOperationSerializer()
            deserializer = ListChannelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListChannels"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * A list of the channels moderated by an `AppInstanceUser`.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    override suspend fun listChannelsModeratedByAppInstanceUser(input: ListChannelsModeratedByAppInstanceUserRequest): ListChannelsModeratedByAppInstanceUserResponse {
        val op = SdkHttpOperation.build<ListChannelsModeratedByAppInstanceUserRequest, ListChannelsModeratedByAppInstanceUserResponse> {
            serializer = ListChannelsModeratedByAppInstanceUserOperationSerializer()
            deserializer = ListChannelsModeratedByAppInstanceUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListChannelsModeratedByAppInstanceUser"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of media capture pipelines.
     */
    override suspend fun listMediaCapturePipelines(input: ListMediaCapturePipelinesRequest): ListMediaCapturePipelinesResponse {
        val op = SdkHttpOperation.build<ListMediaCapturePipelinesRequest, ListMediaCapturePipelinesResponse> {
            serializer = ListMediaCapturePipelinesOperationSerializer()
            deserializer = ListMediaCapturePipelinesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMediaCapturePipelines"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags applied to an Amazon Chime SDK meeting resource.
     */
    override suspend fun listMeetingTags(input: ListMeetingTagsRequest): ListMeetingTagsResponse {
        val op = SdkHttpOperation.build<ListMeetingTagsRequest, ListMeetingTagsResponse> {
            serializer = ListMeetingTagsOperationSerializer()
            deserializer = ListMeetingTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMeetingTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists up to 100 active Amazon Chime SDK meetings. For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide*.
     */
    override suspend fun listMeetings(input: ListMeetingsRequest): ListMeetingsResponse {
        val op = SdkHttpOperation.build<ListMeetingsRequest, ListMeetingsResponse> {
            serializer = ListMeetingsOperationSerializer()
            deserializer = ListMeetingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMeetings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the phone number orders for the administrator's Amazon Chime account.
     */
    override suspend fun listPhoneNumberOrders(input: ListPhoneNumberOrdersRequest): ListPhoneNumberOrdersResponse {
        val op = SdkHttpOperation.build<ListPhoneNumberOrdersRequest, ListPhoneNumberOrdersResponse> {
            serializer = ListPhoneNumberOrdersOperationSerializer()
            deserializer = ListPhoneNumberOrdersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPhoneNumberOrders"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the phone numbers for the specified Amazon Chime account, Amazon Chime user, Amazon Chime Voice Connector, or Amazon Chime Voice Connector group.
     */
    override suspend fun listPhoneNumbers(input: ListPhoneNumbersRequest): ListPhoneNumbersResponse {
        val op = SdkHttpOperation.build<ListPhoneNumbersRequest, ListPhoneNumbersResponse> {
            serializer = ListPhoneNumbersOperationSerializer()
            deserializer = ListPhoneNumbersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPhoneNumbers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the proxy sessions for the specified Amazon Chime Voice Connector.
     */
    override suspend fun listProxySessions(input: ListProxySessionsRequest): ListProxySessionsResponse {
        val op = SdkHttpOperation.build<ListProxySessionsRequest, ListProxySessionsResponse> {
            serializer = ListProxySessionsOperationSerializer()
            deserializer = ListProxySessionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListProxySessions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the membership details for the specified room in an Amazon Chime Enterprise account, such as the members' IDs, email addresses, and names.
     */
    override suspend fun listRoomMemberships(input: ListRoomMembershipsRequest): ListRoomMembershipsResponse {
        val op = SdkHttpOperation.build<ListRoomMembershipsRequest, ListRoomMembershipsResponse> {
            serializer = ListRoomMembershipsOperationSerializer()
            deserializer = ListRoomMembershipsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRoomMemberships"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the room details for the specified Amazon Chime Enterprise account. Optionally, filter the results by a member ID (user ID or bot ID) to see a list of rooms that the member belongs to.
     */
    override suspend fun listRooms(input: ListRoomsRequest): ListRoomsResponse {
        val op = SdkHttpOperation.build<ListRoomsRequest, ListRoomsResponse> {
            serializer = ListRoomsOperationSerializer()
            deserializer = ListRoomsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRooms"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the SIP media applications under the administrator's AWS account.
     */
    override suspend fun listSipMediaApplications(input: ListSipMediaApplicationsRequest): ListSipMediaApplicationsResponse {
        val op = SdkHttpOperation.build<ListSipMediaApplicationsRequest, ListSipMediaApplicationsResponse> {
            serializer = ListSipMediaApplicationsOperationSerializer()
            deserializer = ListSipMediaApplicationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSipMediaApplications"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the SIP rules under the administrator's AWS account.
     */
    override suspend fun listSipRules(input: ListSipRulesRequest): ListSipRulesResponse {
        val op = SdkHttpOperation.build<ListSipRulesRequest, ListSipRulesResponse> {
            serializer = ListSipRulesOperationSerializer()
            deserializer = ListSipRulesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSipRules"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists supported phone number countries.
     */
    override suspend fun listSupportedPhoneNumberCountries(input: ListSupportedPhoneNumberCountriesRequest): ListSupportedPhoneNumberCountriesResponse {
        val op = SdkHttpOperation.build<ListSupportedPhoneNumberCountriesRequest, ListSupportedPhoneNumberCountriesResponse> {
            serializer = ListSupportedPhoneNumberCountriesOperationSerializer()
            deserializer = ListSupportedPhoneNumberCountriesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSupportedPhoneNumberCountries"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags applied to an Amazon Chime SDK meeting resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the users that belong to the specified Amazon Chime account. You can specify an email address to list only the user that the email address belongs to.
     */
    override suspend fun listUsers(input: ListUsersRequest): ListUsersResponse {
        val op = SdkHttpOperation.build<ListUsersRequest, ListUsersResponse> {
            serializer = ListUsersOperationSerializer()
            deserializer = ListUsersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListUsers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the Amazon Chime Voice Connector groups for the administrator's AWS account.
     */
    override suspend fun listVoiceConnectorGroups(input: ListVoiceConnectorGroupsRequest): ListVoiceConnectorGroupsResponse {
        val op = SdkHttpOperation.build<ListVoiceConnectorGroupsRequest, ListVoiceConnectorGroupsResponse> {
            serializer = ListVoiceConnectorGroupsOperationSerializer()
            deserializer = ListVoiceConnectorGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListVoiceConnectorGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the SIP credentials for the specified Amazon Chime Voice Connector.
     */
    override suspend fun listVoiceConnectorTerminationCredentials(input: ListVoiceConnectorTerminationCredentialsRequest): ListVoiceConnectorTerminationCredentialsResponse {
        val op = SdkHttpOperation.build<ListVoiceConnectorTerminationCredentialsRequest, ListVoiceConnectorTerminationCredentialsResponse> {
            serializer = ListVoiceConnectorTerminationCredentialsOperationSerializer()
            deserializer = ListVoiceConnectorTerminationCredentialsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListVoiceConnectorTerminationCredentials"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the Amazon Chime Voice Connectors for the administrator's AWS account.
     */
    override suspend fun listVoiceConnectors(input: ListVoiceConnectorsRequest): ListVoiceConnectorsResponse {
        val op = SdkHttpOperation.build<ListVoiceConnectorsRequest, ListVoiceConnectorsResponse> {
            serializer = ListVoiceConnectorsOperationSerializer()
            deserializer = ListVoiceConnectorsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListVoiceConnectors"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Logs out the specified user from all of the devices they are currently logged into.
     */
    override suspend fun logoutUser(input: LogoutUserRequest): LogoutUserResponse {
        val op = SdkHttpOperation.build<LogoutUserRequest, LogoutUserResponse> {
            serializer = LogoutUserOperationSerializer()
            deserializer = LogoutUserOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "LogoutUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sets the amount of time in days that a given `AppInstance` retains data.
     */
    override suspend fun putAppInstanceRetentionSettings(input: PutAppInstanceRetentionSettingsRequest): PutAppInstanceRetentionSettingsResponse {
        val op = SdkHttpOperation.build<PutAppInstanceRetentionSettingsRequest, PutAppInstanceRetentionSettingsResponse> {
            serializer = PutAppInstanceRetentionSettingsOperationSerializer()
            deserializer = PutAppInstanceRetentionSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutAppInstanceRetentionSettings"
                hostPrefix = "identity-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The data streaming configurations of an `AppInstance`.
     */
    override suspend fun putAppInstanceStreamingConfigurations(input: PutAppInstanceStreamingConfigurationsRequest): PutAppInstanceStreamingConfigurationsResponse {
        val op = SdkHttpOperation.build<PutAppInstanceStreamingConfigurationsRequest, PutAppInstanceStreamingConfigurationsResponse> {
            serializer = PutAppInstanceStreamingConfigurationsOperationSerializer()
            deserializer = PutAppInstanceStreamingConfigurationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutAppInstanceStreamingConfigurations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an events configuration that allows a bot to receive outgoing events sent by Amazon Chime. Choose either an HTTPS endpoint or a Lambda function ARN. For more information, see Bot.
     */
    override suspend fun putEventsConfiguration(input: PutEventsConfigurationRequest): PutEventsConfigurationResponse {
        val op = SdkHttpOperation.build<PutEventsConfigurationRequest, PutEventsConfigurationResponse> {
            serializer = PutEventsConfigurationOperationSerializer()
            deserializer = PutEventsConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "PutEventsConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Puts retention settings for the specified Amazon Chime Enterprise account. We recommend using AWS CloudTrail to monitor usage of this API for your account. For more information, see [Logging Amazon Chime API Calls with AWS CloudTrail](https://docs.aws.amazon.com/chime/latest/ag/cloudtrail.html) in the *Amazon Chime Administration Guide*.
     *
     *  To turn off existing retention settings, remove the number of days from the corresponding **RetentionDays** field in the **RetentionSettings** object. For more information about retention settings, see [Managing Chat Retention Policies](https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html) in the *Amazon Chime Administration Guide*.
     */
    override suspend fun putRetentionSettings(input: PutRetentionSettingsRequest): PutRetentionSettingsResponse {
        val op = SdkHttpOperation.build<PutRetentionSettingsRequest, PutRetentionSettingsResponse> {
            serializer = PutRetentionSettingsOperationSerializer()
            deserializer = PutRetentionSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "PutRetentionSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the logging configuration for the specified SIP media application.
     */
    override suspend fun putSipMediaApplicationLoggingConfiguration(input: PutSipMediaApplicationLoggingConfigurationRequest): PutSipMediaApplicationLoggingConfigurationResponse {
        val op = SdkHttpOperation.build<PutSipMediaApplicationLoggingConfigurationRequest, PutSipMediaApplicationLoggingConfigurationResponse> {
            serializer = PutSipMediaApplicationLoggingConfigurationOperationSerializer()
            deserializer = PutSipMediaApplicationLoggingConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutSipMediaApplicationLoggingConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Puts emergency calling configuration details to the specified Amazon Chime Voice Connector, such as emergency phone numbers and calling countries. Origination and termination settings must be enabled for the Amazon Chime Voice Connector before emergency calling can be configured.
     */
    override suspend fun putVoiceConnectorEmergencyCallingConfiguration(input: PutVoiceConnectorEmergencyCallingConfigurationRequest): PutVoiceConnectorEmergencyCallingConfigurationResponse {
        val op = SdkHttpOperation.build<PutVoiceConnectorEmergencyCallingConfigurationRequest, PutVoiceConnectorEmergencyCallingConfigurationResponse> {
            serializer = PutVoiceConnectorEmergencyCallingConfigurationOperationSerializer()
            deserializer = PutVoiceConnectorEmergencyCallingConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutVoiceConnectorEmergencyCallingConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds a logging configuration for the specified Amazon Chime Voice Connector. The logging configuration specifies whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.
     */
    override suspend fun putVoiceConnectorLoggingConfiguration(input: PutVoiceConnectorLoggingConfigurationRequest): PutVoiceConnectorLoggingConfigurationResponse {
        val op = SdkHttpOperation.build<PutVoiceConnectorLoggingConfigurationRequest, PutVoiceConnectorLoggingConfigurationResponse> {
            serializer = PutVoiceConnectorLoggingConfigurationOperationSerializer()
            deserializer = PutVoiceConnectorLoggingConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutVoiceConnectorLoggingConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds origination settings for the specified Amazon Chime Voice Connector.
     *
     * If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to turning off origination settings.
     */
    override suspend fun putVoiceConnectorOrigination(input: PutVoiceConnectorOriginationRequest): PutVoiceConnectorOriginationResponse {
        val op = SdkHttpOperation.build<PutVoiceConnectorOriginationRequest, PutVoiceConnectorOriginationResponse> {
            serializer = PutVoiceConnectorOriginationOperationSerializer()
            deserializer = PutVoiceConnectorOriginationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutVoiceConnectorOrigination"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Puts the specified proxy configuration to the specified Amazon Chime Voice Connector.
     */
    override suspend fun putVoiceConnectorProxy(input: PutVoiceConnectorProxyRequest): PutVoiceConnectorProxyResponse {
        val op = SdkHttpOperation.build<PutVoiceConnectorProxyRequest, PutVoiceConnectorProxyResponse> {
            serializer = PutVoiceConnectorProxyOperationSerializer()
            deserializer = PutVoiceConnectorProxyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutVoiceConnectorProxy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds a streaming configuration for the specified Amazon Chime Voice Connector. The streaming configuration specifies whether media streaming is enabled for sending to Kinesis. It also sets the retention period, in hours, for the Amazon Kinesis data.
     */
    override suspend fun putVoiceConnectorStreamingConfiguration(input: PutVoiceConnectorStreamingConfigurationRequest): PutVoiceConnectorStreamingConfigurationResponse {
        val op = SdkHttpOperation.build<PutVoiceConnectorStreamingConfigurationRequest, PutVoiceConnectorStreamingConfigurationResponse> {
            serializer = PutVoiceConnectorStreamingConfigurationOperationSerializer()
            deserializer = PutVoiceConnectorStreamingConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutVoiceConnectorStreamingConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds termination settings for the specified Amazon Chime Voice Connector.
     *
     * If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to turning off termination settings.
     */
    override suspend fun putVoiceConnectorTermination(input: PutVoiceConnectorTerminationRequest): PutVoiceConnectorTerminationResponse {
        val op = SdkHttpOperation.build<PutVoiceConnectorTerminationRequest, PutVoiceConnectorTerminationResponse> {
            serializer = PutVoiceConnectorTerminationOperationSerializer()
            deserializer = PutVoiceConnectorTerminationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutVoiceConnectorTermination"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds termination SIP credentials for the specified Amazon Chime Voice Connector.
     */
    override suspend fun putVoiceConnectorTerminationCredentials(input: PutVoiceConnectorTerminationCredentialsRequest): PutVoiceConnectorTerminationCredentialsResponse {
        val op = SdkHttpOperation.build<PutVoiceConnectorTerminationCredentialsRequest, PutVoiceConnectorTerminationCredentialsResponse> {
            serializer = PutVoiceConnectorTerminationCredentialsOperationSerializer()
            deserializer = PutVoiceConnectorTerminationCredentialsOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "PutVoiceConnectorTerminationCredentials"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Redacts message content, but not metadata. The message exists in the back end, but the action returns null content, and the state shows as redacted.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    override suspend fun redactChannelMessage(input: RedactChannelMessageRequest): RedactChannelMessageResponse {
        val op = SdkHttpOperation.build<RedactChannelMessageRequest, RedactChannelMessageResponse> {
            serializer = RedactChannelMessageOperationSerializer()
            deserializer = RedactChannelMessageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RedactChannelMessage"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Redacts the specified message from the specified Amazon Chime conversation.
     */
    override suspend fun redactConversationMessage(input: RedactConversationMessageRequest): RedactConversationMessageResponse {
        val op = SdkHttpOperation.build<RedactConversationMessageRequest, RedactConversationMessageResponse> {
            serializer = RedactConversationMessageOperationSerializer()
            deserializer = RedactConversationMessageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RedactConversationMessage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Redacts the specified message from the specified Amazon Chime channel.
     */
    override suspend fun redactRoomMessage(input: RedactRoomMessageRequest): RedactRoomMessageResponse {
        val op = SdkHttpOperation.build<RedactRoomMessageRequest, RedactRoomMessageResponse> {
            serializer = RedactRoomMessageOperationSerializer()
            deserializer = RedactRoomMessageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RedactRoomMessage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Regenerates the security token for a bot.
     */
    override suspend fun regenerateSecurityToken(input: RegenerateSecurityTokenRequest): RegenerateSecurityTokenResponse {
        val op = SdkHttpOperation.build<RegenerateSecurityTokenRequest, RegenerateSecurityTokenResponse> {
            serializer = RegenerateSecurityTokenOperationSerializer()
            deserializer = RegenerateSecurityTokenOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegenerateSecurityToken"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Resets the personal meeting PIN for the specified user on an Amazon Chime account. Returns the User object with the updated personal meeting PIN.
     */
    override suspend fun resetPersonalPin(input: ResetPersonalPinRequest): ResetPersonalPinResponse {
        val op = SdkHttpOperation.build<ResetPersonalPinRequest, ResetPersonalPinResponse> {
            serializer = ResetPersonalPINOperationSerializer()
            deserializer = ResetPersonalPINOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ResetPersonalPIN"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Moves a phone number from the **Deletion queue** back into the phone number **Inventory**.
     */
    override suspend fun restorePhoneNumber(input: RestorePhoneNumberRequest): RestorePhoneNumberResponse {
        val op = SdkHttpOperation.build<RestorePhoneNumberRequest, RestorePhoneNumberResponse> {
            serializer = RestorePhoneNumberOperationSerializer()
            deserializer = RestorePhoneNumberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RestorePhoneNumber"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Searches for phone numbers that can be ordered. For US numbers, provide at least one of the following search filters: `AreaCode`, `City`, `State`, or `TollFreePrefix`. If you provide `City`, you must also provide `State`. Numbers outside the US only support the `PhoneNumberType` filter, which you must use.
     */
    override suspend fun searchAvailablePhoneNumbers(input: SearchAvailablePhoneNumbersRequest): SearchAvailablePhoneNumbersResponse {
        val op = SdkHttpOperation.build<SearchAvailablePhoneNumbersRequest, SearchAvailablePhoneNumbersResponse> {
            serializer = SearchAvailablePhoneNumbersOperationSerializer()
            deserializer = SearchAvailablePhoneNumbersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchAvailablePhoneNumbers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sends a message to a particular channel that the member is a part of.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     *
     * Also, `STANDARD` messages can contain 4KB of data and the 1KB of metadata. `CONTROL` messages can contain 30 bytes of data and no metadata.
     */
    override suspend fun sendChannelMessage(input: SendChannelMessageRequest): SendChannelMessageResponse {
        val op = SdkHttpOperation.build<SendChannelMessageRequest, SendChannelMessageResponse> {
            serializer = SendChannelMessageOperationSerializer()
            deserializer = SendChannelMessageOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "SendChannelMessage"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts transcription for the specified `meetingId`.
     */
    override suspend fun startMeetingTranscription(input: StartMeetingTranscriptionRequest): StartMeetingTranscriptionResponse {
        val op = SdkHttpOperation.build<StartMeetingTranscriptionRequest, StartMeetingTranscriptionResponse> {
            serializer = StartMeetingTranscriptionOperationSerializer()
            deserializer = StartMeetingTranscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartMeetingTranscription"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops transcription for the specified `meetingId`.
     */
    override suspend fun stopMeetingTranscription(input: StopMeetingTranscriptionRequest): StopMeetingTranscriptionResponse {
        val op = SdkHttpOperation.build<StopMeetingTranscriptionRequest, StopMeetingTranscriptionResponse> {
            serializer = StopMeetingTranscriptionOperationSerializer()
            deserializer = StopMeetingTranscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopMeetingTranscription"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Applies the specified tags to the specified Amazon Chime SDK attendee.
     */
    override suspend fun tagAttendee(input: TagAttendeeRequest): TagAttendeeResponse {
        val op = SdkHttpOperation.build<TagAttendeeRequest, TagAttendeeResponse> {
            serializer = TagAttendeeOperationSerializer()
            deserializer = TagAttendeeOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "TagAttendee"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Applies the specified tags to the specified Amazon Chime SDK meeting.
     */
    override suspend fun tagMeeting(input: TagMeetingRequest): TagMeetingResponse {
        val op = SdkHttpOperation.build<TagMeetingRequest, TagMeetingResponse> {
            serializer = TagMeetingOperationSerializer()
            deserializer = TagMeetingOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "TagMeeting"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Applies the specified tags to the specified Amazon Chime SDK meeting resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Untags the specified tags from the specified Amazon Chime SDK attendee.
     */
    override suspend fun untagAttendee(input: UntagAttendeeRequest): UntagAttendeeResponse {
        val op = SdkHttpOperation.build<UntagAttendeeRequest, UntagAttendeeResponse> {
            serializer = UntagAttendeeOperationSerializer()
            deserializer = UntagAttendeeOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UntagAttendee"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Untags the specified tags from the specified Amazon Chime SDK meeting.
     */
    override suspend fun untagMeeting(input: UntagMeetingRequest): UntagMeetingResponse {
        val op = SdkHttpOperation.build<UntagMeetingRequest, UntagMeetingResponse> {
            serializer = UntagMeetingOperationSerializer()
            deserializer = UntagMeetingOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UntagMeeting"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Untags the specified tags from the specified Amazon Chime SDK meeting resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates account details for the specified Amazon Chime account. Currently, only account name and default license updates are supported for this action.
     */
    override suspend fun updateAccount(input: UpdateAccountRequest): UpdateAccountResponse {
        val op = SdkHttpOperation.build<UpdateAccountRequest, UpdateAccountResponse> {
            serializer = UpdateAccountOperationSerializer()
            deserializer = UpdateAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the settings for the specified Amazon Chime account. You can update settings for remote control of shared screens, or for the dial-out option. For more information about these settings, see [Use the Policies Page](https://docs.aws.amazon.com/chime/latest/ag/policies.html) in the *Amazon Chime Administration Guide*.
     */
    override suspend fun updateAccountSettings(input: UpdateAccountSettingsRequest): UpdateAccountSettingsResponse {
        val op = SdkHttpOperation.build<UpdateAccountSettingsRequest, UpdateAccountSettingsResponse> {
            serializer = UpdateAccountSettingsOperationSerializer()
            deserializer = UpdateAccountSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UpdateAccountSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates `AppInstance` metadata.
     */
    override suspend fun updateAppInstance(input: UpdateAppInstanceRequest): UpdateAppInstanceResponse {
        val op = SdkHttpOperation.build<UpdateAppInstanceRequest, UpdateAppInstanceResponse> {
            serializer = UpdateAppInstanceOperationSerializer()
            deserializer = UpdateAppInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAppInstance"
                hostPrefix = "identity-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the details of an `AppInstanceUser`. You can update names and metadata.
     */
    override suspend fun updateAppInstanceUser(input: UpdateAppInstanceUserRequest): UpdateAppInstanceUserResponse {
        val op = SdkHttpOperation.build<UpdateAppInstanceUserRequest, UpdateAppInstanceUserResponse> {
            serializer = UpdateAppInstanceUserOperationSerializer()
            deserializer = UpdateAppInstanceUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAppInstanceUser"
                hostPrefix = "identity-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the status of the specified bot, such as starting or stopping the bot from running in your Amazon Chime Enterprise account.
     */
    override suspend fun updateBot(input: UpdateBotRequest): UpdateBotResponse {
        val op = SdkHttpOperation.build<UpdateBotRequest, UpdateBotResponse> {
            serializer = UpdateBotOperationSerializer()
            deserializer = UpdateBotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateBot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update a channel's attributes.
     *
     * **Restriction**: You can't change a channel's privacy.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    override suspend fun updateChannel(input: UpdateChannelRequest): UpdateChannelResponse {
        val op = SdkHttpOperation.build<UpdateChannelRequest, UpdateChannelResponse> {
            serializer = UpdateChannelOperationSerializer()
            deserializer = UpdateChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateChannel"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the content of a message.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    override suspend fun updateChannelMessage(input: UpdateChannelMessageRequest): UpdateChannelMessageResponse {
        val op = SdkHttpOperation.build<UpdateChannelMessageRequest, UpdateChannelMessageResponse> {
            serializer = UpdateChannelMessageOperationSerializer()
            deserializer = UpdateChannelMessageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateChannelMessage"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The details of the time when a user last read messages in a channel.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    override suspend fun updateChannelReadMarker(input: UpdateChannelReadMarkerRequest): UpdateChannelReadMarkerResponse {
        val op = SdkHttpOperation.build<UpdateChannelReadMarkerRequest, UpdateChannelReadMarkerResponse> {
            serializer = UpdateChannelReadMarkerOperationSerializer()
            deserializer = UpdateChannelReadMarkerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateChannelReadMarker"
                hostPrefix = "messaging-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates global settings for the administrator's AWS account, such as Amazon Chime Business Calling and Amazon Chime Voice Connector settings.
     */
    override suspend fun updateGlobalSettings(input: UpdateGlobalSettingsRequest): UpdateGlobalSettingsResponse {
        val op = SdkHttpOperation.build<UpdateGlobalSettingsRequest, UpdateGlobalSettingsResponse> {
            serializer = UpdateGlobalSettingsOperationSerializer()
            deserializer = UpdateGlobalSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UpdateGlobalSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates phone number details, such as product type or calling name, for the specified phone number ID. You can update one phone number detail at a time. For example, you can update either the product type or the calling name in one action.
     *
     * For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.
     *
     * Updates to outbound calling names can take 72 hours to complete. Pending updates to outbound calling names must be complete before you can request another update.
     */
    override suspend fun updatePhoneNumber(input: UpdatePhoneNumberRequest): UpdatePhoneNumberResponse {
        val op = SdkHttpOperation.build<UpdatePhoneNumberRequest, UpdatePhoneNumberResponse> {
            serializer = UpdatePhoneNumberOperationSerializer()
            deserializer = UpdatePhoneNumberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePhoneNumber"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the phone number settings for the administrator's AWS account, such as the default outbound calling name. You can update the default outbound calling name once every seven days. Outbound calling names can take up to 72 hours to update.
     */
    override suspend fun updatePhoneNumberSettings(input: UpdatePhoneNumberSettingsRequest): UpdatePhoneNumberSettingsResponse {
        val op = SdkHttpOperation.build<UpdatePhoneNumberSettingsRequest, UpdatePhoneNumberSettingsResponse> {
            serializer = UpdatePhoneNumberSettingsOperationSerializer()
            deserializer = UpdatePhoneNumberSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UpdatePhoneNumberSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified proxy session details, such as voice or SMS capabilities.
     */
    override suspend fun updateProxySession(input: UpdateProxySessionRequest): UpdateProxySessionResponse {
        val op = SdkHttpOperation.build<UpdateProxySessionRequest, UpdateProxySessionResponse> {
            serializer = UpdateProxySessionOperationSerializer()
            deserializer = UpdateProxySessionOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "UpdateProxySession"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates room details, such as the room name, for a room in an Amazon Chime Enterprise account.
     */
    override suspend fun updateRoom(input: UpdateRoomRequest): UpdateRoomResponse {
        val op = SdkHttpOperation.build<UpdateRoomRequest, UpdateRoomResponse> {
            serializer = UpdateRoomOperationSerializer()
            deserializer = UpdateRoomOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateRoom"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates room membership details, such as the member role, for a room in an Amazon Chime Enterprise account. The member role designates whether the member is a chat room administrator or a general chat room member. The member role can be updated only for user IDs.
     */
    override suspend fun updateRoomMembership(input: UpdateRoomMembershipRequest): UpdateRoomMembershipResponse {
        val op = SdkHttpOperation.build<UpdateRoomMembershipRequest, UpdateRoomMembershipResponse> {
            serializer = UpdateRoomMembershipOperationSerializer()
            deserializer = UpdateRoomMembershipOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateRoomMembership"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the details of the specified SIP media application.
     */
    override suspend fun updateSipMediaApplication(input: UpdateSipMediaApplicationRequest): UpdateSipMediaApplicationResponse {
        val op = SdkHttpOperation.build<UpdateSipMediaApplicationRequest, UpdateSipMediaApplicationResponse> {
            serializer = UpdateSipMediaApplicationOperationSerializer()
            deserializer = UpdateSipMediaApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSipMediaApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Invokes the AWS Lambda function associated with the SIP media application and transaction ID in an update request. The Lambda function can then return a new set of actions.
     */
    override suspend fun updateSipMediaApplicationCall(input: UpdateSipMediaApplicationCallRequest): UpdateSipMediaApplicationCallResponse {
        val op = SdkHttpOperation.build<UpdateSipMediaApplicationCallRequest, UpdateSipMediaApplicationCallResponse> {
            serializer = UpdateSipMediaApplicationCallOperationSerializer()
            deserializer = UpdateSipMediaApplicationCallOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "UpdateSipMediaApplicationCall"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the details of the specified SIP rule.
     */
    override suspend fun updateSipRule(input: UpdateSipRuleRequest): UpdateSipRuleResponse {
        val op = SdkHttpOperation.build<UpdateSipRuleRequest, UpdateSipRuleResponse> {
            serializer = UpdateSipRuleOperationSerializer()
            deserializer = UpdateSipRuleOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "UpdateSipRule"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates user details for a specified user ID. Currently, only `LicenseType` updates are supported for this action.
     */
    override suspend fun updateUser(input: UpdateUserRequest): UpdateUserResponse {
        val op = SdkHttpOperation.build<UpdateUserRequest, UpdateUserResponse> {
            serializer = UpdateUserOperationSerializer()
            deserializer = UpdateUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the settings for the specified user, such as phone number settings.
     */
    override suspend fun updateUserSettings(input: UpdateUserSettingsRequest): UpdateUserSettingsResponse {
        val op = SdkHttpOperation.build<UpdateUserSettingsRequest, UpdateUserSettingsResponse> {
            serializer = UpdateUserSettingsOperationSerializer()
            deserializer = UpdateUserSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UpdateUserSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates details for the specified Amazon Chime Voice Connector.
     */
    override suspend fun updateVoiceConnector(input: UpdateVoiceConnectorRequest): UpdateVoiceConnectorResponse {
        val op = SdkHttpOperation.build<UpdateVoiceConnectorRequest, UpdateVoiceConnectorResponse> {
            serializer = UpdateVoiceConnectorOperationSerializer()
            deserializer = UpdateVoiceConnectorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateVoiceConnector"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates details of the specified Amazon Chime Voice Connector group, such as the name and Amazon Chime Voice Connector priority ranking.
     */
    override suspend fun updateVoiceConnectorGroup(input: UpdateVoiceConnectorGroupRequest): UpdateVoiceConnectorGroupResponse {
        val op = SdkHttpOperation.build<UpdateVoiceConnectorGroupRequest, UpdateVoiceConnectorGroupResponse> {
            serializer = UpdateVoiceConnectorGroupOperationSerializer()
            deserializer = UpdateVoiceConnectorGroupOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "UpdateVoiceConnectorGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Validates an address to be used for 911 calls made with Amazon Chime Voice Connectors. You can use validated addresses in a Presence Information Data Format Location Object file that you include in SIP requests. That helps ensure that addresses are routed to the appropriate Public Safety Answering Point.
     */
    override suspend fun validateE911Address(input: ValidateE911AddressRequest): ValidateE911AddressResponse {
        val op = SdkHttpOperation.build<ValidateE911AddressRequest, ValidateE911AddressResponse> {
            serializer = ValidateE911AddressOperationSerializer()
            deserializer = ValidateE911AddressOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "ValidateE911Address"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "chime"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "chime")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
