// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model



/**
 * An Amazon Chime SDK meeting attendee. Includes a unique `AttendeeId` and `JoinToken` . The `JoinToken` allows a client to authenticate and join as the specified attendee. The `JoinToken` expires when the meeting ends or when DeleteAttendee is called. After that, the attendee is unable to join the meeting.
 *
 * We recommend securely transferring each `JoinToken` from your server application to the client so that no other client has access to the token except for the one authorized to represent the attendee.
 */
public class Attendee private constructor(builder: Builder) {
    /**
     * The Amazon Chime SDK attendee ID.
     */
    public val attendeeId: kotlin.String? = builder.attendeeId
    /**
     * The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.
     */
    public val externalUserId: kotlin.String? = builder.externalUserId
    /**
     * The join token used by the Amazon Chime SDK attendee.
     */
    public val joinToken: kotlin.String? = builder.joinToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chime.model.Attendee = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Attendee(")
        append("attendeeId=$attendeeId,")
        append("externalUserId=*** Sensitive Data Redacted ***,")
        append("joinToken=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attendeeId?.hashCode() ?: 0
        result = 31 * result + (externalUserId?.hashCode() ?: 0)
        result = 31 * result + (joinToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Attendee

        if (attendeeId != other.attendeeId) return false
        if (externalUserId != other.externalUserId) return false
        if (joinToken != other.joinToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chime.model.Attendee = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Chime SDK attendee ID.
         */
        public var attendeeId: kotlin.String? = null
        /**
         * The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.
         */
        public var externalUserId: kotlin.String? = null
        /**
         * The join token used by the Amazon Chime SDK attendee.
         */
        public var joinToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chime.model.Attendee) : this() {
            this.attendeeId = x.attendeeId
            this.externalUserId = x.externalUserId
            this.joinToken = x.joinToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chime.model.Attendee = Attendee(this)
    }
}
