// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model



public class CreateProxySessionRequest private constructor(builder: Builder) {
    /**
     * The proxy session capabilities.
     */
    public val capabilities: List<Capability>? = builder.capabilities
    /**
     * The number of minutes allowed for the proxy session.
     */
    public val expiryMinutes: kotlin.Int? = builder.expiryMinutes
    /**
     * The preference for matching the country or area code of the proxy phone number with that of the first participant.
     */
    public val geoMatchLevel: aws.sdk.kotlin.services.chime.model.GeoMatchLevel? = builder.geoMatchLevel
    /**
     * The country and area code for the proxy phone number.
     */
    public val geoMatchParams: aws.sdk.kotlin.services.chime.model.GeoMatchParams? = builder.geoMatchParams
    /**
     * The name of the proxy session.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.
     */
    public val numberSelectionBehavior: aws.sdk.kotlin.services.chime.model.NumberSelectionBehavior? = builder.numberSelectionBehavior
    /**
     * The participant phone numbers.
     */
    public val participantPhoneNumbers: List<String>? = builder.participantPhoneNumbers
    /**
     * The Amazon Chime voice connector ID.
     */
    public val voiceConnectorId: kotlin.String? = requireNotNull(builder.voiceConnectorId) { "A non-null value must be provided for voiceConnectorId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chime.model.CreateProxySessionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateProxySessionRequest(")
        append("capabilities=$capabilities,")
        append("expiryMinutes=$expiryMinutes,")
        append("geoMatchLevel=$geoMatchLevel,")
        append("geoMatchParams=$geoMatchParams,")
        append("name=*** Sensitive Data Redacted ***,")
        append("numberSelectionBehavior=$numberSelectionBehavior,")
        append("participantPhoneNumbers=$participantPhoneNumbers,")
        append("voiceConnectorId=$voiceConnectorId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = capabilities?.hashCode() ?: 0
        result = 31 * result + (expiryMinutes ?: 0)
        result = 31 * result + (geoMatchLevel?.hashCode() ?: 0)
        result = 31 * result + (geoMatchParams?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (numberSelectionBehavior?.hashCode() ?: 0)
        result = 31 * result + (participantPhoneNumbers?.hashCode() ?: 0)
        result = 31 * result + (voiceConnectorId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateProxySessionRequest

        if (capabilities != other.capabilities) return false
        if (expiryMinutes != other.expiryMinutes) return false
        if (geoMatchLevel != other.geoMatchLevel) return false
        if (geoMatchParams != other.geoMatchParams) return false
        if (name != other.name) return false
        if (numberSelectionBehavior != other.numberSelectionBehavior) return false
        if (participantPhoneNumbers != other.participantPhoneNumbers) return false
        if (voiceConnectorId != other.voiceConnectorId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chime.model.CreateProxySessionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The proxy session capabilities.
         */
        public var capabilities: List<Capability>? = null
        /**
         * The number of minutes allowed for the proxy session.
         */
        public var expiryMinutes: kotlin.Int? = null
        /**
         * The preference for matching the country or area code of the proxy phone number with that of the first participant.
         */
        public var geoMatchLevel: aws.sdk.kotlin.services.chime.model.GeoMatchLevel? = null
        /**
         * The country and area code for the proxy phone number.
         */
        public var geoMatchParams: aws.sdk.kotlin.services.chime.model.GeoMatchParams? = null
        /**
         * The name of the proxy session.
         */
        public var name: kotlin.String? = null
        /**
         * The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.
         */
        public var numberSelectionBehavior: aws.sdk.kotlin.services.chime.model.NumberSelectionBehavior? = null
        /**
         * The participant phone numbers.
         */
        public var participantPhoneNumbers: List<String>? = null
        /**
         * The Amazon Chime voice connector ID.
         */
        public var voiceConnectorId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chime.model.CreateProxySessionRequest) : this() {
            this.capabilities = x.capabilities
            this.expiryMinutes = x.expiryMinutes
            this.geoMatchLevel = x.geoMatchLevel
            this.geoMatchParams = x.geoMatchParams
            this.name = x.name
            this.numberSelectionBehavior = x.numberSelectionBehavior
            this.participantPhoneNumbers = x.participantPhoneNumbers
            this.voiceConnectorId = x.voiceConnectorId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chime.model.CreateProxySessionRequest = CreateProxySessionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.chime.model.GeoMatchParams] inside the given [block]
         */
        public fun geoMatchParams(block: aws.sdk.kotlin.services.chime.model.GeoMatchParams.Builder.() -> kotlin.Unit) {
            this.geoMatchParams = aws.sdk.kotlin.services.chime.model.GeoMatchParams.invoke(block)
        }
    }
}
