// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model



/**
 * The proxy configuration for an Amazon Chime Voice Connector.
 */
public class Proxy private constructor(builder: Builder) {
    /**
     * The default number of minutes allowed for proxy sessions.
     */
    public val defaultSessionExpiryMinutes: kotlin.Int? = builder.defaultSessionExpiryMinutes
    /**
     * When true, stops proxy sessions from being created on the specified Amazon Chime Voice Connector.
     */
    public val disabled: kotlin.Boolean? = builder.disabled
    /**
     * The phone number to route calls to after a proxy session expires.
     */
    public val fallBackPhoneNumber: kotlin.String? = builder.fallBackPhoneNumber
    /**
     * The countries for proxy phone numbers to be selected from.
     */
    public val phoneNumberCountries: List<String>? = builder.phoneNumberCountries

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chime.model.Proxy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Proxy(")
        append("defaultSessionExpiryMinutes=$defaultSessionExpiryMinutes,")
        append("disabled=$disabled,")
        append("fallBackPhoneNumber=*** Sensitive Data Redacted ***,")
        append("phoneNumberCountries=$phoneNumberCountries)")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultSessionExpiryMinutes ?: 0
        result = 31 * result + (disabled?.hashCode() ?: 0)
        result = 31 * result + (fallBackPhoneNumber?.hashCode() ?: 0)
        result = 31 * result + (phoneNumberCountries?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Proxy

        if (defaultSessionExpiryMinutes != other.defaultSessionExpiryMinutes) return false
        if (disabled != other.disabled) return false
        if (fallBackPhoneNumber != other.fallBackPhoneNumber) return false
        if (phoneNumberCountries != other.phoneNumberCountries) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chime.model.Proxy = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The default number of minutes allowed for proxy sessions.
         */
        public var defaultSessionExpiryMinutes: kotlin.Int? = null
        /**
         * When true, stops proxy sessions from being created on the specified Amazon Chime Voice Connector.
         */
        public var disabled: kotlin.Boolean? = null
        /**
         * The phone number to route calls to after a proxy session expires.
         */
        public var fallBackPhoneNumber: kotlin.String? = null
        /**
         * The countries for proxy phone numbers to be selected from.
         */
        public var phoneNumberCountries: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chime.model.Proxy) : this() {
            this.defaultSessionExpiryMinutes = x.defaultSessionExpiryMinutes
            this.disabled = x.disabled
            this.fallBackPhoneNumber = x.fallBackPhoneNumber
            this.phoneNumberCountries = x.phoneNumberCountries
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chime.model.Proxy = Proxy(this)
    }
}
