// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model



/**
 * The streaming configuration associated with an Amazon Chime Voice Connector. Specifies whether media streaming is enabled for sending to Amazon Kinesis, and shows the retention period for the Amazon Kinesis data, in hours.
 */
public class StreamingConfiguration private constructor(builder: Builder) {
    /**
     * The retention period, in hours, for the Amazon Kinesis data.
     */
    public val dataRetentionInHours: kotlin.Int? = builder.dataRetentionInHours
    /**
     * When true, media streaming to Amazon Kinesis is turned off.
     */
    public val disabled: kotlin.Boolean? = builder.disabled
    /**
     * The streaming notification targets.
     */
    public val streamingNotificationTargets: List<StreamingNotificationTarget>? = builder.streamingNotificationTargets

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chime.model.StreamingConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StreamingConfiguration(")
        append("dataRetentionInHours=$dataRetentionInHours,")
        append("disabled=$disabled,")
        append("streamingNotificationTargets=$streamingNotificationTargets)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataRetentionInHours ?: 0
        result = 31 * result + (disabled?.hashCode() ?: 0)
        result = 31 * result + (streamingNotificationTargets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StreamingConfiguration

        if (dataRetentionInHours != other.dataRetentionInHours) return false
        if (disabled != other.disabled) return false
        if (streamingNotificationTargets != other.streamingNotificationTargets) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chime.model.StreamingConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The retention period, in hours, for the Amazon Kinesis data.
         */
        public var dataRetentionInHours: kotlin.Int? = null
        /**
         * When true, media streaming to Amazon Kinesis is turned off.
         */
        public var disabled: kotlin.Boolean? = null
        /**
         * The streaming notification targets.
         */
        public var streamingNotificationTargets: List<StreamingNotificationTarget>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chime.model.StreamingConfiguration) : this() {
            this.dataRetentionInHours = x.dataRetentionInHours
            this.disabled = x.disabled
            this.streamingNotificationTargets = x.streamingNotificationTargets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chime.model.StreamingConfiguration = StreamingConfiguration(this)
    }
}
