// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The Amazon Chime Voice Connector group configuration, including associated Amazon Chime Voice Connectors. You can include Amazon Chime Voice Connectors from different AWS Regions in your group. This creates a fault tolerant mechanism for fallback in case of availability events.
 */
public class VoiceConnectorGroup private constructor(builder: Builder) {
    /**
     * The Amazon Chime Voice Connector group creation time stamp, in ISO 8601 format.
     */
    public val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimestamp
    /**
     * The name of the Amazon Chime Voice Connector group.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The updated Amazon Chime Voice Connector group time stamp, in ISO 8601 format.
     */
    public val updatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedTimestamp
    /**
     * The ARN of the specified Amazon Chime Voice Connector group.
     */
    public val voiceConnectorGroupArn: kotlin.String? = builder.voiceConnectorGroupArn
    /**
     * The Amazon Chime Voice Connector group ID.
     */
    public val voiceConnectorGroupId: kotlin.String? = builder.voiceConnectorGroupId
    /**
     * The Amazon Chime Voice Connectors to which to route inbound calls.
     */
    public val voiceConnectorItems: List<VoiceConnectorItem>? = builder.voiceConnectorItems

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chime.model.VoiceConnectorGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VoiceConnectorGroup(")
        append("createdTimestamp=$createdTimestamp,")
        append("name=$name,")
        append("updatedTimestamp=$updatedTimestamp,")
        append("voiceConnectorGroupArn=$voiceConnectorGroupArn,")
        append("voiceConnectorGroupId=$voiceConnectorGroupId,")
        append("voiceConnectorItems=$voiceConnectorItems)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdTimestamp?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (updatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (voiceConnectorGroupArn?.hashCode() ?: 0)
        result = 31 * result + (voiceConnectorGroupId?.hashCode() ?: 0)
        result = 31 * result + (voiceConnectorItems?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VoiceConnectorGroup

        if (createdTimestamp != other.createdTimestamp) return false
        if (name != other.name) return false
        if (updatedTimestamp != other.updatedTimestamp) return false
        if (voiceConnectorGroupArn != other.voiceConnectorGroupArn) return false
        if (voiceConnectorGroupId != other.voiceConnectorGroupId) return false
        if (voiceConnectorItems != other.voiceConnectorItems) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chime.model.VoiceConnectorGroup = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Chime Voice Connector group creation time stamp, in ISO 8601 format.
         */
        public var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the Amazon Chime Voice Connector group.
         */
        public var name: kotlin.String? = null
        /**
         * The updated Amazon Chime Voice Connector group time stamp, in ISO 8601 format.
         */
        public var updatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the specified Amazon Chime Voice Connector group.
         */
        public var voiceConnectorGroupArn: kotlin.String? = null
        /**
         * The Amazon Chime Voice Connector group ID.
         */
        public var voiceConnectorGroupId: kotlin.String? = null
        /**
         * The Amazon Chime Voice Connectors to which to route inbound calls.
         */
        public var voiceConnectorItems: List<VoiceConnectorItem>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chime.model.VoiceConnectorGroup) : this() {
            this.createdTimestamp = x.createdTimestamp
            this.name = x.name
            this.updatedTimestamp = x.updatedTimestamp
            this.voiceConnectorGroupArn = x.voiceConnectorGroupArn
            this.voiceConnectorGroupId = x.voiceConnectorGroupId
            this.voiceConnectorItems = x.voiceConnectorItems
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chime.model.VoiceConnectorGroup = VoiceConnectorGroup(this)
    }
}
