// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.chime.model.AssociateSigninDelegateGroupsWithAccountResponse
import aws.sdk.kotlin.services.chime.model.ChimeException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class AssociateSigninDelegateGroupsWithAccountOperationDeserializer: HttpDeserialize<AssociateSigninDelegateGroupsWithAccountResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): AssociateSigninDelegateGroupsWithAccountResponse {
        if (!response.status.isSuccess()) {
            throwAssociateSigninDelegateGroupsWithAccountError(context, response)
        }
        val builder = AssociateSigninDelegateGroupsWithAccountResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwAssociateSigninDelegateGroupsWithAccountError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ChimeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceFailureException" -> ServiceFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottledClientException" -> ThrottledClientExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedClientException" -> UnauthorizedClientExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ChimeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
