// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.transform

import aws.sdk.kotlin.services.chime.model.ChannelMembershipType
import aws.sdk.kotlin.services.chime.model.CreateChannelMembershipRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateChannelMembershipOperationSerializer: HttpSerialize<CreateChannelMembershipRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateChannelMembershipRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "channels",
                "${input.channelArn}".encodeLabel(),
                "memberships",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        builder.headers {
            if (input.chimeBearer?.isNotEmpty() == true) append("x-amz-chime-bearer", input.chimeBearer)
        }

        val payload = serializeCreateChannelMembershipOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateChannelMembershipOperationBody(context: ExecutionContext, input: CreateChannelMembershipRequest): ByteArray {
    val serializer = JsonSerializer()
    val MEMBERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MemberArn"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MEMBERARN_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.memberArn?.let { field(MEMBERARN_DESCRIPTOR, it) }
        input.type?.let { field(TYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
