// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.chime.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.chime.model.*
import aws.sdk.kotlin.services.chime.model.AssociatePhoneNumberWithUserRequest
import aws.sdk.kotlin.services.chime.model.AssociatePhoneNumberWithUserResponse
import aws.sdk.kotlin.services.chime.model.AssociatePhoneNumbersWithVoiceConnectorGroupRequest
import aws.sdk.kotlin.services.chime.model.AssociatePhoneNumbersWithVoiceConnectorGroupResponse
import aws.sdk.kotlin.services.chime.model.AssociatePhoneNumbersWithVoiceConnectorRequest
import aws.sdk.kotlin.services.chime.model.AssociatePhoneNumbersWithVoiceConnectorResponse
import aws.sdk.kotlin.services.chime.model.AssociateSigninDelegateGroupsWithAccountRequest
import aws.sdk.kotlin.services.chime.model.AssociateSigninDelegateGroupsWithAccountResponse
import aws.sdk.kotlin.services.chime.model.BatchCreateAttendeeRequest
import aws.sdk.kotlin.services.chime.model.BatchCreateAttendeeResponse
import aws.sdk.kotlin.services.chime.model.BatchCreateChannelMembershipRequest
import aws.sdk.kotlin.services.chime.model.BatchCreateChannelMembershipResponse
import aws.sdk.kotlin.services.chime.model.BatchCreateRoomMembershipRequest
import aws.sdk.kotlin.services.chime.model.BatchCreateRoomMembershipResponse
import aws.sdk.kotlin.services.chime.model.BatchDeletePhoneNumberRequest
import aws.sdk.kotlin.services.chime.model.BatchDeletePhoneNumberResponse
import aws.sdk.kotlin.services.chime.model.BatchSuspendUserRequest
import aws.sdk.kotlin.services.chime.model.BatchSuspendUserResponse
import aws.sdk.kotlin.services.chime.model.BatchUnsuspendUserRequest
import aws.sdk.kotlin.services.chime.model.BatchUnsuspendUserResponse
import aws.sdk.kotlin.services.chime.model.BatchUpdatePhoneNumberRequest
import aws.sdk.kotlin.services.chime.model.BatchUpdatePhoneNumberResponse
import aws.sdk.kotlin.services.chime.model.BatchUpdateUserRequest
import aws.sdk.kotlin.services.chime.model.BatchUpdateUserResponse
import aws.sdk.kotlin.services.chime.model.CreateAccountRequest
import aws.sdk.kotlin.services.chime.model.CreateAccountResponse
import aws.sdk.kotlin.services.chime.model.CreateAppInstanceAdminRequest
import aws.sdk.kotlin.services.chime.model.CreateAppInstanceAdminResponse
import aws.sdk.kotlin.services.chime.model.CreateAppInstanceRequest
import aws.sdk.kotlin.services.chime.model.CreateAppInstanceResponse
import aws.sdk.kotlin.services.chime.model.CreateAppInstanceUserRequest
import aws.sdk.kotlin.services.chime.model.CreateAppInstanceUserResponse
import aws.sdk.kotlin.services.chime.model.CreateAttendeeRequest
import aws.sdk.kotlin.services.chime.model.CreateAttendeeResponse
import aws.sdk.kotlin.services.chime.model.CreateBotRequest
import aws.sdk.kotlin.services.chime.model.CreateBotResponse
import aws.sdk.kotlin.services.chime.model.CreateChannelBanRequest
import aws.sdk.kotlin.services.chime.model.CreateChannelBanResponse
import aws.sdk.kotlin.services.chime.model.CreateChannelMembershipRequest
import aws.sdk.kotlin.services.chime.model.CreateChannelMembershipResponse
import aws.sdk.kotlin.services.chime.model.CreateChannelModeratorRequest
import aws.sdk.kotlin.services.chime.model.CreateChannelModeratorResponse
import aws.sdk.kotlin.services.chime.model.CreateChannelRequest
import aws.sdk.kotlin.services.chime.model.CreateChannelResponse
import aws.sdk.kotlin.services.chime.model.CreateMediaCapturePipelineRequest
import aws.sdk.kotlin.services.chime.model.CreateMediaCapturePipelineResponse
import aws.sdk.kotlin.services.chime.model.CreateMeetingDialOutRequest
import aws.sdk.kotlin.services.chime.model.CreateMeetingDialOutResponse
import aws.sdk.kotlin.services.chime.model.CreateMeetingRequest
import aws.sdk.kotlin.services.chime.model.CreateMeetingResponse
import aws.sdk.kotlin.services.chime.model.CreateMeetingWithAttendeesRequest
import aws.sdk.kotlin.services.chime.model.CreateMeetingWithAttendeesResponse
import aws.sdk.kotlin.services.chime.model.CreatePhoneNumberOrderRequest
import aws.sdk.kotlin.services.chime.model.CreatePhoneNumberOrderResponse
import aws.sdk.kotlin.services.chime.model.CreateProxySessionRequest
import aws.sdk.kotlin.services.chime.model.CreateProxySessionResponse
import aws.sdk.kotlin.services.chime.model.CreateRoomMembershipRequest
import aws.sdk.kotlin.services.chime.model.CreateRoomMembershipResponse
import aws.sdk.kotlin.services.chime.model.CreateRoomRequest
import aws.sdk.kotlin.services.chime.model.CreateRoomResponse
import aws.sdk.kotlin.services.chime.model.CreateSipMediaApplicationCallRequest
import aws.sdk.kotlin.services.chime.model.CreateSipMediaApplicationCallResponse
import aws.sdk.kotlin.services.chime.model.CreateSipMediaApplicationRequest
import aws.sdk.kotlin.services.chime.model.CreateSipMediaApplicationResponse
import aws.sdk.kotlin.services.chime.model.CreateSipRuleRequest
import aws.sdk.kotlin.services.chime.model.CreateSipRuleResponse
import aws.sdk.kotlin.services.chime.model.CreateUserRequest
import aws.sdk.kotlin.services.chime.model.CreateUserResponse
import aws.sdk.kotlin.services.chime.model.CreateVoiceConnectorGroupRequest
import aws.sdk.kotlin.services.chime.model.CreateVoiceConnectorGroupResponse
import aws.sdk.kotlin.services.chime.model.CreateVoiceConnectorRequest
import aws.sdk.kotlin.services.chime.model.CreateVoiceConnectorResponse
import aws.sdk.kotlin.services.chime.model.DeleteAccountRequest
import aws.sdk.kotlin.services.chime.model.DeleteAccountResponse
import aws.sdk.kotlin.services.chime.model.DeleteAppInstanceAdminRequest
import aws.sdk.kotlin.services.chime.model.DeleteAppInstanceAdminResponse
import aws.sdk.kotlin.services.chime.model.DeleteAppInstanceRequest
import aws.sdk.kotlin.services.chime.model.DeleteAppInstanceResponse
import aws.sdk.kotlin.services.chime.model.DeleteAppInstanceStreamingConfigurationsRequest
import aws.sdk.kotlin.services.chime.model.DeleteAppInstanceStreamingConfigurationsResponse
import aws.sdk.kotlin.services.chime.model.DeleteAppInstanceUserRequest
import aws.sdk.kotlin.services.chime.model.DeleteAppInstanceUserResponse
import aws.sdk.kotlin.services.chime.model.DeleteAttendeeRequest
import aws.sdk.kotlin.services.chime.model.DeleteAttendeeResponse
import aws.sdk.kotlin.services.chime.model.DeleteChannelBanRequest
import aws.sdk.kotlin.services.chime.model.DeleteChannelBanResponse
import aws.sdk.kotlin.services.chime.model.DeleteChannelMembershipRequest
import aws.sdk.kotlin.services.chime.model.DeleteChannelMembershipResponse
import aws.sdk.kotlin.services.chime.model.DeleteChannelMessageRequest
import aws.sdk.kotlin.services.chime.model.DeleteChannelMessageResponse
import aws.sdk.kotlin.services.chime.model.DeleteChannelModeratorRequest
import aws.sdk.kotlin.services.chime.model.DeleteChannelModeratorResponse
import aws.sdk.kotlin.services.chime.model.DeleteChannelRequest
import aws.sdk.kotlin.services.chime.model.DeleteChannelResponse
import aws.sdk.kotlin.services.chime.model.DeleteEventsConfigurationRequest
import aws.sdk.kotlin.services.chime.model.DeleteEventsConfigurationResponse
import aws.sdk.kotlin.services.chime.model.DeleteMediaCapturePipelineRequest
import aws.sdk.kotlin.services.chime.model.DeleteMediaCapturePipelineResponse
import aws.sdk.kotlin.services.chime.model.DeleteMeetingRequest
import aws.sdk.kotlin.services.chime.model.DeleteMeetingResponse
import aws.sdk.kotlin.services.chime.model.DeletePhoneNumberRequest
import aws.sdk.kotlin.services.chime.model.DeletePhoneNumberResponse
import aws.sdk.kotlin.services.chime.model.DeleteProxySessionRequest
import aws.sdk.kotlin.services.chime.model.DeleteProxySessionResponse
import aws.sdk.kotlin.services.chime.model.DeleteRoomMembershipRequest
import aws.sdk.kotlin.services.chime.model.DeleteRoomMembershipResponse
import aws.sdk.kotlin.services.chime.model.DeleteRoomRequest
import aws.sdk.kotlin.services.chime.model.DeleteRoomResponse
import aws.sdk.kotlin.services.chime.model.DeleteSipMediaApplicationRequest
import aws.sdk.kotlin.services.chime.model.DeleteSipMediaApplicationResponse
import aws.sdk.kotlin.services.chime.model.DeleteSipRuleRequest
import aws.sdk.kotlin.services.chime.model.DeleteSipRuleResponse
import aws.sdk.kotlin.services.chime.model.DeleteVoiceConnectorEmergencyCallingConfigurationRequest
import aws.sdk.kotlin.services.chime.model.DeleteVoiceConnectorEmergencyCallingConfigurationResponse
import aws.sdk.kotlin.services.chime.model.DeleteVoiceConnectorGroupRequest
import aws.sdk.kotlin.services.chime.model.DeleteVoiceConnectorGroupResponse
import aws.sdk.kotlin.services.chime.model.DeleteVoiceConnectorOriginationRequest
import aws.sdk.kotlin.services.chime.model.DeleteVoiceConnectorOriginationResponse
import aws.sdk.kotlin.services.chime.model.DeleteVoiceConnectorProxyRequest
import aws.sdk.kotlin.services.chime.model.DeleteVoiceConnectorProxyResponse
import aws.sdk.kotlin.services.chime.model.DeleteVoiceConnectorRequest
import aws.sdk.kotlin.services.chime.model.DeleteVoiceConnectorResponse
import aws.sdk.kotlin.services.chime.model.DeleteVoiceConnectorStreamingConfigurationRequest
import aws.sdk.kotlin.services.chime.model.DeleteVoiceConnectorStreamingConfigurationResponse
import aws.sdk.kotlin.services.chime.model.DeleteVoiceConnectorTerminationCredentialsRequest
import aws.sdk.kotlin.services.chime.model.DeleteVoiceConnectorTerminationCredentialsResponse
import aws.sdk.kotlin.services.chime.model.DeleteVoiceConnectorTerminationRequest
import aws.sdk.kotlin.services.chime.model.DeleteVoiceConnectorTerminationResponse
import aws.sdk.kotlin.services.chime.model.DescribeAppInstanceAdminRequest
import aws.sdk.kotlin.services.chime.model.DescribeAppInstanceAdminResponse
import aws.sdk.kotlin.services.chime.model.DescribeAppInstanceRequest
import aws.sdk.kotlin.services.chime.model.DescribeAppInstanceResponse
import aws.sdk.kotlin.services.chime.model.DescribeAppInstanceUserRequest
import aws.sdk.kotlin.services.chime.model.DescribeAppInstanceUserResponse
import aws.sdk.kotlin.services.chime.model.DescribeChannelBanRequest
import aws.sdk.kotlin.services.chime.model.DescribeChannelBanResponse
import aws.sdk.kotlin.services.chime.model.DescribeChannelMembershipForAppInstanceUserRequest
import aws.sdk.kotlin.services.chime.model.DescribeChannelMembershipForAppInstanceUserResponse
import aws.sdk.kotlin.services.chime.model.DescribeChannelMembershipRequest
import aws.sdk.kotlin.services.chime.model.DescribeChannelMembershipResponse
import aws.sdk.kotlin.services.chime.model.DescribeChannelModeratedByAppInstanceUserRequest
import aws.sdk.kotlin.services.chime.model.DescribeChannelModeratedByAppInstanceUserResponse
import aws.sdk.kotlin.services.chime.model.DescribeChannelModeratorRequest
import aws.sdk.kotlin.services.chime.model.DescribeChannelModeratorResponse
import aws.sdk.kotlin.services.chime.model.DescribeChannelRequest
import aws.sdk.kotlin.services.chime.model.DescribeChannelResponse
import aws.sdk.kotlin.services.chime.model.DisassociatePhoneNumberFromUserRequest
import aws.sdk.kotlin.services.chime.model.DisassociatePhoneNumberFromUserResponse
import aws.sdk.kotlin.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorGroupRequest
import aws.sdk.kotlin.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorGroupResponse
import aws.sdk.kotlin.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorRequest
import aws.sdk.kotlin.services.chime.model.DisassociatePhoneNumbersFromVoiceConnectorResponse
import aws.sdk.kotlin.services.chime.model.DisassociateSigninDelegateGroupsFromAccountRequest
import aws.sdk.kotlin.services.chime.model.DisassociateSigninDelegateGroupsFromAccountResponse
import aws.sdk.kotlin.services.chime.model.GetAccountRequest
import aws.sdk.kotlin.services.chime.model.GetAccountResponse
import aws.sdk.kotlin.services.chime.model.GetAccountSettingsRequest
import aws.sdk.kotlin.services.chime.model.GetAccountSettingsResponse
import aws.sdk.kotlin.services.chime.model.GetAppInstanceRetentionSettingsRequest
import aws.sdk.kotlin.services.chime.model.GetAppInstanceRetentionSettingsResponse
import aws.sdk.kotlin.services.chime.model.GetAppInstanceStreamingConfigurationsRequest
import aws.sdk.kotlin.services.chime.model.GetAppInstanceStreamingConfigurationsResponse
import aws.sdk.kotlin.services.chime.model.GetAttendeeRequest
import aws.sdk.kotlin.services.chime.model.GetAttendeeResponse
import aws.sdk.kotlin.services.chime.model.GetBotRequest
import aws.sdk.kotlin.services.chime.model.GetBotResponse
import aws.sdk.kotlin.services.chime.model.GetChannelMessageRequest
import aws.sdk.kotlin.services.chime.model.GetChannelMessageResponse
import aws.sdk.kotlin.services.chime.model.GetEventsConfigurationRequest
import aws.sdk.kotlin.services.chime.model.GetEventsConfigurationResponse
import aws.sdk.kotlin.services.chime.model.GetGlobalSettingsRequest
import aws.sdk.kotlin.services.chime.model.GetGlobalSettingsResponse
import aws.sdk.kotlin.services.chime.model.GetMediaCapturePipelineRequest
import aws.sdk.kotlin.services.chime.model.GetMediaCapturePipelineResponse
import aws.sdk.kotlin.services.chime.model.GetMeetingRequest
import aws.sdk.kotlin.services.chime.model.GetMeetingResponse
import aws.sdk.kotlin.services.chime.model.GetMessagingSessionEndpointRequest
import aws.sdk.kotlin.services.chime.model.GetMessagingSessionEndpointResponse
import aws.sdk.kotlin.services.chime.model.GetPhoneNumberOrderRequest
import aws.sdk.kotlin.services.chime.model.GetPhoneNumberOrderResponse
import aws.sdk.kotlin.services.chime.model.GetPhoneNumberRequest
import aws.sdk.kotlin.services.chime.model.GetPhoneNumberResponse
import aws.sdk.kotlin.services.chime.model.GetPhoneNumberSettingsRequest
import aws.sdk.kotlin.services.chime.model.GetPhoneNumberSettingsResponse
import aws.sdk.kotlin.services.chime.model.GetProxySessionRequest
import aws.sdk.kotlin.services.chime.model.GetProxySessionResponse
import aws.sdk.kotlin.services.chime.model.GetRetentionSettingsRequest
import aws.sdk.kotlin.services.chime.model.GetRetentionSettingsResponse
import aws.sdk.kotlin.services.chime.model.GetRoomRequest
import aws.sdk.kotlin.services.chime.model.GetRoomResponse
import aws.sdk.kotlin.services.chime.model.GetSipMediaApplicationLoggingConfigurationRequest
import aws.sdk.kotlin.services.chime.model.GetSipMediaApplicationLoggingConfigurationResponse
import aws.sdk.kotlin.services.chime.model.GetSipMediaApplicationRequest
import aws.sdk.kotlin.services.chime.model.GetSipMediaApplicationResponse
import aws.sdk.kotlin.services.chime.model.GetSipRuleRequest
import aws.sdk.kotlin.services.chime.model.GetSipRuleResponse
import aws.sdk.kotlin.services.chime.model.GetUserRequest
import aws.sdk.kotlin.services.chime.model.GetUserResponse
import aws.sdk.kotlin.services.chime.model.GetUserSettingsRequest
import aws.sdk.kotlin.services.chime.model.GetUserSettingsResponse
import aws.sdk.kotlin.services.chime.model.GetVoiceConnectorEmergencyCallingConfigurationRequest
import aws.sdk.kotlin.services.chime.model.GetVoiceConnectorEmergencyCallingConfigurationResponse
import aws.sdk.kotlin.services.chime.model.GetVoiceConnectorGroupRequest
import aws.sdk.kotlin.services.chime.model.GetVoiceConnectorGroupResponse
import aws.sdk.kotlin.services.chime.model.GetVoiceConnectorLoggingConfigurationRequest
import aws.sdk.kotlin.services.chime.model.GetVoiceConnectorLoggingConfigurationResponse
import aws.sdk.kotlin.services.chime.model.GetVoiceConnectorOriginationRequest
import aws.sdk.kotlin.services.chime.model.GetVoiceConnectorOriginationResponse
import aws.sdk.kotlin.services.chime.model.GetVoiceConnectorProxyRequest
import aws.sdk.kotlin.services.chime.model.GetVoiceConnectorProxyResponse
import aws.sdk.kotlin.services.chime.model.GetVoiceConnectorRequest
import aws.sdk.kotlin.services.chime.model.GetVoiceConnectorResponse
import aws.sdk.kotlin.services.chime.model.GetVoiceConnectorStreamingConfigurationRequest
import aws.sdk.kotlin.services.chime.model.GetVoiceConnectorStreamingConfigurationResponse
import aws.sdk.kotlin.services.chime.model.GetVoiceConnectorTerminationHealthRequest
import aws.sdk.kotlin.services.chime.model.GetVoiceConnectorTerminationHealthResponse
import aws.sdk.kotlin.services.chime.model.GetVoiceConnectorTerminationRequest
import aws.sdk.kotlin.services.chime.model.GetVoiceConnectorTerminationResponse
import aws.sdk.kotlin.services.chime.model.InviteUsersRequest
import aws.sdk.kotlin.services.chime.model.InviteUsersResponse
import aws.sdk.kotlin.services.chime.model.ListAccountsRequest
import aws.sdk.kotlin.services.chime.model.ListAccountsResponse
import aws.sdk.kotlin.services.chime.model.ListAppInstanceAdminsRequest
import aws.sdk.kotlin.services.chime.model.ListAppInstanceAdminsResponse
import aws.sdk.kotlin.services.chime.model.ListAppInstanceUsersRequest
import aws.sdk.kotlin.services.chime.model.ListAppInstanceUsersResponse
import aws.sdk.kotlin.services.chime.model.ListAppInstancesRequest
import aws.sdk.kotlin.services.chime.model.ListAppInstancesResponse
import aws.sdk.kotlin.services.chime.model.ListAttendeeTagsRequest
import aws.sdk.kotlin.services.chime.model.ListAttendeeTagsResponse
import aws.sdk.kotlin.services.chime.model.ListAttendeesRequest
import aws.sdk.kotlin.services.chime.model.ListAttendeesResponse
import aws.sdk.kotlin.services.chime.model.ListBotsRequest
import aws.sdk.kotlin.services.chime.model.ListBotsResponse
import aws.sdk.kotlin.services.chime.model.ListChannelBansRequest
import aws.sdk.kotlin.services.chime.model.ListChannelBansResponse
import aws.sdk.kotlin.services.chime.model.ListChannelMembershipsForAppInstanceUserRequest
import aws.sdk.kotlin.services.chime.model.ListChannelMembershipsForAppInstanceUserResponse
import aws.sdk.kotlin.services.chime.model.ListChannelMembershipsRequest
import aws.sdk.kotlin.services.chime.model.ListChannelMembershipsResponse
import aws.sdk.kotlin.services.chime.model.ListChannelMessagesRequest
import aws.sdk.kotlin.services.chime.model.ListChannelMessagesResponse
import aws.sdk.kotlin.services.chime.model.ListChannelModeratorsRequest
import aws.sdk.kotlin.services.chime.model.ListChannelModeratorsResponse
import aws.sdk.kotlin.services.chime.model.ListChannelsModeratedByAppInstanceUserRequest
import aws.sdk.kotlin.services.chime.model.ListChannelsModeratedByAppInstanceUserResponse
import aws.sdk.kotlin.services.chime.model.ListChannelsRequest
import aws.sdk.kotlin.services.chime.model.ListChannelsResponse
import aws.sdk.kotlin.services.chime.model.ListMediaCapturePipelinesRequest
import aws.sdk.kotlin.services.chime.model.ListMediaCapturePipelinesResponse
import aws.sdk.kotlin.services.chime.model.ListMeetingTagsRequest
import aws.sdk.kotlin.services.chime.model.ListMeetingTagsResponse
import aws.sdk.kotlin.services.chime.model.ListMeetingsRequest
import aws.sdk.kotlin.services.chime.model.ListMeetingsResponse
import aws.sdk.kotlin.services.chime.model.ListPhoneNumberOrdersRequest
import aws.sdk.kotlin.services.chime.model.ListPhoneNumberOrdersResponse
import aws.sdk.kotlin.services.chime.model.ListPhoneNumbersRequest
import aws.sdk.kotlin.services.chime.model.ListPhoneNumbersResponse
import aws.sdk.kotlin.services.chime.model.ListProxySessionsRequest
import aws.sdk.kotlin.services.chime.model.ListProxySessionsResponse
import aws.sdk.kotlin.services.chime.model.ListRoomMembershipsRequest
import aws.sdk.kotlin.services.chime.model.ListRoomMembershipsResponse
import aws.sdk.kotlin.services.chime.model.ListRoomsRequest
import aws.sdk.kotlin.services.chime.model.ListRoomsResponse
import aws.sdk.kotlin.services.chime.model.ListSipMediaApplicationsRequest
import aws.sdk.kotlin.services.chime.model.ListSipMediaApplicationsResponse
import aws.sdk.kotlin.services.chime.model.ListSipRulesRequest
import aws.sdk.kotlin.services.chime.model.ListSipRulesResponse
import aws.sdk.kotlin.services.chime.model.ListSupportedPhoneNumberCountriesRequest
import aws.sdk.kotlin.services.chime.model.ListSupportedPhoneNumberCountriesResponse
import aws.sdk.kotlin.services.chime.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.chime.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.chime.model.ListUsersRequest
import aws.sdk.kotlin.services.chime.model.ListUsersResponse
import aws.sdk.kotlin.services.chime.model.ListVoiceConnectorGroupsRequest
import aws.sdk.kotlin.services.chime.model.ListVoiceConnectorGroupsResponse
import aws.sdk.kotlin.services.chime.model.ListVoiceConnectorTerminationCredentialsRequest
import aws.sdk.kotlin.services.chime.model.ListVoiceConnectorTerminationCredentialsResponse
import aws.sdk.kotlin.services.chime.model.ListVoiceConnectorsRequest
import aws.sdk.kotlin.services.chime.model.ListVoiceConnectorsResponse
import aws.sdk.kotlin.services.chime.model.LogoutUserRequest
import aws.sdk.kotlin.services.chime.model.LogoutUserResponse
import aws.sdk.kotlin.services.chime.model.PutAppInstanceRetentionSettingsRequest
import aws.sdk.kotlin.services.chime.model.PutAppInstanceRetentionSettingsResponse
import aws.sdk.kotlin.services.chime.model.PutAppInstanceStreamingConfigurationsRequest
import aws.sdk.kotlin.services.chime.model.PutAppInstanceStreamingConfigurationsResponse
import aws.sdk.kotlin.services.chime.model.PutEventsConfigurationRequest
import aws.sdk.kotlin.services.chime.model.PutEventsConfigurationResponse
import aws.sdk.kotlin.services.chime.model.PutRetentionSettingsRequest
import aws.sdk.kotlin.services.chime.model.PutRetentionSettingsResponse
import aws.sdk.kotlin.services.chime.model.PutSipMediaApplicationLoggingConfigurationRequest
import aws.sdk.kotlin.services.chime.model.PutSipMediaApplicationLoggingConfigurationResponse
import aws.sdk.kotlin.services.chime.model.PutVoiceConnectorEmergencyCallingConfigurationRequest
import aws.sdk.kotlin.services.chime.model.PutVoiceConnectorEmergencyCallingConfigurationResponse
import aws.sdk.kotlin.services.chime.model.PutVoiceConnectorLoggingConfigurationRequest
import aws.sdk.kotlin.services.chime.model.PutVoiceConnectorLoggingConfigurationResponse
import aws.sdk.kotlin.services.chime.model.PutVoiceConnectorOriginationRequest
import aws.sdk.kotlin.services.chime.model.PutVoiceConnectorOriginationResponse
import aws.sdk.kotlin.services.chime.model.PutVoiceConnectorProxyRequest
import aws.sdk.kotlin.services.chime.model.PutVoiceConnectorProxyResponse
import aws.sdk.kotlin.services.chime.model.PutVoiceConnectorStreamingConfigurationRequest
import aws.sdk.kotlin.services.chime.model.PutVoiceConnectorStreamingConfigurationResponse
import aws.sdk.kotlin.services.chime.model.PutVoiceConnectorTerminationCredentialsRequest
import aws.sdk.kotlin.services.chime.model.PutVoiceConnectorTerminationCredentialsResponse
import aws.sdk.kotlin.services.chime.model.PutVoiceConnectorTerminationRequest
import aws.sdk.kotlin.services.chime.model.PutVoiceConnectorTerminationResponse
import aws.sdk.kotlin.services.chime.model.RedactChannelMessageRequest
import aws.sdk.kotlin.services.chime.model.RedactChannelMessageResponse
import aws.sdk.kotlin.services.chime.model.RedactConversationMessageRequest
import aws.sdk.kotlin.services.chime.model.RedactConversationMessageResponse
import aws.sdk.kotlin.services.chime.model.RedactRoomMessageRequest
import aws.sdk.kotlin.services.chime.model.RedactRoomMessageResponse
import aws.sdk.kotlin.services.chime.model.RegenerateSecurityTokenRequest
import aws.sdk.kotlin.services.chime.model.RegenerateSecurityTokenResponse
import aws.sdk.kotlin.services.chime.model.ResetPersonalPinRequest
import aws.sdk.kotlin.services.chime.model.ResetPersonalPinResponse
import aws.sdk.kotlin.services.chime.model.RestorePhoneNumberRequest
import aws.sdk.kotlin.services.chime.model.RestorePhoneNumberResponse
import aws.sdk.kotlin.services.chime.model.SearchAvailablePhoneNumbersRequest
import aws.sdk.kotlin.services.chime.model.SearchAvailablePhoneNumbersResponse
import aws.sdk.kotlin.services.chime.model.SendChannelMessageRequest
import aws.sdk.kotlin.services.chime.model.SendChannelMessageResponse
import aws.sdk.kotlin.services.chime.model.StartMeetingTranscriptionRequest
import aws.sdk.kotlin.services.chime.model.StartMeetingTranscriptionResponse
import aws.sdk.kotlin.services.chime.model.StopMeetingTranscriptionRequest
import aws.sdk.kotlin.services.chime.model.StopMeetingTranscriptionResponse
import aws.sdk.kotlin.services.chime.model.TagAttendeeRequest
import aws.sdk.kotlin.services.chime.model.TagAttendeeResponse
import aws.sdk.kotlin.services.chime.model.TagMeetingRequest
import aws.sdk.kotlin.services.chime.model.TagMeetingResponse
import aws.sdk.kotlin.services.chime.model.TagResourceRequest
import aws.sdk.kotlin.services.chime.model.TagResourceResponse
import aws.sdk.kotlin.services.chime.model.UntagAttendeeRequest
import aws.sdk.kotlin.services.chime.model.UntagAttendeeResponse
import aws.sdk.kotlin.services.chime.model.UntagMeetingRequest
import aws.sdk.kotlin.services.chime.model.UntagMeetingResponse
import aws.sdk.kotlin.services.chime.model.UntagResourceRequest
import aws.sdk.kotlin.services.chime.model.UntagResourceResponse
import aws.sdk.kotlin.services.chime.model.UpdateAccountRequest
import aws.sdk.kotlin.services.chime.model.UpdateAccountResponse
import aws.sdk.kotlin.services.chime.model.UpdateAccountSettingsRequest
import aws.sdk.kotlin.services.chime.model.UpdateAccountSettingsResponse
import aws.sdk.kotlin.services.chime.model.UpdateAppInstanceRequest
import aws.sdk.kotlin.services.chime.model.UpdateAppInstanceResponse
import aws.sdk.kotlin.services.chime.model.UpdateAppInstanceUserRequest
import aws.sdk.kotlin.services.chime.model.UpdateAppInstanceUserResponse
import aws.sdk.kotlin.services.chime.model.UpdateBotRequest
import aws.sdk.kotlin.services.chime.model.UpdateBotResponse
import aws.sdk.kotlin.services.chime.model.UpdateChannelMessageRequest
import aws.sdk.kotlin.services.chime.model.UpdateChannelMessageResponse
import aws.sdk.kotlin.services.chime.model.UpdateChannelReadMarkerRequest
import aws.sdk.kotlin.services.chime.model.UpdateChannelReadMarkerResponse
import aws.sdk.kotlin.services.chime.model.UpdateChannelRequest
import aws.sdk.kotlin.services.chime.model.UpdateChannelResponse
import aws.sdk.kotlin.services.chime.model.UpdateGlobalSettingsRequest
import aws.sdk.kotlin.services.chime.model.UpdateGlobalSettingsResponse
import aws.sdk.kotlin.services.chime.model.UpdatePhoneNumberRequest
import aws.sdk.kotlin.services.chime.model.UpdatePhoneNumberResponse
import aws.sdk.kotlin.services.chime.model.UpdatePhoneNumberSettingsRequest
import aws.sdk.kotlin.services.chime.model.UpdatePhoneNumberSettingsResponse
import aws.sdk.kotlin.services.chime.model.UpdateProxySessionRequest
import aws.sdk.kotlin.services.chime.model.UpdateProxySessionResponse
import aws.sdk.kotlin.services.chime.model.UpdateRoomMembershipRequest
import aws.sdk.kotlin.services.chime.model.UpdateRoomMembershipResponse
import aws.sdk.kotlin.services.chime.model.UpdateRoomRequest
import aws.sdk.kotlin.services.chime.model.UpdateRoomResponse
import aws.sdk.kotlin.services.chime.model.UpdateSipMediaApplicationCallRequest
import aws.sdk.kotlin.services.chime.model.UpdateSipMediaApplicationCallResponse
import aws.sdk.kotlin.services.chime.model.UpdateSipMediaApplicationRequest
import aws.sdk.kotlin.services.chime.model.UpdateSipMediaApplicationResponse
import aws.sdk.kotlin.services.chime.model.UpdateSipRuleRequest
import aws.sdk.kotlin.services.chime.model.UpdateSipRuleResponse
import aws.sdk.kotlin.services.chime.model.UpdateUserRequest
import aws.sdk.kotlin.services.chime.model.UpdateUserResponse
import aws.sdk.kotlin.services.chime.model.UpdateUserSettingsRequest
import aws.sdk.kotlin.services.chime.model.UpdateUserSettingsResponse
import aws.sdk.kotlin.services.chime.model.UpdateVoiceConnectorGroupRequest
import aws.sdk.kotlin.services.chime.model.UpdateVoiceConnectorGroupResponse
import aws.sdk.kotlin.services.chime.model.UpdateVoiceConnectorRequest
import aws.sdk.kotlin.services.chime.model.UpdateVoiceConnectorResponse
import aws.sdk.kotlin.services.chime.model.ValidateE911AddressRequest
import aws.sdk.kotlin.services.chime.model.ValidateE911AddressResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * The Amazon Chime API (application programming interface) is designed for developers to perform key tasks, such as creating and managing Amazon Chime accounts, users, and Voice Connectors. This guide provides detailed information about the Amazon Chime API, including operations, types, inputs and outputs, and error codes. It also includes API actions for use with the Amazon Chime SDK, which developers use to build their own communication applications. For more information about the Amazon Chime SDK, see [ Using the Amazon Chime SDK ](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide*.
 *
 * You can use an AWS SDK, the AWS Command Line Interface (AWS CLI), or the REST API to make API calls. We recommend using an AWS SDK or the AWS CLI. Each API operation includes links to information about using it with a language-specific AWS SDK or the AWS CLI.
 *
 * ## Using an AWS SDK
 *  You don't need to write code to calculate a signature for request authentication. The SDK clients authenticate your requests by using access keys that you provide. For more information about AWS SDKs, see the [AWS Developer Center](http://aws.amazon.com/developer/).
 *
 * ## Using the AWS CLI
 * Use your access keys with the AWS CLI to make API calls. For information about setting up the AWS CLI, see [Installing the AWS Command Line Interface](https://docs.aws.amazon.com/cli/latest/userguide/installing.html) in the *AWS Command Line Interface User Guide*. For a list of available Amazon Chime commands, see the [Amazon Chime commands](https://docs.aws.amazon.com/cli/latest/reference/chime/index.html) in the *AWS CLI Command Reference*.
 *
 * ## Using REST APIs
 * If you use REST to make API calls, you must authenticate your request by providing a signature. Amazon Chime supports signature version 4. For more information, see [Signature Version 4 Signing Process](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html) in the *Amazon Web Services General Reference*.
 *
 * When making REST API calls, use the service name `chime` and REST endpoint `https://service.chime.aws.amazon.com`.
 *
 * Administrative permissions are controlled using AWS Identity and Access Management (IAM). For more information, see [Identity and Access Management for Amazon Chime](https://docs.aws.amazon.com/chime/latest/ag/security-iam.html) in the *Amazon Chime Administration Guide*.
 */
public interface ChimeClient : SdkClient {

    override val serviceName: String
        get() = "Chime"
    /**
     * ChimeClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): ChimeClient {
            val config = Config.Builder().apply(block).build()
            return DefaultChimeClient(config)
        }

        public operator fun invoke(config: Config): ChimeClient = DefaultChimeClient(config)

        /**
         * Construct a [ChimeClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): ChimeClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultChimeClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a phone number with the specified Amazon Chime user.
     */
    public suspend fun associatePhoneNumberWithUser(input: AssociatePhoneNumberWithUserRequest): AssociatePhoneNumberWithUserResponse

    /**
     * Associates phone numbers with the specified Amazon Chime Voice Connector.
     */
    public suspend fun associatePhoneNumbersWithVoiceConnector(input: AssociatePhoneNumbersWithVoiceConnectorRequest): AssociatePhoneNumbersWithVoiceConnectorResponse

    /**
     * Associates phone numbers with the specified Amazon Chime Voice Connector group.
     */
    public suspend fun associatePhoneNumbersWithVoiceConnectorGroup(input: AssociatePhoneNumbersWithVoiceConnectorGroupRequest): AssociatePhoneNumbersWithVoiceConnectorGroupResponse

    /**
     * Associates the specified sign-in delegate groups with the specified Amazon Chime account.
     */
    public suspend fun associateSigninDelegateGroupsWithAccount(input: AssociateSigninDelegateGroupsWithAccountRequest): AssociateSigninDelegateGroupsWithAccountResponse

    /**
     * Creates up to 100 new attendees for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide*.
     */
    public suspend fun batchCreateAttendee(input: BatchCreateAttendeeRequest): BatchCreateAttendeeResponse

    /**
     * Adds a specified number of users to a channel.
     */
    public suspend fun batchCreateChannelMembership(input: BatchCreateChannelMembershipRequest): BatchCreateChannelMembershipResponse

    /**
     * Adds up to 50 members to a chat room in an Amazon Chime Enterprise account. Members can be users or bots. The member role designates whether the member is a chat room administrator or a general chat room member.
     */
    public suspend fun batchCreateRoomMembership(input: BatchCreateRoomMembershipRequest): BatchCreateRoomMembershipResponse

    /**
     * Moves phone numbers into the **Deletion queue**. Phone numbers must be disassociated from any users or Amazon Chime Voice Connectors before they can be deleted.
     *
     *  Phone numbers remain in the **Deletion queue** for 7 days before they are deleted permanently.
     */
    public suspend fun batchDeletePhoneNumber(input: BatchDeletePhoneNumberRequest): BatchDeletePhoneNumberResponse

    /**
     * Suspends up to 50 users from a `Team` or `EnterpriseLWA` Amazon Chime account. For more information about different account types, see [Managing Your Amazon Chime Accounts](https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html) in the *Amazon Chime Administration Guide*.
     *
     * Users suspended from a `Team` account are disassociated from the account,but they can continue to use Amazon Chime as free users. To remove the suspension from suspended `Team` account users, invite them to the `Team` account again. You can use the InviteUsers action to do so.
     *
     * Users suspended from an `EnterpriseLWA` account are immediately signed out of Amazon Chime and can no longer sign in. To remove the suspension from suspended `EnterpriseLWA` account users, use the BatchUnsuspendUser action.
     *
     *  To sign out users without suspending them, use the LogoutUser action.
     */
    public suspend fun batchSuspendUser(input: BatchSuspendUserRequest): BatchSuspendUserResponse

    /**
     * Removes the suspension from up to 50 previously suspended users for the specified Amazon Chime `EnterpriseLWA` account. Only users on `EnterpriseLWA` accounts can be unsuspended using this action. For more information about different account types, see [ Managing Your Amazon Chime Accounts ](https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html) in the account types, in the *Amazon Chime Administration Guide*.
     *
     *  Previously suspended users who are unsuspended using this action are returned to `Registered` status. Users who are not previously suspended are ignored.
     */
    public suspend fun batchUnsuspendUser(input: BatchUnsuspendUserRequest): BatchUnsuspendUserResponse

    /**
     * Updates phone number product types or calling names. You can update one attribute at a time for each `UpdatePhoneNumberRequestItem`. For example, you can update the product type or the calling name.
     *
     * For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.
     *
     * Updates to outbound calling names can take up to 72 hours to complete. Pending updates to outbound calling names must be complete before you can request another update.
     */
    public suspend fun batchUpdatePhoneNumber(input: BatchUpdatePhoneNumberRequest): BatchUpdatePhoneNumberResponse

    /**
     * Updates user details within the UpdateUserRequestItem object for up to 20 users for the specified Amazon Chime account. Currently, only `LicenseType` updates are supported for this action.
     */
    public suspend fun batchUpdateUser(input: BatchUpdateUserRequest): BatchUpdateUserResponse

    /**
     * Creates an Amazon Chime account under the administrator's AWS account. Only `Team` account types are currently supported for this action. For more information about different account types, see [Managing Your Amazon Chime Accounts](https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html) in the *Amazon Chime Administration Guide*.
     */
    public suspend fun createAccount(input: CreateAccountRequest): CreateAccountResponse

    /**
     * Creates an Amazon Chime SDK messaging `AppInstance` under an AWS account. Only SDK messaging customers use this API. `CreateAppInstance` supports idempotency behavior as described in the AWS API Standard.
     */
    public suspend fun createAppInstance(input: CreateAppInstanceRequest): CreateAppInstanceResponse

    /**
     * Promotes an `AppInstanceUser` to an `AppInstanceAdmin`. The promoted user can perform the following actions.
     * + `ChannelModerator` actions across all channels in the `AppInstance`.
     * + `DeleteChannelMessage` actions.
     *
     * Only an `AppInstanceUser` can be promoted to an `AppInstanceAdmin` role.
     */
    public suspend fun createAppInstanceAdmin(input: CreateAppInstanceAdminRequest): CreateAppInstanceAdminResponse

    /**
     * Creates a user under an Amazon Chime `AppInstance`. The request consists of a unique `appInstanceUserId` and `Name` for that user.
     */
    public suspend fun createAppInstanceUser(input: CreateAppInstanceUserRequest): CreateAppInstanceUserResponse

    /**
     * Creates a new attendee for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide*.
     */
    public suspend fun createAttendee(input: CreateAttendeeRequest): CreateAttendeeResponse

    /**
     * Creates a bot for an Amazon Chime Enterprise account.
     */
    public suspend fun createBot(input: CreateBotRequest): CreateBotResponse

    /**
     * Creates a channel to which you can add users and send messages.
     *
     * **Restriction**: You can't change a channel's privacy.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun createChannel(input: CreateChannelRequest): CreateChannelResponse

    /**
     * Permanently bans a member from a channel. Moderators can't add banned members to a channel. To undo a ban, you first have to `DeleteChannelBan`, and then `CreateChannelMembership`. Bans are cleaned up when you delete users or channels.
     *
     * If you ban a user who is already part of a channel, that user is automatically kicked from the channel.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun createChannelBan(input: CreateChannelBanRequest): CreateChannelBanResponse

    /**
     * Adds a user to a channel. The `InvitedBy` response field is derived from the request header. A channel member can:
     * + List messages
     * + Send messages
     * + Receive messages
     * + Edit their own messages
     * + Leave the channel
     *
     * Privacy settings impact this action as follows:
     * + Public Channels: You do not need to be a member to list messages, but you must be a member to send messages.
     * + Private Channels: You must be a member to list or send messages.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun createChannelMembership(input: CreateChannelMembershipRequest): CreateChannelMembershipResponse

    /**
     * Creates a new `ChannelModerator`. A channel moderator can:
     * + Add and remove other members of the channel.
     * + Add and remove other moderators of the channel.
     * + Add and remove user bans for the channel.
     * + Redact messages in the channel.
     * + List messages in the channel.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun createChannelModerator(input: CreateChannelModeratorRequest): CreateChannelModeratorResponse

    /**
     * Creates a media capture pipeline.
     */
    public suspend fun createMediaCapturePipeline(input: CreateMediaCapturePipelineRequest): CreateMediaCapturePipelineResponse

    /**
     * Creates a new Amazon Chime SDK meeting in the specified media Region with no initial attendees. For more information about specifying media Regions, see [Amazon Chime SDK Media Regions](https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html) in the *Amazon Chime Developer Guide* . For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide* .
     */
    public suspend fun createMeeting(input: CreateMeetingRequest): CreateMeetingResponse

    /**
     * Uses the join token and call metadata in a meeting request (From number, To number, and so forth) to initiate an outbound call to a public switched telephone network (PSTN) and join them into a Chime meeting. Also ensures that the From number belongs to the customer.
     *
     * To play welcome audio or implement an interactive voice response (IVR), use the `CreateSipMediaApplicationCall` action with the corresponding SIP media application ID.
     */
    public suspend fun createMeetingDialOut(input: CreateMeetingDialOutRequest): CreateMeetingDialOutResponse

    /**
     * Creates a new Amazon Chime SDK meeting in the specified media Region, with attendees. For more information about specifying media Regions, see [Amazon Chime SDK Media Regions](https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html) in the *Amazon Chime Developer Guide* . For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide* .
     */
    public suspend fun createMeetingWithAttendees(input: CreateMeetingWithAttendeesRequest): CreateMeetingWithAttendeesResponse

    /**
     * Creates an order for phone numbers to be provisioned. For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.
     */
    public suspend fun createPhoneNumberOrder(input: CreatePhoneNumberOrderRequest): CreatePhoneNumberOrderResponse

    /**
     * Creates a proxy session on the specified Amazon Chime Voice Connector for the specified participant phone numbers.
     */
    public suspend fun createProxySession(input: CreateProxySessionRequest): CreateProxySessionResponse

    /**
     * Creates a chat room for the specified Amazon Chime Enterprise account.
     */
    public suspend fun createRoom(input: CreateRoomRequest): CreateRoomResponse

    /**
     * Adds a member to a chat room in an Amazon Chime Enterprise account. A member can be either a user or a bot. The member role designates whether the member is a chat room administrator or a general chat room member.
     */
    public suspend fun createRoomMembership(input: CreateRoomMembershipRequest): CreateRoomMembershipResponse

    /**
     * Creates a SIP media application.
     */
    public suspend fun createSipMediaApplication(input: CreateSipMediaApplicationRequest): CreateSipMediaApplicationResponse

    /**
     * Creates an outbound call to a phone number from the phone number specified in the request, and it invokes the endpoint of the specified `sipMediaApplicationId`.
     */
    public suspend fun createSipMediaApplicationCall(input: CreateSipMediaApplicationCallRequest): CreateSipMediaApplicationCallResponse

    /**
     * Creates a SIP rule which can be used to run a SIP media application as a target for a specific trigger type.
     */
    public suspend fun createSipRule(input: CreateSipRuleRequest): CreateSipRuleResponse

    /**
     * Creates a user under the specified Amazon Chime account.
     */
    public suspend fun createUser(input: CreateUserRequest): CreateUserResponse

    /**
     * Creates an Amazon Chime Voice Connector under the administrator's AWS account. You can choose to create an Amazon Chime Voice Connector in a specific AWS Region.
     *
     *  Enabling CreateVoiceConnectorRequest$RequireEncryption configures your Amazon Chime Voice Connector to use TLS transport for SIP signaling and Secure RTP (SRTP) for media. Inbound calls use TLS transport, and unencrypted outbound calls are blocked.
     */
    public suspend fun createVoiceConnector(input: CreateVoiceConnectorRequest): CreateVoiceConnectorResponse

    /**
     * Creates an Amazon Chime Voice Connector group under the administrator's AWS account. You can associate Amazon Chime Voice Connectors with the Amazon Chime Voice Connector group by including `VoiceConnectorItems` in the request.
     *
     * You can include Amazon Chime Voice Connectors from different AWS Regions in your group. This creates a fault tolerant mechanism for fallback in case of availability events.
     */
    public suspend fun createVoiceConnectorGroup(input: CreateVoiceConnectorGroupRequest): CreateVoiceConnectorGroupResponse

    /**
     * Deletes the specified Amazon Chime account. You must suspend all users before deleting `Team` account. You can use the BatchSuspendUser action to dodo.
     *
     * For `EnterpriseLWA` and `EnterpriseAD` accounts, you must release the claimed domains for your Amazon Chime account before deletion. As soon as you release the domain, all users under that account are suspended.
     *
     * Deleted accounts appear in your `Disabled` accounts list for 90 days. To restore deleted account from your `Disabled` accounts list, you must contact AWS Support.
     *
     * After 90 days, deleted accounts are permanently removed from your `Disabled` accounts list.
     */
    public suspend fun deleteAccount(input: DeleteAccountRequest): DeleteAccountResponse

    /**
     * Deletes an `AppInstance` and all associated data asynchronously.
     */
    public suspend fun deleteAppInstance(input: DeleteAppInstanceRequest): DeleteAppInstanceResponse

    /**
     * Demotes an `AppInstanceAdmin` to an `AppInstanceUser`. This action does not delete the user.
     */
    public suspend fun deleteAppInstanceAdmin(input: DeleteAppInstanceAdminRequest): DeleteAppInstanceAdminResponse

    /**
     * Deletes the streaming configurations of an `AppInstance`.
     */
    public suspend fun deleteAppInstanceStreamingConfigurations(input: DeleteAppInstanceStreamingConfigurationsRequest): DeleteAppInstanceStreamingConfigurationsResponse

    /**
     * Deletes an `AppInstanceUser`.
     */
    public suspend fun deleteAppInstanceUser(input: DeleteAppInstanceUserRequest): DeleteAppInstanceUserResponse

    /**
     * Deletes an attendee from the specified Amazon Chime SDK meeting and deletes their `JoinToken`. Attendees are automatically deleted when a Amazon Chime SDK meeting is deleted. For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide*.
     */
    public suspend fun deleteAttendee(input: DeleteAttendeeRequest): DeleteAttendeeResponse

    /**
     * Immediately makes a channel and its memberships inaccessible and marks them for deletion. This is an irreversible process.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun deleteChannel(input: DeleteChannelRequest): DeleteChannelResponse

    /**
     * Removes a user from a channel's ban list.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun deleteChannelBan(input: DeleteChannelBanRequest): DeleteChannelBanResponse

    /**
     * Removes a member from a channel.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun deleteChannelMembership(input: DeleteChannelMembershipRequest): DeleteChannelMembershipResponse

    /**
     * Deletes a channel message. Only admins can perform this action. Deletion makes messages inaccessible immediately. A background process deletes any revisions created by `UpdateChannelMessage`.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun deleteChannelMessage(input: DeleteChannelMessageRequest): DeleteChannelMessageResponse

    /**
     * Deletes a channel moderator.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun deleteChannelModerator(input: DeleteChannelModeratorRequest): DeleteChannelModeratorResponse

    /**
     * Deletes the events configuration that allows a bot to receive outgoing events.
     */
    public suspend fun deleteEventsConfiguration(input: DeleteEventsConfigurationRequest): DeleteEventsConfigurationResponse

    /**
     * Deletes the media capture pipeline.
     */
    public suspend fun deleteMediaCapturePipeline(input: DeleteMediaCapturePipelineRequest): DeleteMediaCapturePipelineResponse

    /**
     * Deletes the specified Amazon Chime SDK meeting. The operation deletes all attendees, disconnects all clients, and prevents new clients from joining the meeting. For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide*.
     */
    public suspend fun deleteMeeting(input: DeleteMeetingRequest): DeleteMeetingResponse

    /**
     * Moves the specified phone number into the **Deletion queue**. A phone number must be disassociated from any users or Amazon Chime Voice Connectors before it can be deleted.
     *
     * Deleted phone numbers remain in the **Deletion queue** for 7 days before they are deleted permanently.
     */
    public suspend fun deletePhoneNumber(input: DeletePhoneNumberRequest): DeletePhoneNumberResponse

    /**
     * Deletes the specified proxy session from the specified Amazon Chime Voice Connector.
     */
    public suspend fun deleteProxySession(input: DeleteProxySessionRequest): DeleteProxySessionResponse

    /**
     * Deletes a chat room in an Amazon Chime Enterprise account.
     */
    public suspend fun deleteRoom(input: DeleteRoomRequest): DeleteRoomResponse

    /**
     * Removes a member from a chat room in an Amazon Chime Enterprise account.
     */
    public suspend fun deleteRoomMembership(input: DeleteRoomMembershipRequest): DeleteRoomMembershipResponse

    /**
     * Deletes a SIP media application.
     */
    public suspend fun deleteSipMediaApplication(input: DeleteSipMediaApplicationRequest): DeleteSipMediaApplicationResponse

    /**
     * Deletes a SIP rule. You must disable a SIP rule before you can delete it.
     */
    public suspend fun deleteSipRule(input: DeleteSipRuleRequest): DeleteSipRuleResponse

    /**
     * Deletes the specified Amazon Chime Voice Connector. Any phone numbers associated with the Amazon Chime Voice Connector must be disassociated from it before it can be deleted.
     */
    public suspend fun deleteVoiceConnector(input: DeleteVoiceConnectorRequest): DeleteVoiceConnectorResponse

    /**
     * Deletes the emergency calling configuration details from the specified Amazon Chime Voice Connector.
     */
    public suspend fun deleteVoiceConnectorEmergencyCallingConfiguration(input: DeleteVoiceConnectorEmergencyCallingConfigurationRequest): DeleteVoiceConnectorEmergencyCallingConfigurationResponse

    /**
     * Deletes the specified Amazon Chime Voice Connector group. Any `VoiceConnectorItems` and phone numbers associated with the group must be removed before it can be deleted.
     */
    public suspend fun deleteVoiceConnectorGroup(input: DeleteVoiceConnectorGroupRequest): DeleteVoiceConnectorGroupResponse

    /**
     * Deletes the origination settings for the specified Amazon Chime Voice Connector.
     *
     * If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to deleting the origination settings.
     */
    public suspend fun deleteVoiceConnectorOrigination(input: DeleteVoiceConnectorOriginationRequest): DeleteVoiceConnectorOriginationResponse

    /**
     * Deletes the proxy configuration from the specified Amazon Chime Voice Connector.
     */
    public suspend fun deleteVoiceConnectorProxy(input: DeleteVoiceConnectorProxyRequest): DeleteVoiceConnectorProxyResponse

    /**
     * Deletes the streaming configuration for the specified Amazon Chime Voice Connector.
     */
    public suspend fun deleteVoiceConnectorStreamingConfiguration(input: DeleteVoiceConnectorStreamingConfigurationRequest): DeleteVoiceConnectorStreamingConfigurationResponse

    /**
     * Deletes the termination settings for the specified Amazon Chime Voice Connector.
     *
     * If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to deleting the termination settings.
     */
    public suspend fun deleteVoiceConnectorTermination(input: DeleteVoiceConnectorTerminationRequest): DeleteVoiceConnectorTerminationResponse

    /**
     * Deletes the specified SIP credentials used by your equipment to authenticate during call termination.
     */
    public suspend fun deleteVoiceConnectorTerminationCredentials(input: DeleteVoiceConnectorTerminationCredentialsRequest): DeleteVoiceConnectorTerminationCredentialsResponse

    /**
     * Returns the full details of an `AppInstance`.
     */
    public suspend fun describeAppInstance(input: DescribeAppInstanceRequest): DescribeAppInstanceResponse

    /**
     * Returns the full details of an `AppInstanceAdmin`.
     */
    public suspend fun describeAppInstanceAdmin(input: DescribeAppInstanceAdminRequest): DescribeAppInstanceAdminResponse

    /**
     * Returns the full details of an `AppInstanceUser`.
     */
    public suspend fun describeAppInstanceUser(input: DescribeAppInstanceUserRequest): DescribeAppInstanceUserResponse

    /**
     * Returns the full details of a channel in an Amazon Chime `AppInstance`.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun describeChannel(input: DescribeChannelRequest): DescribeChannelResponse

    /**
     * Returns the full details of a channel ban.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun describeChannelBan(input: DescribeChannelBanRequest): DescribeChannelBanResponse

    /**
     * Returns the full details of a user's channel membership.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun describeChannelMembership(input: DescribeChannelMembershipRequest): DescribeChannelMembershipResponse

    /**
     * Returns the details of a channel based on the membership of the specified `AppInstanceUser`.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun describeChannelMembershipForAppInstanceUser(input: DescribeChannelMembershipForAppInstanceUserRequest): DescribeChannelMembershipForAppInstanceUserResponse

    /**
     * Returns the full details of a channel moderated by the specified `AppInstanceUser`.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun describeChannelModeratedByAppInstanceUser(input: DescribeChannelModeratedByAppInstanceUserRequest): DescribeChannelModeratedByAppInstanceUserResponse

    /**
     * Returns the full details of a single ChannelModerator.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun describeChannelModerator(input: DescribeChannelModeratorRequest): DescribeChannelModeratorResponse

    /**
     * Disassociates the primary provisioned phone number from the specified Amazon Chime user.
     */
    public suspend fun disassociatePhoneNumberFromUser(input: DisassociatePhoneNumberFromUserRequest): DisassociatePhoneNumberFromUserResponse

    /**
     * Disassociates the specified phone numbers from the specified Amazon Chime Voice Connector.
     */
    public suspend fun disassociatePhoneNumbersFromVoiceConnector(input: DisassociatePhoneNumbersFromVoiceConnectorRequest): DisassociatePhoneNumbersFromVoiceConnectorResponse

    /**
     * Disassociates the specified phone numbers from the specified Amazon Chime Voice Connector group.
     */
    public suspend fun disassociatePhoneNumbersFromVoiceConnectorGroup(input: DisassociatePhoneNumbersFromVoiceConnectorGroupRequest): DisassociatePhoneNumbersFromVoiceConnectorGroupResponse

    /**
     * Disassociates the specified sign-in delegate groups from the specified Amazon Chime account.
     */
    public suspend fun disassociateSigninDelegateGroupsFromAccount(input: DisassociateSigninDelegateGroupsFromAccountRequest): DisassociateSigninDelegateGroupsFromAccountResponse

    /**
     * Retrieves details for the specified Amazon Chime account, such as account type and supported licenses.
     */
    public suspend fun getAccount(input: GetAccountRequest): GetAccountResponse

    /**
     * Retrieves account settings for the specified Amazon Chime account ID, such as remote control and dialout settings. For more information about these settings, see [Use the Policies Page](https://docs.aws.amazon.com/chime/latest/ag/policies.html) in the *Amazon Chime Administration Guide*.
     */
    public suspend fun getAccountSettings(input: GetAccountSettingsRequest): GetAccountSettingsResponse

    /**
     * Gets the retention settings for an `AppInstance`.
     */
    public suspend fun getAppInstanceRetentionSettings(input: GetAppInstanceRetentionSettingsRequest): GetAppInstanceRetentionSettingsResponse

    /**
     * Gets the streaming settings for an `AppInstance`.
     */
    public suspend fun getAppInstanceStreamingConfigurations(input: GetAppInstanceStreamingConfigurationsRequest): GetAppInstanceStreamingConfigurationsResponse

    /**
     * Gets the Amazon Chime SDK attendee details for a specified meeting ID and attendee ID. For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide* .
     */
    public suspend fun getAttendee(input: GetAttendeeRequest): GetAttendeeResponse

    /**
     * Retrieves details for the specified bot, such as bot email address, bot type, status, and display name.
     */
    public suspend fun getBot(input: GetBotRequest): GetBotResponse

    /**
     * Gets the full details of a channel message.
     *
     * The x-amz-chime-bearer request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun getChannelMessage(input: GetChannelMessageRequest): GetChannelMessageResponse

    /**
     * Gets details for an events configuration that allows a bot to receive outgoing events, such as an HTTPS endpoint or Lambda function ARN.
     */
    public suspend fun getEventsConfiguration(input: GetEventsConfigurationRequest): GetEventsConfigurationResponse

    /**
     * Retrieves global settings for the administrator's AWS account, such as Amazon Chime Business Calling and Amazon Chime Voice Connector settings.
     */
    public suspend fun getGlobalSettings(input: GetGlobalSettingsRequest = GetGlobalSettingsRequest {}): GetGlobalSettingsResponse

    /**
     * Gets an existing media capture pipeline.
     */
    public suspend fun getMediaCapturePipeline(input: GetMediaCapturePipelineRequest): GetMediaCapturePipelineResponse

    /**
     * Gets the Amazon Chime SDK meeting details for the specified meeting ID. For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide* .
     */
    public suspend fun getMeeting(input: GetMeetingRequest): GetMeetingResponse

    /**
     * The details of the endpoint for the messaging session.
     */
    public suspend fun getMessagingSessionEndpoint(input: GetMessagingSessionEndpointRequest = GetMessagingSessionEndpointRequest {}): GetMessagingSessionEndpointResponse

    /**
     * Retrieves details for the specified phone number ID, such as associations, capabilities, and product type.
     */
    public suspend fun getPhoneNumber(input: GetPhoneNumberRequest): GetPhoneNumberResponse

    /**
     * Retrieves details for the specified phone number order, such as the order creation timestamp, phone numbers in E.164 format, product type, and order status.
     */
    public suspend fun getPhoneNumberOrder(input: GetPhoneNumberOrderRequest): GetPhoneNumberOrderResponse

    /**
     * Retrieves the phone number settings for the administrator's AWS account, such as the default outbound calling name.
     */
    public suspend fun getPhoneNumberSettings(input: GetPhoneNumberSettingsRequest = GetPhoneNumberSettingsRequest {}): GetPhoneNumberSettingsResponse

    /**
     * Gets the specified proxy session details for the specified Amazon Chime Voice Connector.
     */
    public suspend fun getProxySession(input: GetProxySessionRequest): GetProxySessionResponse

    /**
     * Gets the retention settings for the specified Amazon Chime Enterprise account. For more information about retention settings, see [Managing Chat Retention Policies](https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html) in the *Amazon Chime Administration Guide*.
     */
    public suspend fun getRetentionSettings(input: GetRetentionSettingsRequest): GetRetentionSettingsResponse

    /**
     * Retrieves room details, such as the room name, for a room in an Amazon Chime Enterprise account.
     */
    public suspend fun getRoom(input: GetRoomRequest): GetRoomResponse

    /**
     * Retrieves the information for a SIP media application, including name, AWS Region, and endpoints.
     */
    public suspend fun getSipMediaApplication(input: GetSipMediaApplicationRequest): GetSipMediaApplicationResponse

    /**
     * Returns the logging configuration for the specified SIP media application.
     */
    public suspend fun getSipMediaApplicationLoggingConfiguration(input: GetSipMediaApplicationLoggingConfigurationRequest): GetSipMediaApplicationLoggingConfigurationResponse

    /**
     * Retrieves the details of a SIP rule, such as the rule ID, name, triggers, and target endpoints.
     */
    public suspend fun getSipRule(input: GetSipRuleRequest): GetSipRuleResponse

    /**
     * Retrieves details for the specified user ID, such as primary email address, license type,and personal meeting PIN.
     *
     *  To retrieve user details with an email address instead of a user ID, use the ListUsers action, and then filter by email address.
     */
    public suspend fun getUser(input: GetUserRequest): GetUserResponse

    /**
     * Retrieves settings for the specified user ID, such as any associated phone number settings.
     */
    public suspend fun getUserSettings(input: GetUserSettingsRequest): GetUserSettingsResponse

    /**
     * Retrieves details for the specified Amazon Chime Voice Connector, such as timestamps,name, outbound host, and encryption requirements.
     */
    public suspend fun getVoiceConnector(input: GetVoiceConnectorRequest): GetVoiceConnectorResponse

    /**
     * Gets the emergency calling configuration details for the specified Amazon Chime Voice Connector.
     */
    public suspend fun getVoiceConnectorEmergencyCallingConfiguration(input: GetVoiceConnectorEmergencyCallingConfigurationRequest): GetVoiceConnectorEmergencyCallingConfigurationResponse

    /**
     * Retrieves details for the specified Amazon Chime Voice Connector group, such as timestamps,name, and associated `VoiceConnectorItems`.
     */
    public suspend fun getVoiceConnectorGroup(input: GetVoiceConnectorGroupRequest): GetVoiceConnectorGroupResponse

    /**
     * Retrieves the logging configuration details for the specified Amazon Chime Voice Connector. Shows whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.
     */
    public suspend fun getVoiceConnectorLoggingConfiguration(input: GetVoiceConnectorLoggingConfigurationRequest): GetVoiceConnectorLoggingConfigurationResponse

    /**
     * Retrieves origination setting details for the specified Amazon Chime Voice Connector.
     */
    public suspend fun getVoiceConnectorOrigination(input: GetVoiceConnectorOriginationRequest): GetVoiceConnectorOriginationResponse

    /**
     * Gets the proxy configuration details for the specified Amazon Chime Voice Connector.
     */
    public suspend fun getVoiceConnectorProxy(input: GetVoiceConnectorProxyRequest): GetVoiceConnectorProxyResponse

    /**
     * Retrieves the streaming configuration details for the specified Amazon Chime Voice Connector. Shows whether media streaming is enabled for sending to Amazon Kinesis. It also shows the retention period, in hours, for the Amazon Kinesis data.
     */
    public suspend fun getVoiceConnectorStreamingConfiguration(input: GetVoiceConnectorStreamingConfigurationRequest): GetVoiceConnectorStreamingConfigurationResponse

    /**
     * Retrieves termination setting details for the specified Amazon Chime Voice Connector.
     */
    public suspend fun getVoiceConnectorTermination(input: GetVoiceConnectorTerminationRequest): GetVoiceConnectorTerminationResponse

    /**
     * Retrieves information about the last time a SIP `OPTIONS` ping was received from your SIP infrastructure for the specified Amazon Chime Voice Connector.
     */
    public suspend fun getVoiceConnectorTerminationHealth(input: GetVoiceConnectorTerminationHealthRequest): GetVoiceConnectorTerminationHealthResponse

    /**
     * Sends email to a maximum of 50 users, inviting them to the specified Amazon Chime `Team` account. Only `Team` account types are currently supported for this action.
     */
    public suspend fun inviteUsers(input: InviteUsersRequest): InviteUsersResponse

    /**
     * Lists the Amazon Chime accounts under the administrator's AWS account. You can filter accounts by account name prefix. To find out which Amazon Chime account a user belongs to, you can filter by the user's email address, which returns one account result.
     */
    public suspend fun listAccounts(input: ListAccountsRequest = ListAccountsRequest {}): ListAccountsResponse

    /**
     * Returns a list of the administrators in the `AppInstance`.
     */
    public suspend fun listAppInstanceAdmins(input: ListAppInstanceAdminsRequest): ListAppInstanceAdminsResponse

    /**
     * List all `AppInstanceUsers` created under a single `AppInstance`.
     */
    public suspend fun listAppInstanceUsers(input: ListAppInstanceUsersRequest): ListAppInstanceUsersResponse

    /**
     * Lists all Amazon Chime `AppInstance`s created under a single AWS account.
     */
    public suspend fun listAppInstances(input: ListAppInstancesRequest = ListAppInstancesRequest {}): ListAppInstancesResponse

    /**
     * Lists the tags applied to an Amazon Chime SDK attendee resource.
     */
    public suspend fun listAttendeeTags(input: ListAttendeeTagsRequest): ListAttendeeTagsResponse

    /**
     * Lists the attendees for the specified Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide*.
     */
    public suspend fun listAttendees(input: ListAttendeesRequest): ListAttendeesResponse

    /**
     * Lists the bots associated with the administrator's Amazon Chime Enterprise account ID.
     */
    public suspend fun listBots(input: ListBotsRequest): ListBotsResponse

    /**
     * Lists all the users banned from a particular channel.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun listChannelBans(input: ListChannelBansRequest): ListChannelBansResponse

    /**
     * Lists all channel memberships in a channel.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun listChannelMemberships(input: ListChannelMembershipsRequest): ListChannelMembershipsResponse

    /**
     * Lists all channels that a particular `AppInstanceUser` is a part of. Only an `AppInstanceAdmin` can call the API with a user ARN that is not their own.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun listChannelMembershipsForAppInstanceUser(input: ListChannelMembershipsForAppInstanceUserRequest = ListChannelMembershipsForAppInstanceUserRequest {}): ListChannelMembershipsForAppInstanceUserResponse

    /**
     * List all the messages in a channel. Returns a paginated list of `ChannelMessages`. By default, sorted by creation timestamp in descending order.
     *
     * Redacted messages appear in the results as empty, since they are only redacted, not deleted. Deleted messages do not appear in the results. This action always returns the latest version of an edited message.
     *
     * Also, the x-amz-chime-bearer request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun listChannelMessages(input: ListChannelMessagesRequest): ListChannelMessagesResponse

    /**
     * Lists all the moderators for a channel.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun listChannelModerators(input: ListChannelModeratorsRequest): ListChannelModeratorsResponse

    /**
     * Lists all Channels created under a single Chime App as a paginated list. You can specify filters to narrow results.
     *
     * **Functionality & restrictions**
     * + Use privacy = `PUBLIC` to retrieve all public channels in the account.
     * + Only an `AppInstanceAdmin` can set privacy = `PRIVATE` to list the private channels in an account.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun listChannels(input: ListChannelsRequest): ListChannelsResponse

    /**
     * A list of the channels moderated by an `AppInstanceUser`.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun listChannelsModeratedByAppInstanceUser(input: ListChannelsModeratedByAppInstanceUserRequest = ListChannelsModeratedByAppInstanceUserRequest {}): ListChannelsModeratedByAppInstanceUserResponse

    /**
     * Returns a list of media capture pipelines.
     */
    public suspend fun listMediaCapturePipelines(input: ListMediaCapturePipelinesRequest = ListMediaCapturePipelinesRequest {}): ListMediaCapturePipelinesResponse

    /**
     * Lists the tags applied to an Amazon Chime SDK meeting resource.
     */
    public suspend fun listMeetingTags(input: ListMeetingTagsRequest): ListMeetingTagsResponse

    /**
     * Lists up to 100 active Amazon Chime SDK meetings. For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide*.
     */
    public suspend fun listMeetings(input: ListMeetingsRequest = ListMeetingsRequest {}): ListMeetingsResponse

    /**
     * Lists the phone number orders for the administrator's Amazon Chime account.
     */
    public suspend fun listPhoneNumberOrders(input: ListPhoneNumberOrdersRequest = ListPhoneNumberOrdersRequest {}): ListPhoneNumberOrdersResponse

    /**
     * Lists the phone numbers for the specified Amazon Chime account, Amazon Chime user, Amazon Chime Voice Connector, or Amazon Chime Voice Connector group.
     */
    public suspend fun listPhoneNumbers(input: ListPhoneNumbersRequest = ListPhoneNumbersRequest {}): ListPhoneNumbersResponse

    /**
     * Lists the proxy sessions for the specified Amazon Chime Voice Connector.
     */
    public suspend fun listProxySessions(input: ListProxySessionsRequest): ListProxySessionsResponse

    /**
     * Lists the membership details for the specified room in an Amazon Chime Enterprise account, such as the members' IDs, email addresses, and names.
     */
    public suspend fun listRoomMemberships(input: ListRoomMembershipsRequest): ListRoomMembershipsResponse

    /**
     * Lists the room details for the specified Amazon Chime Enterprise account. Optionally, filter the results by a member ID (user ID or bot ID) to see a list of rooms that the member belongs to.
     */
    public suspend fun listRooms(input: ListRoomsRequest): ListRoomsResponse

    /**
     * Lists the SIP media applications under the administrator's AWS account.
     */
    public suspend fun listSipMediaApplications(input: ListSipMediaApplicationsRequest = ListSipMediaApplicationsRequest {}): ListSipMediaApplicationsResponse

    /**
     * Lists the SIP rules under the administrator's AWS account.
     */
    public suspend fun listSipRules(input: ListSipRulesRequest = ListSipRulesRequest {}): ListSipRulesResponse

    /**
     * Lists supported phone number countries.
     */
    public suspend fun listSupportedPhoneNumberCountries(input: ListSupportedPhoneNumberCountriesRequest): ListSupportedPhoneNumberCountriesResponse

    /**
     * Lists the tags applied to an Amazon Chime SDK meeting resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the users that belong to the specified Amazon Chime account. You can specify an email address to list only the user that the email address belongs to.
     */
    public suspend fun listUsers(input: ListUsersRequest): ListUsersResponse

    /**
     * Lists the Amazon Chime Voice Connector groups for the administrator's AWS account.
     */
    public suspend fun listVoiceConnectorGroups(input: ListVoiceConnectorGroupsRequest = ListVoiceConnectorGroupsRequest {}): ListVoiceConnectorGroupsResponse

    /**
     * Lists the SIP credentials for the specified Amazon Chime Voice Connector.
     */
    public suspend fun listVoiceConnectorTerminationCredentials(input: ListVoiceConnectorTerminationCredentialsRequest): ListVoiceConnectorTerminationCredentialsResponse

    /**
     * Lists the Amazon Chime Voice Connectors for the administrator's AWS account.
     */
    public suspend fun listVoiceConnectors(input: ListVoiceConnectorsRequest = ListVoiceConnectorsRequest {}): ListVoiceConnectorsResponse

    /**
     * Logs out the specified user from all of the devices they are currently logged into.
     */
    public suspend fun logoutUser(input: LogoutUserRequest): LogoutUserResponse

    /**
     * Sets the amount of time in days that a given `AppInstance` retains data.
     */
    public suspend fun putAppInstanceRetentionSettings(input: PutAppInstanceRetentionSettingsRequest): PutAppInstanceRetentionSettingsResponse

    /**
     * The data streaming configurations of an `AppInstance`.
     */
    public suspend fun putAppInstanceStreamingConfigurations(input: PutAppInstanceStreamingConfigurationsRequest): PutAppInstanceStreamingConfigurationsResponse

    /**
     * Creates an events configuration that allows a bot to receive outgoing events sent by Amazon Chime. Choose either an HTTPS endpoint or a Lambda function ARN. For more information, see Bot.
     */
    public suspend fun putEventsConfiguration(input: PutEventsConfigurationRequest): PutEventsConfigurationResponse

    /**
     * Puts retention settings for the specified Amazon Chime Enterprise account. We recommend using AWS CloudTrail to monitor usage of this API for your account. For more information, see [Logging Amazon Chime API Calls with AWS CloudTrail](https://docs.aws.amazon.com/chime/latest/ag/cloudtrail.html) in the *Amazon Chime Administration Guide*.
     *
     *  To turn off existing retention settings, remove the number of days from the corresponding **RetentionDays** field in the **RetentionSettings** object. For more information about retention settings, see [Managing Chat Retention Policies](https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html) in the *Amazon Chime Administration Guide*.
     */
    public suspend fun putRetentionSettings(input: PutRetentionSettingsRequest): PutRetentionSettingsResponse

    /**
     * Updates the logging configuration for the specified SIP media application.
     */
    public suspend fun putSipMediaApplicationLoggingConfiguration(input: PutSipMediaApplicationLoggingConfigurationRequest): PutSipMediaApplicationLoggingConfigurationResponse

    /**
     * Puts emergency calling configuration details to the specified Amazon Chime Voice Connector, such as emergency phone numbers and calling countries. Origination and termination settings must be enabled for the Amazon Chime Voice Connector before emergency calling can be configured.
     */
    public suspend fun putVoiceConnectorEmergencyCallingConfiguration(input: PutVoiceConnectorEmergencyCallingConfigurationRequest): PutVoiceConnectorEmergencyCallingConfigurationResponse

    /**
     * Adds a logging configuration for the specified Amazon Chime Voice Connector. The logging configuration specifies whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.
     */
    public suspend fun putVoiceConnectorLoggingConfiguration(input: PutVoiceConnectorLoggingConfigurationRequest): PutVoiceConnectorLoggingConfigurationResponse

    /**
     * Adds origination settings for the specified Amazon Chime Voice Connector.
     *
     * If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to turning off origination settings.
     */
    public suspend fun putVoiceConnectorOrigination(input: PutVoiceConnectorOriginationRequest): PutVoiceConnectorOriginationResponse

    /**
     * Puts the specified proxy configuration to the specified Amazon Chime Voice Connector.
     */
    public suspend fun putVoiceConnectorProxy(input: PutVoiceConnectorProxyRequest): PutVoiceConnectorProxyResponse

    /**
     * Adds a streaming configuration for the specified Amazon Chime Voice Connector. The streaming configuration specifies whether media streaming is enabled for sending to Kinesis. It also sets the retention period, in hours, for the Amazon Kinesis data.
     */
    public suspend fun putVoiceConnectorStreamingConfiguration(input: PutVoiceConnectorStreamingConfigurationRequest): PutVoiceConnectorStreamingConfigurationResponse

    /**
     * Adds termination settings for the specified Amazon Chime Voice Connector.
     *
     * If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to turning off termination settings.
     */
    public suspend fun putVoiceConnectorTermination(input: PutVoiceConnectorTerminationRequest): PutVoiceConnectorTerminationResponse

    /**
     * Adds termination SIP credentials for the specified Amazon Chime Voice Connector.
     */
    public suspend fun putVoiceConnectorTerminationCredentials(input: PutVoiceConnectorTerminationCredentialsRequest): PutVoiceConnectorTerminationCredentialsResponse

    /**
     * Redacts message content, but not metadata. The message exists in the back end, but the action returns null content, and the state shows as redacted.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun redactChannelMessage(input: RedactChannelMessageRequest): RedactChannelMessageResponse

    /**
     * Redacts the specified message from the specified Amazon Chime conversation.
     */
    public suspend fun redactConversationMessage(input: RedactConversationMessageRequest): RedactConversationMessageResponse

    /**
     * Redacts the specified message from the specified Amazon Chime channel.
     */
    public suspend fun redactRoomMessage(input: RedactRoomMessageRequest): RedactRoomMessageResponse

    /**
     * Regenerates the security token for a bot.
     */
    public suspend fun regenerateSecurityToken(input: RegenerateSecurityTokenRequest): RegenerateSecurityTokenResponse

    /**
     * Resets the personal meeting PIN for the specified user on an Amazon Chime account. Returns the User object with the updated personal meeting PIN.
     */
    public suspend fun resetPersonalPin(input: ResetPersonalPinRequest): ResetPersonalPinResponse

    /**
     * Moves a phone number from the **Deletion queue** back into the phone number **Inventory**.
     */
    public suspend fun restorePhoneNumber(input: RestorePhoneNumberRequest): RestorePhoneNumberResponse

    /**
     * Searches for phone numbers that can be ordered. For US numbers, provide at least one of the following search filters: `AreaCode`, `City`, `State`, or `TollFreePrefix`. If you provide `City`, you must also provide `State`. Numbers outside the US only support the `PhoneNumberType` filter, which you must use.
     */
    public suspend fun searchAvailablePhoneNumbers(input: SearchAvailablePhoneNumbersRequest = SearchAvailablePhoneNumbersRequest {}): SearchAvailablePhoneNumbersResponse

    /**
     * Sends a message to a particular channel that the member is a part of.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     *
     * Also, `STANDARD` messages can contain 4KB of data and the 1KB of metadata. `CONTROL` messages can contain 30 bytes of data and no metadata.
     */
    public suspend fun sendChannelMessage(input: SendChannelMessageRequest): SendChannelMessageResponse

    /**
     * Starts transcription for the specified `meetingId`.
     */
    public suspend fun startMeetingTranscription(input: StartMeetingTranscriptionRequest): StartMeetingTranscriptionResponse

    /**
     * Stops transcription for the specified `meetingId`.
     */
    public suspend fun stopMeetingTranscription(input: StopMeetingTranscriptionRequest): StopMeetingTranscriptionResponse

    /**
     * Applies the specified tags to the specified Amazon Chime SDK attendee.
     */
    public suspend fun tagAttendee(input: TagAttendeeRequest): TagAttendeeResponse

    /**
     * Applies the specified tags to the specified Amazon Chime SDK meeting.
     */
    public suspend fun tagMeeting(input: TagMeetingRequest): TagMeetingResponse

    /**
     * Applies the specified tags to the specified Amazon Chime SDK meeting resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Untags the specified tags from the specified Amazon Chime SDK attendee.
     */
    public suspend fun untagAttendee(input: UntagAttendeeRequest): UntagAttendeeResponse

    /**
     * Untags the specified tags from the specified Amazon Chime SDK meeting.
     */
    public suspend fun untagMeeting(input: UntagMeetingRequest): UntagMeetingResponse

    /**
     * Untags the specified tags from the specified Amazon Chime SDK meeting resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates account details for the specified Amazon Chime account. Currently, only account name and default license updates are supported for this action.
     */
    public suspend fun updateAccount(input: UpdateAccountRequest): UpdateAccountResponse

    /**
     * Updates the settings for the specified Amazon Chime account. You can update settings for remote control of shared screens, or for the dial-out option. For more information about these settings, see [Use the Policies Page](https://docs.aws.amazon.com/chime/latest/ag/policies.html) in the *Amazon Chime Administration Guide*.
     */
    public suspend fun updateAccountSettings(input: UpdateAccountSettingsRequest): UpdateAccountSettingsResponse

    /**
     * Updates `AppInstance` metadata.
     */
    public suspend fun updateAppInstance(input: UpdateAppInstanceRequest): UpdateAppInstanceResponse

    /**
     * Updates the details of an `AppInstanceUser`. You can update names and metadata.
     */
    public suspend fun updateAppInstanceUser(input: UpdateAppInstanceUserRequest): UpdateAppInstanceUserResponse

    /**
     * Updates the status of the specified bot, such as starting or stopping the bot from running in your Amazon Chime Enterprise account.
     */
    public suspend fun updateBot(input: UpdateBotRequest): UpdateBotResponse

    /**
     * Update a channel's attributes.
     *
     * **Restriction**: You can't change a channel's privacy.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun updateChannel(input: UpdateChannelRequest): UpdateChannelResponse

    /**
     * Updates the content of a message.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun updateChannelMessage(input: UpdateChannelMessageRequest): UpdateChannelMessageResponse

    /**
     * The details of the time when a user last read messages in a channel.
     *
     * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
     */
    public suspend fun updateChannelReadMarker(input: UpdateChannelReadMarkerRequest): UpdateChannelReadMarkerResponse

    /**
     * Updates global settings for the administrator's AWS account, such as Amazon Chime Business Calling and Amazon Chime Voice Connector settings.
     */
    public suspend fun updateGlobalSettings(input: UpdateGlobalSettingsRequest = UpdateGlobalSettingsRequest {}): UpdateGlobalSettingsResponse

    /**
     * Updates phone number details, such as product type or calling name, for the specified phone number ID. You can update one phone number detail at a time. For example, you can update either the product type or the calling name in one action.
     *
     * For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.
     *
     * Updates to outbound calling names can take 72 hours to complete. Pending updates to outbound calling names must be complete before you can request another update.
     */
    public suspend fun updatePhoneNumber(input: UpdatePhoneNumberRequest): UpdatePhoneNumberResponse

    /**
     * Updates the phone number settings for the administrator's AWS account, such as the default outbound calling name. You can update the default outbound calling name once every seven days. Outbound calling names can take up to 72 hours to update.
     */
    public suspend fun updatePhoneNumberSettings(input: UpdatePhoneNumberSettingsRequest): UpdatePhoneNumberSettingsResponse

    /**
     * Updates the specified proxy session details, such as voice or SMS capabilities.
     */
    public suspend fun updateProxySession(input: UpdateProxySessionRequest): UpdateProxySessionResponse

    /**
     * Updates room details, such as the room name, for a room in an Amazon Chime Enterprise account.
     */
    public suspend fun updateRoom(input: UpdateRoomRequest): UpdateRoomResponse

    /**
     * Updates room membership details, such as the member role, for a room in an Amazon Chime Enterprise account. The member role designates whether the member is a chat room administrator or a general chat room member. The member role can be updated only for user IDs.
     */
    public suspend fun updateRoomMembership(input: UpdateRoomMembershipRequest): UpdateRoomMembershipResponse

    /**
     * Updates the details of the specified SIP media application.
     */
    public suspend fun updateSipMediaApplication(input: UpdateSipMediaApplicationRequest): UpdateSipMediaApplicationResponse

    /**
     * Invokes the AWS Lambda function associated with the SIP media application and transaction ID in an update request. The Lambda function can then return a new set of actions.
     */
    public suspend fun updateSipMediaApplicationCall(input: UpdateSipMediaApplicationCallRequest): UpdateSipMediaApplicationCallResponse

    /**
     * Updates the details of the specified SIP rule.
     */
    public suspend fun updateSipRule(input: UpdateSipRuleRequest): UpdateSipRuleResponse

    /**
     * Updates user details for a specified user ID. Currently, only `LicenseType` updates are supported for this action.
     */
    public suspend fun updateUser(input: UpdateUserRequest): UpdateUserResponse

    /**
     * Updates the settings for the specified user, such as phone number settings.
     */
    public suspend fun updateUserSettings(input: UpdateUserSettingsRequest): UpdateUserSettingsResponse

    /**
     * Updates details for the specified Amazon Chime Voice Connector.
     */
    public suspend fun updateVoiceConnector(input: UpdateVoiceConnectorRequest): UpdateVoiceConnectorResponse

    /**
     * Updates details of the specified Amazon Chime Voice Connector group, such as the name and Amazon Chime Voice Connector priority ranking.
     */
    public suspend fun updateVoiceConnectorGroup(input: UpdateVoiceConnectorGroupRequest): UpdateVoiceConnectorGroupResponse

    /**
     * Validates an address to be used for 911 calls made with Amazon Chime Voice Connectors. You can use validated addresses in a Presence Information Data Format Location Object file that you include in SIP requests. That helps ensure that addresses are routed to the appropriate Public Safety Answering Point.
     */
    public suspend fun validateE911Address(input: ValidateE911AddressRequest): ValidateE911AddressResponse
}

/**
 * Associates a phone number with the specified Amazon Chime user.
 */
public suspend inline fun ChimeClient.associatePhoneNumberWithUser(crossinline block: AssociatePhoneNumberWithUserRequest.Builder.() -> Unit): AssociatePhoneNumberWithUserResponse = associatePhoneNumberWithUser(AssociatePhoneNumberWithUserRequest.Builder().apply(block).build())

/**
 * Associates phone numbers with the specified Amazon Chime Voice Connector.
 */
public suspend inline fun ChimeClient.associatePhoneNumbersWithVoiceConnector(crossinline block: AssociatePhoneNumbersWithVoiceConnectorRequest.Builder.() -> Unit): AssociatePhoneNumbersWithVoiceConnectorResponse = associatePhoneNumbersWithVoiceConnector(AssociatePhoneNumbersWithVoiceConnectorRequest.Builder().apply(block).build())

/**
 * Associates phone numbers with the specified Amazon Chime Voice Connector group.
 */
public suspend inline fun ChimeClient.associatePhoneNumbersWithVoiceConnectorGroup(crossinline block: AssociatePhoneNumbersWithVoiceConnectorGroupRequest.Builder.() -> Unit): AssociatePhoneNumbersWithVoiceConnectorGroupResponse = associatePhoneNumbersWithVoiceConnectorGroup(AssociatePhoneNumbersWithVoiceConnectorGroupRequest.Builder().apply(block).build())

/**
 * Associates the specified sign-in delegate groups with the specified Amazon Chime account.
 */
public suspend inline fun ChimeClient.associateSigninDelegateGroupsWithAccount(crossinline block: AssociateSigninDelegateGroupsWithAccountRequest.Builder.() -> Unit): AssociateSigninDelegateGroupsWithAccountResponse = associateSigninDelegateGroupsWithAccount(AssociateSigninDelegateGroupsWithAccountRequest.Builder().apply(block).build())

/**
 * Creates up to 100 new attendees for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide*.
 */
public suspend inline fun ChimeClient.batchCreateAttendee(crossinline block: BatchCreateAttendeeRequest.Builder.() -> Unit): BatchCreateAttendeeResponse = batchCreateAttendee(BatchCreateAttendeeRequest.Builder().apply(block).build())

/**
 * Adds a specified number of users to a channel.
 */
public suspend inline fun ChimeClient.batchCreateChannelMembership(crossinline block: BatchCreateChannelMembershipRequest.Builder.() -> Unit): BatchCreateChannelMembershipResponse = batchCreateChannelMembership(BatchCreateChannelMembershipRequest.Builder().apply(block).build())

/**
 * Adds up to 50 members to a chat room in an Amazon Chime Enterprise account. Members can be users or bots. The member role designates whether the member is a chat room administrator or a general chat room member.
 */
public suspend inline fun ChimeClient.batchCreateRoomMembership(crossinline block: BatchCreateRoomMembershipRequest.Builder.() -> Unit): BatchCreateRoomMembershipResponse = batchCreateRoomMembership(BatchCreateRoomMembershipRequest.Builder().apply(block).build())

/**
 * Moves phone numbers into the **Deletion queue**. Phone numbers must be disassociated from any users or Amazon Chime Voice Connectors before they can be deleted.
 *
 *  Phone numbers remain in the **Deletion queue** for 7 days before they are deleted permanently.
 */
public suspend inline fun ChimeClient.batchDeletePhoneNumber(crossinline block: BatchDeletePhoneNumberRequest.Builder.() -> Unit): BatchDeletePhoneNumberResponse = batchDeletePhoneNumber(BatchDeletePhoneNumberRequest.Builder().apply(block).build())

/**
 * Suspends up to 50 users from a `Team` or `EnterpriseLWA` Amazon Chime account. For more information about different account types, see [Managing Your Amazon Chime Accounts](https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html) in the *Amazon Chime Administration Guide*.
 *
 * Users suspended from a `Team` account are disassociated from the account,but they can continue to use Amazon Chime as free users. To remove the suspension from suspended `Team` account users, invite them to the `Team` account again. You can use the InviteUsers action to do so.
 *
 * Users suspended from an `EnterpriseLWA` account are immediately signed out of Amazon Chime and can no longer sign in. To remove the suspension from suspended `EnterpriseLWA` account users, use the BatchUnsuspendUser action.
 *
 *  To sign out users without suspending them, use the LogoutUser action.
 */
public suspend inline fun ChimeClient.batchSuspendUser(crossinline block: BatchSuspendUserRequest.Builder.() -> Unit): BatchSuspendUserResponse = batchSuspendUser(BatchSuspendUserRequest.Builder().apply(block).build())

/**
 * Removes the suspension from up to 50 previously suspended users for the specified Amazon Chime `EnterpriseLWA` account. Only users on `EnterpriseLWA` accounts can be unsuspended using this action. For more information about different account types, see [ Managing Your Amazon Chime Accounts ](https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html) in the account types, in the *Amazon Chime Administration Guide*.
 *
 *  Previously suspended users who are unsuspended using this action are returned to `Registered` status. Users who are not previously suspended are ignored.
 */
public suspend inline fun ChimeClient.batchUnsuspendUser(crossinline block: BatchUnsuspendUserRequest.Builder.() -> Unit): BatchUnsuspendUserResponse = batchUnsuspendUser(BatchUnsuspendUserRequest.Builder().apply(block).build())

/**
 * Updates phone number product types or calling names. You can update one attribute at a time for each `UpdatePhoneNumberRequestItem`. For example, you can update the product type or the calling name.
 *
 * For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.
 *
 * Updates to outbound calling names can take up to 72 hours to complete. Pending updates to outbound calling names must be complete before you can request another update.
 */
public suspend inline fun ChimeClient.batchUpdatePhoneNumber(crossinline block: BatchUpdatePhoneNumberRequest.Builder.() -> Unit): BatchUpdatePhoneNumberResponse = batchUpdatePhoneNumber(BatchUpdatePhoneNumberRequest.Builder().apply(block).build())

/**
 * Updates user details within the UpdateUserRequestItem object for up to 20 users for the specified Amazon Chime account. Currently, only `LicenseType` updates are supported for this action.
 */
public suspend inline fun ChimeClient.batchUpdateUser(crossinline block: BatchUpdateUserRequest.Builder.() -> Unit): BatchUpdateUserResponse = batchUpdateUser(BatchUpdateUserRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Chime account under the administrator's AWS account. Only `Team` account types are currently supported for this action. For more information about different account types, see [Managing Your Amazon Chime Accounts](https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html) in the *Amazon Chime Administration Guide*.
 */
public suspend inline fun ChimeClient.createAccount(crossinline block: CreateAccountRequest.Builder.() -> Unit): CreateAccountResponse = createAccount(CreateAccountRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Chime SDK messaging `AppInstance` under an AWS account. Only SDK messaging customers use this API. `CreateAppInstance` supports idempotency behavior as described in the AWS API Standard.
 */
public suspend inline fun ChimeClient.createAppInstance(crossinline block: CreateAppInstanceRequest.Builder.() -> Unit): CreateAppInstanceResponse = createAppInstance(CreateAppInstanceRequest.Builder().apply(block).build())

/**
 * Promotes an `AppInstanceUser` to an `AppInstanceAdmin`. The promoted user can perform the following actions.
 * + `ChannelModerator` actions across all channels in the `AppInstance`.
 * + `DeleteChannelMessage` actions.
 *
 * Only an `AppInstanceUser` can be promoted to an `AppInstanceAdmin` role.
 */
public suspend inline fun ChimeClient.createAppInstanceAdmin(crossinline block: CreateAppInstanceAdminRequest.Builder.() -> Unit): CreateAppInstanceAdminResponse = createAppInstanceAdmin(CreateAppInstanceAdminRequest.Builder().apply(block).build())

/**
 * Creates a user under an Amazon Chime `AppInstance`. The request consists of a unique `appInstanceUserId` and `Name` for that user.
 */
public suspend inline fun ChimeClient.createAppInstanceUser(crossinline block: CreateAppInstanceUserRequest.Builder.() -> Unit): CreateAppInstanceUserResponse = createAppInstanceUser(CreateAppInstanceUserRequest.Builder().apply(block).build())

/**
 * Creates a new attendee for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide*.
 */
public suspend inline fun ChimeClient.createAttendee(crossinline block: CreateAttendeeRequest.Builder.() -> Unit): CreateAttendeeResponse = createAttendee(CreateAttendeeRequest.Builder().apply(block).build())

/**
 * Creates a bot for an Amazon Chime Enterprise account.
 */
public suspend inline fun ChimeClient.createBot(crossinline block: CreateBotRequest.Builder.() -> Unit): CreateBotResponse = createBot(CreateBotRequest.Builder().apply(block).build())

/**
 * Creates a channel to which you can add users and send messages.
 *
 * **Restriction**: You can't change a channel's privacy.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeClient.createChannel(crossinline block: CreateChannelRequest.Builder.() -> Unit): CreateChannelResponse = createChannel(CreateChannelRequest.Builder().apply(block).build())

/**
 * Permanently bans a member from a channel. Moderators can't add banned members to a channel. To undo a ban, you first have to `DeleteChannelBan`, and then `CreateChannelMembership`. Bans are cleaned up when you delete users or channels.
 *
 * If you ban a user who is already part of a channel, that user is automatically kicked from the channel.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeClient.createChannelBan(crossinline block: CreateChannelBanRequest.Builder.() -> Unit): CreateChannelBanResponse = createChannelBan(CreateChannelBanRequest.Builder().apply(block).build())

/**
 * Adds a user to a channel. The `InvitedBy` response field is derived from the request header. A channel member can:
 * + List messages
 * + Send messages
 * + Receive messages
 * + Edit their own messages
 * + Leave the channel
 *
 * Privacy settings impact this action as follows:
 * + Public Channels: You do not need to be a member to list messages, but you must be a member to send messages.
 * + Private Channels: You must be a member to list or send messages.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeClient.createChannelMembership(crossinline block: CreateChannelMembershipRequest.Builder.() -> Unit): CreateChannelMembershipResponse = createChannelMembership(CreateChannelMembershipRequest.Builder().apply(block).build())

/**
 * Creates a new `ChannelModerator`. A channel moderator can:
 * + Add and remove other members of the channel.
 * + Add and remove other moderators of the channel.
 * + Add and remove user bans for the channel.
 * + Redact messages in the channel.
 * + List messages in the channel.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeClient.createChannelModerator(crossinline block: CreateChannelModeratorRequest.Builder.() -> Unit): CreateChannelModeratorResponse = createChannelModerator(CreateChannelModeratorRequest.Builder().apply(block).build())

/**
 * Creates a media capture pipeline.
 */
public suspend inline fun ChimeClient.createMediaCapturePipeline(crossinline block: CreateMediaCapturePipelineRequest.Builder.() -> Unit): CreateMediaCapturePipelineResponse = createMediaCapturePipeline(CreateMediaCapturePipelineRequest.Builder().apply(block).build())

/**
 * Creates a new Amazon Chime SDK meeting in the specified media Region with no initial attendees. For more information about specifying media Regions, see [Amazon Chime SDK Media Regions](https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html) in the *Amazon Chime Developer Guide* . For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide* .
 */
public suspend inline fun ChimeClient.createMeeting(crossinline block: CreateMeetingRequest.Builder.() -> Unit): CreateMeetingResponse = createMeeting(CreateMeetingRequest.Builder().apply(block).build())

/**
 * Uses the join token and call metadata in a meeting request (From number, To number, and so forth) to initiate an outbound call to a public switched telephone network (PSTN) and join them into a Chime meeting. Also ensures that the From number belongs to the customer.
 *
 * To play welcome audio or implement an interactive voice response (IVR), use the `CreateSipMediaApplicationCall` action with the corresponding SIP media application ID.
 */
public suspend inline fun ChimeClient.createMeetingDialOut(crossinline block: CreateMeetingDialOutRequest.Builder.() -> Unit): CreateMeetingDialOutResponse = createMeetingDialOut(CreateMeetingDialOutRequest.Builder().apply(block).build())

/**
 * Creates a new Amazon Chime SDK meeting in the specified media Region, with attendees. For more information about specifying media Regions, see [Amazon Chime SDK Media Regions](https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html) in the *Amazon Chime Developer Guide* . For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide* .
 */
public suspend inline fun ChimeClient.createMeetingWithAttendees(crossinline block: CreateMeetingWithAttendeesRequest.Builder.() -> Unit): CreateMeetingWithAttendeesResponse = createMeetingWithAttendees(CreateMeetingWithAttendeesRequest.Builder().apply(block).build())

/**
 * Creates an order for phone numbers to be provisioned. For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.
 */
public suspend inline fun ChimeClient.createPhoneNumberOrder(crossinline block: CreatePhoneNumberOrderRequest.Builder.() -> Unit): CreatePhoneNumberOrderResponse = createPhoneNumberOrder(CreatePhoneNumberOrderRequest.Builder().apply(block).build())

/**
 * Creates a proxy session on the specified Amazon Chime Voice Connector for the specified participant phone numbers.
 */
public suspend inline fun ChimeClient.createProxySession(crossinline block: CreateProxySessionRequest.Builder.() -> Unit): CreateProxySessionResponse = createProxySession(CreateProxySessionRequest.Builder().apply(block).build())

/**
 * Creates a chat room for the specified Amazon Chime Enterprise account.
 */
public suspend inline fun ChimeClient.createRoom(crossinline block: CreateRoomRequest.Builder.() -> Unit): CreateRoomResponse = createRoom(CreateRoomRequest.Builder().apply(block).build())

/**
 * Adds a member to a chat room in an Amazon Chime Enterprise account. A member can be either a user or a bot. The member role designates whether the member is a chat room administrator or a general chat room member.
 */
public suspend inline fun ChimeClient.createRoomMembership(crossinline block: CreateRoomMembershipRequest.Builder.() -> Unit): CreateRoomMembershipResponse = createRoomMembership(CreateRoomMembershipRequest.Builder().apply(block).build())

/**
 * Creates a SIP media application.
 */
public suspend inline fun ChimeClient.createSipMediaApplication(crossinline block: CreateSipMediaApplicationRequest.Builder.() -> Unit): CreateSipMediaApplicationResponse = createSipMediaApplication(CreateSipMediaApplicationRequest.Builder().apply(block).build())

/**
 * Creates an outbound call to a phone number from the phone number specified in the request, and it invokes the endpoint of the specified `sipMediaApplicationId`.
 */
public suspend inline fun ChimeClient.createSipMediaApplicationCall(crossinline block: CreateSipMediaApplicationCallRequest.Builder.() -> Unit): CreateSipMediaApplicationCallResponse = createSipMediaApplicationCall(CreateSipMediaApplicationCallRequest.Builder().apply(block).build())

/**
 * Creates a SIP rule which can be used to run a SIP media application as a target for a specific trigger type.
 */
public suspend inline fun ChimeClient.createSipRule(crossinline block: CreateSipRuleRequest.Builder.() -> Unit): CreateSipRuleResponse = createSipRule(CreateSipRuleRequest.Builder().apply(block).build())

/**
 * Creates a user under the specified Amazon Chime account.
 */
public suspend inline fun ChimeClient.createUser(crossinline block: CreateUserRequest.Builder.() -> Unit): CreateUserResponse = createUser(CreateUserRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Chime Voice Connector under the administrator's AWS account. You can choose to create an Amazon Chime Voice Connector in a specific AWS Region.
 *
 *  Enabling CreateVoiceConnectorRequest$RequireEncryption configures your Amazon Chime Voice Connector to use TLS transport for SIP signaling and Secure RTP (SRTP) for media. Inbound calls use TLS transport, and unencrypted outbound calls are blocked.
 */
public suspend inline fun ChimeClient.createVoiceConnector(crossinline block: CreateVoiceConnectorRequest.Builder.() -> Unit): CreateVoiceConnectorResponse = createVoiceConnector(CreateVoiceConnectorRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Chime Voice Connector group under the administrator's AWS account. You can associate Amazon Chime Voice Connectors with the Amazon Chime Voice Connector group by including `VoiceConnectorItems` in the request.
 *
 * You can include Amazon Chime Voice Connectors from different AWS Regions in your group. This creates a fault tolerant mechanism for fallback in case of availability events.
 */
public suspend inline fun ChimeClient.createVoiceConnectorGroup(crossinline block: CreateVoiceConnectorGroupRequest.Builder.() -> Unit): CreateVoiceConnectorGroupResponse = createVoiceConnectorGroup(CreateVoiceConnectorGroupRequest.Builder().apply(block).build())

/**
 * Deletes the specified Amazon Chime account. You must suspend all users before deleting `Team` account. You can use the BatchSuspendUser action to dodo.
 *
 * For `EnterpriseLWA` and `EnterpriseAD` accounts, you must release the claimed domains for your Amazon Chime account before deletion. As soon as you release the domain, all users under that account are suspended.
 *
 * Deleted accounts appear in your `Disabled` accounts list for 90 days. To restore deleted account from your `Disabled` accounts list, you must contact AWS Support.
 *
 * After 90 days, deleted accounts are permanently removed from your `Disabled` accounts list.
 */
public suspend inline fun ChimeClient.deleteAccount(crossinline block: DeleteAccountRequest.Builder.() -> Unit): DeleteAccountResponse = deleteAccount(DeleteAccountRequest.Builder().apply(block).build())

/**
 * Deletes an `AppInstance` and all associated data asynchronously.
 */
public suspend inline fun ChimeClient.deleteAppInstance(crossinline block: DeleteAppInstanceRequest.Builder.() -> Unit): DeleteAppInstanceResponse = deleteAppInstance(DeleteAppInstanceRequest.Builder().apply(block).build())

/**
 * Demotes an `AppInstanceAdmin` to an `AppInstanceUser`. This action does not delete the user.
 */
public suspend inline fun ChimeClient.deleteAppInstanceAdmin(crossinline block: DeleteAppInstanceAdminRequest.Builder.() -> Unit): DeleteAppInstanceAdminResponse = deleteAppInstanceAdmin(DeleteAppInstanceAdminRequest.Builder().apply(block).build())

/**
 * Deletes the streaming configurations of an `AppInstance`.
 */
public suspend inline fun ChimeClient.deleteAppInstanceStreamingConfigurations(crossinline block: DeleteAppInstanceStreamingConfigurationsRequest.Builder.() -> Unit): DeleteAppInstanceStreamingConfigurationsResponse = deleteAppInstanceStreamingConfigurations(DeleteAppInstanceStreamingConfigurationsRequest.Builder().apply(block).build())

/**
 * Deletes an `AppInstanceUser`.
 */
public suspend inline fun ChimeClient.deleteAppInstanceUser(crossinline block: DeleteAppInstanceUserRequest.Builder.() -> Unit): DeleteAppInstanceUserResponse = deleteAppInstanceUser(DeleteAppInstanceUserRequest.Builder().apply(block).build())

/**
 * Deletes an attendee from the specified Amazon Chime SDK meeting and deletes their `JoinToken`. Attendees are automatically deleted when a Amazon Chime SDK meeting is deleted. For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide*.
 */
public suspend inline fun ChimeClient.deleteAttendee(crossinline block: DeleteAttendeeRequest.Builder.() -> Unit): DeleteAttendeeResponse = deleteAttendee(DeleteAttendeeRequest.Builder().apply(block).build())

/**
 * Immediately makes a channel and its memberships inaccessible and marks them for deletion. This is an irreversible process.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeClient.deleteChannel(crossinline block: DeleteChannelRequest.Builder.() -> Unit): DeleteChannelResponse = deleteChannel(DeleteChannelRequest.Builder().apply(block).build())

/**
 * Removes a user from a channel's ban list.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeClient.deleteChannelBan(crossinline block: DeleteChannelBanRequest.Builder.() -> Unit): DeleteChannelBanResponse = deleteChannelBan(DeleteChannelBanRequest.Builder().apply(block).build())

/**
 * Removes a member from a channel.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeClient.deleteChannelMembership(crossinline block: DeleteChannelMembershipRequest.Builder.() -> Unit): DeleteChannelMembershipResponse = deleteChannelMembership(DeleteChannelMembershipRequest.Builder().apply(block).build())

/**
 * Deletes a channel message. Only admins can perform this action. Deletion makes messages inaccessible immediately. A background process deletes any revisions created by `UpdateChannelMessage`.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeClient.deleteChannelMessage(crossinline block: DeleteChannelMessageRequest.Builder.() -> Unit): DeleteChannelMessageResponse = deleteChannelMessage(DeleteChannelMessageRequest.Builder().apply(block).build())

/**
 * Deletes a channel moderator.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeClient.deleteChannelModerator(crossinline block: DeleteChannelModeratorRequest.Builder.() -> Unit): DeleteChannelModeratorResponse = deleteChannelModerator(DeleteChannelModeratorRequest.Builder().apply(block).build())

/**
 * Deletes the events configuration that allows a bot to receive outgoing events.
 */
public suspend inline fun ChimeClient.deleteEventsConfiguration(crossinline block: DeleteEventsConfigurationRequest.Builder.() -> Unit): DeleteEventsConfigurationResponse = deleteEventsConfiguration(DeleteEventsConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes the media capture pipeline.
 */
public suspend inline fun ChimeClient.deleteMediaCapturePipeline(crossinline block: DeleteMediaCapturePipelineRequest.Builder.() -> Unit): DeleteMediaCapturePipelineResponse = deleteMediaCapturePipeline(DeleteMediaCapturePipelineRequest.Builder().apply(block).build())

/**
 * Deletes the specified Amazon Chime SDK meeting. The operation deletes all attendees, disconnects all clients, and prevents new clients from joining the meeting. For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide*.
 */
public suspend inline fun ChimeClient.deleteMeeting(crossinline block: DeleteMeetingRequest.Builder.() -> Unit): DeleteMeetingResponse = deleteMeeting(DeleteMeetingRequest.Builder().apply(block).build())

/**
 * Moves the specified phone number into the **Deletion queue**. A phone number must be disassociated from any users or Amazon Chime Voice Connectors before it can be deleted.
 *
 * Deleted phone numbers remain in the **Deletion queue** for 7 days before they are deleted permanently.
 */
public suspend inline fun ChimeClient.deletePhoneNumber(crossinline block: DeletePhoneNumberRequest.Builder.() -> Unit): DeletePhoneNumberResponse = deletePhoneNumber(DeletePhoneNumberRequest.Builder().apply(block).build())

/**
 * Deletes the specified proxy session from the specified Amazon Chime Voice Connector.
 */
public suspend inline fun ChimeClient.deleteProxySession(crossinline block: DeleteProxySessionRequest.Builder.() -> Unit): DeleteProxySessionResponse = deleteProxySession(DeleteProxySessionRequest.Builder().apply(block).build())

/**
 * Deletes a chat room in an Amazon Chime Enterprise account.
 */
public suspend inline fun ChimeClient.deleteRoom(crossinline block: DeleteRoomRequest.Builder.() -> Unit): DeleteRoomResponse = deleteRoom(DeleteRoomRequest.Builder().apply(block).build())

/**
 * Removes a member from a chat room in an Amazon Chime Enterprise account.
 */
public suspend inline fun ChimeClient.deleteRoomMembership(crossinline block: DeleteRoomMembershipRequest.Builder.() -> Unit): DeleteRoomMembershipResponse = deleteRoomMembership(DeleteRoomMembershipRequest.Builder().apply(block).build())

/**
 * Deletes a SIP media application.
 */
public suspend inline fun ChimeClient.deleteSipMediaApplication(crossinline block: DeleteSipMediaApplicationRequest.Builder.() -> Unit): DeleteSipMediaApplicationResponse = deleteSipMediaApplication(DeleteSipMediaApplicationRequest.Builder().apply(block).build())

/**
 * Deletes a SIP rule. You must disable a SIP rule before you can delete it.
 */
public suspend inline fun ChimeClient.deleteSipRule(crossinline block: DeleteSipRuleRequest.Builder.() -> Unit): DeleteSipRuleResponse = deleteSipRule(DeleteSipRuleRequest.Builder().apply(block).build())

/**
 * Deletes the specified Amazon Chime Voice Connector. Any phone numbers associated with the Amazon Chime Voice Connector must be disassociated from it before it can be deleted.
 */
public suspend inline fun ChimeClient.deleteVoiceConnector(crossinline block: DeleteVoiceConnectorRequest.Builder.() -> Unit): DeleteVoiceConnectorResponse = deleteVoiceConnector(DeleteVoiceConnectorRequest.Builder().apply(block).build())

/**
 * Deletes the emergency calling configuration details from the specified Amazon Chime Voice Connector.
 */
public suspend inline fun ChimeClient.deleteVoiceConnectorEmergencyCallingConfiguration(crossinline block: DeleteVoiceConnectorEmergencyCallingConfigurationRequest.Builder.() -> Unit): DeleteVoiceConnectorEmergencyCallingConfigurationResponse = deleteVoiceConnectorEmergencyCallingConfiguration(DeleteVoiceConnectorEmergencyCallingConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes the specified Amazon Chime Voice Connector group. Any `VoiceConnectorItems` and phone numbers associated with the group must be removed before it can be deleted.
 */
public suspend inline fun ChimeClient.deleteVoiceConnectorGroup(crossinline block: DeleteVoiceConnectorGroupRequest.Builder.() -> Unit): DeleteVoiceConnectorGroupResponse = deleteVoiceConnectorGroup(DeleteVoiceConnectorGroupRequest.Builder().apply(block).build())

/**
 * Deletes the origination settings for the specified Amazon Chime Voice Connector.
 *
 * If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to deleting the origination settings.
 */
public suspend inline fun ChimeClient.deleteVoiceConnectorOrigination(crossinline block: DeleteVoiceConnectorOriginationRequest.Builder.() -> Unit): DeleteVoiceConnectorOriginationResponse = deleteVoiceConnectorOrigination(DeleteVoiceConnectorOriginationRequest.Builder().apply(block).build())

/**
 * Deletes the proxy configuration from the specified Amazon Chime Voice Connector.
 */
public suspend inline fun ChimeClient.deleteVoiceConnectorProxy(crossinline block: DeleteVoiceConnectorProxyRequest.Builder.() -> Unit): DeleteVoiceConnectorProxyResponse = deleteVoiceConnectorProxy(DeleteVoiceConnectorProxyRequest.Builder().apply(block).build())

/**
 * Deletes the streaming configuration for the specified Amazon Chime Voice Connector.
 */
public suspend inline fun ChimeClient.deleteVoiceConnectorStreamingConfiguration(crossinline block: DeleteVoiceConnectorStreamingConfigurationRequest.Builder.() -> Unit): DeleteVoiceConnectorStreamingConfigurationResponse = deleteVoiceConnectorStreamingConfiguration(DeleteVoiceConnectorStreamingConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes the termination settings for the specified Amazon Chime Voice Connector.
 *
 * If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to deleting the termination settings.
 */
public suspend inline fun ChimeClient.deleteVoiceConnectorTermination(crossinline block: DeleteVoiceConnectorTerminationRequest.Builder.() -> Unit): DeleteVoiceConnectorTerminationResponse = deleteVoiceConnectorTermination(DeleteVoiceConnectorTerminationRequest.Builder().apply(block).build())

/**
 * Deletes the specified SIP credentials used by your equipment to authenticate during call termination.
 */
public suspend inline fun ChimeClient.deleteVoiceConnectorTerminationCredentials(crossinline block: DeleteVoiceConnectorTerminationCredentialsRequest.Builder.() -> Unit): DeleteVoiceConnectorTerminationCredentialsResponse = deleteVoiceConnectorTerminationCredentials(DeleteVoiceConnectorTerminationCredentialsRequest.Builder().apply(block).build())

/**
 * Returns the full details of an `AppInstance`.
 */
public suspend inline fun ChimeClient.describeAppInstance(crossinline block: DescribeAppInstanceRequest.Builder.() -> Unit): DescribeAppInstanceResponse = describeAppInstance(DescribeAppInstanceRequest.Builder().apply(block).build())

/**
 * Returns the full details of an `AppInstanceAdmin`.
 */
public suspend inline fun ChimeClient.describeAppInstanceAdmin(crossinline block: DescribeAppInstanceAdminRequest.Builder.() -> Unit): DescribeAppInstanceAdminResponse = describeAppInstanceAdmin(DescribeAppInstanceAdminRequest.Builder().apply(block).build())

/**
 * Returns the full details of an `AppInstanceUser`.
 */
public suspend inline fun ChimeClient.describeAppInstanceUser(crossinline block: DescribeAppInstanceUserRequest.Builder.() -> Unit): DescribeAppInstanceUserResponse = describeAppInstanceUser(DescribeAppInstanceUserRequest.Builder().apply(block).build())

/**
 * Returns the full details of a channel in an Amazon Chime `AppInstance`.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeClient.describeChannel(crossinline block: DescribeChannelRequest.Builder.() -> Unit): DescribeChannelResponse = describeChannel(DescribeChannelRequest.Builder().apply(block).build())

/**
 * Returns the full details of a channel ban.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeClient.describeChannelBan(crossinline block: DescribeChannelBanRequest.Builder.() -> Unit): DescribeChannelBanResponse = describeChannelBan(DescribeChannelBanRequest.Builder().apply(block).build())

/**
 * Returns the full details of a user's channel membership.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeClient.describeChannelMembership(crossinline block: DescribeChannelMembershipRequest.Builder.() -> Unit): DescribeChannelMembershipResponse = describeChannelMembership(DescribeChannelMembershipRequest.Builder().apply(block).build())

/**
 * Returns the details of a channel based on the membership of the specified `AppInstanceUser`.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeClient.describeChannelMembershipForAppInstanceUser(crossinline block: DescribeChannelMembershipForAppInstanceUserRequest.Builder.() -> Unit): DescribeChannelMembershipForAppInstanceUserResponse = describeChannelMembershipForAppInstanceUser(DescribeChannelMembershipForAppInstanceUserRequest.Builder().apply(block).build())

/**
 * Returns the full details of a channel moderated by the specified `AppInstanceUser`.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeClient.describeChannelModeratedByAppInstanceUser(crossinline block: DescribeChannelModeratedByAppInstanceUserRequest.Builder.() -> Unit): DescribeChannelModeratedByAppInstanceUserResponse = describeChannelModeratedByAppInstanceUser(DescribeChannelModeratedByAppInstanceUserRequest.Builder().apply(block).build())

/**
 * Returns the full details of a single ChannelModerator.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeClient.describeChannelModerator(crossinline block: DescribeChannelModeratorRequest.Builder.() -> Unit): DescribeChannelModeratorResponse = describeChannelModerator(DescribeChannelModeratorRequest.Builder().apply(block).build())

/**
 * Disassociates the primary provisioned phone number from the specified Amazon Chime user.
 */
public suspend inline fun ChimeClient.disassociatePhoneNumberFromUser(crossinline block: DisassociatePhoneNumberFromUserRequest.Builder.() -> Unit): DisassociatePhoneNumberFromUserResponse = disassociatePhoneNumberFromUser(DisassociatePhoneNumberFromUserRequest.Builder().apply(block).build())

/**
 * Disassociates the specified phone numbers from the specified Amazon Chime Voice Connector.
 */
public suspend inline fun ChimeClient.disassociatePhoneNumbersFromVoiceConnector(crossinline block: DisassociatePhoneNumbersFromVoiceConnectorRequest.Builder.() -> Unit): DisassociatePhoneNumbersFromVoiceConnectorResponse = disassociatePhoneNumbersFromVoiceConnector(DisassociatePhoneNumbersFromVoiceConnectorRequest.Builder().apply(block).build())

/**
 * Disassociates the specified phone numbers from the specified Amazon Chime Voice Connector group.
 */
public suspend inline fun ChimeClient.disassociatePhoneNumbersFromVoiceConnectorGroup(crossinline block: DisassociatePhoneNumbersFromVoiceConnectorGroupRequest.Builder.() -> Unit): DisassociatePhoneNumbersFromVoiceConnectorGroupResponse = disassociatePhoneNumbersFromVoiceConnectorGroup(DisassociatePhoneNumbersFromVoiceConnectorGroupRequest.Builder().apply(block).build())

/**
 * Disassociates the specified sign-in delegate groups from the specified Amazon Chime account.
 */
public suspend inline fun ChimeClient.disassociateSigninDelegateGroupsFromAccount(crossinline block: DisassociateSigninDelegateGroupsFromAccountRequest.Builder.() -> Unit): DisassociateSigninDelegateGroupsFromAccountResponse = disassociateSigninDelegateGroupsFromAccount(DisassociateSigninDelegateGroupsFromAccountRequest.Builder().apply(block).build())

/**
 * Retrieves details for the specified Amazon Chime account, such as account type and supported licenses.
 */
public suspend inline fun ChimeClient.getAccount(crossinline block: GetAccountRequest.Builder.() -> Unit): GetAccountResponse = getAccount(GetAccountRequest.Builder().apply(block).build())

/**
 * Retrieves account settings for the specified Amazon Chime account ID, such as remote control and dialout settings. For more information about these settings, see [Use the Policies Page](https://docs.aws.amazon.com/chime/latest/ag/policies.html) in the *Amazon Chime Administration Guide*.
 */
public suspend inline fun ChimeClient.getAccountSettings(crossinline block: GetAccountSettingsRequest.Builder.() -> Unit): GetAccountSettingsResponse = getAccountSettings(GetAccountSettingsRequest.Builder().apply(block).build())

/**
 * Gets the retention settings for an `AppInstance`.
 */
public suspend inline fun ChimeClient.getAppInstanceRetentionSettings(crossinline block: GetAppInstanceRetentionSettingsRequest.Builder.() -> Unit): GetAppInstanceRetentionSettingsResponse = getAppInstanceRetentionSettings(GetAppInstanceRetentionSettingsRequest.Builder().apply(block).build())

/**
 * Gets the streaming settings for an `AppInstance`.
 */
public suspend inline fun ChimeClient.getAppInstanceStreamingConfigurations(crossinline block: GetAppInstanceStreamingConfigurationsRequest.Builder.() -> Unit): GetAppInstanceStreamingConfigurationsResponse = getAppInstanceStreamingConfigurations(GetAppInstanceStreamingConfigurationsRequest.Builder().apply(block).build())

/**
 * Gets the Amazon Chime SDK attendee details for a specified meeting ID and attendee ID. For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide* .
 */
public suspend inline fun ChimeClient.getAttendee(crossinline block: GetAttendeeRequest.Builder.() -> Unit): GetAttendeeResponse = getAttendee(GetAttendeeRequest.Builder().apply(block).build())

/**
 * Retrieves details for the specified bot, such as bot email address, bot type, status, and display name.
 */
public suspend inline fun ChimeClient.getBot(crossinline block: GetBotRequest.Builder.() -> Unit): GetBotResponse = getBot(GetBotRequest.Builder().apply(block).build())

/**
 * Gets the full details of a channel message.
 *
 * The x-amz-chime-bearer request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeClient.getChannelMessage(crossinline block: GetChannelMessageRequest.Builder.() -> Unit): GetChannelMessageResponse = getChannelMessage(GetChannelMessageRequest.Builder().apply(block).build())

/**
 * Gets details for an events configuration that allows a bot to receive outgoing events, such as an HTTPS endpoint or Lambda function ARN.
 */
public suspend inline fun ChimeClient.getEventsConfiguration(crossinline block: GetEventsConfigurationRequest.Builder.() -> Unit): GetEventsConfigurationResponse = getEventsConfiguration(GetEventsConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves global settings for the administrator's AWS account, such as Amazon Chime Business Calling and Amazon Chime Voice Connector settings.
 */
public suspend inline fun ChimeClient.getGlobalSettings(crossinline block: GetGlobalSettingsRequest.Builder.() -> Unit): GetGlobalSettingsResponse = getGlobalSettings(GetGlobalSettingsRequest.Builder().apply(block).build())

/**
 * Gets an existing media capture pipeline.
 */
public suspend inline fun ChimeClient.getMediaCapturePipeline(crossinline block: GetMediaCapturePipelineRequest.Builder.() -> Unit): GetMediaCapturePipelineResponse = getMediaCapturePipeline(GetMediaCapturePipelineRequest.Builder().apply(block).build())

/**
 * Gets the Amazon Chime SDK meeting details for the specified meeting ID. For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide* .
 */
public suspend inline fun ChimeClient.getMeeting(crossinline block: GetMeetingRequest.Builder.() -> Unit): GetMeetingResponse = getMeeting(GetMeetingRequest.Builder().apply(block).build())

/**
 * The details of the endpoint for the messaging session.
 */
public suspend inline fun ChimeClient.getMessagingSessionEndpoint(crossinline block: GetMessagingSessionEndpointRequest.Builder.() -> Unit): GetMessagingSessionEndpointResponse = getMessagingSessionEndpoint(GetMessagingSessionEndpointRequest.Builder().apply(block).build())

/**
 * Retrieves details for the specified phone number ID, such as associations, capabilities, and product type.
 */
public suspend inline fun ChimeClient.getPhoneNumber(crossinline block: GetPhoneNumberRequest.Builder.() -> Unit): GetPhoneNumberResponse = getPhoneNumber(GetPhoneNumberRequest.Builder().apply(block).build())

/**
 * Retrieves details for the specified phone number order, such as the order creation timestamp, phone numbers in E.164 format, product type, and order status.
 */
public suspend inline fun ChimeClient.getPhoneNumberOrder(crossinline block: GetPhoneNumberOrderRequest.Builder.() -> Unit): GetPhoneNumberOrderResponse = getPhoneNumberOrder(GetPhoneNumberOrderRequest.Builder().apply(block).build())

/**
 * Retrieves the phone number settings for the administrator's AWS account, such as the default outbound calling name.
 */
public suspend inline fun ChimeClient.getPhoneNumberSettings(crossinline block: GetPhoneNumberSettingsRequest.Builder.() -> Unit): GetPhoneNumberSettingsResponse = getPhoneNumberSettings(GetPhoneNumberSettingsRequest.Builder().apply(block).build())

/**
 * Gets the specified proxy session details for the specified Amazon Chime Voice Connector.
 */
public suspend inline fun ChimeClient.getProxySession(crossinline block: GetProxySessionRequest.Builder.() -> Unit): GetProxySessionResponse = getProxySession(GetProxySessionRequest.Builder().apply(block).build())

/**
 * Gets the retention settings for the specified Amazon Chime Enterprise account. For more information about retention settings, see [Managing Chat Retention Policies](https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html) in the *Amazon Chime Administration Guide*.
 */
public suspend inline fun ChimeClient.getRetentionSettings(crossinline block: GetRetentionSettingsRequest.Builder.() -> Unit): GetRetentionSettingsResponse = getRetentionSettings(GetRetentionSettingsRequest.Builder().apply(block).build())

/**
 * Retrieves room details, such as the room name, for a room in an Amazon Chime Enterprise account.
 */
public suspend inline fun ChimeClient.getRoom(crossinline block: GetRoomRequest.Builder.() -> Unit): GetRoomResponse = getRoom(GetRoomRequest.Builder().apply(block).build())

/**
 * Retrieves the information for a SIP media application, including name, AWS Region, and endpoints.
 */
public suspend inline fun ChimeClient.getSipMediaApplication(crossinline block: GetSipMediaApplicationRequest.Builder.() -> Unit): GetSipMediaApplicationResponse = getSipMediaApplication(GetSipMediaApplicationRequest.Builder().apply(block).build())

/**
 * Returns the logging configuration for the specified SIP media application.
 */
public suspend inline fun ChimeClient.getSipMediaApplicationLoggingConfiguration(crossinline block: GetSipMediaApplicationLoggingConfigurationRequest.Builder.() -> Unit): GetSipMediaApplicationLoggingConfigurationResponse = getSipMediaApplicationLoggingConfiguration(GetSipMediaApplicationLoggingConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves the details of a SIP rule, such as the rule ID, name, triggers, and target endpoints.
 */
public suspend inline fun ChimeClient.getSipRule(crossinline block: GetSipRuleRequest.Builder.() -> Unit): GetSipRuleResponse = getSipRule(GetSipRuleRequest.Builder().apply(block).build())

/**
 * Retrieves details for the specified user ID, such as primary email address, license type,and personal meeting PIN.
 *
 *  To retrieve user details with an email address instead of a user ID, use the ListUsers action, and then filter by email address.
 */
public suspend inline fun ChimeClient.getUser(crossinline block: GetUserRequest.Builder.() -> Unit): GetUserResponse = getUser(GetUserRequest.Builder().apply(block).build())

/**
 * Retrieves settings for the specified user ID, such as any associated phone number settings.
 */
public suspend inline fun ChimeClient.getUserSettings(crossinline block: GetUserSettingsRequest.Builder.() -> Unit): GetUserSettingsResponse = getUserSettings(GetUserSettingsRequest.Builder().apply(block).build())

/**
 * Retrieves details for the specified Amazon Chime Voice Connector, such as timestamps,name, outbound host, and encryption requirements.
 */
public suspend inline fun ChimeClient.getVoiceConnector(crossinline block: GetVoiceConnectorRequest.Builder.() -> Unit): GetVoiceConnectorResponse = getVoiceConnector(GetVoiceConnectorRequest.Builder().apply(block).build())

/**
 * Gets the emergency calling configuration details for the specified Amazon Chime Voice Connector.
 */
public suspend inline fun ChimeClient.getVoiceConnectorEmergencyCallingConfiguration(crossinline block: GetVoiceConnectorEmergencyCallingConfigurationRequest.Builder.() -> Unit): GetVoiceConnectorEmergencyCallingConfigurationResponse = getVoiceConnectorEmergencyCallingConfiguration(GetVoiceConnectorEmergencyCallingConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves details for the specified Amazon Chime Voice Connector group, such as timestamps,name, and associated `VoiceConnectorItems`.
 */
public suspend inline fun ChimeClient.getVoiceConnectorGroup(crossinline block: GetVoiceConnectorGroupRequest.Builder.() -> Unit): GetVoiceConnectorGroupResponse = getVoiceConnectorGroup(GetVoiceConnectorGroupRequest.Builder().apply(block).build())

/**
 * Retrieves the logging configuration details for the specified Amazon Chime Voice Connector. Shows whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.
 */
public suspend inline fun ChimeClient.getVoiceConnectorLoggingConfiguration(crossinline block: GetVoiceConnectorLoggingConfigurationRequest.Builder.() -> Unit): GetVoiceConnectorLoggingConfigurationResponse = getVoiceConnectorLoggingConfiguration(GetVoiceConnectorLoggingConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves origination setting details for the specified Amazon Chime Voice Connector.
 */
public suspend inline fun ChimeClient.getVoiceConnectorOrigination(crossinline block: GetVoiceConnectorOriginationRequest.Builder.() -> Unit): GetVoiceConnectorOriginationResponse = getVoiceConnectorOrigination(GetVoiceConnectorOriginationRequest.Builder().apply(block).build())

/**
 * Gets the proxy configuration details for the specified Amazon Chime Voice Connector.
 */
public suspend inline fun ChimeClient.getVoiceConnectorProxy(crossinline block: GetVoiceConnectorProxyRequest.Builder.() -> Unit): GetVoiceConnectorProxyResponse = getVoiceConnectorProxy(GetVoiceConnectorProxyRequest.Builder().apply(block).build())

/**
 * Retrieves the streaming configuration details for the specified Amazon Chime Voice Connector. Shows whether media streaming is enabled for sending to Amazon Kinesis. It also shows the retention period, in hours, for the Amazon Kinesis data.
 */
public suspend inline fun ChimeClient.getVoiceConnectorStreamingConfiguration(crossinline block: GetVoiceConnectorStreamingConfigurationRequest.Builder.() -> Unit): GetVoiceConnectorStreamingConfigurationResponse = getVoiceConnectorStreamingConfiguration(GetVoiceConnectorStreamingConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves termination setting details for the specified Amazon Chime Voice Connector.
 */
public suspend inline fun ChimeClient.getVoiceConnectorTermination(crossinline block: GetVoiceConnectorTerminationRequest.Builder.() -> Unit): GetVoiceConnectorTerminationResponse = getVoiceConnectorTermination(GetVoiceConnectorTerminationRequest.Builder().apply(block).build())

/**
 * Retrieves information about the last time a SIP `OPTIONS` ping was received from your SIP infrastructure for the specified Amazon Chime Voice Connector.
 */
public suspend inline fun ChimeClient.getVoiceConnectorTerminationHealth(crossinline block: GetVoiceConnectorTerminationHealthRequest.Builder.() -> Unit): GetVoiceConnectorTerminationHealthResponse = getVoiceConnectorTerminationHealth(GetVoiceConnectorTerminationHealthRequest.Builder().apply(block).build())

/**
 * Sends email to a maximum of 50 users, inviting them to the specified Amazon Chime `Team` account. Only `Team` account types are currently supported for this action.
 */
public suspend inline fun ChimeClient.inviteUsers(crossinline block: InviteUsersRequest.Builder.() -> Unit): InviteUsersResponse = inviteUsers(InviteUsersRequest.Builder().apply(block).build())

/**
 * Lists the Amazon Chime accounts under the administrator's AWS account. You can filter accounts by account name prefix. To find out which Amazon Chime account a user belongs to, you can filter by the user's email address, which returns one account result.
 */
public suspend inline fun ChimeClient.listAccounts(crossinline block: ListAccountsRequest.Builder.() -> Unit): ListAccountsResponse = listAccounts(ListAccountsRequest.Builder().apply(block).build())

/**
 * Returns a list of the administrators in the `AppInstance`.
 */
public suspend inline fun ChimeClient.listAppInstanceAdmins(crossinline block: ListAppInstanceAdminsRequest.Builder.() -> Unit): ListAppInstanceAdminsResponse = listAppInstanceAdmins(ListAppInstanceAdminsRequest.Builder().apply(block).build())

/**
 * List all `AppInstanceUsers` created under a single `AppInstance`.
 */
public suspend inline fun ChimeClient.listAppInstanceUsers(crossinline block: ListAppInstanceUsersRequest.Builder.() -> Unit): ListAppInstanceUsersResponse = listAppInstanceUsers(ListAppInstanceUsersRequest.Builder().apply(block).build())

/**
 * Lists all Amazon Chime `AppInstance`s created under a single AWS account.
 */
public suspend inline fun ChimeClient.listAppInstances(crossinline block: ListAppInstancesRequest.Builder.() -> Unit): ListAppInstancesResponse = listAppInstances(ListAppInstancesRequest.Builder().apply(block).build())

/**
 * Lists the tags applied to an Amazon Chime SDK attendee resource.
 */
public suspend inline fun ChimeClient.listAttendeeTags(crossinline block: ListAttendeeTagsRequest.Builder.() -> Unit): ListAttendeeTagsResponse = listAttendeeTags(ListAttendeeTagsRequest.Builder().apply(block).build())

/**
 * Lists the attendees for the specified Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide*.
 */
public suspend inline fun ChimeClient.listAttendees(crossinline block: ListAttendeesRequest.Builder.() -> Unit): ListAttendeesResponse = listAttendees(ListAttendeesRequest.Builder().apply(block).build())

/**
 * Lists the bots associated with the administrator's Amazon Chime Enterprise account ID.
 */
public suspend inline fun ChimeClient.listBots(crossinline block: ListBotsRequest.Builder.() -> Unit): ListBotsResponse = listBots(ListBotsRequest.Builder().apply(block).build())

/**
 * Lists all the users banned from a particular channel.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeClient.listChannelBans(crossinline block: ListChannelBansRequest.Builder.() -> Unit): ListChannelBansResponse = listChannelBans(ListChannelBansRequest.Builder().apply(block).build())

/**
 * Lists all channel memberships in a channel.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeClient.listChannelMemberships(crossinline block: ListChannelMembershipsRequest.Builder.() -> Unit): ListChannelMembershipsResponse = listChannelMemberships(ListChannelMembershipsRequest.Builder().apply(block).build())

/**
 * Lists all channels that a particular `AppInstanceUser` is a part of. Only an `AppInstanceAdmin` can call the API with a user ARN that is not their own.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeClient.listChannelMembershipsForAppInstanceUser(crossinline block: ListChannelMembershipsForAppInstanceUserRequest.Builder.() -> Unit): ListChannelMembershipsForAppInstanceUserResponse = listChannelMembershipsForAppInstanceUser(ListChannelMembershipsForAppInstanceUserRequest.Builder().apply(block).build())

/**
 * List all the messages in a channel. Returns a paginated list of `ChannelMessages`. By default, sorted by creation timestamp in descending order.
 *
 * Redacted messages appear in the results as empty, since they are only redacted, not deleted. Deleted messages do not appear in the results. This action always returns the latest version of an edited message.
 *
 * Also, the x-amz-chime-bearer request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeClient.listChannelMessages(crossinline block: ListChannelMessagesRequest.Builder.() -> Unit): ListChannelMessagesResponse = listChannelMessages(ListChannelMessagesRequest.Builder().apply(block).build())

/**
 * Lists all the moderators for a channel.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeClient.listChannelModerators(crossinline block: ListChannelModeratorsRequest.Builder.() -> Unit): ListChannelModeratorsResponse = listChannelModerators(ListChannelModeratorsRequest.Builder().apply(block).build())

/**
 * Lists all Channels created under a single Chime App as a paginated list. You can specify filters to narrow results.
 *
 * **Functionality & restrictions**
 * + Use privacy = `PUBLIC` to retrieve all public channels in the account.
 * + Only an `AppInstanceAdmin` can set privacy = `PRIVATE` to list the private channels in an account.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeClient.listChannels(crossinline block: ListChannelsRequest.Builder.() -> Unit): ListChannelsResponse = listChannels(ListChannelsRequest.Builder().apply(block).build())

/**
 * A list of the channels moderated by an `AppInstanceUser`.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeClient.listChannelsModeratedByAppInstanceUser(crossinline block: ListChannelsModeratedByAppInstanceUserRequest.Builder.() -> Unit): ListChannelsModeratedByAppInstanceUserResponse = listChannelsModeratedByAppInstanceUser(ListChannelsModeratedByAppInstanceUserRequest.Builder().apply(block).build())

/**
 * Returns a list of media capture pipelines.
 */
public suspend inline fun ChimeClient.listMediaCapturePipelines(crossinline block: ListMediaCapturePipelinesRequest.Builder.() -> Unit): ListMediaCapturePipelinesResponse = listMediaCapturePipelines(ListMediaCapturePipelinesRequest.Builder().apply(block).build())

/**
 * Lists the tags applied to an Amazon Chime SDK meeting resource.
 */
public suspend inline fun ChimeClient.listMeetingTags(crossinline block: ListMeetingTagsRequest.Builder.() -> Unit): ListMeetingTagsResponse = listMeetingTags(ListMeetingTagsRequest.Builder().apply(block).build())

/**
 * Lists up to 100 active Amazon Chime SDK meetings. For more information about the Amazon Chime SDK, see [Using the Amazon Chime SDK](https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the *Amazon Chime Developer Guide*.
 */
public suspend inline fun ChimeClient.listMeetings(crossinline block: ListMeetingsRequest.Builder.() -> Unit): ListMeetingsResponse = listMeetings(ListMeetingsRequest.Builder().apply(block).build())

/**
 * Lists the phone number orders for the administrator's Amazon Chime account.
 */
public suspend inline fun ChimeClient.listPhoneNumberOrders(crossinline block: ListPhoneNumberOrdersRequest.Builder.() -> Unit): ListPhoneNumberOrdersResponse = listPhoneNumberOrders(ListPhoneNumberOrdersRequest.Builder().apply(block).build())

/**
 * Lists the phone numbers for the specified Amazon Chime account, Amazon Chime user, Amazon Chime Voice Connector, or Amazon Chime Voice Connector group.
 */
public suspend inline fun ChimeClient.listPhoneNumbers(crossinline block: ListPhoneNumbersRequest.Builder.() -> Unit): ListPhoneNumbersResponse = listPhoneNumbers(ListPhoneNumbersRequest.Builder().apply(block).build())

/**
 * Lists the proxy sessions for the specified Amazon Chime Voice Connector.
 */
public suspend inline fun ChimeClient.listProxySessions(crossinline block: ListProxySessionsRequest.Builder.() -> Unit): ListProxySessionsResponse = listProxySessions(ListProxySessionsRequest.Builder().apply(block).build())

/**
 * Lists the membership details for the specified room in an Amazon Chime Enterprise account, such as the members' IDs, email addresses, and names.
 */
public suspend inline fun ChimeClient.listRoomMemberships(crossinline block: ListRoomMembershipsRequest.Builder.() -> Unit): ListRoomMembershipsResponse = listRoomMemberships(ListRoomMembershipsRequest.Builder().apply(block).build())

/**
 * Lists the room details for the specified Amazon Chime Enterprise account. Optionally, filter the results by a member ID (user ID or bot ID) to see a list of rooms that the member belongs to.
 */
public suspend inline fun ChimeClient.listRooms(crossinline block: ListRoomsRequest.Builder.() -> Unit): ListRoomsResponse = listRooms(ListRoomsRequest.Builder().apply(block).build())

/**
 * Lists the SIP media applications under the administrator's AWS account.
 */
public suspend inline fun ChimeClient.listSipMediaApplications(crossinline block: ListSipMediaApplicationsRequest.Builder.() -> Unit): ListSipMediaApplicationsResponse = listSipMediaApplications(ListSipMediaApplicationsRequest.Builder().apply(block).build())

/**
 * Lists the SIP rules under the administrator's AWS account.
 */
public suspend inline fun ChimeClient.listSipRules(crossinline block: ListSipRulesRequest.Builder.() -> Unit): ListSipRulesResponse = listSipRules(ListSipRulesRequest.Builder().apply(block).build())

/**
 * Lists supported phone number countries.
 */
public suspend inline fun ChimeClient.listSupportedPhoneNumberCountries(crossinline block: ListSupportedPhoneNumberCountriesRequest.Builder.() -> Unit): ListSupportedPhoneNumberCountriesResponse = listSupportedPhoneNumberCountries(ListSupportedPhoneNumberCountriesRequest.Builder().apply(block).build())

/**
 * Lists the tags applied to an Amazon Chime SDK meeting resource.
 */
public suspend inline fun ChimeClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists the users that belong to the specified Amazon Chime account. You can specify an email address to list only the user that the email address belongs to.
 */
public suspend inline fun ChimeClient.listUsers(crossinline block: ListUsersRequest.Builder.() -> Unit): ListUsersResponse = listUsers(ListUsersRequest.Builder().apply(block).build())

/**
 * Lists the Amazon Chime Voice Connector groups for the administrator's AWS account.
 */
public suspend inline fun ChimeClient.listVoiceConnectorGroups(crossinline block: ListVoiceConnectorGroupsRequest.Builder.() -> Unit): ListVoiceConnectorGroupsResponse = listVoiceConnectorGroups(ListVoiceConnectorGroupsRequest.Builder().apply(block).build())

/**
 * Lists the SIP credentials for the specified Amazon Chime Voice Connector.
 */
public suspend inline fun ChimeClient.listVoiceConnectorTerminationCredentials(crossinline block: ListVoiceConnectorTerminationCredentialsRequest.Builder.() -> Unit): ListVoiceConnectorTerminationCredentialsResponse = listVoiceConnectorTerminationCredentials(ListVoiceConnectorTerminationCredentialsRequest.Builder().apply(block).build())

/**
 * Lists the Amazon Chime Voice Connectors for the administrator's AWS account.
 */
public suspend inline fun ChimeClient.listVoiceConnectors(crossinline block: ListVoiceConnectorsRequest.Builder.() -> Unit): ListVoiceConnectorsResponse = listVoiceConnectors(ListVoiceConnectorsRequest.Builder().apply(block).build())

/**
 * Logs out the specified user from all of the devices they are currently logged into.
 */
public suspend inline fun ChimeClient.logoutUser(crossinline block: LogoutUserRequest.Builder.() -> Unit): LogoutUserResponse = logoutUser(LogoutUserRequest.Builder().apply(block).build())

/**
 * Sets the amount of time in days that a given `AppInstance` retains data.
 */
public suspend inline fun ChimeClient.putAppInstanceRetentionSettings(crossinline block: PutAppInstanceRetentionSettingsRequest.Builder.() -> Unit): PutAppInstanceRetentionSettingsResponse = putAppInstanceRetentionSettings(PutAppInstanceRetentionSettingsRequest.Builder().apply(block).build())

/**
 * The data streaming configurations of an `AppInstance`.
 */
public suspend inline fun ChimeClient.putAppInstanceStreamingConfigurations(crossinline block: PutAppInstanceStreamingConfigurationsRequest.Builder.() -> Unit): PutAppInstanceStreamingConfigurationsResponse = putAppInstanceStreamingConfigurations(PutAppInstanceStreamingConfigurationsRequest.Builder().apply(block).build())

/**
 * Creates an events configuration that allows a bot to receive outgoing events sent by Amazon Chime. Choose either an HTTPS endpoint or a Lambda function ARN. For more information, see Bot.
 */
public suspend inline fun ChimeClient.putEventsConfiguration(crossinline block: PutEventsConfigurationRequest.Builder.() -> Unit): PutEventsConfigurationResponse = putEventsConfiguration(PutEventsConfigurationRequest.Builder().apply(block).build())

/**
 * Puts retention settings for the specified Amazon Chime Enterprise account. We recommend using AWS CloudTrail to monitor usage of this API for your account. For more information, see [Logging Amazon Chime API Calls with AWS CloudTrail](https://docs.aws.amazon.com/chime/latest/ag/cloudtrail.html) in the *Amazon Chime Administration Guide*.
 *
 *  To turn off existing retention settings, remove the number of days from the corresponding **RetentionDays** field in the **RetentionSettings** object. For more information about retention settings, see [Managing Chat Retention Policies](https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html) in the *Amazon Chime Administration Guide*.
 */
public suspend inline fun ChimeClient.putRetentionSettings(crossinline block: PutRetentionSettingsRequest.Builder.() -> Unit): PutRetentionSettingsResponse = putRetentionSettings(PutRetentionSettingsRequest.Builder().apply(block).build())

/**
 * Updates the logging configuration for the specified SIP media application.
 */
public suspend inline fun ChimeClient.putSipMediaApplicationLoggingConfiguration(crossinline block: PutSipMediaApplicationLoggingConfigurationRequest.Builder.() -> Unit): PutSipMediaApplicationLoggingConfigurationResponse = putSipMediaApplicationLoggingConfiguration(PutSipMediaApplicationLoggingConfigurationRequest.Builder().apply(block).build())

/**
 * Puts emergency calling configuration details to the specified Amazon Chime Voice Connector, such as emergency phone numbers and calling countries. Origination and termination settings must be enabled for the Amazon Chime Voice Connector before emergency calling can be configured.
 */
public suspend inline fun ChimeClient.putVoiceConnectorEmergencyCallingConfiguration(crossinline block: PutVoiceConnectorEmergencyCallingConfigurationRequest.Builder.() -> Unit): PutVoiceConnectorEmergencyCallingConfigurationResponse = putVoiceConnectorEmergencyCallingConfiguration(PutVoiceConnectorEmergencyCallingConfigurationRequest.Builder().apply(block).build())

/**
 * Adds a logging configuration for the specified Amazon Chime Voice Connector. The logging configuration specifies whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.
 */
public suspend inline fun ChimeClient.putVoiceConnectorLoggingConfiguration(crossinline block: PutVoiceConnectorLoggingConfigurationRequest.Builder.() -> Unit): PutVoiceConnectorLoggingConfigurationResponse = putVoiceConnectorLoggingConfiguration(PutVoiceConnectorLoggingConfigurationRequest.Builder().apply(block).build())

/**
 * Adds origination settings for the specified Amazon Chime Voice Connector.
 *
 * If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to turning off origination settings.
 */
public suspend inline fun ChimeClient.putVoiceConnectorOrigination(crossinline block: PutVoiceConnectorOriginationRequest.Builder.() -> Unit): PutVoiceConnectorOriginationResponse = putVoiceConnectorOrigination(PutVoiceConnectorOriginationRequest.Builder().apply(block).build())

/**
 * Puts the specified proxy configuration to the specified Amazon Chime Voice Connector.
 */
public suspend inline fun ChimeClient.putVoiceConnectorProxy(crossinline block: PutVoiceConnectorProxyRequest.Builder.() -> Unit): PutVoiceConnectorProxyResponse = putVoiceConnectorProxy(PutVoiceConnectorProxyRequest.Builder().apply(block).build())

/**
 * Adds a streaming configuration for the specified Amazon Chime Voice Connector. The streaming configuration specifies whether media streaming is enabled for sending to Kinesis. It also sets the retention period, in hours, for the Amazon Kinesis data.
 */
public suspend inline fun ChimeClient.putVoiceConnectorStreamingConfiguration(crossinline block: PutVoiceConnectorStreamingConfigurationRequest.Builder.() -> Unit): PutVoiceConnectorStreamingConfigurationResponse = putVoiceConnectorStreamingConfiguration(PutVoiceConnectorStreamingConfigurationRequest.Builder().apply(block).build())

/**
 * Adds termination settings for the specified Amazon Chime Voice Connector.
 *
 * If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to turning off termination settings.
 */
public suspend inline fun ChimeClient.putVoiceConnectorTermination(crossinline block: PutVoiceConnectorTerminationRequest.Builder.() -> Unit): PutVoiceConnectorTerminationResponse = putVoiceConnectorTermination(PutVoiceConnectorTerminationRequest.Builder().apply(block).build())

/**
 * Adds termination SIP credentials for the specified Amazon Chime Voice Connector.
 */
public suspend inline fun ChimeClient.putVoiceConnectorTerminationCredentials(crossinline block: PutVoiceConnectorTerminationCredentialsRequest.Builder.() -> Unit): PutVoiceConnectorTerminationCredentialsResponse = putVoiceConnectorTerminationCredentials(PutVoiceConnectorTerminationCredentialsRequest.Builder().apply(block).build())

/**
 * Redacts message content, but not metadata. The message exists in the back end, but the action returns null content, and the state shows as redacted.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeClient.redactChannelMessage(crossinline block: RedactChannelMessageRequest.Builder.() -> Unit): RedactChannelMessageResponse = redactChannelMessage(RedactChannelMessageRequest.Builder().apply(block).build())

/**
 * Redacts the specified message from the specified Amazon Chime conversation.
 */
public suspend inline fun ChimeClient.redactConversationMessage(crossinline block: RedactConversationMessageRequest.Builder.() -> Unit): RedactConversationMessageResponse = redactConversationMessage(RedactConversationMessageRequest.Builder().apply(block).build())

/**
 * Redacts the specified message from the specified Amazon Chime channel.
 */
public suspend inline fun ChimeClient.redactRoomMessage(crossinline block: RedactRoomMessageRequest.Builder.() -> Unit): RedactRoomMessageResponse = redactRoomMessage(RedactRoomMessageRequest.Builder().apply(block).build())

/**
 * Regenerates the security token for a bot.
 */
public suspend inline fun ChimeClient.regenerateSecurityToken(crossinline block: RegenerateSecurityTokenRequest.Builder.() -> Unit): RegenerateSecurityTokenResponse = regenerateSecurityToken(RegenerateSecurityTokenRequest.Builder().apply(block).build())

/**
 * Resets the personal meeting PIN for the specified user on an Amazon Chime account. Returns the User object with the updated personal meeting PIN.
 */
public suspend inline fun ChimeClient.resetPersonalPin(crossinline block: ResetPersonalPinRequest.Builder.() -> Unit): ResetPersonalPinResponse = resetPersonalPin(ResetPersonalPinRequest.Builder().apply(block).build())

/**
 * Moves a phone number from the **Deletion queue** back into the phone number **Inventory**.
 */
public suspend inline fun ChimeClient.restorePhoneNumber(crossinline block: RestorePhoneNumberRequest.Builder.() -> Unit): RestorePhoneNumberResponse = restorePhoneNumber(RestorePhoneNumberRequest.Builder().apply(block).build())

/**
 * Searches for phone numbers that can be ordered. For US numbers, provide at least one of the following search filters: `AreaCode`, `City`, `State`, or `TollFreePrefix`. If you provide `City`, you must also provide `State`. Numbers outside the US only support the `PhoneNumberType` filter, which you must use.
 */
public suspend inline fun ChimeClient.searchAvailablePhoneNumbers(crossinline block: SearchAvailablePhoneNumbersRequest.Builder.() -> Unit): SearchAvailablePhoneNumbersResponse = searchAvailablePhoneNumbers(SearchAvailablePhoneNumbersRequest.Builder().apply(block).build())

/**
 * Sends a message to a particular channel that the member is a part of.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 *
 * Also, `STANDARD` messages can contain 4KB of data and the 1KB of metadata. `CONTROL` messages can contain 30 bytes of data and no metadata.
 */
public suspend inline fun ChimeClient.sendChannelMessage(crossinline block: SendChannelMessageRequest.Builder.() -> Unit): SendChannelMessageResponse = sendChannelMessage(SendChannelMessageRequest.Builder().apply(block).build())

/**
 * Starts transcription for the specified `meetingId`.
 */
public suspend inline fun ChimeClient.startMeetingTranscription(crossinline block: StartMeetingTranscriptionRequest.Builder.() -> Unit): StartMeetingTranscriptionResponse = startMeetingTranscription(StartMeetingTranscriptionRequest.Builder().apply(block).build())

/**
 * Stops transcription for the specified `meetingId`.
 */
public suspend inline fun ChimeClient.stopMeetingTranscription(crossinline block: StopMeetingTranscriptionRequest.Builder.() -> Unit): StopMeetingTranscriptionResponse = stopMeetingTranscription(StopMeetingTranscriptionRequest.Builder().apply(block).build())

/**
 * Applies the specified tags to the specified Amazon Chime SDK attendee.
 */
public suspend inline fun ChimeClient.tagAttendee(crossinline block: TagAttendeeRequest.Builder.() -> Unit): TagAttendeeResponse = tagAttendee(TagAttendeeRequest.Builder().apply(block).build())

/**
 * Applies the specified tags to the specified Amazon Chime SDK meeting.
 */
public suspend inline fun ChimeClient.tagMeeting(crossinline block: TagMeetingRequest.Builder.() -> Unit): TagMeetingResponse = tagMeeting(TagMeetingRequest.Builder().apply(block).build())

/**
 * Applies the specified tags to the specified Amazon Chime SDK meeting resource.
 */
public suspend inline fun ChimeClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Untags the specified tags from the specified Amazon Chime SDK attendee.
 */
public suspend inline fun ChimeClient.untagAttendee(crossinline block: UntagAttendeeRequest.Builder.() -> Unit): UntagAttendeeResponse = untagAttendee(UntagAttendeeRequest.Builder().apply(block).build())

/**
 * Untags the specified tags from the specified Amazon Chime SDK meeting.
 */
public suspend inline fun ChimeClient.untagMeeting(crossinline block: UntagMeetingRequest.Builder.() -> Unit): UntagMeetingResponse = untagMeeting(UntagMeetingRequest.Builder().apply(block).build())

/**
 * Untags the specified tags from the specified Amazon Chime SDK meeting resource.
 */
public suspend inline fun ChimeClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates account details for the specified Amazon Chime account. Currently, only account name and default license updates are supported for this action.
 */
public suspend inline fun ChimeClient.updateAccount(crossinline block: UpdateAccountRequest.Builder.() -> Unit): UpdateAccountResponse = updateAccount(UpdateAccountRequest.Builder().apply(block).build())

/**
 * Updates the settings for the specified Amazon Chime account. You can update settings for remote control of shared screens, or for the dial-out option. For more information about these settings, see [Use the Policies Page](https://docs.aws.amazon.com/chime/latest/ag/policies.html) in the *Amazon Chime Administration Guide*.
 */
public suspend inline fun ChimeClient.updateAccountSettings(crossinline block: UpdateAccountSettingsRequest.Builder.() -> Unit): UpdateAccountSettingsResponse = updateAccountSettings(UpdateAccountSettingsRequest.Builder().apply(block).build())

/**
 * Updates `AppInstance` metadata.
 */
public suspend inline fun ChimeClient.updateAppInstance(crossinline block: UpdateAppInstanceRequest.Builder.() -> Unit): UpdateAppInstanceResponse = updateAppInstance(UpdateAppInstanceRequest.Builder().apply(block).build())

/**
 * Updates the details of an `AppInstanceUser`. You can update names and metadata.
 */
public suspend inline fun ChimeClient.updateAppInstanceUser(crossinline block: UpdateAppInstanceUserRequest.Builder.() -> Unit): UpdateAppInstanceUserResponse = updateAppInstanceUser(UpdateAppInstanceUserRequest.Builder().apply(block).build())

/**
 * Updates the status of the specified bot, such as starting or stopping the bot from running in your Amazon Chime Enterprise account.
 */
public suspend inline fun ChimeClient.updateBot(crossinline block: UpdateBotRequest.Builder.() -> Unit): UpdateBotResponse = updateBot(UpdateBotRequest.Builder().apply(block).build())

/**
 * Update a channel's attributes.
 *
 * **Restriction**: You can't change a channel's privacy.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeClient.updateChannel(crossinline block: UpdateChannelRequest.Builder.() -> Unit): UpdateChannelResponse = updateChannel(UpdateChannelRequest.Builder().apply(block).build())

/**
 * Updates the content of a message.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeClient.updateChannelMessage(crossinline block: UpdateChannelMessageRequest.Builder.() -> Unit): UpdateChannelMessageResponse = updateChannelMessage(UpdateChannelMessageRequest.Builder().apply(block).build())

/**
 * The details of the time when a user last read messages in a channel.
 *
 * The `x-amz-chime-bearer` request header is mandatory. Use the `AppInstanceUserArn` of the user that makes the API call as the value in the header.
 */
public suspend inline fun ChimeClient.updateChannelReadMarker(crossinline block: UpdateChannelReadMarkerRequest.Builder.() -> Unit): UpdateChannelReadMarkerResponse = updateChannelReadMarker(UpdateChannelReadMarkerRequest.Builder().apply(block).build())

/**
 * Updates global settings for the administrator's AWS account, such as Amazon Chime Business Calling and Amazon Chime Voice Connector settings.
 */
public suspend inline fun ChimeClient.updateGlobalSettings(crossinline block: UpdateGlobalSettingsRequest.Builder.() -> Unit): UpdateGlobalSettingsResponse = updateGlobalSettings(UpdateGlobalSettingsRequest.Builder().apply(block).build())

/**
 * Updates phone number details, such as product type or calling name, for the specified phone number ID. You can update one phone number detail at a time. For example, you can update either the product type or the calling name in one action.
 *
 * For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.
 *
 * Updates to outbound calling names can take 72 hours to complete. Pending updates to outbound calling names must be complete before you can request another update.
 */
public suspend inline fun ChimeClient.updatePhoneNumber(crossinline block: UpdatePhoneNumberRequest.Builder.() -> Unit): UpdatePhoneNumberResponse = updatePhoneNumber(UpdatePhoneNumberRequest.Builder().apply(block).build())

/**
 * Updates the phone number settings for the administrator's AWS account, such as the default outbound calling name. You can update the default outbound calling name once every seven days. Outbound calling names can take up to 72 hours to update.
 */
public suspend inline fun ChimeClient.updatePhoneNumberSettings(crossinline block: UpdatePhoneNumberSettingsRequest.Builder.() -> Unit): UpdatePhoneNumberSettingsResponse = updatePhoneNumberSettings(UpdatePhoneNumberSettingsRequest.Builder().apply(block).build())

/**
 * Updates the specified proxy session details, such as voice or SMS capabilities.
 */
public suspend inline fun ChimeClient.updateProxySession(crossinline block: UpdateProxySessionRequest.Builder.() -> Unit): UpdateProxySessionResponse = updateProxySession(UpdateProxySessionRequest.Builder().apply(block).build())

/**
 * Updates room details, such as the room name, for a room in an Amazon Chime Enterprise account.
 */
public suspend inline fun ChimeClient.updateRoom(crossinline block: UpdateRoomRequest.Builder.() -> Unit): UpdateRoomResponse = updateRoom(UpdateRoomRequest.Builder().apply(block).build())

/**
 * Updates room membership details, such as the member role, for a room in an Amazon Chime Enterprise account. The member role designates whether the member is a chat room administrator or a general chat room member. The member role can be updated only for user IDs.
 */
public suspend inline fun ChimeClient.updateRoomMembership(crossinline block: UpdateRoomMembershipRequest.Builder.() -> Unit): UpdateRoomMembershipResponse = updateRoomMembership(UpdateRoomMembershipRequest.Builder().apply(block).build())

/**
 * Updates the details of the specified SIP media application.
 */
public suspend inline fun ChimeClient.updateSipMediaApplication(crossinline block: UpdateSipMediaApplicationRequest.Builder.() -> Unit): UpdateSipMediaApplicationResponse = updateSipMediaApplication(UpdateSipMediaApplicationRequest.Builder().apply(block).build())

/**
 * Invokes the AWS Lambda function associated with the SIP media application and transaction ID in an update request. The Lambda function can then return a new set of actions.
 */
public suspend inline fun ChimeClient.updateSipMediaApplicationCall(crossinline block: UpdateSipMediaApplicationCallRequest.Builder.() -> Unit): UpdateSipMediaApplicationCallResponse = updateSipMediaApplicationCall(UpdateSipMediaApplicationCallRequest.Builder().apply(block).build())

/**
 * Updates the details of the specified SIP rule.
 */
public suspend inline fun ChimeClient.updateSipRule(crossinline block: UpdateSipRuleRequest.Builder.() -> Unit): UpdateSipRuleResponse = updateSipRule(UpdateSipRuleRequest.Builder().apply(block).build())

/**
 * Updates user details for a specified user ID. Currently, only `LicenseType` updates are supported for this action.
 */
public suspend inline fun ChimeClient.updateUser(crossinline block: UpdateUserRequest.Builder.() -> Unit): UpdateUserResponse = updateUser(UpdateUserRequest.Builder().apply(block).build())

/**
 * Updates the settings for the specified user, such as phone number settings.
 */
public suspend inline fun ChimeClient.updateUserSettings(crossinline block: UpdateUserSettingsRequest.Builder.() -> Unit): UpdateUserSettingsResponse = updateUserSettings(UpdateUserSettingsRequest.Builder().apply(block).build())

/**
 * Updates details for the specified Amazon Chime Voice Connector.
 */
public suspend inline fun ChimeClient.updateVoiceConnector(crossinline block: UpdateVoiceConnectorRequest.Builder.() -> Unit): UpdateVoiceConnectorResponse = updateVoiceConnector(UpdateVoiceConnectorRequest.Builder().apply(block).build())

/**
 * Updates details of the specified Amazon Chime Voice Connector group, such as the name and Amazon Chime Voice Connector priority ranking.
 */
public suspend inline fun ChimeClient.updateVoiceConnectorGroup(crossinline block: UpdateVoiceConnectorGroupRequest.Builder.() -> Unit): UpdateVoiceConnectorGroupResponse = updateVoiceConnectorGroup(UpdateVoiceConnectorGroupRequest.Builder().apply(block).build())

/**
 * Validates an address to be used for 911 calls made with Amazon Chime Voice Connectors. You can use validated addresses in a Presence Information Data Format Location Object file that you include in SIP requests. That helps ensure that addresses are routed to the appropriate Public Safety Answering Point.
 */
public suspend inline fun ChimeClient.validateE911Address(crossinline block: ValidateE911AddressRequest.Builder.() -> Unit): ValidateE911AddressResponse = validateE911Address(ValidateE911AddressRequest.Builder().apply(block).build())
