// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The Amazon Chime account details. An AWS account can have multiple Amazon Chime accounts.
 */
public class Account private constructor(builder: Builder) {
    /**
     * The Amazon Chime account ID.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The status of the account.
     */
    public val accountStatus: aws.sdk.kotlin.services.chime.model.AccountStatus? = builder.accountStatus
    /**
     * The Amazon Chime account type. For more information about different account types, see [Managing Your Amazon Chime Accounts](https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html) in the *Amazon Chime Administration Guide*.
     */
    public val accountType: aws.sdk.kotlin.services.chime.model.AccountType? = builder.accountType
    /**
     * The AWS account ID.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * The Amazon Chime account creation timestamp, in ISO 8601 format.
     */
    public val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimestamp
    /**
     * The default license for the Amazon Chime account.
     */
    public val defaultLicense: aws.sdk.kotlin.services.chime.model.License? = builder.defaultLicense
    /**
     * The Amazon Chime account name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The sign-in delegate groups associated with the account.
     */
    public val signinDelegateGroups: List<SigninDelegateGroup>? = builder.signinDelegateGroups
    /**
     * Supported licenses for the Amazon Chime account.
     */
    public val supportedLicenses: List<License>? = builder.supportedLicenses

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chime.model.Account = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Account(")
        append("accountId=$accountId,")
        append("accountStatus=$accountStatus,")
        append("accountType=$accountType,")
        append("awsAccountId=$awsAccountId,")
        append("createdTimestamp=$createdTimestamp,")
        append("defaultLicense=$defaultLicense,")
        append("name=$name,")
        append("signinDelegateGroups=$signinDelegateGroups,")
        append("supportedLicenses=$supportedLicenses)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (accountStatus?.hashCode() ?: 0)
        result = 31 * result + (accountType?.hashCode() ?: 0)
        result = 31 * result + (awsAccountId?.hashCode() ?: 0)
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (defaultLicense?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (signinDelegateGroups?.hashCode() ?: 0)
        result = 31 * result + (supportedLicenses?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Account

        if (accountId != other.accountId) return false
        if (accountStatus != other.accountStatus) return false
        if (accountType != other.accountType) return false
        if (awsAccountId != other.awsAccountId) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (defaultLicense != other.defaultLicense) return false
        if (name != other.name) return false
        if (signinDelegateGroups != other.signinDelegateGroups) return false
        if (supportedLicenses != other.supportedLicenses) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chime.model.Account = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Chime account ID.
         */
        public var accountId: kotlin.String? = null
        /**
         * The status of the account.
         */
        public var accountStatus: aws.sdk.kotlin.services.chime.model.AccountStatus? = null
        /**
         * The Amazon Chime account type. For more information about different account types, see [Managing Your Amazon Chime Accounts](https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html) in the *Amazon Chime Administration Guide*.
         */
        public var accountType: aws.sdk.kotlin.services.chime.model.AccountType? = null
        /**
         * The AWS account ID.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The Amazon Chime account creation timestamp, in ISO 8601 format.
         */
        public var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The default license for the Amazon Chime account.
         */
        public var defaultLicense: aws.sdk.kotlin.services.chime.model.License? = null
        /**
         * The Amazon Chime account name.
         */
        public var name: kotlin.String? = null
        /**
         * The sign-in delegate groups associated with the account.
         */
        public var signinDelegateGroups: List<SigninDelegateGroup>? = null
        /**
         * Supported licenses for the Amazon Chime account.
         */
        public var supportedLicenses: List<License>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chime.model.Account) : this() {
            this.accountId = x.accountId
            this.accountStatus = x.accountStatus
            this.accountType = x.accountType
            this.awsAccountId = x.awsAccountId
            this.createdTimestamp = x.createdTimestamp
            this.defaultLicense = x.defaultLicense
            this.name = x.name
            this.signinDelegateGroups = x.signinDelegateGroups
            this.supportedLicenses = x.supportedLicenses
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chime.model.Account = Account(this)
    }
}
