// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model



/**
 * Settings specific to the Amazon Transcribe engine.
 */
public class EngineTranscribeSettings private constructor(builder: Builder) {
    /**
     * Set this field to `PII` to identify personally identifiable information in the transcription output.
     */
    public val contentIdentificationType: aws.sdk.kotlin.services.chime.model.TranscribeContentIdentificationType? = builder.contentIdentificationType
    /**
     * Set this field to `PII` to redact personally identifiable information in the transcription output. Content redaction is performed only upon complete transcription of the audio segments.
     */
    public val contentRedactionType: aws.sdk.kotlin.services.chime.model.TranscribeContentRedactionType? = builder.contentRedactionType
    /**
     * Generates partial transcription results that are less likely to change as meeting attendees speak. It does so by only allowing the last few words from the partial results to change.
     */
    public val enablePartialResultsStabilization: kotlin.Boolean? = builder.enablePartialResultsStabilization
    /**
     * The language code specified for the Amazon Transcribe engine.
     */
    public val languageCode: aws.sdk.kotlin.services.chime.model.TranscribeLanguageCode? = builder.languageCode
    /**
     * The name of the language model used during transcription.
     */
    public val languageModelName: kotlin.String? = builder.languageModelName
    /**
     * The stabity level of a partial results transcription. Determines how stable you want the transcription results to be. A higher level means the transcription results are less likely to change.
     */
    public val partialResultsStability: aws.sdk.kotlin.services.chime.model.TranscribePartialResultsStability? = builder.partialResultsStability
    /**
     * Lists the PII entity types you want to identify or redact. To specify entity types, you must enable `ContentIdentificationType` or `ContentRedactionType`.
     *
     * `PIIEntityTypes` must be comma-separated. The available values are: `BANK_ACCOUNT_NUMBER`, `BANK_ROUTING, CREDIT_DEBIT_NUMBER`, `CREDIT_DEBIT_CVV`, `CREDIT_DEBIT_EXPIRY`, `PIN`, `EMAIL`, `ADDRESS`, `NAME`, `PHONE`, `SSN`, and `ALL`.
     *
     * `PiiEntityTypes` is an optional parameter with a default value of `ALL`.
     */
    public val piiEntityTypes: kotlin.String? = builder.piiEntityTypes
    /**
     * The AWS Region passed to Amazon Transcribe. If you don't specify a Region, Amazon Chime uses the meeting's Region.
     */
    public val region: aws.sdk.kotlin.services.chime.model.TranscribeRegion? = builder.region
    /**
     * The filtering method passed to Amazon Transcribe.
     */
    public val vocabularyFilterMethod: aws.sdk.kotlin.services.chime.model.TranscribeVocabularyFilterMethod? = builder.vocabularyFilterMethod
    /**
     * The name of the vocabulary filter passed to Amazon Transcribe.
     */
    public val vocabularyFilterName: kotlin.String? = builder.vocabularyFilterName
    /**
     * The name of the vocabulary passed to Amazon Transcribe.
     */
    public val vocabularyName: kotlin.String? = builder.vocabularyName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chime.model.EngineTranscribeSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EngineTranscribeSettings(")
        append("contentIdentificationType=$contentIdentificationType,")
        append("contentRedactionType=$contentRedactionType,")
        append("enablePartialResultsStabilization=$enablePartialResultsStabilization,")
        append("languageCode=$languageCode,")
        append("languageModelName=$languageModelName,")
        append("partialResultsStability=$partialResultsStability,")
        append("piiEntityTypes=$piiEntityTypes,")
        append("region=$region,")
        append("vocabularyFilterMethod=$vocabularyFilterMethod,")
        append("vocabularyFilterName=$vocabularyFilterName,")
        append("vocabularyName=$vocabularyName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = contentIdentificationType?.hashCode() ?: 0
        result = 31 * result + (contentRedactionType?.hashCode() ?: 0)
        result = 31 * result + (enablePartialResultsStabilization?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (languageModelName?.hashCode() ?: 0)
        result = 31 * result + (partialResultsStability?.hashCode() ?: 0)
        result = 31 * result + (piiEntityTypes?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (vocabularyFilterMethod?.hashCode() ?: 0)
        result = 31 * result + (vocabularyFilterName?.hashCode() ?: 0)
        result = 31 * result + (vocabularyName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EngineTranscribeSettings

        if (contentIdentificationType != other.contentIdentificationType) return false
        if (contentRedactionType != other.contentRedactionType) return false
        if (enablePartialResultsStabilization != other.enablePartialResultsStabilization) return false
        if (languageCode != other.languageCode) return false
        if (languageModelName != other.languageModelName) return false
        if (partialResultsStability != other.partialResultsStability) return false
        if (piiEntityTypes != other.piiEntityTypes) return false
        if (region != other.region) return false
        if (vocabularyFilterMethod != other.vocabularyFilterMethod) return false
        if (vocabularyFilterName != other.vocabularyFilterName) return false
        if (vocabularyName != other.vocabularyName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chime.model.EngineTranscribeSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Set this field to `PII` to identify personally identifiable information in the transcription output.
         */
        public var contentIdentificationType: aws.sdk.kotlin.services.chime.model.TranscribeContentIdentificationType? = null
        /**
         * Set this field to `PII` to redact personally identifiable information in the transcription output. Content redaction is performed only upon complete transcription of the audio segments.
         */
        public var contentRedactionType: aws.sdk.kotlin.services.chime.model.TranscribeContentRedactionType? = null
        /**
         * Generates partial transcription results that are less likely to change as meeting attendees speak. It does so by only allowing the last few words from the partial results to change.
         */
        public var enablePartialResultsStabilization: kotlin.Boolean? = null
        /**
         * The language code specified for the Amazon Transcribe engine.
         */
        public var languageCode: aws.sdk.kotlin.services.chime.model.TranscribeLanguageCode? = null
        /**
         * The name of the language model used during transcription.
         */
        public var languageModelName: kotlin.String? = null
        /**
         * The stabity level of a partial results transcription. Determines how stable you want the transcription results to be. A higher level means the transcription results are less likely to change.
         */
        public var partialResultsStability: aws.sdk.kotlin.services.chime.model.TranscribePartialResultsStability? = null
        /**
         * Lists the PII entity types you want to identify or redact. To specify entity types, you must enable `ContentIdentificationType` or `ContentRedactionType`.
         *
         * `PIIEntityTypes` must be comma-separated. The available values are: `BANK_ACCOUNT_NUMBER`, `BANK_ROUTING, CREDIT_DEBIT_NUMBER`, `CREDIT_DEBIT_CVV`, `CREDIT_DEBIT_EXPIRY`, `PIN`, `EMAIL`, `ADDRESS`, `NAME`, `PHONE`, `SSN`, and `ALL`.
         *
         * `PiiEntityTypes` is an optional parameter with a default value of `ALL`.
         */
        public var piiEntityTypes: kotlin.String? = null
        /**
         * The AWS Region passed to Amazon Transcribe. If you don't specify a Region, Amazon Chime uses the meeting's Region.
         */
        public var region: aws.sdk.kotlin.services.chime.model.TranscribeRegion? = null
        /**
         * The filtering method passed to Amazon Transcribe.
         */
        public var vocabularyFilterMethod: aws.sdk.kotlin.services.chime.model.TranscribeVocabularyFilterMethod? = null
        /**
         * The name of the vocabulary filter passed to Amazon Transcribe.
         */
        public var vocabularyFilterName: kotlin.String? = null
        /**
         * The name of the vocabulary passed to Amazon Transcribe.
         */
        public var vocabularyName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chime.model.EngineTranscribeSettings) : this() {
            this.contentIdentificationType = x.contentIdentificationType
            this.contentRedactionType = x.contentRedactionType
            this.enablePartialResultsStabilization = x.enablePartialResultsStabilization
            this.languageCode = x.languageCode
            this.languageModelName = x.languageModelName
            this.partialResultsStability = x.partialResultsStability
            this.piiEntityTypes = x.piiEntityTypes
            this.region = x.region
            this.vocabularyFilterMethod = x.vocabularyFilterMethod
            this.vocabularyFilterName = x.vocabularyFilterName
            this.vocabularyName = x.vocabularyName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chime.model.EngineTranscribeSettings = EngineTranscribeSettings(this)
    }
}
