// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model



/**
 * Origination routes define call distribution properties for your SIP hosts to receive inbound calls using your Amazon Chime Voice Connector. Limit: Ten origination routes for each Amazon Chime Voice Connector.
 *
 * The parameters listed below are not required, but you must use at least one.
 */
public class OriginationRoute private constructor(builder: Builder) {
    /**
     * The FQDN or IP address to contact for origination traffic.
     */
    public val host: kotlin.String? = builder.host
    /**
     * The designated origination route port. Defaults to 5060.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The priority associated with the host, with 1 being the highest priority. Higher priority hosts are attempted first.
     */
    public val priority: kotlin.Int? = builder.priority
    /**
     * The protocol to use for the origination route. Encryption-enabled Amazon Chime Voice Connectors use TCP protocol by default.
     */
    public val protocol: aws.sdk.kotlin.services.chime.model.OriginationRouteProtocol? = builder.protocol
    /**
     * The weight associated with the host. If hosts are equal in priority, calls are redistributed among them based on their relative weight.
     */
    public val weight: kotlin.Int? = builder.weight

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chime.model.OriginationRoute = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OriginationRoute(")
        append("host=$host,")
        append("port=$port,")
        append("priority=$priority,")
        append("protocol=$protocol,")
        append("weight=$weight)")
    }

    override fun hashCode(): kotlin.Int {
        var result = host?.hashCode() ?: 0
        result = 31 * result + (port ?: 0)
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (weight ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OriginationRoute

        if (host != other.host) return false
        if (port != other.port) return false
        if (priority != other.priority) return false
        if (protocol != other.protocol) return false
        if (weight != other.weight) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chime.model.OriginationRoute = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The FQDN or IP address to contact for origination traffic.
         */
        public var host: kotlin.String? = null
        /**
         * The designated origination route port. Defaults to 5060.
         */
        public var port: kotlin.Int? = null
        /**
         * The priority associated with the host, with 1 being the highest priority. Higher priority hosts are attempted first.
         */
        public var priority: kotlin.Int? = null
        /**
         * The protocol to use for the origination route. Encryption-enabled Amazon Chime Voice Connectors use TCP protocol by default.
         */
        public var protocol: aws.sdk.kotlin.services.chime.model.OriginationRouteProtocol? = null
        /**
         * The weight associated with the host. If hosts are equal in priority, calls are redistributed among them based on their relative weight.
         */
        public var weight: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chime.model.OriginationRoute) : this() {
            this.host = x.host
            this.port = x.port
            this.priority = x.priority
            this.protocol = x.protocol
            this.weight = x.weight
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chime.model.OriginationRoute = OriginationRoute(this)
    }
}
