// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The proxy session for an Amazon Chime Voice Connector.
 */
public class ProxySession private constructor(builder: Builder) {
    /**
     * The proxy session capabilities.
     */
    public val capabilities: List<Capability>? = builder.capabilities
    /**
     * The created time stamp, in ISO 8601 format.
     */
    public val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimestamp
    /**
     * The ended time stamp, in ISO 8601 format.
     */
    public val endedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.endedTimestamp
    /**
     * The number of minutes allowed for the proxy session.
     */
    public val expiryMinutes: kotlin.Int? = builder.expiryMinutes
    /**
     * The preference for matching the country or area code of the proxy phone number with that of the first participant.
     */
    public val geoMatchLevel: aws.sdk.kotlin.services.chime.model.GeoMatchLevel? = builder.geoMatchLevel
    /**
     * The country and area code for the proxy phone number.
     */
    public val geoMatchParams: aws.sdk.kotlin.services.chime.model.GeoMatchParams? = builder.geoMatchParams
    /**
     * The name of the proxy session.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.
     */
    public val numberSelectionBehavior: aws.sdk.kotlin.services.chime.model.NumberSelectionBehavior? = builder.numberSelectionBehavior
    /**
     * The proxy session participants.
     */
    public val participants: List<Participant>? = builder.participants
    /**
     * The proxy session ID.
     */
    public val proxySessionId: kotlin.String? = builder.proxySessionId
    /**
     * The status of the proxy session.
     */
    public val status: aws.sdk.kotlin.services.chime.model.ProxySessionStatus? = builder.status
    /**
     * The updated time stamp, in ISO 8601 format.
     */
    public val updatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedTimestamp
    /**
     * The Amazon Chime voice connector ID.
     */
    public val voiceConnectorId: kotlin.String? = builder.voiceConnectorId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chime.model.ProxySession = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProxySession(")
        append("capabilities=$capabilities,")
        append("createdTimestamp=$createdTimestamp,")
        append("endedTimestamp=$endedTimestamp,")
        append("expiryMinutes=$expiryMinutes,")
        append("geoMatchLevel=$geoMatchLevel,")
        append("geoMatchParams=$geoMatchParams,")
        append("name=$name,")
        append("numberSelectionBehavior=$numberSelectionBehavior,")
        append("participants=$participants,")
        append("proxySessionId=$proxySessionId,")
        append("status=$status,")
        append("updatedTimestamp=$updatedTimestamp,")
        append("voiceConnectorId=$voiceConnectorId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = capabilities?.hashCode() ?: 0
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (endedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (expiryMinutes ?: 0)
        result = 31 * result + (geoMatchLevel?.hashCode() ?: 0)
        result = 31 * result + (geoMatchParams?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (numberSelectionBehavior?.hashCode() ?: 0)
        result = 31 * result + (participants?.hashCode() ?: 0)
        result = 31 * result + (proxySessionId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (voiceConnectorId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProxySession

        if (capabilities != other.capabilities) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (endedTimestamp != other.endedTimestamp) return false
        if (expiryMinutes != other.expiryMinutes) return false
        if (geoMatchLevel != other.geoMatchLevel) return false
        if (geoMatchParams != other.geoMatchParams) return false
        if (name != other.name) return false
        if (numberSelectionBehavior != other.numberSelectionBehavior) return false
        if (participants != other.participants) return false
        if (proxySessionId != other.proxySessionId) return false
        if (status != other.status) return false
        if (updatedTimestamp != other.updatedTimestamp) return false
        if (voiceConnectorId != other.voiceConnectorId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chime.model.ProxySession = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The proxy session capabilities.
         */
        public var capabilities: List<Capability>? = null
        /**
         * The created time stamp, in ISO 8601 format.
         */
        public var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ended time stamp, in ISO 8601 format.
         */
        public var endedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of minutes allowed for the proxy session.
         */
        public var expiryMinutes: kotlin.Int? = null
        /**
         * The preference for matching the country or area code of the proxy phone number with that of the first participant.
         */
        public var geoMatchLevel: aws.sdk.kotlin.services.chime.model.GeoMatchLevel? = null
        /**
         * The country and area code for the proxy phone number.
         */
        public var geoMatchParams: aws.sdk.kotlin.services.chime.model.GeoMatchParams? = null
        /**
         * The name of the proxy session.
         */
        public var name: kotlin.String? = null
        /**
         * The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.
         */
        public var numberSelectionBehavior: aws.sdk.kotlin.services.chime.model.NumberSelectionBehavior? = null
        /**
         * The proxy session participants.
         */
        public var participants: List<Participant>? = null
        /**
         * The proxy session ID.
         */
        public var proxySessionId: kotlin.String? = null
        /**
         * The status of the proxy session.
         */
        public var status: aws.sdk.kotlin.services.chime.model.ProxySessionStatus? = null
        /**
         * The updated time stamp, in ISO 8601 format.
         */
        public var updatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Chime voice connector ID.
         */
        public var voiceConnectorId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chime.model.ProxySession) : this() {
            this.capabilities = x.capabilities
            this.createdTimestamp = x.createdTimestamp
            this.endedTimestamp = x.endedTimestamp
            this.expiryMinutes = x.expiryMinutes
            this.geoMatchLevel = x.geoMatchLevel
            this.geoMatchParams = x.geoMatchParams
            this.name = x.name
            this.numberSelectionBehavior = x.numberSelectionBehavior
            this.participants = x.participants
            this.proxySessionId = x.proxySessionId
            this.status = x.status
            this.updatedTimestamp = x.updatedTimestamp
            this.voiceConnectorId = x.voiceConnectorId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chime.model.ProxySession = ProxySession(this)

        /**
         * construct an [aws.sdk.kotlin.services.chime.model.GeoMatchParams] inside the given [block]
         */
        public fun geoMatchParams(block: aws.sdk.kotlin.services.chime.model.GeoMatchParams.Builder.() -> kotlin.Unit) {
            this.geoMatchParams = aws.sdk.kotlin.services.chime.model.GeoMatchParams.invoke(block)
        }
    }
}
