// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of the SIP media application, including name and endpoints. An AWS account can have multiple SIP media applications.
 */
public class SipMediaApplication private constructor(builder: Builder) {
    /**
     * The AWS Region in which the SIP media application is created.
     */
    public val awsRegion: kotlin.String? = builder.awsRegion
    /**
     * The SIP media application creation timestamp, in ISO 8601 format.
     */
    public val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimestamp
    /**
     * List of endpoints for SIP media application. Currently, only one endpoint per SIP media application is permitted.
     */
    public val endpoints: List<SipMediaApplicationEndpoint>? = builder.endpoints
    /**
     * The name of the SIP media application.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The SIP media application ID.
     */
    public val sipMediaApplicationId: kotlin.String? = builder.sipMediaApplicationId
    /**
     * The SIP media application updated timestamp, in ISO 8601 format.
     */
    public val updatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedTimestamp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chime.model.SipMediaApplication = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SipMediaApplication(")
        append("awsRegion=$awsRegion,")
        append("createdTimestamp=$createdTimestamp,")
        append("endpoints=$endpoints,")
        append("name=$name,")
        append("sipMediaApplicationId=$sipMediaApplicationId,")
        append("updatedTimestamp=$updatedTimestamp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsRegion?.hashCode() ?: 0
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (endpoints?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (sipMediaApplicationId?.hashCode() ?: 0)
        result = 31 * result + (updatedTimestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SipMediaApplication

        if (awsRegion != other.awsRegion) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (endpoints != other.endpoints) return false
        if (name != other.name) return false
        if (sipMediaApplicationId != other.sipMediaApplicationId) return false
        if (updatedTimestamp != other.updatedTimestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chime.model.SipMediaApplication = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The AWS Region in which the SIP media application is created.
         */
        public var awsRegion: kotlin.String? = null
        /**
         * The SIP media application creation timestamp, in ISO 8601 format.
         */
        public var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * List of endpoints for SIP media application. Currently, only one endpoint per SIP media application is permitted.
         */
        public var endpoints: List<SipMediaApplicationEndpoint>? = null
        /**
         * The name of the SIP media application.
         */
        public var name: kotlin.String? = null
        /**
         * The SIP media application ID.
         */
        public var sipMediaApplicationId: kotlin.String? = null
        /**
         * The SIP media application updated timestamp, in ISO 8601 format.
         */
        public var updatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chime.model.SipMediaApplication) : this() {
            this.awsRegion = x.awsRegion
            this.createdTimestamp = x.createdTimestamp
            this.endpoints = x.endpoints
            this.name = x.name
            this.sipMediaApplicationId = x.sipMediaApplicationId
            this.updatedTimestamp = x.updatedTimestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chime.model.SipMediaApplication = SipMediaApplication(this)
    }
}
