// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The SIP rule details, including name, triggers, and target applications. An AWS account can have multiple SIP rules.
 */
public class SipRule private constructor(builder: Builder) {
    /**
     * The time at which the SIP rule was created, in ISO 8601 format.
     */
    public val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimestamp
    /**
     * Indicates whether the SIP rule is enabled or disabled. You must disable a rule before you can delete it.
     */
    public val disabled: kotlin.Boolean? = builder.disabled
    /**
     * The name of the SIP rule.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The SIP rule ID.
     */
    public val sipRuleId: kotlin.String? = builder.sipRuleId
    /**
     * Target SIP media application and other details, such as priority and AWS Region, to be specified in the SIP rule. Only one SIP rule per AWS Region can be provided.
     */
    public val targetApplications: List<SipRuleTargetApplication>? = builder.targetApplications
    /**
     * The type of trigger assigned to the SIP rule in `TriggerValue`, currently `RequestUriHostname` or `ToPhoneNumber`.
     */
    public val triggerType: aws.sdk.kotlin.services.chime.model.SipRuleTriggerType? = builder.triggerType
    /**
     * If `TriggerType` is `RequestUriHostname`, then the value can be the outbound host name of the Amazon Chime Voice Connector. If `TriggerType` is `ToPhoneNumber`, then the value can be a customer-owned phone number in E164 format. `SipRule` is triggered when a SIP rule requests host name or `ToPhoneNumber` matches in the incoming SIP request.
     */
    public val triggerValue: kotlin.String? = builder.triggerValue
    /**
     * The time at which the SIP rule was last updated, in ISO 8601 format.
     */
    public val updatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedTimestamp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chime.model.SipRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SipRule(")
        append("createdTimestamp=$createdTimestamp,")
        append("disabled=$disabled,")
        append("name=$name,")
        append("sipRuleId=$sipRuleId,")
        append("targetApplications=$targetApplications,")
        append("triggerType=$triggerType,")
        append("triggerValue=$triggerValue,")
        append("updatedTimestamp=$updatedTimestamp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdTimestamp?.hashCode() ?: 0
        result = 31 * result + (disabled?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (sipRuleId?.hashCode() ?: 0)
        result = 31 * result + (targetApplications?.hashCode() ?: 0)
        result = 31 * result + (triggerType?.hashCode() ?: 0)
        result = 31 * result + (triggerValue?.hashCode() ?: 0)
        result = 31 * result + (updatedTimestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SipRule

        if (createdTimestamp != other.createdTimestamp) return false
        if (disabled != other.disabled) return false
        if (name != other.name) return false
        if (sipRuleId != other.sipRuleId) return false
        if (targetApplications != other.targetApplications) return false
        if (triggerType != other.triggerType) return false
        if (triggerValue != other.triggerValue) return false
        if (updatedTimestamp != other.updatedTimestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chime.model.SipRule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time at which the SIP rule was created, in ISO 8601 format.
         */
        public var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates whether the SIP rule is enabled or disabled. You must disable a rule before you can delete it.
         */
        public var disabled: kotlin.Boolean? = null
        /**
         * The name of the SIP rule.
         */
        public var name: kotlin.String? = null
        /**
         * The SIP rule ID.
         */
        public var sipRuleId: kotlin.String? = null
        /**
         * Target SIP media application and other details, such as priority and AWS Region, to be specified in the SIP rule. Only one SIP rule per AWS Region can be provided.
         */
        public var targetApplications: List<SipRuleTargetApplication>? = null
        /**
         * The type of trigger assigned to the SIP rule in `TriggerValue`, currently `RequestUriHostname` or `ToPhoneNumber`.
         */
        public var triggerType: aws.sdk.kotlin.services.chime.model.SipRuleTriggerType? = null
        /**
         * If `TriggerType` is `RequestUriHostname`, then the value can be the outbound host name of the Amazon Chime Voice Connector. If `TriggerType` is `ToPhoneNumber`, then the value can be a customer-owned phone number in E164 format. `SipRule` is triggered when a SIP rule requests host name or `ToPhoneNumber` matches in the incoming SIP request.
         */
        public var triggerValue: kotlin.String? = null
        /**
         * The time at which the SIP rule was last updated, in ISO 8601 format.
         */
        public var updatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chime.model.SipRule) : this() {
            this.createdTimestamp = x.createdTimestamp
            this.disabled = x.disabled
            this.name = x.name
            this.sipRuleId = x.sipRuleId
            this.targetApplications = x.targetApplications
            this.triggerType = x.triggerType
            this.triggerValue = x.triggerValue
            this.updatedTimestamp = x.updatedTimestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chime.model.SipRule = SipRule(this)
    }
}
