// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model



/**
 * Termination settings enable your SIP hosts to make outbound calls using your Amazon Chime Voice Connector.
 */
public class Termination private constructor(builder: Builder) {
    /**
     * The countries to which calls are allowed, in ISO 3166-1 alpha-2 format. Required.
     */
    public val callingRegions: List<String>? = builder.callingRegions
    /**
     * The IP addresses allowed to make calls, in CIDR format. Required.
     */
    public val cidrAllowedList: List<String>? = builder.cidrAllowedList
    /**
     * The limit on calls per second. Max value based on account service quota. Default value of 1.
     */
    public val cpsLimit: kotlin.Int? = builder.cpsLimit
    /**
     * The default caller ID phone number.
     */
    public val defaultPhoneNumber: kotlin.String? = builder.defaultPhoneNumber
    /**
     * When termination settings are disabled, outbound calls can not be made.
     */
    public val disabled: kotlin.Boolean? = builder.disabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chime.model.Termination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Termination(")
        append("callingRegions=$callingRegions,")
        append("cidrAllowedList=$cidrAllowedList,")
        append("cpsLimit=$cpsLimit,")
        append("defaultPhoneNumber=*** Sensitive Data Redacted ***,")
        append("disabled=$disabled)")
    }

    override fun hashCode(): kotlin.Int {
        var result = callingRegions?.hashCode() ?: 0
        result = 31 * result + (cidrAllowedList?.hashCode() ?: 0)
        result = 31 * result + (cpsLimit ?: 0)
        result = 31 * result + (defaultPhoneNumber?.hashCode() ?: 0)
        result = 31 * result + (disabled?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Termination

        if (callingRegions != other.callingRegions) return false
        if (cidrAllowedList != other.cidrAllowedList) return false
        if (cpsLimit != other.cpsLimit) return false
        if (defaultPhoneNumber != other.defaultPhoneNumber) return false
        if (disabled != other.disabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chime.model.Termination = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The countries to which calls are allowed, in ISO 3166-1 alpha-2 format. Required.
         */
        public var callingRegions: List<String>? = null
        /**
         * The IP addresses allowed to make calls, in CIDR format. Required.
         */
        public var cidrAllowedList: List<String>? = null
        /**
         * The limit on calls per second. Max value based on account service quota. Default value of 1.
         */
        public var cpsLimit: kotlin.Int? = null
        /**
         * The default caller ID phone number.
         */
        public var defaultPhoneNumber: kotlin.String? = null
        /**
         * When termination settings are disabled, outbound calls can not be made.
         */
        public var disabled: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chime.model.Termination) : this() {
            this.callingRegions = x.callingRegions
            this.cidrAllowedList = x.cidrAllowedList
            this.cpsLimit = x.cpsLimit
            this.defaultPhoneNumber = x.defaultPhoneNumber
            this.disabled = x.disabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chime.model.Termination = Termination(this)
    }
}
