// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The Amazon Chime Voice Connector configuration, including outbound host name and encryption settings.
 */
public class VoiceConnector private constructor(builder: Builder) {
    /**
     * The AWS Region in which the Amazon Chime Voice Connector is created. Default: `us-east-1`.
     */
    public val awsRegion: aws.sdk.kotlin.services.chime.model.VoiceConnectorAwsRegion? = builder.awsRegion
    /**
     * The Amazon Chime Voice Connector creation timestamp, in ISO 8601 format.
     */
    public val createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimestamp
    /**
     * The name of the Amazon Chime Voice Connector.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The outbound host name for the Amazon Chime Voice Connector.
     */
    public val outboundHostName: kotlin.String? = builder.outboundHostName
    /**
     * Designates whether encryption is required for the Amazon Chime Voice Connector.
     */
    public val requireEncryption: kotlin.Boolean? = builder.requireEncryption
    /**
     * The updated Amazon Chime Voice Connector timestamp, in ISO 8601 format.
     */
    public val updatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedTimestamp
    /**
     * The ARN of the specified Amazon Chime Voice Connector.
     */
    public val voiceConnectorArn: kotlin.String? = builder.voiceConnectorArn
    /**
     * The Amazon Chime Voice Connector ID.
     */
    public val voiceConnectorId: kotlin.String? = builder.voiceConnectorId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.chime.model.VoiceConnector = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VoiceConnector(")
        append("awsRegion=$awsRegion,")
        append("createdTimestamp=$createdTimestamp,")
        append("name=$name,")
        append("outboundHostName=$outboundHostName,")
        append("requireEncryption=$requireEncryption,")
        append("updatedTimestamp=$updatedTimestamp,")
        append("voiceConnectorArn=$voiceConnectorArn,")
        append("voiceConnectorId=$voiceConnectorId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsRegion?.hashCode() ?: 0
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outboundHostName?.hashCode() ?: 0)
        result = 31 * result + (requireEncryption?.hashCode() ?: 0)
        result = 31 * result + (updatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (voiceConnectorArn?.hashCode() ?: 0)
        result = 31 * result + (voiceConnectorId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VoiceConnector

        if (awsRegion != other.awsRegion) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (name != other.name) return false
        if (outboundHostName != other.outboundHostName) return false
        if (requireEncryption != other.requireEncryption) return false
        if (updatedTimestamp != other.updatedTimestamp) return false
        if (voiceConnectorArn != other.voiceConnectorArn) return false
        if (voiceConnectorId != other.voiceConnectorId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.chime.model.VoiceConnector = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The AWS Region in which the Amazon Chime Voice Connector is created. Default: `us-east-1`.
         */
        public var awsRegion: aws.sdk.kotlin.services.chime.model.VoiceConnectorAwsRegion? = null
        /**
         * The Amazon Chime Voice Connector creation timestamp, in ISO 8601 format.
         */
        public var createdTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the Amazon Chime Voice Connector.
         */
        public var name: kotlin.String? = null
        /**
         * The outbound host name for the Amazon Chime Voice Connector.
         */
        public var outboundHostName: kotlin.String? = null
        /**
         * Designates whether encryption is required for the Amazon Chime Voice Connector.
         */
        public var requireEncryption: kotlin.Boolean? = null
        /**
         * The updated Amazon Chime Voice Connector timestamp, in ISO 8601 format.
         */
        public var updatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the specified Amazon Chime Voice Connector.
         */
        public var voiceConnectorArn: kotlin.String? = null
        /**
         * The Amazon Chime Voice Connector ID.
         */
        public var voiceConnectorId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.chime.model.VoiceConnector) : this() {
            this.awsRegion = x.awsRegion
            this.createdTimestamp = x.createdTimestamp
            this.name = x.name
            this.outboundHostName = x.outboundHostName
            this.requireEncryption = x.requireEncryption
            this.updatedTimestamp = x.updatedTimestamp
            this.voiceConnectorArn = x.voiceConnectorArn
            this.voiceConnectorId = x.voiceConnectorId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.chime.model.VoiceConnector = VoiceConnector(this)
    }
}
