// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.transform

import aws.sdk.kotlin.services.chime.model.CreateMeetingRequest
import aws.sdk.kotlin.services.chime.model.MeetingNotificationConfiguration
import aws.sdk.kotlin.services.chime.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateMeetingOperationSerializer: HttpSerialize<CreateMeetingRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateMeetingRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/meetings"
        }

        val payload = serializeCreateMeetingOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateMeetingOperationBody(context: ExecutionContext, input: CreateMeetingRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientRequestToken"))
    val EXTERNALMEETINGID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExternalMeetingId"))
    val MEDIAREGION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MediaRegion"))
    val MEETINGHOSTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MeetingHostId"))
    val NOTIFICATIONSCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("NotificationsConfiguration"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(EXTERNALMEETINGID_DESCRIPTOR)
        field(MEDIAREGION_DESCRIPTOR)
        field(MEETINGHOSTID_DESCRIPTOR)
        field(NOTIFICATIONSCONFIGURATION_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTREQUESTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.externalMeetingId?.let { field(EXTERNALMEETINGID_DESCRIPTOR, it) }
        input.mediaRegion?.let { field(MEDIAREGION_DESCRIPTOR, it) }
        input.meetingHostId?.let { field(MEETINGHOSTID_DESCRIPTOR, it) }
        input.notificationsConfiguration?.let { field(NOTIFICATIONSCONFIGURATION_DESCRIPTOR, it, ::serializeMeetingNotificationConfigurationDocument) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
