// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.transform

import aws.sdk.kotlin.services.chime.model.Capability
import aws.sdk.kotlin.services.chime.model.CreateProxySessionRequest
import aws.sdk.kotlin.services.chime.model.GeoMatchLevel
import aws.sdk.kotlin.services.chime.model.GeoMatchParams
import aws.sdk.kotlin.services.chime.model.NumberSelectionBehavior
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateProxySessionOperationSerializer: HttpSerialize<CreateProxySessionRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateProxySessionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "voice-connectors",
                "${input.voiceConnectorId}".encodeLabel(),
                "proxy-sessions",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateProxySessionOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateProxySessionOperationBody(context: ExecutionContext, input: CreateProxySessionRequest): ByteArray {
    val serializer = JsonSerializer()
    val CAPABILITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Capabilities"))
    val EXPIRYMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ExpiryMinutes"))
    val GEOMATCHLEVEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GeoMatchLevel"))
    val GEOMATCHPARAMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("GeoMatchParams"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val NUMBERSELECTIONBEHAVIOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NumberSelectionBehavior"))
    val PARTICIPANTPHONENUMBERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ParticipantPhoneNumbers"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CAPABILITIES_DESCRIPTOR)
        field(EXPIRYMINUTES_DESCRIPTOR)
        field(GEOMATCHLEVEL_DESCRIPTOR)
        field(GEOMATCHPARAMS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(NUMBERSELECTIONBEHAVIOR_DESCRIPTOR)
        field(PARTICIPANTPHONENUMBERS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.capabilities != null) {
            listField(CAPABILITIES_DESCRIPTOR) {
                for (el0 in input.capabilities) {
                    serializeString(el0.value)
                }
            }
        }
        input.expiryMinutes?.let { field(EXPIRYMINUTES_DESCRIPTOR, it) }
        input.geoMatchLevel?.let { field(GEOMATCHLEVEL_DESCRIPTOR, it.value) }
        input.geoMatchParams?.let { field(GEOMATCHPARAMS_DESCRIPTOR, it, ::serializeGeoMatchParamsDocument) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.numberSelectionBehavior?.let { field(NUMBERSELECTIONBEHAVIOR_DESCRIPTOR, it.value) }
        if (input.participantPhoneNumbers != null) {
            listField(PARTICIPANTPHONENUMBERS_DESCRIPTOR) {
                for (el0 in input.participantPhoneNumbers) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
