// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.transform

import aws.sdk.kotlin.services.chime.model.ListChannelMessagesRequest
import aws.sdk.kotlin.services.chime.model.SortOrder
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.parameters
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class ListChannelMessagesOperationSerializer: HttpSerialize<ListChannelMessagesRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListChannelMessagesRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            val pathSegments = listOf(
                "channels",
                "${input.channelArn}".encodeLabel(),
                "messages",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                if (input.maxResults != null) append("max-results", "${input.maxResults}")
                if (input.nextToken != null) append("next-token", input.nextToken)
                if (input.notAfter != null) append("not-after", input.notAfter.format(TimestampFormat.ISO_8601))
                if (input.notBefore != null) append("not-before", input.notBefore.format(TimestampFormat.ISO_8601))
                if (input.sortOrder != null) append("sort-order", input.sortOrder.value)
            }
        }

        builder.headers {
            if (input.chimeBearer?.isNotEmpty() == true) append("x-amz-chime-bearer", input.chimeBearer)
        }

        return builder
    }
}
