// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.transform

import aws.sdk.kotlin.services.chime.model.PutVoiceConnectorProxyRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutVoiceConnectorProxyOperationSerializer: HttpSerialize<PutVoiceConnectorProxyRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PutVoiceConnectorProxyRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf(
                "voice-connectors",
                "${input.voiceConnectorId}".encodeLabel(),
                "programmable-numbers",
                "proxy",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializePutVoiceConnectorProxyOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializePutVoiceConnectorProxyOperationBody(context: ExecutionContext, input: PutVoiceConnectorProxyRequest): ByteArray {
    val serializer = JsonSerializer()
    val DEFAULTSESSIONEXPIRYMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("DefaultSessionExpiryMinutes"))
    val DISABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("Disabled"))
    val FALLBACKPHONENUMBER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FallBackPhoneNumber"))
    val PHONENUMBERPOOLCOUNTRIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("PhoneNumberPoolCountries"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEFAULTSESSIONEXPIRYMINUTES_DESCRIPTOR)
        field(DISABLED_DESCRIPTOR)
        field(FALLBACKPHONENUMBER_DESCRIPTOR)
        field(PHONENUMBERPOOLCOUNTRIES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.defaultSessionExpiryMinutes?.let { field(DEFAULTSESSIONEXPIRYMINUTES_DESCRIPTOR, it) }
        input.disabled?.let { field(DISABLED_DESCRIPTOR, it) }
        input.fallBackPhoneNumber?.let { field(FALLBACKPHONENUMBER_DESCRIPTOR, it) }
        if (input.phoneNumberPoolCountries != null) {
            listField(PHONENUMBERPOOLCOUNTRIES_DESCRIPTOR) {
                for (el0 in input.phoneNumberPoolCountries) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
