// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.chime.model.Address
import aws.sdk.kotlin.services.chime.model.CandidateAddress
import aws.sdk.kotlin.services.chime.model.ChimeException
import aws.sdk.kotlin.services.chime.model.ValidateE911AddressResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ValidateE911AddressOperationDeserializer: HttpDeserialize<ValidateE911AddressResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ValidateE911AddressResponse {
        if (!response.status.isSuccess()) {
            throwValidateE911AddressError(context, response)
        }
        val builder = ValidateE911AddressResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeValidateE911AddressOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwValidateE911AddressError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ChimeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceFailureException" -> ServiceFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottledClientException" -> ThrottledClientExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedClientException" -> UnauthorizedClientExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ChimeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeValidateE911AddressOperationBody(builder: ValidateE911AddressResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Address"))
    val ADDRESSEXTERNALID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AddressExternalId"))
    val CANDIDATEADDRESSLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("CandidateAddressList"))
    val VALIDATIONRESULT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ValidationResult"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDRESS_DESCRIPTOR)
        field(ADDRESSEXTERNALID_DESCRIPTOR)
        field(CANDIDATEADDRESSLIST_DESCRIPTOR)
        field(VALIDATIONRESULT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADDRESS_DESCRIPTOR.index -> builder.address = deserializeAddressDocument(deserializer)
                ADDRESSEXTERNALID_DESCRIPTOR.index -> builder.addressExternalId = deserializeString()
                CANDIDATEADDRESSLIST_DESCRIPTOR.index -> builder.candidateAddressList =
                    deserializer.deserializeList(CANDIDATEADDRESSLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<CandidateAddress>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCandidateAddressDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                VALIDATIONRESULT_DESCRIPTOR.index -> builder.validationResult = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
