// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime

import aws.sdk.kotlin.runtime.auth.AuthConfig
import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.endpoint.EndpointResolver
import aws.sdk.kotlin.runtime.region.RegionConfig
import aws.sdk.kotlin.services.chime.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * The Amazon Chime API (application programming interface) is designed for developers to
 * perform key tasks, such as creating and managing Amazon Chime accounts, users, and Voice
 * Connectors. This guide provides detailed information about the Amazon Chime API,
 * including operations, types, inputs and outputs, and error codes. It also includes some
 * server-side API actions to use with the Amazon Chime SDK. For more information about the
 * Amazon Chime SDK, see <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">
 * Using the Amazon Chime SDK
 * in the Amazon Chime Developer Guide.
 * You can use an AWS SDK, the AWS Command Line Interface (AWS CLI), or the REST API to make API calls. We recommend using an AWS SDK or the
 * AWS CLI. Each API operation includes links to information about using it with a language-specific AWS SDK or the AWS CLI.
 * Using an AWS SDK
 * You don't need to write code to calculate a signature for request authentication. The SDK clients authenticate your requests by using access keys that you provide. For more information about AWS SDKs, see the
 * <a href="http://aws.amazon.com/developer/">AWS Developer Center.
 * Using the AWS CLI
 * Use your access keys with the AWS CLI to make API calls. For information about setting up the AWS CLI, see
 * <a href="https://docs.aws.amazon.com/cli/latest/userguide/installing.html">Installing the AWS Command Line Interface
 * in the AWS Command Line Interface User Guide. For a list of available Amazon Chime commands, see the
 * <a href="https://docs.aws.amazon.com/cli/latest/reference/chime/index.html">Amazon Chime commands in the
 * AWS CLI Command Reference.
 * Using REST APIs
 * If you use REST to make API calls, you must authenticate your request by providing a signature. Amazon Chime supports signature version 4. For more information, see
 * <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process
 * in the Amazon Web Services General Reference.
 * When making REST API calls, use the service name chime and REST endpoint https://service.chime.aws.amazon.com.
 * Administrative permissions are controlled using AWS Identity and Access Management (IAM). For more information, see
 * <a href="https://docs.aws.amazon.com/chime/latest/ag/security-iam.html">Identity and Access Management for Amazon Chime
 * in the Amazon Chime Administration Guide.
 */
interface ChimeClient : SdkClient {

    override val serviceName: String
        get() = "Chime"
    /**
     * ChimeClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.DslBuilder.() -> Unit = {}): ChimeClient {
            val config = Config.BuilderImpl().apply(block).build()
            return DefaultChimeClient(config)
        }
    }

    class Config private constructor(builder: BuilderImpl): AuthConfig, HttpClientConfig, IdempotencyTokenConfig, RegionConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider? = builder.credentialsProvider
        val endpointResolver: EndpointResolver? = builder.endpointResolver
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        override val region: String? = builder.region
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        override val signingRegion: String? = builder.signingRegion

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun signingRegion(signingRegion: String): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: EndpointResolver?

            /**
             * Override the default HTTP client configuration (e.g. configure proxy behavior, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

            /**
             * AWS region to be used for signing the request. This is not necessarily the same as `region`
             * in the case of global services like IAM
             */
            var signingRegion: String?

            fun build(): Config
        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: EndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default
            override var signingRegion: String? = null

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder = apply { this.idempotencyTokenProvider = idempotencyTokenProvider }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
            override fun signingRegion(signingRegion: String): FluentBuilder = apply { this.signingRegion = signingRegion }
        }
    }

    /**
     * Associates a phone number with the specified Amazon Chime user.
     */
    suspend fun associatePhoneNumberWithUser(input: AssociatePhoneNumberWithUserRequest): AssociatePhoneNumberWithUserResponse

    /**
     * Associates a phone number with the specified Amazon Chime user.
     */
    suspend fun associatePhoneNumberWithUser(block: AssociatePhoneNumberWithUserRequest.DslBuilder.() -> Unit) = associatePhoneNumberWithUser(AssociatePhoneNumberWithUserRequest.builder().apply(block).build())

    /**
     * Associates phone numbers with the specified Amazon Chime Voice Connector.
     */
    suspend fun associatePhoneNumbersWithVoiceConnector(input: AssociatePhoneNumbersWithVoiceConnectorRequest): AssociatePhoneNumbersWithVoiceConnectorResponse

    /**
     * Associates phone numbers with the specified Amazon Chime Voice Connector.
     */
    suspend fun associatePhoneNumbersWithVoiceConnector(block: AssociatePhoneNumbersWithVoiceConnectorRequest.DslBuilder.() -> Unit) = associatePhoneNumbersWithVoiceConnector(AssociatePhoneNumbersWithVoiceConnectorRequest.builder().apply(block).build())

    /**
     * Associates phone numbers with the specified Amazon Chime Voice Connector group.
     */
    suspend fun associatePhoneNumbersWithVoiceConnectorGroup(input: AssociatePhoneNumbersWithVoiceConnectorGroupRequest): AssociatePhoneNumbersWithVoiceConnectorGroupResponse

    /**
     * Associates phone numbers with the specified Amazon Chime Voice Connector group.
     */
    suspend fun associatePhoneNumbersWithVoiceConnectorGroup(block: AssociatePhoneNumbersWithVoiceConnectorGroupRequest.DslBuilder.() -> Unit) = associatePhoneNumbersWithVoiceConnectorGroup(AssociatePhoneNumbersWithVoiceConnectorGroupRequest.builder().apply(block).build())

    /**
     * Associates the specified sign-in delegate groups with the specified Amazon Chime account.
     */
    suspend fun associateSigninDelegateGroupsWithAccount(input: AssociateSigninDelegateGroupsWithAccountRequest): AssociateSigninDelegateGroupsWithAccountResponse

    /**
     * Associates the specified sign-in delegate groups with the specified Amazon Chime account.
     */
    suspend fun associateSigninDelegateGroupsWithAccount(block: AssociateSigninDelegateGroupsWithAccountRequest.DslBuilder.() -> Unit) = associateSigninDelegateGroupsWithAccount(AssociateSigninDelegateGroupsWithAccountRequest.builder().apply(block).build())

    /**
     * Creates up to 100 new attendees for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see
     * <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK
     * in the
     * Amazon Chime Developer Guide.
     */
    suspend fun batchCreateAttendee(input: BatchCreateAttendeeRequest): BatchCreateAttendeeResponse

    /**
     * Creates up to 100 new attendees for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see
     * <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK
     * in the
     * Amazon Chime Developer Guide.
     */
    suspend fun batchCreateAttendee(block: BatchCreateAttendeeRequest.DslBuilder.() -> Unit) = batchCreateAttendee(BatchCreateAttendeeRequest.builder().apply(block).build())

    /**
     * Adds a specified number of users to a channel.
     */
    suspend fun batchCreateChannelMembership(input: BatchCreateChannelMembershipRequest): BatchCreateChannelMembershipResponse

    /**
     * Adds a specified number of users to a channel.
     */
    suspend fun batchCreateChannelMembership(block: BatchCreateChannelMembershipRequest.DslBuilder.() -> Unit) = batchCreateChannelMembership(BatchCreateChannelMembershipRequest.builder().apply(block).build())

    /**
     * Adds up to 50 members to a chat room in an Amazon Chime Enterprise account. Members can be users or bots. The member role designates whether the member is a chat room administrator or a general chat room member.
     */
    suspend fun batchCreateRoomMembership(input: BatchCreateRoomMembershipRequest): BatchCreateRoomMembershipResponse

    /**
     * Adds up to 50 members to a chat room in an Amazon Chime Enterprise account. Members can be users or bots. The member role designates whether the member is a chat room administrator or a general chat room member.
     */
    suspend fun batchCreateRoomMembership(block: BatchCreateRoomMembershipRequest.DslBuilder.() -> Unit) = batchCreateRoomMembership(BatchCreateRoomMembershipRequest.builder().apply(block).build())

    /**
     * Moves phone numbers into the
     * Deletion queue. Phone numbers must be disassociated from any users or Amazon Chime Voice Connectors before they can be deleted.
     * Phone numbers remain in the
     * Deletion queue for 7 days before they are deleted permanently.
     */
    suspend fun batchDeletePhoneNumber(input: BatchDeletePhoneNumberRequest): BatchDeletePhoneNumberResponse

    /**
     * Moves phone numbers into the
     * Deletion queue. Phone numbers must be disassociated from any users or Amazon Chime Voice Connectors before they can be deleted.
     * Phone numbers remain in the
     * Deletion queue for 7 days before they are deleted permanently.
     */
    suspend fun batchDeletePhoneNumber(block: BatchDeletePhoneNumberRequest.DslBuilder.() -> Unit) = batchDeletePhoneNumber(BatchDeletePhoneNumberRequest.builder().apply(block).build())

    /**
     * Suspends up to 50 users from a Team or EnterpriseLWA Amazon Chime
     * account. For more information about different account types, see <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime Accounts in the Amazon Chime Administration
     * Guide.
     * Users suspended from a Team account are disassociated from the account,but they
     * can continue to use Amazon Chime as free users. To remove the suspension from suspended
     * Team account users, invite them to the Team account again.
     * You can use the InviteUsers action to do so.
     * Users suspended from an EnterpriseLWA account are immediately signed out of
     * Amazon Chime and can no longer sign in. To remove the suspension from suspended EnterpriseLWA account users, use the BatchUnsuspendUser action.
     * To sign out users without suspending them, use the
     * LogoutUser
     * action.
     */
    suspend fun batchSuspendUser(input: BatchSuspendUserRequest): BatchSuspendUserResponse

    /**
     * Suspends up to 50 users from a Team or EnterpriseLWA Amazon Chime
     * account. For more information about different account types, see <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime Accounts in the Amazon Chime Administration
     * Guide.
     * Users suspended from a Team account are disassociated from the account,but they
     * can continue to use Amazon Chime as free users. To remove the suspension from suspended
     * Team account users, invite them to the Team account again.
     * You can use the InviteUsers action to do so.
     * Users suspended from an EnterpriseLWA account are immediately signed out of
     * Amazon Chime and can no longer sign in. To remove the suspension from suspended EnterpriseLWA account users, use the BatchUnsuspendUser action.
     * To sign out users without suspending them, use the
     * LogoutUser
     * action.
     */
    suspend fun batchSuspendUser(block: BatchSuspendUserRequest.DslBuilder.() -> Unit) = batchSuspendUser(BatchSuspendUserRequest.builder().apply(block).build())

    /**
     * Removes the suspension from up to 50 previously suspended users for the specified Amazon
     * Chime EnterpriseLWA account. Only users on EnterpriseLWA
     * accounts can be unsuspended using this action. For more information about different account types, see
     * <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">
     * Managing Your Amazon Chime Accounts
     * in the account types, in the Amazon Chime Administration Guide.
     * Previously suspended users who are unsuspended using this action are returned to
     * Registered
     * status. Users who are not previously suspended are ignored.
     */
    suspend fun batchUnsuspendUser(input: BatchUnsuspendUserRequest): BatchUnsuspendUserResponse

    /**
     * Removes the suspension from up to 50 previously suspended users for the specified Amazon
     * Chime EnterpriseLWA account. Only users on EnterpriseLWA
     * accounts can be unsuspended using this action. For more information about different account types, see
     * <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">
     * Managing Your Amazon Chime Accounts
     * in the account types, in the Amazon Chime Administration Guide.
     * Previously suspended users who are unsuspended using this action are returned to
     * Registered
     * status. Users who are not previously suspended are ignored.
     */
    suspend fun batchUnsuspendUser(block: BatchUnsuspendUserRequest.DslBuilder.() -> Unit) = batchUnsuspendUser(BatchUnsuspendUserRequest.builder().apply(block).build())

    /**
     * Updates phone number product types or calling names. You can update one attribute at a time for each UpdatePhoneNumberRequestItem. For example, you can update the product type or the calling name.
     * For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.
     * Updates to outbound calling names can take up to 72 hours to complete. Pending updates to outbound calling names must be complete before you can request another update.
     */
    suspend fun batchUpdatePhoneNumber(input: BatchUpdatePhoneNumberRequest): BatchUpdatePhoneNumberResponse

    /**
     * Updates phone number product types or calling names. You can update one attribute at a time for each UpdatePhoneNumberRequestItem. For example, you can update the product type or the calling name.
     * For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.
     * Updates to outbound calling names can take up to 72 hours to complete. Pending updates to outbound calling names must be complete before you can request another update.
     */
    suspend fun batchUpdatePhoneNumber(block: BatchUpdatePhoneNumberRequest.DslBuilder.() -> Unit) = batchUpdatePhoneNumber(BatchUpdatePhoneNumberRequest.builder().apply(block).build())

    /**
     * Updates user details within the UpdateUserRequestItem object for up to 20 users for the specified Amazon Chime account. Currently, only LicenseType updates are supported for this action.
     */
    suspend fun batchUpdateUser(input: BatchUpdateUserRequest): BatchUpdateUserResponse

    /**
     * Updates user details within the UpdateUserRequestItem object for up to 20 users for the specified Amazon Chime account. Currently, only LicenseType updates are supported for this action.
     */
    suspend fun batchUpdateUser(block: BatchUpdateUserRequest.DslBuilder.() -> Unit) = batchUpdateUser(BatchUpdateUserRequest.builder().apply(block).build())

    /**
     * Creates an Amazon Chime account under the administrator's AWS account. Only Team
     * account types are currently supported for this action. For more information about different account types, see
     * <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime Accounts in the Amazon Chime Administration Guide.
     */
    suspend fun createAccount(input: CreateAccountRequest): CreateAccountResponse

    /**
     * Creates an Amazon Chime account under the administrator's AWS account. Only Team
     * account types are currently supported for this action. For more information about different account types, see
     * <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime Accounts in the Amazon Chime Administration Guide.
     */
    suspend fun createAccount(block: CreateAccountRequest.DslBuilder.() -> Unit) = createAccount(CreateAccountRequest.builder().apply(block).build())

    /**
     * Creates an Amazon Chime SDK messaging AppInstance under an AWS account. Only SDK messaging customers use this API.
     * CreateAppInstance supports idempotency behavior as described in the AWS API Standard.
     */
    suspend fun createAppInstance(input: CreateAppInstanceRequest): CreateAppInstanceResponse

    /**
     * Creates an Amazon Chime SDK messaging AppInstance under an AWS account. Only SDK messaging customers use this API.
     * CreateAppInstance supports idempotency behavior as described in the AWS API Standard.
     */
    suspend fun createAppInstance(block: CreateAppInstanceRequest.DslBuilder.() -> Unit) = createAppInstance(CreateAppInstanceRequest.builder().apply(block).build())

    /**
     * Promotes an AppInstanceUser to an AppInstanceAdmin. The promoted user can perform the following actions.
     * ChannelModerator actions across all channels in the AppInstance.
     * DeleteChannelMessage actions.
     * Only an AppInstanceUser can be promoted to an AppInstanceAdmin role.
     */
    suspend fun createAppInstanceAdmin(input: CreateAppInstanceAdminRequest): CreateAppInstanceAdminResponse

    /**
     * Promotes an AppInstanceUser to an AppInstanceAdmin. The promoted user can perform the following actions.
     * ChannelModerator actions across all channels in the AppInstance.
     * DeleteChannelMessage actions.
     * Only an AppInstanceUser can be promoted to an AppInstanceAdmin role.
     */
    suspend fun createAppInstanceAdmin(block: CreateAppInstanceAdminRequest.DslBuilder.() -> Unit) = createAppInstanceAdmin(CreateAppInstanceAdminRequest.builder().apply(block).build())

    /**
     * Creates a user under an Amazon Chime AppInstance. The request consists of a unique appInstanceUserId and
     * Name for that user.
     */
    suspend fun createAppInstanceUser(input: CreateAppInstanceUserRequest): CreateAppInstanceUserResponse

    /**
     * Creates a user under an Amazon Chime AppInstance. The request consists of a unique appInstanceUserId and
     * Name for that user.
     */
    suspend fun createAppInstanceUser(block: CreateAppInstanceUserRequest.DslBuilder.() -> Unit) = createAppInstanceUser(CreateAppInstanceUserRequest.builder().apply(block).build())

    /**
     * Creates a new attendee for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see
     * <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK
     * in the
     * Amazon Chime Developer Guide.
     */
    suspend fun createAttendee(input: CreateAttendeeRequest): CreateAttendeeResponse

    /**
     * Creates a new attendee for an active Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see
     * <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK
     * in the
     * Amazon Chime Developer Guide.
     */
    suspend fun createAttendee(block: CreateAttendeeRequest.DslBuilder.() -> Unit) = createAttendee(CreateAttendeeRequest.builder().apply(block).build())

    /**
     * Creates a bot for an Amazon Chime Enterprise account.
     */
    suspend fun createBot(input: CreateBotRequest): CreateBotResponse

    /**
     * Creates a bot for an Amazon Chime Enterprise account.
     */
    suspend fun createBot(block: CreateBotRequest.DslBuilder.() -> Unit) = createBot(CreateBotRequest.builder().apply(block).build())

    /**
     * Creates a channel to which you can add users and send messages.
     * Restriction: You can't change a channel's
     * privacy.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun createChannel(input: CreateChannelRequest): CreateChannelResponse

    /**
     * Creates a channel to which you can add users and send messages.
     * Restriction: You can't change a channel's
     * privacy.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun createChannel(block: CreateChannelRequest.DslBuilder.() -> Unit) = createChannel(CreateChannelRequest.builder().apply(block).build())

    /**
     * Permanently bans a member from a channel. Moderators can't add banned members to a
     * channel. To undo a ban, you first have to DeleteChannelBan, and then
     * CreateChannelMembership. Bans are cleaned up when you delete users or
     * channels.
     * If you ban a user who is already part of a channel, that user is automatically kicked
     * from the channel.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun createChannelBan(input: CreateChannelBanRequest): CreateChannelBanResponse

    /**
     * Permanently bans a member from a channel. Moderators can't add banned members to a
     * channel. To undo a ban, you first have to DeleteChannelBan, and then
     * CreateChannelMembership. Bans are cleaned up when you delete users or
     * channels.
     * If you ban a user who is already part of a channel, that user is automatically kicked
     * from the channel.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun createChannelBan(block: CreateChannelBanRequest.DslBuilder.() -> Unit) = createChannelBan(CreateChannelBanRequest.builder().apply(block).build())

    /**
     * Adds a user to a channel. The InvitedBy response field is derived from the
     * request header. A channel member can:
     * List messages
     * Send messages
     * Receive messages
     * Edit their own messages
     * Leave the channel
     * Privacy settings impact this action as follows:
     * Public Channels: You do not need to be a member to list messages, but you must be
     * a member to send messages.
     * Private Channels: You must be a member to list or send messages.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun createChannelMembership(input: CreateChannelMembershipRequest): CreateChannelMembershipResponse

    /**
     * Adds a user to a channel. The InvitedBy response field is derived from the
     * request header. A channel member can:
     * List messages
     * Send messages
     * Receive messages
     * Edit their own messages
     * Leave the channel
     * Privacy settings impact this action as follows:
     * Public Channels: You do not need to be a member to list messages, but you must be
     * a member to send messages.
     * Private Channels: You must be a member to list or send messages.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun createChannelMembership(block: CreateChannelMembershipRequest.DslBuilder.() -> Unit) = createChannelMembership(CreateChannelMembershipRequest.builder().apply(block).build())

    /**
     * Creates a new ChannelModerator. A channel moderator can:
     * Add and remove other members of the channel.
     * Add and remove other moderators of the channel.
     * Add and remove user bans for the channel.
     * Redact messages in the channel.
     * List messages in the channel.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun createChannelModerator(input: CreateChannelModeratorRequest): CreateChannelModeratorResponse

    /**
     * Creates a new ChannelModerator. A channel moderator can:
     * Add and remove other members of the channel.
     * Add and remove other moderators of the channel.
     * Add and remove user bans for the channel.
     * Redact messages in the channel.
     * List messages in the channel.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun createChannelModerator(block: CreateChannelModeratorRequest.DslBuilder.() -> Unit) = createChannelModerator(CreateChannelModeratorRequest.builder().apply(block).build())

    /**
     * Creates a media capture pipeline.
     */
    suspend fun createMediaCapturePipeline(input: CreateMediaCapturePipelineRequest): CreateMediaCapturePipelineResponse

    /**
     * Creates a media capture pipeline.
     */
    suspend fun createMediaCapturePipeline(block: CreateMediaCapturePipelineRequest.DslBuilder.() -> Unit) = createMediaCapturePipeline(CreateMediaCapturePipelineRequest.builder().apply(block).build())

    /**
     * Creates a new Amazon Chime SDK meeting in the specified media Region with no initial attendees. For more information about specifying media Regions, see
     * <a href="https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html">Amazon Chime SDK Media Regions
     * in the
     * Amazon Chime Developer Guide
     * . For more information about the Amazon Chime SDK, see
     * <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK
     * in the
     * Amazon Chime Developer Guide
     * .
     */
    suspend fun createMeeting(input: CreateMeetingRequest): CreateMeetingResponse

    /**
     * Creates a new Amazon Chime SDK meeting in the specified media Region with no initial attendees. For more information about specifying media Regions, see
     * <a href="https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html">Amazon Chime SDK Media Regions
     * in the
     * Amazon Chime Developer Guide
     * . For more information about the Amazon Chime SDK, see
     * <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK
     * in the
     * Amazon Chime Developer Guide
     * .
     */
    suspend fun createMeeting(block: CreateMeetingRequest.DslBuilder.() -> Unit) = createMeeting(CreateMeetingRequest.builder().apply(block).build())

    /**
     * Uses the join token and call metadata in a meeting request (From number, To number, and so forth) to initiate an outbound call to a public
     * switched telephone network (PSTN) and join them into a Chime meeting. Also ensures that the From number belongs to the customer.
     * To play welcome audio or implement an interactive voice response (IVR), use the
     * CreateSipMediaApplicationCall action with the corresponding SIP media application ID.
     */
    suspend fun createMeetingDialOut(input: CreateMeetingDialOutRequest): CreateMeetingDialOutResponse

    /**
     * Uses the join token and call metadata in a meeting request (From number, To number, and so forth) to initiate an outbound call to a public
     * switched telephone network (PSTN) and join them into a Chime meeting. Also ensures that the From number belongs to the customer.
     * To play welcome audio or implement an interactive voice response (IVR), use the
     * CreateSipMediaApplicationCall action with the corresponding SIP media application ID.
     */
    suspend fun createMeetingDialOut(block: CreateMeetingDialOutRequest.DslBuilder.() -> Unit) = createMeetingDialOut(CreateMeetingDialOutRequest.builder().apply(block).build())

    /**
     * Creates a new Amazon Chime SDK meeting in the specified media Region, with attendees. For more information about specifying media Regions, see
     * <a href="https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html">Amazon Chime SDK Media Regions
     * in the
     * Amazon Chime Developer Guide
     * . For more information about the Amazon Chime SDK, see
     * <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK
     * in the
     * Amazon Chime Developer Guide
     * .
     */
    suspend fun createMeetingWithAttendees(input: CreateMeetingWithAttendeesRequest): CreateMeetingWithAttendeesResponse

    /**
     * Creates a new Amazon Chime SDK meeting in the specified media Region, with attendees. For more information about specifying media Regions, see
     * <a href="https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html">Amazon Chime SDK Media Regions
     * in the
     * Amazon Chime Developer Guide
     * . For more information about the Amazon Chime SDK, see
     * <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK
     * in the
     * Amazon Chime Developer Guide
     * .
     */
    suspend fun createMeetingWithAttendees(block: CreateMeetingWithAttendeesRequest.DslBuilder.() -> Unit) = createMeetingWithAttendees(CreateMeetingWithAttendeesRequest.builder().apply(block).build())

    /**
     * Creates an order for phone numbers to be provisioned. For toll-free numbers, you cannot use the Amazon Chime Business Calling product type.
     * For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.
     */
    suspend fun createPhoneNumberOrder(input: CreatePhoneNumberOrderRequest): CreatePhoneNumberOrderResponse

    /**
     * Creates an order for phone numbers to be provisioned. For toll-free numbers, you cannot use the Amazon Chime Business Calling product type.
     * For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.
     */
    suspend fun createPhoneNumberOrder(block: CreatePhoneNumberOrderRequest.DslBuilder.() -> Unit) = createPhoneNumberOrder(CreatePhoneNumberOrderRequest.builder().apply(block).build())

    /**
     * Creates a proxy session on the specified Amazon Chime Voice Connector for the specified participant phone numbers.
     */
    suspend fun createProxySession(input: CreateProxySessionRequest): CreateProxySessionResponse

    /**
     * Creates a proxy session on the specified Amazon Chime Voice Connector for the specified participant phone numbers.
     */
    suspend fun createProxySession(block: CreateProxySessionRequest.DslBuilder.() -> Unit) = createProxySession(CreateProxySessionRequest.builder().apply(block).build())

    /**
     * Creates a chat room for the specified Amazon Chime Enterprise account.
     */
    suspend fun createRoom(input: CreateRoomRequest): CreateRoomResponse

    /**
     * Creates a chat room for the specified Amazon Chime Enterprise account.
     */
    suspend fun createRoom(block: CreateRoomRequest.DslBuilder.() -> Unit) = createRoom(CreateRoomRequest.builder().apply(block).build())

    /**
     * Adds a member to a chat room in an Amazon Chime Enterprise account. A member can be either a user or a bot. The member role designates whether the member is a chat room administrator or a general chat room member.
     */
    suspend fun createRoomMembership(input: CreateRoomMembershipRequest): CreateRoomMembershipResponse

    /**
     * Adds a member to a chat room in an Amazon Chime Enterprise account. A member can be either a user or a bot. The member role designates whether the member is a chat room administrator or a general chat room member.
     */
    suspend fun createRoomMembership(block: CreateRoomMembershipRequest.DslBuilder.() -> Unit) = createRoomMembership(CreateRoomMembershipRequest.builder().apply(block).build())

    /**
     * Creates a SIP media application.
     */
    suspend fun createSipMediaApplication(input: CreateSipMediaApplicationRequest): CreateSipMediaApplicationResponse

    /**
     * Creates a SIP media application.
     */
    suspend fun createSipMediaApplication(block: CreateSipMediaApplicationRequest.DslBuilder.() -> Unit) = createSipMediaApplication(CreateSipMediaApplicationRequest.builder().apply(block).build())

    /**
     * Creates an outbound call to a phone number from the phone number specified in the request, and it invokes the endpoint of the specified
     * sipMediaApplicationId.
     */
    suspend fun createSipMediaApplicationCall(input: CreateSipMediaApplicationCallRequest): CreateSipMediaApplicationCallResponse

    /**
     * Creates an outbound call to a phone number from the phone number specified in the request, and it invokes the endpoint of the specified
     * sipMediaApplicationId.
     */
    suspend fun createSipMediaApplicationCall(block: CreateSipMediaApplicationCallRequest.DslBuilder.() -> Unit) = createSipMediaApplicationCall(CreateSipMediaApplicationCallRequest.builder().apply(block).build())

    /**
     * Creates a SIP rule which can be used to run a SIP media application as a target for a specific trigger type.
     */
    suspend fun createSipRule(input: CreateSipRuleRequest): CreateSipRuleResponse

    /**
     * Creates a SIP rule which can be used to run a SIP media application as a target for a specific trigger type.
     */
    suspend fun createSipRule(block: CreateSipRuleRequest.DslBuilder.() -> Unit) = createSipRule(CreateSipRuleRequest.builder().apply(block).build())

    /**
     * Creates a user under the specified Amazon Chime account.
     */
    suspend fun createUser(input: CreateUserRequest): CreateUserResponse

    /**
     * Creates a user under the specified Amazon Chime account.
     */
    suspend fun createUser(block: CreateUserRequest.DslBuilder.() -> Unit) = createUser(CreateUserRequest.builder().apply(block).build())

    /**
     * Creates an Amazon Chime Voice Connector under the administrator's AWS account. You can choose to create an Amazon Chime Voice Connector in a specific AWS Region.
     * Enabling
     * CreateVoiceConnectorRequest$RequireEncryption
     * configures your Amazon Chime Voice Connector to use TLS transport for SIP signaling and Secure RTP (SRTP) for media. Inbound calls use TLS transport, and unencrypted outbound calls are blocked.
     */
    suspend fun createVoiceConnector(input: CreateVoiceConnectorRequest): CreateVoiceConnectorResponse

    /**
     * Creates an Amazon Chime Voice Connector under the administrator's AWS account. You can choose to create an Amazon Chime Voice Connector in a specific AWS Region.
     * Enabling
     * CreateVoiceConnectorRequest$RequireEncryption
     * configures your Amazon Chime Voice Connector to use TLS transport for SIP signaling and Secure RTP (SRTP) for media. Inbound calls use TLS transport, and unencrypted outbound calls are blocked.
     */
    suspend fun createVoiceConnector(block: CreateVoiceConnectorRequest.DslBuilder.() -> Unit) = createVoiceConnector(CreateVoiceConnectorRequest.builder().apply(block).build())

    /**
     * Creates an Amazon Chime Voice Connector group under the administrator's AWS account. You can
     * associate Amazon Chime Voice Connectors with the Amazon Chime Voice Connector group by
     * including VoiceConnectorItems in the request.
     * You can include Amazon Chime Voice Connectors from different AWS Regions in your group. This
     * creates a fault tolerant mechanism for fallback in case of availability events.
     */
    suspend fun createVoiceConnectorGroup(input: CreateVoiceConnectorGroupRequest): CreateVoiceConnectorGroupResponse

    /**
     * Creates an Amazon Chime Voice Connector group under the administrator's AWS account. You can
     * associate Amazon Chime Voice Connectors with the Amazon Chime Voice Connector group by
     * including VoiceConnectorItems in the request.
     * You can include Amazon Chime Voice Connectors from different AWS Regions in your group. This
     * creates a fault tolerant mechanism for fallback in case of availability events.
     */
    suspend fun createVoiceConnectorGroup(block: CreateVoiceConnectorGroupRequest.DslBuilder.() -> Unit) = createVoiceConnectorGroup(CreateVoiceConnectorGroupRequest.builder().apply(block).build())

    /**
     * Deletes the specified Amazon Chime account. You must suspend all users before deleting
     * Team account. You can use the BatchSuspendUser action
     * to dodo.
     * For EnterpriseLWA and EnterpriseAD accounts, you must release the
     * claimed domains for your Amazon Chime account before deletion. As soon as you release
     * the domain, all users under that account are suspended.
     * Deleted accounts appear in your Disabled accounts list for 90 days. To restore
     * deleted account from your Disabled accounts list, you must contact AWS
     * Support.
     * After 90 days, deleted accounts are permanently removed from your
     * Disabled accounts list.
     */
    suspend fun deleteAccount(input: DeleteAccountRequest): DeleteAccountResponse

    /**
     * Deletes the specified Amazon Chime account. You must suspend all users before deleting
     * Team account. You can use the BatchSuspendUser action
     * to dodo.
     * For EnterpriseLWA and EnterpriseAD accounts, you must release the
     * claimed domains for your Amazon Chime account before deletion. As soon as you release
     * the domain, all users under that account are suspended.
     * Deleted accounts appear in your Disabled accounts list for 90 days. To restore
     * deleted account from your Disabled accounts list, you must contact AWS
     * Support.
     * After 90 days, deleted accounts are permanently removed from your
     * Disabled accounts list.
     */
    suspend fun deleteAccount(block: DeleteAccountRequest.DslBuilder.() -> Unit) = deleteAccount(DeleteAccountRequest.builder().apply(block).build())

    /**
     * Deletes an AppInstance and all associated data asynchronously.
     */
    suspend fun deleteAppInstance(input: DeleteAppInstanceRequest): DeleteAppInstanceResponse

    /**
     * Deletes an AppInstance and all associated data asynchronously.
     */
    suspend fun deleteAppInstance(block: DeleteAppInstanceRequest.DslBuilder.() -> Unit) = deleteAppInstance(DeleteAppInstanceRequest.builder().apply(block).build())

    /**
     * Demotes an AppInstanceAdmin to an AppInstanceUser. This action does not delete the user.
     */
    suspend fun deleteAppInstanceAdmin(input: DeleteAppInstanceAdminRequest): DeleteAppInstanceAdminResponse

    /**
     * Demotes an AppInstanceAdmin to an AppInstanceUser. This action does not delete the user.
     */
    suspend fun deleteAppInstanceAdmin(block: DeleteAppInstanceAdminRequest.DslBuilder.() -> Unit) = deleteAppInstanceAdmin(DeleteAppInstanceAdminRequest.builder().apply(block).build())

    /**
     * Deletes the streaming configurations of an AppInstance.
     */
    suspend fun deleteAppInstanceStreamingConfigurations(input: DeleteAppInstanceStreamingConfigurationsRequest): DeleteAppInstanceStreamingConfigurationsResponse

    /**
     * Deletes the streaming configurations of an AppInstance.
     */
    suspend fun deleteAppInstanceStreamingConfigurations(block: DeleteAppInstanceStreamingConfigurationsRequest.DslBuilder.() -> Unit) = deleteAppInstanceStreamingConfigurations(DeleteAppInstanceStreamingConfigurationsRequest.builder().apply(block).build())

    /**
     * Deletes an AppInstanceUser.
     */
    suspend fun deleteAppInstanceUser(input: DeleteAppInstanceUserRequest): DeleteAppInstanceUserResponse

    /**
     * Deletes an AppInstanceUser.
     */
    suspend fun deleteAppInstanceUser(block: DeleteAppInstanceUserRequest.DslBuilder.() -> Unit) = deleteAppInstanceUser(DeleteAppInstanceUserRequest.builder().apply(block).build())

    /**
     * Deletes an attendee from the specified Amazon Chime SDK meeting and deletes their
     * JoinToken. Attendees are automatically deleted when a Amazon Chime SDK meeting is deleted. For more information about the Amazon Chime SDK, see
     * <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK
     * in the Amazon Chime Developer Guide.
     */
    suspend fun deleteAttendee(input: DeleteAttendeeRequest): DeleteAttendeeResponse

    /**
     * Deletes an attendee from the specified Amazon Chime SDK meeting and deletes their
     * JoinToken. Attendees are automatically deleted when a Amazon Chime SDK meeting is deleted. For more information about the Amazon Chime SDK, see
     * <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK
     * in the Amazon Chime Developer Guide.
     */
    suspend fun deleteAttendee(block: DeleteAttendeeRequest.DslBuilder.() -> Unit) = deleteAttendee(DeleteAttendeeRequest.builder().apply(block).build())

    /**
     * Immediately makes a channel and its memberships inaccessible and marks them for
     * deletion. This is an irreversible process.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun deleteChannel(input: DeleteChannelRequest): DeleteChannelResponse

    /**
     * Immediately makes a channel and its memberships inaccessible and marks them for
     * deletion. This is an irreversible process.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun deleteChannel(block: DeleteChannelRequest.DslBuilder.() -> Unit) = deleteChannel(DeleteChannelRequest.builder().apply(block).build())

    /**
     * Removes a user from a channel's ban list.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun deleteChannelBan(input: DeleteChannelBanRequest): DeleteChannelBanResponse

    /**
     * Removes a user from a channel's ban list.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun deleteChannelBan(block: DeleteChannelBanRequest.DslBuilder.() -> Unit) = deleteChannelBan(DeleteChannelBanRequest.builder().apply(block).build())

    /**
     * Removes a member from a channel.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun deleteChannelMembership(input: DeleteChannelMembershipRequest): DeleteChannelMembershipResponse

    /**
     * Removes a member from a channel.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun deleteChannelMembership(block: DeleteChannelMembershipRequest.DslBuilder.() -> Unit) = deleteChannelMembership(DeleteChannelMembershipRequest.builder().apply(block).build())

    /**
     * Deletes a channel message. Only admins can perform this action. Deletion makes messages
     * inaccessible immediately. A background process deletes any revisions created by
     * UpdateChannelMessage.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun deleteChannelMessage(input: DeleteChannelMessageRequest): DeleteChannelMessageResponse

    /**
     * Deletes a channel message. Only admins can perform this action. Deletion makes messages
     * inaccessible immediately. A background process deletes any revisions created by
     * UpdateChannelMessage.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun deleteChannelMessage(block: DeleteChannelMessageRequest.DslBuilder.() -> Unit) = deleteChannelMessage(DeleteChannelMessageRequest.builder().apply(block).build())

    /**
     * Deletes a channel moderator.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun deleteChannelModerator(input: DeleteChannelModeratorRequest): DeleteChannelModeratorResponse

    /**
     * Deletes a channel moderator.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun deleteChannelModerator(block: DeleteChannelModeratorRequest.DslBuilder.() -> Unit) = deleteChannelModerator(DeleteChannelModeratorRequest.builder().apply(block).build())

    /**
     * Deletes the events configuration that allows a bot to receive outgoing events.
     */
    suspend fun deleteEventsConfiguration(input: DeleteEventsConfigurationRequest): DeleteEventsConfigurationResponse

    /**
     * Deletes the events configuration that allows a bot to receive outgoing events.
     */
    suspend fun deleteEventsConfiguration(block: DeleteEventsConfigurationRequest.DslBuilder.() -> Unit) = deleteEventsConfiguration(DeleteEventsConfigurationRequest.builder().apply(block).build())

    /**
     * Deletes the media capture pipeline.
     */
    suspend fun deleteMediaCapturePipeline(input: DeleteMediaCapturePipelineRequest): DeleteMediaCapturePipelineResponse

    /**
     * Deletes the media capture pipeline.
     */
    suspend fun deleteMediaCapturePipeline(block: DeleteMediaCapturePipelineRequest.DslBuilder.() -> Unit) = deleteMediaCapturePipeline(DeleteMediaCapturePipelineRequest.builder().apply(block).build())

    /**
     * Deletes the specified Amazon Chime SDK meeting. The operation deletes all attendees, disconnects all clients, and prevents new clients from
     * joining the meeting. For more information about the Amazon Chime SDK, see
     * <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK in the
     * Amazon Chime Developer Guide.
     */
    suspend fun deleteMeeting(input: DeleteMeetingRequest): DeleteMeetingResponse

    /**
     * Deletes the specified Amazon Chime SDK meeting. The operation deletes all attendees, disconnects all clients, and prevents new clients from
     * joining the meeting. For more information about the Amazon Chime SDK, see
     * <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK in the
     * Amazon Chime Developer Guide.
     */
    suspend fun deleteMeeting(block: DeleteMeetingRequest.DslBuilder.() -> Unit) = deleteMeeting(DeleteMeetingRequest.builder().apply(block).build())

    /**
     * Moves the specified phone number into the Deletion queue. A
     * phone number must be disassociated from any users or Amazon Chime Voice Connectors
     * before it can be deleted.
     * Deleted phone numbers remain in the
     * Deletion queue
     * for 7 days before they are deleted permanently.
     */
    suspend fun deletePhoneNumber(input: DeletePhoneNumberRequest): DeletePhoneNumberResponse

    /**
     * Moves the specified phone number into the Deletion queue. A
     * phone number must be disassociated from any users or Amazon Chime Voice Connectors
     * before it can be deleted.
     * Deleted phone numbers remain in the
     * Deletion queue
     * for 7 days before they are deleted permanently.
     */
    suspend fun deletePhoneNumber(block: DeletePhoneNumberRequest.DslBuilder.() -> Unit) = deletePhoneNumber(DeletePhoneNumberRequest.builder().apply(block).build())

    /**
     * Deletes the specified proxy session from the specified Amazon Chime Voice Connector.
     */
    suspend fun deleteProxySession(input: DeleteProxySessionRequest): DeleteProxySessionResponse

    /**
     * Deletes the specified proxy session from the specified Amazon Chime Voice Connector.
     */
    suspend fun deleteProxySession(block: DeleteProxySessionRequest.DslBuilder.() -> Unit) = deleteProxySession(DeleteProxySessionRequest.builder().apply(block).build())

    /**
     * Deletes a chat room in an Amazon Chime Enterprise account.
     */
    suspend fun deleteRoom(input: DeleteRoomRequest): DeleteRoomResponse

    /**
     * Deletes a chat room in an Amazon Chime Enterprise account.
     */
    suspend fun deleteRoom(block: DeleteRoomRequest.DslBuilder.() -> Unit) = deleteRoom(DeleteRoomRequest.builder().apply(block).build())

    /**
     * Removes a member from a chat room in an Amazon Chime Enterprise account.
     */
    suspend fun deleteRoomMembership(input: DeleteRoomMembershipRequest): DeleteRoomMembershipResponse

    /**
     * Removes a member from a chat room in an Amazon Chime Enterprise account.
     */
    suspend fun deleteRoomMembership(block: DeleteRoomMembershipRequest.DslBuilder.() -> Unit) = deleteRoomMembership(DeleteRoomMembershipRequest.builder().apply(block).build())

    /**
     * Deletes a SIP media application.
     */
    suspend fun deleteSipMediaApplication(input: DeleteSipMediaApplicationRequest): DeleteSipMediaApplicationResponse

    /**
     * Deletes a SIP media application.
     */
    suspend fun deleteSipMediaApplication(block: DeleteSipMediaApplicationRequest.DslBuilder.() -> Unit) = deleteSipMediaApplication(DeleteSipMediaApplicationRequest.builder().apply(block).build())

    /**
     * Deletes a SIP rule. You must disable a SIP rule before you can delete it.
     */
    suspend fun deleteSipRule(input: DeleteSipRuleRequest): DeleteSipRuleResponse

    /**
     * Deletes a SIP rule. You must disable a SIP rule before you can delete it.
     */
    suspend fun deleteSipRule(block: DeleteSipRuleRequest.DslBuilder.() -> Unit) = deleteSipRule(DeleteSipRuleRequest.builder().apply(block).build())

    /**
     * Deletes the specified Amazon Chime Voice Connector. Any phone numbers associated with the
     * Amazon Chime Voice Connector must be disassociated from it before it can be
     * deleted.
     */
    suspend fun deleteVoiceConnector(input: DeleteVoiceConnectorRequest): DeleteVoiceConnectorResponse

    /**
     * Deletes the specified Amazon Chime Voice Connector. Any phone numbers associated with the
     * Amazon Chime Voice Connector must be disassociated from it before it can be
     * deleted.
     */
    suspend fun deleteVoiceConnector(block: DeleteVoiceConnectorRequest.DslBuilder.() -> Unit) = deleteVoiceConnector(DeleteVoiceConnectorRequest.builder().apply(block).build())

    /**
     * Deletes the emergency calling configuration details from the specified Amazon Chime Voice Connector.
     */
    suspend fun deleteVoiceConnectorEmergencyCallingConfiguration(input: DeleteVoiceConnectorEmergencyCallingConfigurationRequest): DeleteVoiceConnectorEmergencyCallingConfigurationResponse

    /**
     * Deletes the emergency calling configuration details from the specified Amazon Chime Voice Connector.
     */
    suspend fun deleteVoiceConnectorEmergencyCallingConfiguration(block: DeleteVoiceConnectorEmergencyCallingConfigurationRequest.DslBuilder.() -> Unit) = deleteVoiceConnectorEmergencyCallingConfiguration(DeleteVoiceConnectorEmergencyCallingConfigurationRequest.builder().apply(block).build())

    /**
     * Deletes the specified Amazon Chime Voice Connector group. Any
     * VoiceConnectorItems
     * and phone numbers associated with the group must be removed before it can be deleted.
     */
    suspend fun deleteVoiceConnectorGroup(input: DeleteVoiceConnectorGroupRequest): DeleteVoiceConnectorGroupResponse

    /**
     * Deletes the specified Amazon Chime Voice Connector group. Any
     * VoiceConnectorItems
     * and phone numbers associated with the group must be removed before it can be deleted.
     */
    suspend fun deleteVoiceConnectorGroup(block: DeleteVoiceConnectorGroupRequest.DslBuilder.() -> Unit) = deleteVoiceConnectorGroup(DeleteVoiceConnectorGroupRequest.builder().apply(block).build())

    /**
     * Deletes the origination settings for the specified Amazon Chime Voice Connector.
     * If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to deleting the origination settings.
     */
    suspend fun deleteVoiceConnectorOrigination(input: DeleteVoiceConnectorOriginationRequest): DeleteVoiceConnectorOriginationResponse

    /**
     * Deletes the origination settings for the specified Amazon Chime Voice Connector.
     * If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to deleting the origination settings.
     */
    suspend fun deleteVoiceConnectorOrigination(block: DeleteVoiceConnectorOriginationRequest.DslBuilder.() -> Unit) = deleteVoiceConnectorOrigination(DeleteVoiceConnectorOriginationRequest.builder().apply(block).build())

    /**
     * Deletes the proxy configuration from the specified Amazon Chime Voice Connector.
     */
    suspend fun deleteVoiceConnectorProxy(input: DeleteVoiceConnectorProxyRequest): DeleteVoiceConnectorProxyResponse

    /**
     * Deletes the proxy configuration from the specified Amazon Chime Voice Connector.
     */
    suspend fun deleteVoiceConnectorProxy(block: DeleteVoiceConnectorProxyRequest.DslBuilder.() -> Unit) = deleteVoiceConnectorProxy(DeleteVoiceConnectorProxyRequest.builder().apply(block).build())

    /**
     * Deletes the streaming configuration for the specified Amazon Chime Voice Connector.
     */
    suspend fun deleteVoiceConnectorStreamingConfiguration(input: DeleteVoiceConnectorStreamingConfigurationRequest): DeleteVoiceConnectorStreamingConfigurationResponse

    /**
     * Deletes the streaming configuration for the specified Amazon Chime Voice Connector.
     */
    suspend fun deleteVoiceConnectorStreamingConfiguration(block: DeleteVoiceConnectorStreamingConfigurationRequest.DslBuilder.() -> Unit) = deleteVoiceConnectorStreamingConfiguration(DeleteVoiceConnectorStreamingConfigurationRequest.builder().apply(block).build())

    /**
     * Deletes the termination settings for the specified Amazon Chime Voice Connector.
     * If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to deleting the termination settings.
     */
    suspend fun deleteVoiceConnectorTermination(input: DeleteVoiceConnectorTerminationRequest): DeleteVoiceConnectorTerminationResponse

    /**
     * Deletes the termination settings for the specified Amazon Chime Voice Connector.
     * If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to deleting the termination settings.
     */
    suspend fun deleteVoiceConnectorTermination(block: DeleteVoiceConnectorTerminationRequest.DslBuilder.() -> Unit) = deleteVoiceConnectorTermination(DeleteVoiceConnectorTerminationRequest.builder().apply(block).build())

    /**
     * Deletes the specified SIP credentials used by your equipment to authenticate during call termination.
     */
    suspend fun deleteVoiceConnectorTerminationCredentials(input: DeleteVoiceConnectorTerminationCredentialsRequest): DeleteVoiceConnectorTerminationCredentialsResponse

    /**
     * Deletes the specified SIP credentials used by your equipment to authenticate during call termination.
     */
    suspend fun deleteVoiceConnectorTerminationCredentials(block: DeleteVoiceConnectorTerminationCredentialsRequest.DslBuilder.() -> Unit) = deleteVoiceConnectorTerminationCredentials(DeleteVoiceConnectorTerminationCredentialsRequest.builder().apply(block).build())

    /**
     * Returns the full details of an AppInstance.
     */
    suspend fun describeAppInstance(input: DescribeAppInstanceRequest): DescribeAppInstanceResponse

    /**
     * Returns the full details of an AppInstance.
     */
    suspend fun describeAppInstance(block: DescribeAppInstanceRequest.DslBuilder.() -> Unit) = describeAppInstance(DescribeAppInstanceRequest.builder().apply(block).build())

    /**
     * Returns the full details of an AppInstanceAdmin.
     */
    suspend fun describeAppInstanceAdmin(input: DescribeAppInstanceAdminRequest): DescribeAppInstanceAdminResponse

    /**
     * Returns the full details of an AppInstanceAdmin.
     */
    suspend fun describeAppInstanceAdmin(block: DescribeAppInstanceAdminRequest.DslBuilder.() -> Unit) = describeAppInstanceAdmin(DescribeAppInstanceAdminRequest.builder().apply(block).build())

    /**
     * Returns the full details of an AppInstanceUser.
     */
    suspend fun describeAppInstanceUser(input: DescribeAppInstanceUserRequest): DescribeAppInstanceUserResponse

    /**
     * Returns the full details of an AppInstanceUser.
     */
    suspend fun describeAppInstanceUser(block: DescribeAppInstanceUserRequest.DslBuilder.() -> Unit) = describeAppInstanceUser(DescribeAppInstanceUserRequest.builder().apply(block).build())

    /**
     * Returns the full details of a channel in an Amazon Chime
     * AppInstance.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun describeChannel(input: DescribeChannelRequest): DescribeChannelResponse

    /**
     * Returns the full details of a channel in an Amazon Chime
     * AppInstance.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun describeChannel(block: DescribeChannelRequest.DslBuilder.() -> Unit) = describeChannel(DescribeChannelRequest.builder().apply(block).build())

    /**
     * Returns the full details of a channel ban.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun describeChannelBan(input: DescribeChannelBanRequest): DescribeChannelBanResponse

    /**
     * Returns the full details of a channel ban.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun describeChannelBan(block: DescribeChannelBanRequest.DslBuilder.() -> Unit) = describeChannelBan(DescribeChannelBanRequest.builder().apply(block).build())

    /**
     * Returns the full details of a user's channel membership.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun describeChannelMembership(input: DescribeChannelMembershipRequest): DescribeChannelMembershipResponse

    /**
     * Returns the full details of a user's channel membership.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun describeChannelMembership(block: DescribeChannelMembershipRequest.DslBuilder.() -> Unit) = describeChannelMembership(DescribeChannelMembershipRequest.builder().apply(block).build())

    /**
     * Returns the details of a channel based on the membership of the specified
     * AppInstanceUser.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun describeChannelMembershipForAppInstanceUser(input: DescribeChannelMembershipForAppInstanceUserRequest): DescribeChannelMembershipForAppInstanceUserResponse

    /**
     * Returns the details of a channel based on the membership of the specified
     * AppInstanceUser.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun describeChannelMembershipForAppInstanceUser(block: DescribeChannelMembershipForAppInstanceUserRequest.DslBuilder.() -> Unit) = describeChannelMembershipForAppInstanceUser(DescribeChannelMembershipForAppInstanceUserRequest.builder().apply(block).build())

    /**
     * Returns the full details of a channel moderated by the specified
     * AppInstanceUser.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun describeChannelModeratedByAppInstanceUser(input: DescribeChannelModeratedByAppInstanceUserRequest): DescribeChannelModeratedByAppInstanceUserResponse

    /**
     * Returns the full details of a channel moderated by the specified
     * AppInstanceUser.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun describeChannelModeratedByAppInstanceUser(block: DescribeChannelModeratedByAppInstanceUserRequest.DslBuilder.() -> Unit) = describeChannelModeratedByAppInstanceUser(DescribeChannelModeratedByAppInstanceUserRequest.builder().apply(block).build())

    /**
     * Returns the full details of a single ChannelModerator.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun describeChannelModerator(input: DescribeChannelModeratorRequest): DescribeChannelModeratorResponse

    /**
     * Returns the full details of a single ChannelModerator.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun describeChannelModerator(block: DescribeChannelModeratorRequest.DslBuilder.() -> Unit) = describeChannelModerator(DescribeChannelModeratorRequest.builder().apply(block).build())

    /**
     * Disassociates the primary provisioned phone number from the specified Amazon Chime user.
     */
    suspend fun disassociatePhoneNumberFromUser(input: DisassociatePhoneNumberFromUserRequest): DisassociatePhoneNumberFromUserResponse

    /**
     * Disassociates the primary provisioned phone number from the specified Amazon Chime user.
     */
    suspend fun disassociatePhoneNumberFromUser(block: DisassociatePhoneNumberFromUserRequest.DslBuilder.() -> Unit) = disassociatePhoneNumberFromUser(DisassociatePhoneNumberFromUserRequest.builder().apply(block).build())

    /**
     * Disassociates the specified phone numbers from the specified Amazon Chime Voice Connector.
     */
    suspend fun disassociatePhoneNumbersFromVoiceConnector(input: DisassociatePhoneNumbersFromVoiceConnectorRequest): DisassociatePhoneNumbersFromVoiceConnectorResponse

    /**
     * Disassociates the specified phone numbers from the specified Amazon Chime Voice Connector.
     */
    suspend fun disassociatePhoneNumbersFromVoiceConnector(block: DisassociatePhoneNumbersFromVoiceConnectorRequest.DslBuilder.() -> Unit) = disassociatePhoneNumbersFromVoiceConnector(DisassociatePhoneNumbersFromVoiceConnectorRequest.builder().apply(block).build())

    /**
     * Disassociates the specified phone numbers from the specified Amazon Chime Voice Connector group.
     */
    suspend fun disassociatePhoneNumbersFromVoiceConnectorGroup(input: DisassociatePhoneNumbersFromVoiceConnectorGroupRequest): DisassociatePhoneNumbersFromVoiceConnectorGroupResponse

    /**
     * Disassociates the specified phone numbers from the specified Amazon Chime Voice Connector group.
     */
    suspend fun disassociatePhoneNumbersFromVoiceConnectorGroup(block: DisassociatePhoneNumbersFromVoiceConnectorGroupRequest.DslBuilder.() -> Unit) = disassociatePhoneNumbersFromVoiceConnectorGroup(DisassociatePhoneNumbersFromVoiceConnectorGroupRequest.builder().apply(block).build())

    /**
     * Disassociates the specified sign-in delegate groups from the specified Amazon Chime account.
     */
    suspend fun disassociateSigninDelegateGroupsFromAccount(input: DisassociateSigninDelegateGroupsFromAccountRequest): DisassociateSigninDelegateGroupsFromAccountResponse

    /**
     * Disassociates the specified sign-in delegate groups from the specified Amazon Chime account.
     */
    suspend fun disassociateSigninDelegateGroupsFromAccount(block: DisassociateSigninDelegateGroupsFromAccountRequest.DslBuilder.() -> Unit) = disassociateSigninDelegateGroupsFromAccount(DisassociateSigninDelegateGroupsFromAccountRequest.builder().apply(block).build())

    /**
     * Retrieves details for the specified Amazon Chime account, such as account type and supported
     * licenses.
     */
    suspend fun getAccount(input: GetAccountRequest): GetAccountResponse

    /**
     * Retrieves details for the specified Amazon Chime account, such as account type and supported
     * licenses.
     */
    suspend fun getAccount(block: GetAccountRequest.DslBuilder.() -> Unit) = getAccount(GetAccountRequest.builder().apply(block).build())

    /**
     * Retrieves account settings for the specified Amazon Chime account ID, such as remote control
     * and dialout settings. For more information about these settings, see
     * <a href="https://docs.aws.amazon.com/chime/latest/ag/policies.html">Use the Policies Page in the Amazon Chime Administration Guide.
     */
    suspend fun getAccountSettings(input: GetAccountSettingsRequest): GetAccountSettingsResponse

    /**
     * Retrieves account settings for the specified Amazon Chime account ID, such as remote control
     * and dialout settings. For more information about these settings, see
     * <a href="https://docs.aws.amazon.com/chime/latest/ag/policies.html">Use the Policies Page in the Amazon Chime Administration Guide.
     */
    suspend fun getAccountSettings(block: GetAccountSettingsRequest.DslBuilder.() -> Unit) = getAccountSettings(GetAccountSettingsRequest.builder().apply(block).build())

    /**
     * Gets the retention settings for an AppInstance.
     */
    suspend fun getAppInstanceRetentionSettings(input: GetAppInstanceRetentionSettingsRequest): GetAppInstanceRetentionSettingsResponse

    /**
     * Gets the retention settings for an AppInstance.
     */
    suspend fun getAppInstanceRetentionSettings(block: GetAppInstanceRetentionSettingsRequest.DslBuilder.() -> Unit) = getAppInstanceRetentionSettings(GetAppInstanceRetentionSettingsRequest.builder().apply(block).build())

    /**
     * Gets the streaming settings for an AppInstance.
     */
    suspend fun getAppInstanceStreamingConfigurations(input: GetAppInstanceStreamingConfigurationsRequest): GetAppInstanceStreamingConfigurationsResponse

    /**
     * Gets the streaming settings for an AppInstance.
     */
    suspend fun getAppInstanceStreamingConfigurations(block: GetAppInstanceStreamingConfigurationsRequest.DslBuilder.() -> Unit) = getAppInstanceStreamingConfigurations(GetAppInstanceStreamingConfigurationsRequest.builder().apply(block).build())

    /**
     * Gets the Amazon Chime SDK attendee details for a specified meeting ID and attendee ID. For more information about the Amazon Chime SDK, see
     * <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK
     * in the
     * Amazon Chime Developer Guide
     * .
     */
    suspend fun getAttendee(input: GetAttendeeRequest): GetAttendeeResponse

    /**
     * Gets the Amazon Chime SDK attendee details for a specified meeting ID and attendee ID. For more information about the Amazon Chime SDK, see
     * <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK
     * in the
     * Amazon Chime Developer Guide
     * .
     */
    suspend fun getAttendee(block: GetAttendeeRequest.DslBuilder.() -> Unit) = getAttendee(GetAttendeeRequest.builder().apply(block).build())

    /**
     * Retrieves details for the specified bot, such as bot email address, bot type, status, and display name.
     */
    suspend fun getBot(input: GetBotRequest): GetBotResponse

    /**
     * Retrieves details for the specified bot, such as bot email address, bot type, status, and display name.
     */
    suspend fun getBot(block: GetBotRequest.DslBuilder.() -> Unit) = getBot(GetBotRequest.builder().apply(block).build())

    /**
     * Gets the full details of a channel message.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun getChannelMessage(input: GetChannelMessageRequest): GetChannelMessageResponse

    /**
     * Gets the full details of a channel message.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun getChannelMessage(block: GetChannelMessageRequest.DslBuilder.() -> Unit) = getChannelMessage(GetChannelMessageRequest.builder().apply(block).build())

    /**
     * Gets details for an events configuration that allows a bot to receive outgoing events, such as an HTTPS endpoint or Lambda function ARN.
     */
    suspend fun getEventsConfiguration(input: GetEventsConfigurationRequest): GetEventsConfigurationResponse

    /**
     * Gets details for an events configuration that allows a bot to receive outgoing events, such as an HTTPS endpoint or Lambda function ARN.
     */
    suspend fun getEventsConfiguration(block: GetEventsConfigurationRequest.DslBuilder.() -> Unit) = getEventsConfiguration(GetEventsConfigurationRequest.builder().apply(block).build())

    /**
     * Retrieves global settings for the administrator's AWS account, such as Amazon Chime Business
     * Calling and Amazon Chime Voice Connector settings.
     */
    suspend fun getGlobalSettings(input: GetGlobalSettingsRequest): GetGlobalSettingsResponse

    /**
     * Retrieves global settings for the administrator's AWS account, such as Amazon Chime Business
     * Calling and Amazon Chime Voice Connector settings.
     */
    suspend fun getGlobalSettings(block: GetGlobalSettingsRequest.DslBuilder.() -> Unit) = getGlobalSettings(GetGlobalSettingsRequest.builder().apply(block).build())

    /**
     * Gets an existing media capture pipeline.
     */
    suspend fun getMediaCapturePipeline(input: GetMediaCapturePipelineRequest): GetMediaCapturePipelineResponse

    /**
     * Gets an existing media capture pipeline.
     */
    suspend fun getMediaCapturePipeline(block: GetMediaCapturePipelineRequest.DslBuilder.() -> Unit) = getMediaCapturePipeline(GetMediaCapturePipelineRequest.builder().apply(block).build())

    /**
     * Gets the Amazon Chime SDK meeting details for the specified meeting ID. For more information about the Amazon Chime SDK, see
     * <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK
     * in the
     * Amazon Chime Developer Guide
     * .
     */
    suspend fun getMeeting(input: GetMeetingRequest): GetMeetingResponse

    /**
     * Gets the Amazon Chime SDK meeting details for the specified meeting ID. For more information about the Amazon Chime SDK, see
     * <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK
     * in the
     * Amazon Chime Developer Guide
     * .
     */
    suspend fun getMeeting(block: GetMeetingRequest.DslBuilder.() -> Unit) = getMeeting(GetMeetingRequest.builder().apply(block).build())

    /**
     * The details of the endpoint for the messaging session.
     */
    suspend fun getMessagingSessionEndpoint(input: GetMessagingSessionEndpointRequest): GetMessagingSessionEndpointResponse

    /**
     * The details of the endpoint for the messaging session.
     */
    suspend fun getMessagingSessionEndpoint(block: GetMessagingSessionEndpointRequest.DslBuilder.() -> Unit) = getMessagingSessionEndpoint(GetMessagingSessionEndpointRequest.builder().apply(block).build())

    /**
     * Retrieves details for the specified phone number ID, such as associations, capabilities, and product type.
     */
    suspend fun getPhoneNumber(input: GetPhoneNumberRequest): GetPhoneNumberResponse

    /**
     * Retrieves details for the specified phone number ID, such as associations, capabilities, and product type.
     */
    suspend fun getPhoneNumber(block: GetPhoneNumberRequest.DslBuilder.() -> Unit) = getPhoneNumber(GetPhoneNumberRequest.builder().apply(block).build())

    /**
     * Retrieves details for the specified phone number order, such as the order creation timestamp, phone
     * numbers in E.164 format, product type, and order status.
     */
    suspend fun getPhoneNumberOrder(input: GetPhoneNumberOrderRequest): GetPhoneNumberOrderResponse

    /**
     * Retrieves details for the specified phone number order, such as the order creation timestamp, phone
     * numbers in E.164 format, product type, and order status.
     */
    suspend fun getPhoneNumberOrder(block: GetPhoneNumberOrderRequest.DslBuilder.() -> Unit) = getPhoneNumberOrder(GetPhoneNumberOrderRequest.builder().apply(block).build())

    /**
     * Retrieves the phone number settings for the administrator's AWS account, such as the default outbound calling name.
     */
    suspend fun getPhoneNumberSettings(input: GetPhoneNumberSettingsRequest): GetPhoneNumberSettingsResponse

    /**
     * Retrieves the phone number settings for the administrator's AWS account, such as the default outbound calling name.
     */
    suspend fun getPhoneNumberSettings(block: GetPhoneNumberSettingsRequest.DslBuilder.() -> Unit) = getPhoneNumberSettings(GetPhoneNumberSettingsRequest.builder().apply(block).build())

    /**
     * Gets the specified proxy session details for the specified Amazon Chime Voice Connector.
     */
    suspend fun getProxySession(input: GetProxySessionRequest): GetProxySessionResponse

    /**
     * Gets the specified proxy session details for the specified Amazon Chime Voice Connector.
     */
    suspend fun getProxySession(block: GetProxySessionRequest.DslBuilder.() -> Unit) = getProxySession(GetProxySessionRequest.builder().apply(block).build())

    /**
     * Gets the retention settings for the specified Amazon Chime Enterprise account. For more information about retention settings, see
     * <a href="https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html">Managing Chat Retention Policies in the Amazon Chime Administration Guide.
     */
    suspend fun getRetentionSettings(input: GetRetentionSettingsRequest): GetRetentionSettingsResponse

    /**
     * Gets the retention settings for the specified Amazon Chime Enterprise account. For more information about retention settings, see
     * <a href="https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html">Managing Chat Retention Policies in the Amazon Chime Administration Guide.
     */
    suspend fun getRetentionSettings(block: GetRetentionSettingsRequest.DslBuilder.() -> Unit) = getRetentionSettings(GetRetentionSettingsRequest.builder().apply(block).build())

    /**
     * Retrieves room details, such as the room name, for a room in an Amazon Chime Enterprise account.
     */
    suspend fun getRoom(input: GetRoomRequest): GetRoomResponse

    /**
     * Retrieves room details, such as the room name, for a room in an Amazon Chime Enterprise account.
     */
    suspend fun getRoom(block: GetRoomRequest.DslBuilder.() -> Unit) = getRoom(GetRoomRequest.builder().apply(block).build())

    /**
     * Retrieves the information for a SIP media application, including name, AWS Region, and endpoints.
     */
    suspend fun getSipMediaApplication(input: GetSipMediaApplicationRequest): GetSipMediaApplicationResponse

    /**
     * Retrieves the information for a SIP media application, including name, AWS Region, and endpoints.
     */
    suspend fun getSipMediaApplication(block: GetSipMediaApplicationRequest.DslBuilder.() -> Unit) = getSipMediaApplication(GetSipMediaApplicationRequest.builder().apply(block).build())

    /**
     * Returns the logging configuration for the specified SIP media application.
     */
    suspend fun getSipMediaApplicationLoggingConfiguration(input: GetSipMediaApplicationLoggingConfigurationRequest): GetSipMediaApplicationLoggingConfigurationResponse

    /**
     * Returns the logging configuration for the specified SIP media application.
     */
    suspend fun getSipMediaApplicationLoggingConfiguration(block: GetSipMediaApplicationLoggingConfigurationRequest.DslBuilder.() -> Unit) = getSipMediaApplicationLoggingConfiguration(GetSipMediaApplicationLoggingConfigurationRequest.builder().apply(block).build())

    /**
     * Retrieves the details of a SIP rule, such as the rule ID, name, triggers, and target endpoints.
     */
    suspend fun getSipRule(input: GetSipRuleRequest): GetSipRuleResponse

    /**
     * Retrieves the details of a SIP rule, such as the rule ID, name, triggers, and target endpoints.
     */
    suspend fun getSipRule(block: GetSipRuleRequest.DslBuilder.() -> Unit) = getSipRule(GetSipRuleRequest.builder().apply(block).build())

    /**
     * Retrieves details for the specified user ID, such as primary email address, license type,and personal meeting PIN.
     * To retrieve user details with an email address instead of a user ID, use the
     * ListUsers action, and then filter by email address.
     */
    suspend fun getUser(input: GetUserRequest): GetUserResponse

    /**
     * Retrieves details for the specified user ID, such as primary email address, license type,and personal meeting PIN.
     * To retrieve user details with an email address instead of a user ID, use the
     * ListUsers action, and then filter by email address.
     */
    suspend fun getUser(block: GetUserRequest.DslBuilder.() -> Unit) = getUser(GetUserRequest.builder().apply(block).build())

    /**
     * Retrieves settings for the specified user ID, such as any associated phone number settings.
     */
    suspend fun getUserSettings(input: GetUserSettingsRequest): GetUserSettingsResponse

    /**
     * Retrieves settings for the specified user ID, such as any associated phone number settings.
     */
    suspend fun getUserSettings(block: GetUserSettingsRequest.DslBuilder.() -> Unit) = getUserSettings(GetUserSettingsRequest.builder().apply(block).build())

    /**
     * Retrieves details for the specified Amazon Chime Voice Connector, such as timestamps,name, outbound host, and encryption requirements.
     */
    suspend fun getVoiceConnector(input: GetVoiceConnectorRequest): GetVoiceConnectorResponse

    /**
     * Retrieves details for the specified Amazon Chime Voice Connector, such as timestamps,name, outbound host, and encryption requirements.
     */
    suspend fun getVoiceConnector(block: GetVoiceConnectorRequest.DslBuilder.() -> Unit) = getVoiceConnector(GetVoiceConnectorRequest.builder().apply(block).build())

    /**
     * Gets the emergency calling configuration details for the specified Amazon Chime Voice Connector.
     */
    suspend fun getVoiceConnectorEmergencyCallingConfiguration(input: GetVoiceConnectorEmergencyCallingConfigurationRequest): GetVoiceConnectorEmergencyCallingConfigurationResponse

    /**
     * Gets the emergency calling configuration details for the specified Amazon Chime Voice Connector.
     */
    suspend fun getVoiceConnectorEmergencyCallingConfiguration(block: GetVoiceConnectorEmergencyCallingConfigurationRequest.DslBuilder.() -> Unit) = getVoiceConnectorEmergencyCallingConfiguration(GetVoiceConnectorEmergencyCallingConfigurationRequest.builder().apply(block).build())

    /**
     * Retrieves details for the specified Amazon Chime Voice Connector group, such as timestamps,name, and associated VoiceConnectorItems.
     */
    suspend fun getVoiceConnectorGroup(input: GetVoiceConnectorGroupRequest): GetVoiceConnectorGroupResponse

    /**
     * Retrieves details for the specified Amazon Chime Voice Connector group, such as timestamps,name, and associated VoiceConnectorItems.
     */
    suspend fun getVoiceConnectorGroup(block: GetVoiceConnectorGroupRequest.DslBuilder.() -> Unit) = getVoiceConnectorGroup(GetVoiceConnectorGroupRequest.builder().apply(block).build())

    /**
     * Retrieves the logging configuration details for the specified Amazon Chime Voice Connector. Shows whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.
     */
    suspend fun getVoiceConnectorLoggingConfiguration(input: GetVoiceConnectorLoggingConfigurationRequest): GetVoiceConnectorLoggingConfigurationResponse

    /**
     * Retrieves the logging configuration details for the specified Amazon Chime Voice Connector. Shows whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.
     */
    suspend fun getVoiceConnectorLoggingConfiguration(block: GetVoiceConnectorLoggingConfigurationRequest.DslBuilder.() -> Unit) = getVoiceConnectorLoggingConfiguration(GetVoiceConnectorLoggingConfigurationRequest.builder().apply(block).build())

    /**
     * Retrieves origination setting details for the specified Amazon Chime Voice Connector.
     */
    suspend fun getVoiceConnectorOrigination(input: GetVoiceConnectorOriginationRequest): GetVoiceConnectorOriginationResponse

    /**
     * Retrieves origination setting details for the specified Amazon Chime Voice Connector.
     */
    suspend fun getVoiceConnectorOrigination(block: GetVoiceConnectorOriginationRequest.DslBuilder.() -> Unit) = getVoiceConnectorOrigination(GetVoiceConnectorOriginationRequest.builder().apply(block).build())

    /**
     * Gets the proxy configuration details for the specified Amazon Chime Voice Connector.
     */
    suspend fun getVoiceConnectorProxy(input: GetVoiceConnectorProxyRequest): GetVoiceConnectorProxyResponse

    /**
     * Gets the proxy configuration details for the specified Amazon Chime Voice Connector.
     */
    suspend fun getVoiceConnectorProxy(block: GetVoiceConnectorProxyRequest.DslBuilder.() -> Unit) = getVoiceConnectorProxy(GetVoiceConnectorProxyRequest.builder().apply(block).build())

    /**
     * Retrieves the streaming configuration details for the specified Amazon Chime Voice Connector.
     * Shows whether media streaming is enabled for sending to Amazon Kinesis. It also shows
     * the retention period, in hours, for the Amazon Kinesis data.
     */
    suspend fun getVoiceConnectorStreamingConfiguration(input: GetVoiceConnectorStreamingConfigurationRequest): GetVoiceConnectorStreamingConfigurationResponse

    /**
     * Retrieves the streaming configuration details for the specified Amazon Chime Voice Connector.
     * Shows whether media streaming is enabled for sending to Amazon Kinesis. It also shows
     * the retention period, in hours, for the Amazon Kinesis data.
     */
    suspend fun getVoiceConnectorStreamingConfiguration(block: GetVoiceConnectorStreamingConfigurationRequest.DslBuilder.() -> Unit) = getVoiceConnectorStreamingConfiguration(GetVoiceConnectorStreamingConfigurationRequest.builder().apply(block).build())

    /**
     * Retrieves termination setting details for the specified Amazon Chime Voice Connector.
     */
    suspend fun getVoiceConnectorTermination(input: GetVoiceConnectorTerminationRequest): GetVoiceConnectorTerminationResponse

    /**
     * Retrieves termination setting details for the specified Amazon Chime Voice Connector.
     */
    suspend fun getVoiceConnectorTermination(block: GetVoiceConnectorTerminationRequest.DslBuilder.() -> Unit) = getVoiceConnectorTermination(GetVoiceConnectorTerminationRequest.builder().apply(block).build())

    /**
     * Retrieves information about the last time a SIP OPTIONS ping was received from
     * your SIP infrastructure for the specified Amazon Chime Voice Connector.
     */
    suspend fun getVoiceConnectorTerminationHealth(input: GetVoiceConnectorTerminationHealthRequest): GetVoiceConnectorTerminationHealthResponse

    /**
     * Retrieves information about the last time a SIP OPTIONS ping was received from
     * your SIP infrastructure for the specified Amazon Chime Voice Connector.
     */
    suspend fun getVoiceConnectorTerminationHealth(block: GetVoiceConnectorTerminationHealthRequest.DslBuilder.() -> Unit) = getVoiceConnectorTerminationHealth(GetVoiceConnectorTerminationHealthRequest.builder().apply(block).build())

    /**
     * Sends email to a maximum of 50 users, inviting them to the specified Amazon Chime
     * Team account. Only Team account types are currently
     * supported for this action.
     */
    suspend fun inviteUsers(input: InviteUsersRequest): InviteUsersResponse

    /**
     * Sends email to a maximum of 50 users, inviting them to the specified Amazon Chime
     * Team account. Only Team account types are currently
     * supported for this action.
     */
    suspend fun inviteUsers(block: InviteUsersRequest.DslBuilder.() -> Unit) = inviteUsers(InviteUsersRequest.builder().apply(block).build())

    /**
     * Lists the Amazon Chime accounts under the administrator's AWS account. You can filter accounts
     * by account name prefix. To find out which Amazon Chime account a user belongs to, you can
     * filter by the user's email address, which returns one account result.
     */
    suspend fun listAccounts(input: ListAccountsRequest): ListAccountsResponse

    /**
     * Lists the Amazon Chime accounts under the administrator's AWS account. You can filter accounts
     * by account name prefix. To find out which Amazon Chime account a user belongs to, you can
     * filter by the user's email address, which returns one account result.
     */
    suspend fun listAccounts(block: ListAccountsRequest.DslBuilder.() -> Unit) = listAccounts(ListAccountsRequest.builder().apply(block).build())

    /**
     * Returns a list of the administrators in the AppInstance.
     */
    suspend fun listAppInstanceAdmins(input: ListAppInstanceAdminsRequest): ListAppInstanceAdminsResponse

    /**
     * Returns a list of the administrators in the AppInstance.
     */
    suspend fun listAppInstanceAdmins(block: ListAppInstanceAdminsRequest.DslBuilder.() -> Unit) = listAppInstanceAdmins(ListAppInstanceAdminsRequest.builder().apply(block).build())

    /**
     * List all AppInstanceUsers
     * created under a single AppInstance.
     */
    suspend fun listAppInstanceUsers(input: ListAppInstanceUsersRequest): ListAppInstanceUsersResponse

    /**
     * List all AppInstanceUsers
     * created under a single AppInstance.
     */
    suspend fun listAppInstanceUsers(block: ListAppInstanceUsersRequest.DslBuilder.() -> Unit) = listAppInstanceUsers(ListAppInstanceUsersRequest.builder().apply(block).build())

    /**
     * Lists all Amazon Chime AppInstances created under a single AWS account.
     */
    suspend fun listAppInstances(input: ListAppInstancesRequest): ListAppInstancesResponse

    /**
     * Lists all Amazon Chime AppInstances created under a single AWS account.
     */
    suspend fun listAppInstances(block: ListAppInstancesRequest.DslBuilder.() -> Unit) = listAppInstances(ListAppInstancesRequest.builder().apply(block).build())

    /**
     * Lists the tags applied to an Amazon Chime SDK attendee resource.
     */
    suspend fun listAttendeeTags(input: ListAttendeeTagsRequest): ListAttendeeTagsResponse

    /**
     * Lists the tags applied to an Amazon Chime SDK attendee resource.
     */
    suspend fun listAttendeeTags(block: ListAttendeeTagsRequest.DslBuilder.() -> Unit) = listAttendeeTags(ListAttendeeTagsRequest.builder().apply(block).build())

    /**
     * Lists the attendees for the specified Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see
     * <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK
     * in the Amazon Chime Developer Guide.
     */
    suspend fun listAttendees(input: ListAttendeesRequest): ListAttendeesResponse

    /**
     * Lists the attendees for the specified Amazon Chime SDK meeting. For more information about the Amazon Chime SDK, see
     * <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK
     * in the Amazon Chime Developer Guide.
     */
    suspend fun listAttendees(block: ListAttendeesRequest.DslBuilder.() -> Unit) = listAttendees(ListAttendeesRequest.builder().apply(block).build())

    /**
     * Lists the bots associated with the administrator's Amazon Chime Enterprise account ID.
     */
    suspend fun listBots(input: ListBotsRequest): ListBotsResponse

    /**
     * Lists the bots associated with the administrator's Amazon Chime Enterprise account ID.
     */
    suspend fun listBots(block: ListBotsRequest.DslBuilder.() -> Unit) = listBots(ListBotsRequest.builder().apply(block).build())

    /**
     * Lists all the users banned from a particular channel.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun listChannelBans(input: ListChannelBansRequest): ListChannelBansResponse

    /**
     * Lists all the users banned from a particular channel.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun listChannelBans(block: ListChannelBansRequest.DslBuilder.() -> Unit) = listChannelBans(ListChannelBansRequest.builder().apply(block).build())

    /**
     * Lists all channel memberships in a channel.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun listChannelMemberships(input: ListChannelMembershipsRequest): ListChannelMembershipsResponse

    /**
     * Lists all channel memberships in a channel.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun listChannelMemberships(block: ListChannelMembershipsRequest.DslBuilder.() -> Unit) = listChannelMemberships(ListChannelMembershipsRequest.builder().apply(block).build())

    /**
     * Lists all channels that a particular AppInstanceUser is a part of. Only an
     * AppInstanceAdmin can call the API with a user ARN that is not their own.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun listChannelMembershipsForAppInstanceUser(input: ListChannelMembershipsForAppInstanceUserRequest): ListChannelMembershipsForAppInstanceUserResponse

    /**
     * Lists all channels that a particular AppInstanceUser is a part of. Only an
     * AppInstanceAdmin can call the API with a user ARN that is not their own.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun listChannelMembershipsForAppInstanceUser(block: ListChannelMembershipsForAppInstanceUserRequest.DslBuilder.() -> Unit) = listChannelMembershipsForAppInstanceUser(ListChannelMembershipsForAppInstanceUserRequest.builder().apply(block).build())

    /**
     * List all the messages in a channel. Returns a paginated list of
     * ChannelMessages. By default, sorted by creation timestamp in descending
     * order.
     * Redacted messages appear in the results as empty, since they are only redacted, not
     * deleted. Deleted messages do not appear in the results. This action always returns the
     * latest version of an edited message.
     * Also, the x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun listChannelMessages(input: ListChannelMessagesRequest): ListChannelMessagesResponse

    /**
     * List all the messages in a channel. Returns a paginated list of
     * ChannelMessages. By default, sorted by creation timestamp in descending
     * order.
     * Redacted messages appear in the results as empty, since they are only redacted, not
     * deleted. Deleted messages do not appear in the results. This action always returns the
     * latest version of an edited message.
     * Also, the x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun listChannelMessages(block: ListChannelMessagesRequest.DslBuilder.() -> Unit) = listChannelMessages(ListChannelMessagesRequest.builder().apply(block).build())

    /**
     * Lists all the moderators for a channel.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun listChannelModerators(input: ListChannelModeratorsRequest): ListChannelModeratorsResponse

    /**
     * Lists all the moderators for a channel.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun listChannelModerators(block: ListChannelModeratorsRequest.DslBuilder.() -> Unit) = listChannelModerators(ListChannelModeratorsRequest.builder().apply(block).build())

    /**
     * Lists all Channels created under a single Chime App as a paginated list. You can specify
     * filters to narrow results.
     * <p class="title">
     * Functionality & restrictions
     * Use privacy = PUBLIC to retrieve all public channels in the
     * account.
     * Only an AppInstanceAdmin can set privacy = PRIVATE to
     * list the private channels in an account.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun listChannels(input: ListChannelsRequest): ListChannelsResponse

    /**
     * Lists all Channels created under a single Chime App as a paginated list. You can specify
     * filters to narrow results.
     * <p class="title">
     * Functionality & restrictions
     * Use privacy = PUBLIC to retrieve all public channels in the
     * account.
     * Only an AppInstanceAdmin can set privacy = PRIVATE to
     * list the private channels in an account.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun listChannels(block: ListChannelsRequest.DslBuilder.() -> Unit) = listChannels(ListChannelsRequest.builder().apply(block).build())

    /**
     * A list of the channels moderated by an AppInstanceUser.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun listChannelsModeratedByAppInstanceUser(input: ListChannelsModeratedByAppInstanceUserRequest): ListChannelsModeratedByAppInstanceUserResponse

    /**
     * A list of the channels moderated by an AppInstanceUser.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun listChannelsModeratedByAppInstanceUser(block: ListChannelsModeratedByAppInstanceUserRequest.DslBuilder.() -> Unit) = listChannelsModeratedByAppInstanceUser(ListChannelsModeratedByAppInstanceUserRequest.builder().apply(block).build())

    /**
     * Returns a list of media capture pipelines.
     */
    suspend fun listMediaCapturePipelines(input: ListMediaCapturePipelinesRequest): ListMediaCapturePipelinesResponse

    /**
     * Returns a list of media capture pipelines.
     */
    suspend fun listMediaCapturePipelines(block: ListMediaCapturePipelinesRequest.DslBuilder.() -> Unit) = listMediaCapturePipelines(ListMediaCapturePipelinesRequest.builder().apply(block).build())

    /**
     * Lists the tags applied to an Amazon Chime SDK meeting resource.
     */
    suspend fun listMeetingTags(input: ListMeetingTagsRequest): ListMeetingTagsResponse

    /**
     * Lists the tags applied to an Amazon Chime SDK meeting resource.
     */
    suspend fun listMeetingTags(block: ListMeetingTagsRequest.DslBuilder.() -> Unit) = listMeetingTags(ListMeetingTagsRequest.builder().apply(block).build())

    /**
     * Lists up to 100 active Amazon Chime SDK meetings. For more information about the Amazon Chime SDK, see
     * <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK
     * in the Amazon Chime Developer Guide.
     */
    suspend fun listMeetings(input: ListMeetingsRequest): ListMeetingsResponse

    /**
     * Lists up to 100 active Amazon Chime SDK meetings. For more information about the Amazon Chime SDK, see
     * <a href="https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html">Using the Amazon Chime SDK
     * in the Amazon Chime Developer Guide.
     */
    suspend fun listMeetings(block: ListMeetingsRequest.DslBuilder.() -> Unit) = listMeetings(ListMeetingsRequest.builder().apply(block).build())

    /**
     * Lists the phone number orders for the administrator's Amazon Chime account.
     */
    suspend fun listPhoneNumberOrders(input: ListPhoneNumberOrdersRequest): ListPhoneNumberOrdersResponse

    /**
     * Lists the phone number orders for the administrator's Amazon Chime account.
     */
    suspend fun listPhoneNumberOrders(block: ListPhoneNumberOrdersRequest.DslBuilder.() -> Unit) = listPhoneNumberOrders(ListPhoneNumberOrdersRequest.builder().apply(block).build())

    /**
     * Lists the phone numbers for the specified Amazon Chime account, Amazon Chime user, Amazon Chime Voice Connector, or Amazon Chime Voice Connector group.
     */
    suspend fun listPhoneNumbers(input: ListPhoneNumbersRequest): ListPhoneNumbersResponse

    /**
     * Lists the phone numbers for the specified Amazon Chime account, Amazon Chime user, Amazon Chime Voice Connector, or Amazon Chime Voice Connector group.
     */
    suspend fun listPhoneNumbers(block: ListPhoneNumbersRequest.DslBuilder.() -> Unit) = listPhoneNumbers(ListPhoneNumbersRequest.builder().apply(block).build())

    /**
     * Lists the proxy sessions for the specified Amazon Chime Voice Connector.
     */
    suspend fun listProxySessions(input: ListProxySessionsRequest): ListProxySessionsResponse

    /**
     * Lists the proxy sessions for the specified Amazon Chime Voice Connector.
     */
    suspend fun listProxySessions(block: ListProxySessionsRequest.DslBuilder.() -> Unit) = listProxySessions(ListProxySessionsRequest.builder().apply(block).build())

    /**
     * Lists the membership details for the specified room in an Amazon Chime Enterprise account,
     * such as the members' IDs, email addresses, and names.
     */
    suspend fun listRoomMemberships(input: ListRoomMembershipsRequest): ListRoomMembershipsResponse

    /**
     * Lists the membership details for the specified room in an Amazon Chime Enterprise account,
     * such as the members' IDs, email addresses, and names.
     */
    suspend fun listRoomMemberships(block: ListRoomMembershipsRequest.DslBuilder.() -> Unit) = listRoomMemberships(ListRoomMembershipsRequest.builder().apply(block).build())

    /**
     * Lists the room details for the specified Amazon Chime Enterprise account. Optionally, filter the results by a member ID (user ID or bot ID) to see a list of rooms that the member belongs to.
     */
    suspend fun listRooms(input: ListRoomsRequest): ListRoomsResponse

    /**
     * Lists the room details for the specified Amazon Chime Enterprise account. Optionally, filter the results by a member ID (user ID or bot ID) to see a list of rooms that the member belongs to.
     */
    suspend fun listRooms(block: ListRoomsRequest.DslBuilder.() -> Unit) = listRooms(ListRoomsRequest.builder().apply(block).build())

    /**
     * Lists the SIP media applications under the administrator's AWS account.
     */
    suspend fun listSipMediaApplications(input: ListSipMediaApplicationsRequest): ListSipMediaApplicationsResponse

    /**
     * Lists the SIP media applications under the administrator's AWS account.
     */
    suspend fun listSipMediaApplications(block: ListSipMediaApplicationsRequest.DslBuilder.() -> Unit) = listSipMediaApplications(ListSipMediaApplicationsRequest.builder().apply(block).build())

    /**
     * Lists the SIP rules under the administrator's AWS account.
     */
    suspend fun listSipRules(input: ListSipRulesRequest): ListSipRulesResponse

    /**
     * Lists the SIP rules under the administrator's AWS account.
     */
    suspend fun listSipRules(block: ListSipRulesRequest.DslBuilder.() -> Unit) = listSipRules(ListSipRulesRequest.builder().apply(block).build())

    /**
     * Lists supported phone number countries.
     */
    suspend fun listSupportedPhoneNumberCountries(input: ListSupportedPhoneNumberCountriesRequest): ListSupportedPhoneNumberCountriesResponse

    /**
     * Lists supported phone number countries.
     */
    suspend fun listSupportedPhoneNumberCountries(block: ListSupportedPhoneNumberCountriesRequest.DslBuilder.() -> Unit) = listSupportedPhoneNumberCountries(ListSupportedPhoneNumberCountriesRequest.builder().apply(block).build())

    /**
     * Lists the tags applied to an Amazon Chime SDK meeting resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the tags applied to an Amazon Chime SDK meeting resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.DslBuilder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.builder().apply(block).build())

    /**
     * Lists the users that belong to the specified Amazon Chime account. You can specify an email
     * address to list only the user that the email address belongs to.
     */
    suspend fun listUsers(input: ListUsersRequest): ListUsersResponse

    /**
     * Lists the users that belong to the specified Amazon Chime account. You can specify an email
     * address to list only the user that the email address belongs to.
     */
    suspend fun listUsers(block: ListUsersRequest.DslBuilder.() -> Unit) = listUsers(ListUsersRequest.builder().apply(block).build())

    /**
     * Lists the Amazon Chime Voice Connector groups for the administrator's AWS account.
     */
    suspend fun listVoiceConnectorGroups(input: ListVoiceConnectorGroupsRequest): ListVoiceConnectorGroupsResponse

    /**
     * Lists the Amazon Chime Voice Connector groups for the administrator's AWS account.
     */
    suspend fun listVoiceConnectorGroups(block: ListVoiceConnectorGroupsRequest.DslBuilder.() -> Unit) = listVoiceConnectorGroups(ListVoiceConnectorGroupsRequest.builder().apply(block).build())

    /**
     * Lists the SIP credentials for the specified Amazon Chime Voice Connector.
     */
    suspend fun listVoiceConnectorTerminationCredentials(input: ListVoiceConnectorTerminationCredentialsRequest): ListVoiceConnectorTerminationCredentialsResponse

    /**
     * Lists the SIP credentials for the specified Amazon Chime Voice Connector.
     */
    suspend fun listVoiceConnectorTerminationCredentials(block: ListVoiceConnectorTerminationCredentialsRequest.DslBuilder.() -> Unit) = listVoiceConnectorTerminationCredentials(ListVoiceConnectorTerminationCredentialsRequest.builder().apply(block).build())

    /**
     * Lists the Amazon Chime Voice Connectors for the administrator's AWS account.
     */
    suspend fun listVoiceConnectors(input: ListVoiceConnectorsRequest): ListVoiceConnectorsResponse

    /**
     * Lists the Amazon Chime Voice Connectors for the administrator's AWS account.
     */
    suspend fun listVoiceConnectors(block: ListVoiceConnectorsRequest.DslBuilder.() -> Unit) = listVoiceConnectors(ListVoiceConnectorsRequest.builder().apply(block).build())

    /**
     * Logs out the specified user from all of the devices they are currently logged into.
     */
    suspend fun logoutUser(input: LogoutUserRequest): LogoutUserResponse

    /**
     * Logs out the specified user from all of the devices they are currently logged into.
     */
    suspend fun logoutUser(block: LogoutUserRequest.DslBuilder.() -> Unit) = logoutUser(LogoutUserRequest.builder().apply(block).build())

    /**
     * Sets the amount of time in days that a given AppInstance retains data.
     */
    suspend fun putAppInstanceRetentionSettings(input: PutAppInstanceRetentionSettingsRequest): PutAppInstanceRetentionSettingsResponse

    /**
     * Sets the amount of time in days that a given AppInstance retains data.
     */
    suspend fun putAppInstanceRetentionSettings(block: PutAppInstanceRetentionSettingsRequest.DslBuilder.() -> Unit) = putAppInstanceRetentionSettings(PutAppInstanceRetentionSettingsRequest.builder().apply(block).build())

    /**
     * The data streaming configurations of an AppInstance.
     */
    suspend fun putAppInstanceStreamingConfigurations(input: PutAppInstanceStreamingConfigurationsRequest): PutAppInstanceStreamingConfigurationsResponse

    /**
     * The data streaming configurations of an AppInstance.
     */
    suspend fun putAppInstanceStreamingConfigurations(block: PutAppInstanceStreamingConfigurationsRequest.DslBuilder.() -> Unit) = putAppInstanceStreamingConfigurations(PutAppInstanceStreamingConfigurationsRequest.builder().apply(block).build())

    /**
     * Creates an events configuration that allows a bot to receive outgoing events sent by Amazon
     * Chime. Choose either an HTTPS endpoint or a Lambda function ARN. For more information,
     * see Bot.
     */
    suspend fun putEventsConfiguration(input: PutEventsConfigurationRequest): PutEventsConfigurationResponse

    /**
     * Creates an events configuration that allows a bot to receive outgoing events sent by Amazon
     * Chime. Choose either an HTTPS endpoint or a Lambda function ARN. For more information,
     * see Bot.
     */
    suspend fun putEventsConfiguration(block: PutEventsConfigurationRequest.DslBuilder.() -> Unit) = putEventsConfiguration(PutEventsConfigurationRequest.builder().apply(block).build())

    /**
     * Puts retention settings for the specified Amazon Chime Enterprise account. We recommend using AWS CloudTrail to monitor usage of this API for your account. For more information, see
     * <a href="https://docs.aws.amazon.com/chime/latest/ag/cloudtrail.html">Logging Amazon Chime API Calls with AWS CloudTrail
     * in the Amazon Chime Administration Guide.
     * To turn off existing retention settings, remove the number of days from the corresponding
     * RetentionDays
     * field in the
     * RetentionSettings
     * object. For more information about retention settings, see
     * <a href="https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html">Managing Chat Retention Policies
     * in the Amazon Chime Administration Guide.
     */
    suspend fun putRetentionSettings(input: PutRetentionSettingsRequest): PutRetentionSettingsResponse

    /**
     * Puts retention settings for the specified Amazon Chime Enterprise account. We recommend using AWS CloudTrail to monitor usage of this API for your account. For more information, see
     * <a href="https://docs.aws.amazon.com/chime/latest/ag/cloudtrail.html">Logging Amazon Chime API Calls with AWS CloudTrail
     * in the Amazon Chime Administration Guide.
     * To turn off existing retention settings, remove the number of days from the corresponding
     * RetentionDays
     * field in the
     * RetentionSettings
     * object. For more information about retention settings, see
     * <a href="https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html">Managing Chat Retention Policies
     * in the Amazon Chime Administration Guide.
     */
    suspend fun putRetentionSettings(block: PutRetentionSettingsRequest.DslBuilder.() -> Unit) = putRetentionSettings(PutRetentionSettingsRequest.builder().apply(block).build())

    /**
     * Updates the logging configuration for the specified SIP media application.
     */
    suspend fun putSipMediaApplicationLoggingConfiguration(input: PutSipMediaApplicationLoggingConfigurationRequest): PutSipMediaApplicationLoggingConfigurationResponse

    /**
     * Updates the logging configuration for the specified SIP media application.
     */
    suspend fun putSipMediaApplicationLoggingConfiguration(block: PutSipMediaApplicationLoggingConfigurationRequest.DslBuilder.() -> Unit) = putSipMediaApplicationLoggingConfiguration(PutSipMediaApplicationLoggingConfigurationRequest.builder().apply(block).build())

    /**
     * Puts emergency calling configuration details to the specified Amazon Chime Voice Connector, such as emergency phone numbers and calling countries. Origination and termination settings must be enabled for
     * the Amazon Chime Voice Connector before emergency calling can be configured.
     */
    suspend fun putVoiceConnectorEmergencyCallingConfiguration(input: PutVoiceConnectorEmergencyCallingConfigurationRequest): PutVoiceConnectorEmergencyCallingConfigurationResponse

    /**
     * Puts emergency calling configuration details to the specified Amazon Chime Voice Connector, such as emergency phone numbers and calling countries. Origination and termination settings must be enabled for
     * the Amazon Chime Voice Connector before emergency calling can be configured.
     */
    suspend fun putVoiceConnectorEmergencyCallingConfiguration(block: PutVoiceConnectorEmergencyCallingConfigurationRequest.DslBuilder.() -> Unit) = putVoiceConnectorEmergencyCallingConfiguration(PutVoiceConnectorEmergencyCallingConfigurationRequest.builder().apply(block).build())

    /**
     * Adds a logging configuration for the specified Amazon Chime Voice Connector. The logging configuration specifies whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.
     */
    suspend fun putVoiceConnectorLoggingConfiguration(input: PutVoiceConnectorLoggingConfigurationRequest): PutVoiceConnectorLoggingConfigurationResponse

    /**
     * Adds a logging configuration for the specified Amazon Chime Voice Connector. The logging configuration specifies whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.
     */
    suspend fun putVoiceConnectorLoggingConfiguration(block: PutVoiceConnectorLoggingConfigurationRequest.DslBuilder.() -> Unit) = putVoiceConnectorLoggingConfiguration(PutVoiceConnectorLoggingConfigurationRequest.builder().apply(block).build())

    /**
     * Adds origination settings for the specified Amazon Chime Voice Connector.
     * If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to turning off origination settings.
     */
    suspend fun putVoiceConnectorOrigination(input: PutVoiceConnectorOriginationRequest): PutVoiceConnectorOriginationResponse

    /**
     * Adds origination settings for the specified Amazon Chime Voice Connector.
     * If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to turning off origination settings.
     */
    suspend fun putVoiceConnectorOrigination(block: PutVoiceConnectorOriginationRequest.DslBuilder.() -> Unit) = putVoiceConnectorOrigination(PutVoiceConnectorOriginationRequest.builder().apply(block).build())

    /**
     * Puts the specified proxy configuration to the specified Amazon Chime Voice Connector.
     */
    suspend fun putVoiceConnectorProxy(input: PutVoiceConnectorProxyRequest): PutVoiceConnectorProxyResponse

    /**
     * Puts the specified proxy configuration to the specified Amazon Chime Voice Connector.
     */
    suspend fun putVoiceConnectorProxy(block: PutVoiceConnectorProxyRequest.DslBuilder.() -> Unit) = putVoiceConnectorProxy(PutVoiceConnectorProxyRequest.builder().apply(block).build())

    /**
     * Adds a streaming configuration for the specified Amazon Chime Voice Connector. The streaming
     * configuration specifies whether media streaming is enabled for sending to Indonesians.
     * It also sets the retention period, in hours, for the Amazon Kinesis data.
     */
    suspend fun putVoiceConnectorStreamingConfiguration(input: PutVoiceConnectorStreamingConfigurationRequest): PutVoiceConnectorStreamingConfigurationResponse

    /**
     * Adds a streaming configuration for the specified Amazon Chime Voice Connector. The streaming
     * configuration specifies whether media streaming is enabled for sending to Indonesians.
     * It also sets the retention period, in hours, for the Amazon Kinesis data.
     */
    suspend fun putVoiceConnectorStreamingConfiguration(block: PutVoiceConnectorStreamingConfigurationRequest.DslBuilder.() -> Unit) = putVoiceConnectorStreamingConfiguration(PutVoiceConnectorStreamingConfigurationRequest.builder().apply(block).build())

    /**
     * Adds termination settings for the specified Amazon Chime Voice Connector.
     * If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to turning off termination settings.
     */
    suspend fun putVoiceConnectorTermination(input: PutVoiceConnectorTerminationRequest): PutVoiceConnectorTerminationResponse

    /**
     * Adds termination settings for the specified Amazon Chime Voice Connector.
     * If emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to turning off termination settings.
     */
    suspend fun putVoiceConnectorTermination(block: PutVoiceConnectorTerminationRequest.DslBuilder.() -> Unit) = putVoiceConnectorTermination(PutVoiceConnectorTerminationRequest.builder().apply(block).build())

    /**
     * Adds termination SIP credentials for the specified Amazon Chime Voice Connector.
     */
    suspend fun putVoiceConnectorTerminationCredentials(input: PutVoiceConnectorTerminationCredentialsRequest): PutVoiceConnectorTerminationCredentialsResponse

    /**
     * Adds termination SIP credentials for the specified Amazon Chime Voice Connector.
     */
    suspend fun putVoiceConnectorTerminationCredentials(block: PutVoiceConnectorTerminationCredentialsRequest.DslBuilder.() -> Unit) = putVoiceConnectorTerminationCredentials(PutVoiceConnectorTerminationCredentialsRequest.builder().apply(block).build())

    /**
     * Redacts message content, but not metadata. The message exists in the back end, but the
     * action returns null content, and the state shows as redacted.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun redactChannelMessage(input: RedactChannelMessageRequest): RedactChannelMessageResponse

    /**
     * Redacts message content, but not metadata. The message exists in the back end, but the
     * action returns null content, and the state shows as redacted.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun redactChannelMessage(block: RedactChannelMessageRequest.DslBuilder.() -> Unit) = redactChannelMessage(RedactChannelMessageRequest.builder().apply(block).build())

    /**
     * Redacts the specified message from the specified Amazon Chime conversation.
     */
    suspend fun redactConversationMessage(input: RedactConversationMessageRequest): RedactConversationMessageResponse

    /**
     * Redacts the specified message from the specified Amazon Chime conversation.
     */
    suspend fun redactConversationMessage(block: RedactConversationMessageRequest.DslBuilder.() -> Unit) = redactConversationMessage(RedactConversationMessageRequest.builder().apply(block).build())

    /**
     * Redacts the specified message from the specified Amazon Chime channel.
     */
    suspend fun redactRoomMessage(input: RedactRoomMessageRequest): RedactRoomMessageResponse

    /**
     * Redacts the specified message from the specified Amazon Chime channel.
     */
    suspend fun redactRoomMessage(block: RedactRoomMessageRequest.DslBuilder.() -> Unit) = redactRoomMessage(RedactRoomMessageRequest.builder().apply(block).build())

    /**
     * Regenerates the security token for a bot.
     */
    suspend fun regenerateSecurityToken(input: RegenerateSecurityTokenRequest): RegenerateSecurityTokenResponse

    /**
     * Regenerates the security token for a bot.
     */
    suspend fun regenerateSecurityToken(block: RegenerateSecurityTokenRequest.DslBuilder.() -> Unit) = regenerateSecurityToken(RegenerateSecurityTokenRequest.builder().apply(block).build())

    /**
     * Resets the personal meeting PIN for the specified user on an Amazon Chime account. Returns
     * the User object with the updated personal meeting PIN.
     */
    suspend fun resetPersonalPin(input: ResetPersonalPinRequest): ResetPersonalPinResponse

    /**
     * Resets the personal meeting PIN for the specified user on an Amazon Chime account. Returns
     * the User object with the updated personal meeting PIN.
     */
    suspend fun resetPersonalPin(block: ResetPersonalPinRequest.DslBuilder.() -> Unit) = resetPersonalPin(ResetPersonalPinRequest.builder().apply(block).build())

    /**
     * Moves a phone number from the Deletion queue back into the
     * phone number Inventory.
     */
    suspend fun restorePhoneNumber(input: RestorePhoneNumberRequest): RestorePhoneNumberResponse

    /**
     * Moves a phone number from the Deletion queue back into the
     * phone number Inventory.
     */
    suspend fun restorePhoneNumber(block: RestorePhoneNumberRequest.DslBuilder.() -> Unit) = restorePhoneNumber(RestorePhoneNumberRequest.builder().apply(block).build())

    /**
     * Searches for phone numbers that can be ordered. For US numbers, provide at least one of
     * the following search filters: AreaCode, City,
     * State, or TollFreePrefix. If you provide
     * City, you must also provide State. Numbers outside the US only
     * support the PhoneNumberType filter, which you must use.
     */
    suspend fun searchAvailablePhoneNumbers(input: SearchAvailablePhoneNumbersRequest): SearchAvailablePhoneNumbersResponse

    /**
     * Searches for phone numbers that can be ordered. For US numbers, provide at least one of
     * the following search filters: AreaCode, City,
     * State, or TollFreePrefix. If you provide
     * City, you must also provide State. Numbers outside the US only
     * support the PhoneNumberType filter, which you must use.
     */
    suspend fun searchAvailablePhoneNumbers(block: SearchAvailablePhoneNumbersRequest.DslBuilder.() -> Unit) = searchAvailablePhoneNumbers(SearchAvailablePhoneNumbersRequest.builder().apply(block).build())

    /**
     * Sends a message to a particular channel that the member is a part of.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     * Also, STANDARD messages can contain 4KB of data and the 1KB of metadata.
     * CONTROL messages can contain 30 bytes of data and no metadata.
     */
    suspend fun sendChannelMessage(input: SendChannelMessageRequest): SendChannelMessageResponse

    /**
     * Sends a message to a particular channel that the member is a part of.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     * Also, STANDARD messages can contain 4KB of data and the 1KB of metadata.
     * CONTROL messages can contain 30 bytes of data and no metadata.
     */
    suspend fun sendChannelMessage(block: SendChannelMessageRequest.DslBuilder.() -> Unit) = sendChannelMessage(SendChannelMessageRequest.builder().apply(block).build())

    /**
     * Start transcription for the specified meetingId.
     */
    suspend fun startMeetingTranscription(input: StartMeetingTranscriptionRequest): StartMeetingTranscriptionResponse

    /**
     * Start transcription for the specified meetingId.
     */
    suspend fun startMeetingTranscription(block: StartMeetingTranscriptionRequest.DslBuilder.() -> Unit) = startMeetingTranscription(StartMeetingTranscriptionRequest.builder().apply(block).build())

    /**
     * Stops transcription for the specified meetingId.
     */
    suspend fun stopMeetingTranscription(input: StopMeetingTranscriptionRequest): StopMeetingTranscriptionResponse

    /**
     * Stops transcription for the specified meetingId.
     */
    suspend fun stopMeetingTranscription(block: StopMeetingTranscriptionRequest.DslBuilder.() -> Unit) = stopMeetingTranscription(StopMeetingTranscriptionRequest.builder().apply(block).build())

    /**
     * Applies the specified tags to the specified Amazon Chime SDK attendee.
     */
    suspend fun tagAttendee(input: TagAttendeeRequest): TagAttendeeResponse

    /**
     * Applies the specified tags to the specified Amazon Chime SDK attendee.
     */
    suspend fun tagAttendee(block: TagAttendeeRequest.DslBuilder.() -> Unit) = tagAttendee(TagAttendeeRequest.builder().apply(block).build())

    /**
     * Applies the specified tags to the specified Amazon Chime SDK meeting.
     */
    suspend fun tagMeeting(input: TagMeetingRequest): TagMeetingResponse

    /**
     * Applies the specified tags to the specified Amazon Chime SDK meeting.
     */
    suspend fun tagMeeting(block: TagMeetingRequest.DslBuilder.() -> Unit) = tagMeeting(TagMeetingRequest.builder().apply(block).build())

    /**
     * Applies the specified tags to the specified Amazon Chime SDK meeting resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Applies the specified tags to the specified Amazon Chime SDK meeting resource.
     */
    suspend fun tagResource(block: TagResourceRequest.DslBuilder.() -> Unit) = tagResource(TagResourceRequest.builder().apply(block).build())

    /**
     * Untags the specified tags from the specified Amazon Chime SDK attendee.
     */
    suspend fun untagAttendee(input: UntagAttendeeRequest): UntagAttendeeResponse

    /**
     * Untags the specified tags from the specified Amazon Chime SDK attendee.
     */
    suspend fun untagAttendee(block: UntagAttendeeRequest.DslBuilder.() -> Unit) = untagAttendee(UntagAttendeeRequest.builder().apply(block).build())

    /**
     * Untags the specified tags from the specified Amazon Chime SDK meeting.
     */
    suspend fun untagMeeting(input: UntagMeetingRequest): UntagMeetingResponse

    /**
     * Untags the specified tags from the specified Amazon Chime SDK meeting.
     */
    suspend fun untagMeeting(block: UntagMeetingRequest.DslBuilder.() -> Unit) = untagMeeting(UntagMeetingRequest.builder().apply(block).build())

    /**
     * Untags the specified tags from the specified Amazon Chime SDK meeting resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Untags the specified tags from the specified Amazon Chime SDK meeting resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.DslBuilder.() -> Unit) = untagResource(UntagResourceRequest.builder().apply(block).build())

    /**
     * Updates account details for the specified Amazon Chime account. Currently, only account name and default license updates are supported for this action.
     */
    suspend fun updateAccount(input: UpdateAccountRequest): UpdateAccountResponse

    /**
     * Updates account details for the specified Amazon Chime account. Currently, only account name and default license updates are supported for this action.
     */
    suspend fun updateAccount(block: UpdateAccountRequest.DslBuilder.() -> Unit) = updateAccount(UpdateAccountRequest.builder().apply(block).build())

    /**
     * Updates the settings for the specified Amazon Chime account. You can update settings for
     * remote control of shared screens, or for the dial-out option. For more information about
     * these settings, see <a href="https://docs.aws.amazon.com/chime/latest/ag/policies.html">Use
     * the Policies Page in the Amazon Chime Administration
     * Guide.
     */
    suspend fun updateAccountSettings(input: UpdateAccountSettingsRequest): UpdateAccountSettingsResponse

    /**
     * Updates the settings for the specified Amazon Chime account. You can update settings for
     * remote control of shared screens, or for the dial-out option. For more information about
     * these settings, see <a href="https://docs.aws.amazon.com/chime/latest/ag/policies.html">Use
     * the Policies Page in the Amazon Chime Administration
     * Guide.
     */
    suspend fun updateAccountSettings(block: UpdateAccountSettingsRequest.DslBuilder.() -> Unit) = updateAccountSettings(UpdateAccountSettingsRequest.builder().apply(block).build())

    /**
     * Updates AppInstance metadata.
     */
    suspend fun updateAppInstance(input: UpdateAppInstanceRequest): UpdateAppInstanceResponse

    /**
     * Updates AppInstance metadata.
     */
    suspend fun updateAppInstance(block: UpdateAppInstanceRequest.DslBuilder.() -> Unit) = updateAppInstance(UpdateAppInstanceRequest.builder().apply(block).build())

    /**
     * Updates the details of an AppInstanceUser. You can update names and metadata.
     */
    suspend fun updateAppInstanceUser(input: UpdateAppInstanceUserRequest): UpdateAppInstanceUserResponse

    /**
     * Updates the details of an AppInstanceUser. You can update names and metadata.
     */
    suspend fun updateAppInstanceUser(block: UpdateAppInstanceUserRequest.DslBuilder.() -> Unit) = updateAppInstanceUser(UpdateAppInstanceUserRequest.builder().apply(block).build())

    /**
     * Updates the status of the specified bot, such as starting or stopping the bot from running in your Amazon Chime Enterprise account.
     */
    suspend fun updateBot(input: UpdateBotRequest): UpdateBotResponse

    /**
     * Updates the status of the specified bot, such as starting or stopping the bot from running in your Amazon Chime Enterprise account.
     */
    suspend fun updateBot(block: UpdateBotRequest.DslBuilder.() -> Unit) = updateBot(UpdateBotRequest.builder().apply(block).build())

    /**
     * Update a channel's attributes.
     * Restriction: You can't change a channel's privacy.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun updateChannel(input: UpdateChannelRequest): UpdateChannelResponse

    /**
     * Update a channel's attributes.
     * Restriction: You can't change a channel's privacy.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun updateChannel(block: UpdateChannelRequest.DslBuilder.() -> Unit) = updateChannel(UpdateChannelRequest.builder().apply(block).build())

    /**
     * Updates the content of a message.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun updateChannelMessage(input: UpdateChannelMessageRequest): UpdateChannelMessageResponse

    /**
     * Updates the content of a message.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun updateChannelMessage(block: UpdateChannelMessageRequest.DslBuilder.() -> Unit) = updateChannelMessage(UpdateChannelMessageRequest.builder().apply(block).build())

    /**
     * The details of the time when a user last read messages in a channel.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun updateChannelReadMarker(input: UpdateChannelReadMarkerRequest): UpdateChannelReadMarkerResponse

    /**
     * The details of the time when a user last read messages in a channel.
     * The x-amz-chime-bearer request header is mandatory. Use the
     * AppInstanceUserArn of the user that makes the API call as the value in
     * the header.
     */
    suspend fun updateChannelReadMarker(block: UpdateChannelReadMarkerRequest.DslBuilder.() -> Unit) = updateChannelReadMarker(UpdateChannelReadMarkerRequest.builder().apply(block).build())

    /**
     * Updates global settings for the administrator's AWS account, such as Amazon Chime Business Calling and Amazon Chime Voice Connector settings.
     */
    suspend fun updateGlobalSettings(input: UpdateGlobalSettingsRequest): UpdateGlobalSettingsResponse

    /**
     * Updates global settings for the administrator's AWS account, such as Amazon Chime Business Calling and Amazon Chime Voice Connector settings.
     */
    suspend fun updateGlobalSettings(block: UpdateGlobalSettingsRequest.DslBuilder.() -> Unit) = updateGlobalSettings(UpdateGlobalSettingsRequest.builder().apply(block).build())

    /**
     * Updates phone number details, such as product type or calling name, for the specified phone number ID. You can update one phone number detail at a time. For example, you can update either the product type or the calling name in one action.
     * For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.
     * Updates to outbound calling names can take 72 hours to complete. Pending updates to outbound calling names must be complete before you can request another update.
     */
    suspend fun updatePhoneNumber(input: UpdatePhoneNumberRequest): UpdatePhoneNumberResponse

    /**
     * Updates phone number details, such as product type or calling name, for the specified phone number ID. You can update one phone number detail at a time. For example, you can update either the product type or the calling name in one action.
     * For toll-free numbers, you cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media Application Dial-In product type.
     * Updates to outbound calling names can take 72 hours to complete. Pending updates to outbound calling names must be complete before you can request another update.
     */
    suspend fun updatePhoneNumber(block: UpdatePhoneNumberRequest.DslBuilder.() -> Unit) = updatePhoneNumber(UpdatePhoneNumberRequest.builder().apply(block).build())

    /**
     * Updates the phone number settings for the administrator's AWS account, such as the default
     * outbound calling name. You can update the default outbound calling name once every seven
     * days. Outbound calling names can take up to 72 hours to update.
     */
    suspend fun updatePhoneNumberSettings(input: UpdatePhoneNumberSettingsRequest): UpdatePhoneNumberSettingsResponse

    /**
     * Updates the phone number settings for the administrator's AWS account, such as the default
     * outbound calling name. You can update the default outbound calling name once every seven
     * days. Outbound calling names can take up to 72 hours to update.
     */
    suspend fun updatePhoneNumberSettings(block: UpdatePhoneNumberSettingsRequest.DslBuilder.() -> Unit) = updatePhoneNumberSettings(UpdatePhoneNumberSettingsRequest.builder().apply(block).build())

    /**
     * Updates the specified proxy session details, such as voice or SMS capabilities.
     */
    suspend fun updateProxySession(input: UpdateProxySessionRequest): UpdateProxySessionResponse

    /**
     * Updates the specified proxy session details, such as voice or SMS capabilities.
     */
    suspend fun updateProxySession(block: UpdateProxySessionRequest.DslBuilder.() -> Unit) = updateProxySession(UpdateProxySessionRequest.builder().apply(block).build())

    /**
     * Updates room details, such as the room name, for a room in an Amazon Chime Enterprise account.
     */
    suspend fun updateRoom(input: UpdateRoomRequest): UpdateRoomResponse

    /**
     * Updates room details, such as the room name, for a room in an Amazon Chime Enterprise account.
     */
    suspend fun updateRoom(block: UpdateRoomRequest.DslBuilder.() -> Unit) = updateRoom(UpdateRoomRequest.builder().apply(block).build())

    /**
     * Updates room membership details, such as the member role, for a room in an Amazon Chime
     * Enterprise account. The member role designates whether the member is a chat room
     * administrator or a general chat room member. The member role can be updated only for
     * user IDs.
     */
    suspend fun updateRoomMembership(input: UpdateRoomMembershipRequest): UpdateRoomMembershipResponse

    /**
     * Updates room membership details, such as the member role, for a room in an Amazon Chime
     * Enterprise account. The member role designates whether the member is a chat room
     * administrator or a general chat room member. The member role can be updated only for
     * user IDs.
     */
    suspend fun updateRoomMembership(block: UpdateRoomMembershipRequest.DslBuilder.() -> Unit) = updateRoomMembership(UpdateRoomMembershipRequest.builder().apply(block).build())

    /**
     * Updates the details of the specified SIP media application.
     */
    suspend fun updateSipMediaApplication(input: UpdateSipMediaApplicationRequest): UpdateSipMediaApplicationResponse

    /**
     * Updates the details of the specified SIP media application.
     */
    suspend fun updateSipMediaApplication(block: UpdateSipMediaApplicationRequest.DslBuilder.() -> Unit) = updateSipMediaApplication(UpdateSipMediaApplicationRequest.builder().apply(block).build())

    /**
     * Allows you to trigger a Lambda function at any time while a call is active, and replace the current actions with new actions returned by the invocation.
     */
    suspend fun updateSipMediaApplicationCall(input: UpdateSipMediaApplicationCallRequest): UpdateSipMediaApplicationCallResponse

    /**
     * Allows you to trigger a Lambda function at any time while a call is active, and replace the current actions with new actions returned by the invocation.
     */
    suspend fun updateSipMediaApplicationCall(block: UpdateSipMediaApplicationCallRequest.DslBuilder.() -> Unit) = updateSipMediaApplicationCall(UpdateSipMediaApplicationCallRequest.builder().apply(block).build())

    /**
     * Updates the details of the specified SIP rule.
     */
    suspend fun updateSipRule(input: UpdateSipRuleRequest): UpdateSipRuleResponse

    /**
     * Updates the details of the specified SIP rule.
     */
    suspend fun updateSipRule(block: UpdateSipRuleRequest.DslBuilder.() -> Unit) = updateSipRule(UpdateSipRuleRequest.builder().apply(block).build())

    /**
     * Updates user details for a specified user ID. Currently, only LicenseType updates are supported for this action.
     */
    suspend fun updateUser(input: UpdateUserRequest): UpdateUserResponse

    /**
     * Updates user details for a specified user ID. Currently, only LicenseType updates are supported for this action.
     */
    suspend fun updateUser(block: UpdateUserRequest.DslBuilder.() -> Unit) = updateUser(UpdateUserRequest.builder().apply(block).build())

    /**
     * Updates the settings for the specified user, such as phone number settings.
     */
    suspend fun updateUserSettings(input: UpdateUserSettingsRequest): UpdateUserSettingsResponse

    /**
     * Updates the settings for the specified user, such as phone number settings.
     */
    suspend fun updateUserSettings(block: UpdateUserSettingsRequest.DslBuilder.() -> Unit) = updateUserSettings(UpdateUserSettingsRequest.builder().apply(block).build())

    /**
     * Updates details for the specified Amazon Chime Voice Connector.
     */
    suspend fun updateVoiceConnector(input: UpdateVoiceConnectorRequest): UpdateVoiceConnectorResponse

    /**
     * Updates details for the specified Amazon Chime Voice Connector.
     */
    suspend fun updateVoiceConnector(block: UpdateVoiceConnectorRequest.DslBuilder.() -> Unit) = updateVoiceConnector(UpdateVoiceConnectorRequest.builder().apply(block).build())

    /**
     * Updates details of the specified Amazon Chime Voice Connector group, such as the name and
     * Amazon Chime Voice Connector priority ranking.
     */
    suspend fun updateVoiceConnectorGroup(input: UpdateVoiceConnectorGroupRequest): UpdateVoiceConnectorGroupResponse

    /**
     * Updates details of the specified Amazon Chime Voice Connector group, such as the name and
     * Amazon Chime Voice Connector priority ranking.
     */
    suspend fun updateVoiceConnectorGroup(block: UpdateVoiceConnectorGroupRequest.DslBuilder.() -> Unit) = updateVoiceConnectorGroup(UpdateVoiceConnectorGroupRequest.builder().apply(block).build())
}
