// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The Amazon Chime account details. An AWS account can have multiple Amazon Chime accounts.
 */
class Account private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Chime account ID.
     */
    val accountId: String? = builder.accountId
    /**
     * The status of the account.
     */
    val accountStatus: AccountStatus? = builder.accountStatus
    /**
     * The Amazon Chime account type. For more information about different account types, see
     * <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime Accounts in the Amazon Chime Administration
     * Guide.
     */
    val accountType: AccountType? = builder.accountType
    /**
     * The AWS account ID.
     */
    val awsAccountId: String? = builder.awsAccountId
    /**
     * The Amazon Chime account creation timestamp, in ISO 8601 format.
     */
    val createdTimestamp: Instant? = builder.createdTimestamp
    /**
     * The default license for the Amazon Chime account.
     */
    val defaultLicense: License? = builder.defaultLicense
    /**
     * The Amazon Chime account name.
     */
    val name: String? = builder.name
    /**
     * The sign-in delegate groups associated with the account.
     */
    val signinDelegateGroups: List<SigninDelegateGroup>? = builder.signinDelegateGroups
    /**
     * Supported licenses for the Amazon Chime account.
     */
    val supportedLicenses: List<License>? = builder.supportedLicenses

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Account = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Account(")
        append("accountId=$accountId,")
        append("accountStatus=$accountStatus,")
        append("accountType=$accountType,")
        append("awsAccountId=$awsAccountId,")
        append("createdTimestamp=$createdTimestamp,")
        append("defaultLicense=$defaultLicense,")
        append("name=$name,")
        append("signinDelegateGroups=$signinDelegateGroups,")
        append("supportedLicenses=$supportedLicenses)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (accountStatus?.hashCode() ?: 0)
        result = 31 * result + (accountType?.hashCode() ?: 0)
        result = 31 * result + (awsAccountId?.hashCode() ?: 0)
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (defaultLicense?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (signinDelegateGroups?.hashCode() ?: 0)
        result = 31 * result + (supportedLicenses?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Account

        if (accountId != other.accountId) return false
        if (accountStatus != other.accountStatus) return false
        if (accountType != other.accountType) return false
        if (awsAccountId != other.awsAccountId) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (defaultLicense != other.defaultLicense) return false
        if (name != other.name) return false
        if (signinDelegateGroups != other.signinDelegateGroups) return false
        if (supportedLicenses != other.supportedLicenses) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Account = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Account
        /**
         * The Amazon Chime account ID.
         */
        fun accountId(accountId: String): FluentBuilder
        /**
         * The status of the account.
         */
        fun accountStatus(accountStatus: AccountStatus): FluentBuilder
        /**
         * The Amazon Chime account type. For more information about different account types, see
         * <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime Accounts in the Amazon Chime Administration
         * Guide.
         */
        fun accountType(accountType: AccountType): FluentBuilder
        /**
         * The AWS account ID.
         */
        fun awsAccountId(awsAccountId: String): FluentBuilder
        /**
         * The Amazon Chime account creation timestamp, in ISO 8601 format.
         */
        fun createdTimestamp(createdTimestamp: Instant): FluentBuilder
        /**
         * The default license for the Amazon Chime account.
         */
        fun defaultLicense(defaultLicense: License): FluentBuilder
        /**
         * The Amazon Chime account name.
         */
        fun name(name: String): FluentBuilder
        /**
         * The sign-in delegate groups associated with the account.
         */
        fun signinDelegateGroups(signinDelegateGroups: List<SigninDelegateGroup>): FluentBuilder
        /**
         * Supported licenses for the Amazon Chime account.
         */
        fun supportedLicenses(supportedLicenses: List<License>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Chime account ID.
         */
        var accountId: String?
        /**
         * The status of the account.
         */
        var accountStatus: AccountStatus?
        /**
         * The Amazon Chime account type. For more information about different account types, see
         * <a href="https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html">Managing Your Amazon Chime Accounts in the Amazon Chime Administration
         * Guide.
         */
        var accountType: AccountType?
        /**
         * The AWS account ID.
         */
        var awsAccountId: String?
        /**
         * The Amazon Chime account creation timestamp, in ISO 8601 format.
         */
        var createdTimestamp: Instant?
        /**
         * The default license for the Amazon Chime account.
         */
        var defaultLicense: License?
        /**
         * The Amazon Chime account name.
         */
        var name: String?
        /**
         * The sign-in delegate groups associated with the account.
         */
        var signinDelegateGroups: List<SigninDelegateGroup>?
        /**
         * Supported licenses for the Amazon Chime account.
         */
        var supportedLicenses: List<License>?

        fun build(): Account
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accountId: String? = null
        override var accountStatus: AccountStatus? = null
        override var accountType: AccountType? = null
        override var awsAccountId: String? = null
        override var createdTimestamp: Instant? = null
        override var defaultLicense: License? = null
        override var name: String? = null
        override var signinDelegateGroups: List<SigninDelegateGroup>? = null
        override var supportedLicenses: List<License>? = null

        constructor(x: Account) : this() {
            this.accountId = x.accountId
            this.accountStatus = x.accountStatus
            this.accountType = x.accountType
            this.awsAccountId = x.awsAccountId
            this.createdTimestamp = x.createdTimestamp
            this.defaultLicense = x.defaultLicense
            this.name = x.name
            this.signinDelegateGroups = x.signinDelegateGroups
            this.supportedLicenses = x.supportedLicenses
        }

        override fun build(): Account = Account(this)
        override fun accountId(accountId: String): FluentBuilder = apply { this.accountId = accountId }
        override fun accountStatus(accountStatus: AccountStatus): FluentBuilder = apply { this.accountStatus = accountStatus }
        override fun accountType(accountType: AccountType): FluentBuilder = apply { this.accountType = accountType }
        override fun awsAccountId(awsAccountId: String): FluentBuilder = apply { this.awsAccountId = awsAccountId }
        override fun createdTimestamp(createdTimestamp: Instant): FluentBuilder = apply { this.createdTimestamp = createdTimestamp }
        override fun defaultLicense(defaultLicense: License): FluentBuilder = apply { this.defaultLicense = defaultLicense }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun signinDelegateGroups(signinDelegateGroups: List<SigninDelegateGroup>): FluentBuilder = apply { this.signinDelegateGroups = signinDelegateGroups }
        override fun supportedLicenses(supportedLicenses: List<License>): FluentBuilder = apply { this.supportedLicenses = supportedLicenses }
    }
}
