// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model



/**
 * Settings related to the Amazon Chime account. This includes settings that start or stop
 * remote control of shared screens, or start or stop the dial-out option in the Amazon Chime web application. For more information about these settings, see
 * <a href="https://docs.aws.amazon.com/chime/latest/ag/policies.html">Use the Policies Page in the Amazon Chime Administration Guide.
 */
class AccountSettings private constructor(builder: BuilderImpl) {
    /**
     * Setting that stops or starts remote control of shared screens during meetings.
     */
    val disableRemoteControl: Boolean? = builder.disableRemoteControl
    /**
     * Setting that allows meeting participants to choose the Call me at a phone number option. For more information, see
     * <a href="https://docs.aws.amazon.com/chime/latest/ug/chime-join-meeting.html">Join a Meeting without the Amazon Chime App.
     */
    val enableDialOut: Boolean? = builder.enableDialOut

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AccountSettings = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AccountSettings(")
        append("disableRemoteControl=$disableRemoteControl,")
        append("enableDialOut=$enableDialOut)")
    }

    override fun hashCode(): kotlin.Int {
        var result = disableRemoteControl?.hashCode() ?: 0
        result = 31 * result + (enableDialOut?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AccountSettings

        if (disableRemoteControl != other.disableRemoteControl) return false
        if (enableDialOut != other.enableDialOut) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AccountSettings = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AccountSettings
        /**
         * Setting that stops or starts remote control of shared screens during meetings.
         */
        fun disableRemoteControl(disableRemoteControl: Boolean): FluentBuilder
        /**
         * Setting that allows meeting participants to choose the Call me at a phone number option. For more information, see
         * <a href="https://docs.aws.amazon.com/chime/latest/ug/chime-join-meeting.html">Join a Meeting without the Amazon Chime App.
         */
        fun enableDialOut(enableDialOut: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Setting that stops or starts remote control of shared screens during meetings.
         */
        var disableRemoteControl: Boolean?
        /**
         * Setting that allows meeting participants to choose the Call me at a phone number option. For more information, see
         * <a href="https://docs.aws.amazon.com/chime/latest/ug/chime-join-meeting.html">Join a Meeting without the Amazon Chime App.
         */
        var enableDialOut: Boolean?

        fun build(): AccountSettings
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var disableRemoteControl: Boolean? = null
        override var enableDialOut: Boolean? = null

        constructor(x: AccountSettings) : this() {
            this.disableRemoteControl = x.disableRemoteControl
            this.enableDialOut = x.enableDialOut
        }

        override fun build(): AccountSettings = AccountSettings(this)
        override fun disableRemoteControl(disableRemoteControl: Boolean): FluentBuilder = apply { this.disableRemoteControl = disableRemoteControl }
        override fun enableDialOut(enableDialOut: Boolean): FluentBuilder = apply { this.enableDialOut = enableDialOut }
    }
}
