// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of an AppInstance, an instance of an Amazon Chime SDK messaging application.
 */
class AppInstance private constructor(builder: BuilderImpl) {
    /**
     * The ARN of the messaging instance.
     */
    val appInstanceArn: String? = builder.appInstanceArn
    /**
     * The time at which an AppInstance was created. In epoch milliseconds.
     */
    val createdTimestamp: Instant? = builder.createdTimestamp
    /**
     * The time an AppInstance was last updated. In epoch milliseconds.
     */
    val lastUpdatedTimestamp: Instant? = builder.lastUpdatedTimestamp
    /**
     * The metadata of an AppInstance.
     */
    val metadata: String? = builder.metadata
    /**
     * The name of an AppInstance.
     */
    val name: String? = builder.name

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AppInstance = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AppInstance(")
        append("appInstanceArn=$appInstanceArn,")
        append("createdTimestamp=$createdTimestamp,")
        append("lastUpdatedTimestamp=$lastUpdatedTimestamp,")
        append("metadata=*** Sensitive Data Redacted ***,")
        append("name=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appInstanceArn?.hashCode() ?: 0
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AppInstance

        if (appInstanceArn != other.appInstanceArn) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (lastUpdatedTimestamp != other.lastUpdatedTimestamp) return false
        if (metadata != other.metadata) return false
        if (name != other.name) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AppInstance = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AppInstance
        /**
         * The ARN of the messaging instance.
         */
        fun appInstanceArn(appInstanceArn: String): FluentBuilder
        /**
         * The time at which an AppInstance was created. In epoch milliseconds.
         */
        fun createdTimestamp(createdTimestamp: Instant): FluentBuilder
        /**
         * The time an AppInstance was last updated. In epoch milliseconds.
         */
        fun lastUpdatedTimestamp(lastUpdatedTimestamp: Instant): FluentBuilder
        /**
         * The metadata of an AppInstance.
         */
        fun metadata(metadata: String): FluentBuilder
        /**
         * The name of an AppInstance.
         */
        fun name(name: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ARN of the messaging instance.
         */
        var appInstanceArn: String?
        /**
         * The time at which an AppInstance was created. In epoch milliseconds.
         */
        var createdTimestamp: Instant?
        /**
         * The time an AppInstance was last updated. In epoch milliseconds.
         */
        var lastUpdatedTimestamp: Instant?
        /**
         * The metadata of an AppInstance.
         */
        var metadata: String?
        /**
         * The name of an AppInstance.
         */
        var name: String?

        fun build(): AppInstance
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var appInstanceArn: String? = null
        override var createdTimestamp: Instant? = null
        override var lastUpdatedTimestamp: Instant? = null
        override var metadata: String? = null
        override var name: String? = null

        constructor(x: AppInstance) : this() {
            this.appInstanceArn = x.appInstanceArn
            this.createdTimestamp = x.createdTimestamp
            this.lastUpdatedTimestamp = x.lastUpdatedTimestamp
            this.metadata = x.metadata
            this.name = x.name
        }

        override fun build(): AppInstance = AppInstance(this)
        override fun appInstanceArn(appInstanceArn: String): FluentBuilder = apply { this.appInstanceArn = appInstanceArn }
        override fun createdTimestamp(createdTimestamp: Instant): FluentBuilder = apply { this.createdTimestamp = createdTimestamp }
        override fun lastUpdatedTimestamp(lastUpdatedTimestamp: Instant): FluentBuilder = apply { this.lastUpdatedTimestamp = lastUpdatedTimestamp }
        override fun metadata(metadata: String): FluentBuilder = apply { this.metadata = metadata }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
    }
}
