// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model



/**
 * An Amazon Chime SDK meeting attendee. Includes a unique
 * AttendeeId
 * and
 * JoinToken
 * . The
 * JoinToken
 * allows a client to authenticate and join as the specified attendee. The
 * JoinToken
 * expires when the meeting ends or when
 * DeleteAttendee
 * is called. After that, the attendee is unable to join the meeting.
 * We recommend securely transferring each JoinToken from your server application
 * to the client so that no other client has access to the token except for the one
 * authorized to represent the attendee.
 */
class Attendee private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Chime SDK attendee ID.
     */
    val attendeeId: String? = builder.attendeeId
    /**
     * The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.
     */
    val externalUserId: String? = builder.externalUserId
    /**
     * The join token used by the Amazon Chime SDK attendee.
     */
    val joinToken: String? = builder.joinToken

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Attendee = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Attendee(")
        append("attendeeId=$attendeeId,")
        append("externalUserId=*** Sensitive Data Redacted ***,")
        append("joinToken=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attendeeId?.hashCode() ?: 0
        result = 31 * result + (externalUserId?.hashCode() ?: 0)
        result = 31 * result + (joinToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Attendee

        if (attendeeId != other.attendeeId) return false
        if (externalUserId != other.externalUserId) return false
        if (joinToken != other.joinToken) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Attendee = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Attendee
        /**
         * The Amazon Chime SDK attendee ID.
         */
        fun attendeeId(attendeeId: String): FluentBuilder
        /**
         * The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.
         */
        fun externalUserId(externalUserId: String): FluentBuilder
        /**
         * The join token used by the Amazon Chime SDK attendee.
         */
        fun joinToken(joinToken: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Chime SDK attendee ID.
         */
        var attendeeId: String?
        /**
         * The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a builder application.
         */
        var externalUserId: String?
        /**
         * The join token used by the Amazon Chime SDK attendee.
         */
        var joinToken: String?

        fun build(): Attendee
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var attendeeId: String? = null
        override var externalUserId: String? = null
        override var joinToken: String? = null

        constructor(x: Attendee) : this() {
            this.attendeeId = x.attendeeId
            this.externalUserId = x.externalUserId
            this.joinToken = x.joinToken
        }

        override fun build(): Attendee = Attendee(this)
        override fun attendeeId(attendeeId: String): FluentBuilder = apply { this.attendeeId = attendeeId }
        override fun externalUserId(externalUserId: String): FluentBuilder = apply { this.externalUserId = externalUserId }
        override fun joinToken(joinToken: String): FluentBuilder = apply { this.joinToken = joinToken }
    }
}
