// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A resource that allows Enterprise account administrators to configure an interface to receive events from Amazon Chime.
 */
class Bot private constructor(builder: BuilderImpl) {
    /**
     * The bot email address.
     */
    val botEmail: String? = builder.botEmail
    /**
     * The bot ID.
     */
    val botId: String? = builder.botId
    /**
     * The bot type.
     */
    val botType: BotType? = builder.botType
    /**
     * The bot creation timestamp, in ISO 8601 format.
     */
    val createdTimestamp: Instant? = builder.createdTimestamp
    /**
     * When true, the bot is stopped from running in your account.
     */
    val disabled: Boolean? = builder.disabled
    /**
     * The bot display name.
     */
    val displayName: String? = builder.displayName
    /**
     * The security token used to authenticate Amazon Chime with the outgoing event endpoint.
     */
    val securityToken: String? = builder.securityToken
    /**
     * The updated bot timestamp, in ISO 8601 format.
     */
    val updatedTimestamp: Instant? = builder.updatedTimestamp
    /**
     * The unique ID for the bot user.
     */
    val userId: String? = builder.userId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Bot = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Bot(")
        append("botEmail=*** Sensitive Data Redacted ***,")
        append("botId=$botId,")
        append("botType=$botType,")
        append("createdTimestamp=$createdTimestamp,")
        append("disabled=$disabled,")
        append("displayName=*** Sensitive Data Redacted ***,")
        append("securityToken=*** Sensitive Data Redacted ***,")
        append("updatedTimestamp=$updatedTimestamp,")
        append("userId=$userId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = botEmail?.hashCode() ?: 0
        result = 31 * result + (botId?.hashCode() ?: 0)
        result = 31 * result + (botType?.hashCode() ?: 0)
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (disabled?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (securityToken?.hashCode() ?: 0)
        result = 31 * result + (updatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Bot

        if (botEmail != other.botEmail) return false
        if (botId != other.botId) return false
        if (botType != other.botType) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (disabled != other.disabled) return false
        if (displayName != other.displayName) return false
        if (securityToken != other.securityToken) return false
        if (updatedTimestamp != other.updatedTimestamp) return false
        if (userId != other.userId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Bot = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Bot
        /**
         * The bot email address.
         */
        fun botEmail(botEmail: String): FluentBuilder
        /**
         * The bot ID.
         */
        fun botId(botId: String): FluentBuilder
        /**
         * The bot type.
         */
        fun botType(botType: BotType): FluentBuilder
        /**
         * The bot creation timestamp, in ISO 8601 format.
         */
        fun createdTimestamp(createdTimestamp: Instant): FluentBuilder
        /**
         * When true, the bot is stopped from running in your account.
         */
        fun disabled(disabled: Boolean): FluentBuilder
        /**
         * The bot display name.
         */
        fun displayName(displayName: String): FluentBuilder
        /**
         * The security token used to authenticate Amazon Chime with the outgoing event endpoint.
         */
        fun securityToken(securityToken: String): FluentBuilder
        /**
         * The updated bot timestamp, in ISO 8601 format.
         */
        fun updatedTimestamp(updatedTimestamp: Instant): FluentBuilder
        /**
         * The unique ID for the bot user.
         */
        fun userId(userId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The bot email address.
         */
        var botEmail: String?
        /**
         * The bot ID.
         */
        var botId: String?
        /**
         * The bot type.
         */
        var botType: BotType?
        /**
         * The bot creation timestamp, in ISO 8601 format.
         */
        var createdTimestamp: Instant?
        /**
         * When true, the bot is stopped from running in your account.
         */
        var disabled: Boolean?
        /**
         * The bot display name.
         */
        var displayName: String?
        /**
         * The security token used to authenticate Amazon Chime with the outgoing event endpoint.
         */
        var securityToken: String?
        /**
         * The updated bot timestamp, in ISO 8601 format.
         */
        var updatedTimestamp: Instant?
        /**
         * The unique ID for the bot user.
         */
        var userId: String?

        fun build(): Bot
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var botEmail: String? = null
        override var botId: String? = null
        override var botType: BotType? = null
        override var createdTimestamp: Instant? = null
        override var disabled: Boolean? = null
        override var displayName: String? = null
        override var securityToken: String? = null
        override var updatedTimestamp: Instant? = null
        override var userId: String? = null

        constructor(x: Bot) : this() {
            this.botEmail = x.botEmail
            this.botId = x.botId
            this.botType = x.botType
            this.createdTimestamp = x.createdTimestamp
            this.disabled = x.disabled
            this.displayName = x.displayName
            this.securityToken = x.securityToken
            this.updatedTimestamp = x.updatedTimestamp
            this.userId = x.userId
        }

        override fun build(): Bot = Bot(this)
        override fun botEmail(botEmail: String): FluentBuilder = apply { this.botEmail = botEmail }
        override fun botId(botId: String): FluentBuilder = apply { this.botId = botId }
        override fun botType(botType: BotType): FluentBuilder = apply { this.botType = botType }
        override fun createdTimestamp(createdTimestamp: Instant): FluentBuilder = apply { this.createdTimestamp = createdTimestamp }
        override fun disabled(disabled: Boolean): FluentBuilder = apply { this.disabled = disabled }
        override fun displayName(displayName: String): FluentBuilder = apply { this.displayName = displayName }
        override fun securityToken(securityToken: String): FluentBuilder = apply { this.securityToken = securityToken }
        override fun updatedTimestamp(updatedTimestamp: Instant): FluentBuilder = apply { this.updatedTimestamp = updatedTimestamp }
        override fun userId(userId: String): FluentBuilder = apply { this.userId = userId }
    }
}
