// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of a channel.
 */
class Channel private constructor(builder: BuilderImpl) {
    /**
     * The ARN of the channel.
     */
    val channelArn: String? = builder.channelArn
    /**
     * The AppInstanceUser who created the channel.
     */
    val createdBy: Identity? = builder.createdBy
    /**
     * The time at which the AppInstanceUser created the channel.
     */
    val createdTimestamp: Instant? = builder.createdTimestamp
    /**
     * The time at which a member sent the last message in the channel.
     */
    val lastMessageTimestamp: Instant? = builder.lastMessageTimestamp
    /**
     * The time at which a channel was last updated.
     */
    val lastUpdatedTimestamp: Instant? = builder.lastUpdatedTimestamp
    /**
     * The channel's metadata.
     */
    val metadata: String? = builder.metadata
    /**
     * The mode of the channel.
     */
    val mode: ChannelMode? = builder.mode
    /**
     * The name of the channel.
     */
    val name: String? = builder.name
    /**
     * The channel's privacy setting.
     */
    val privacy: ChannelPrivacy? = builder.privacy

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Channel = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Channel(")
        append("channelArn=$channelArn,")
        append("createdBy=$createdBy,")
        append("createdTimestamp=$createdTimestamp,")
        append("lastMessageTimestamp=$lastMessageTimestamp,")
        append("lastUpdatedTimestamp=$lastUpdatedTimestamp,")
        append("metadata=*** Sensitive Data Redacted ***,")
        append("mode=$mode,")
        append("name=*** Sensitive Data Redacted ***,")
        append("privacy=$privacy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelArn?.hashCode() ?: 0
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lastMessageTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (privacy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Channel

        if (channelArn != other.channelArn) return false
        if (createdBy != other.createdBy) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (lastMessageTimestamp != other.lastMessageTimestamp) return false
        if (lastUpdatedTimestamp != other.lastUpdatedTimestamp) return false
        if (metadata != other.metadata) return false
        if (mode != other.mode) return false
        if (name != other.name) return false
        if (privacy != other.privacy) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Channel = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Channel
        /**
         * The ARN of the channel.
         */
        fun channelArn(channelArn: String): FluentBuilder
        /**
         * The AppInstanceUser who created the channel.
         */
        fun createdBy(createdBy: Identity): FluentBuilder
        /**
         * The time at which the AppInstanceUser created the channel.
         */
        fun createdTimestamp(createdTimestamp: Instant): FluentBuilder
        /**
         * The time at which a member sent the last message in the channel.
         */
        fun lastMessageTimestamp(lastMessageTimestamp: Instant): FluentBuilder
        /**
         * The time at which a channel was last updated.
         */
        fun lastUpdatedTimestamp(lastUpdatedTimestamp: Instant): FluentBuilder
        /**
         * The channel's metadata.
         */
        fun metadata(metadata: String): FluentBuilder
        /**
         * The mode of the channel.
         */
        fun mode(mode: ChannelMode): FluentBuilder
        /**
         * The name of the channel.
         */
        fun name(name: String): FluentBuilder
        /**
         * The channel's privacy setting.
         */
        fun privacy(privacy: ChannelPrivacy): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ARN of the channel.
         */
        var channelArn: String?
        /**
         * The AppInstanceUser who created the channel.
         */
        var createdBy: Identity?
        /**
         * The time at which the AppInstanceUser created the channel.
         */
        var createdTimestamp: Instant?
        /**
         * The time at which a member sent the last message in the channel.
         */
        var lastMessageTimestamp: Instant?
        /**
         * The time at which a channel was last updated.
         */
        var lastUpdatedTimestamp: Instant?
        /**
         * The channel's metadata.
         */
        var metadata: String?
        /**
         * The mode of the channel.
         */
        var mode: ChannelMode?
        /**
         * The name of the channel.
         */
        var name: String?
        /**
         * The channel's privacy setting.
         */
        var privacy: ChannelPrivacy?

        fun build(): Channel
        /**
         * construct an [aws.sdk.kotlin.services.chime.model.Identity] inside the given [block]
         */
        fun createdBy(block: Identity.DslBuilder.() -> kotlin.Unit) {
            this.createdBy = Identity.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var channelArn: String? = null
        override var createdBy: Identity? = null
        override var createdTimestamp: Instant? = null
        override var lastMessageTimestamp: Instant? = null
        override var lastUpdatedTimestamp: Instant? = null
        override var metadata: String? = null
        override var mode: ChannelMode? = null
        override var name: String? = null
        override var privacy: ChannelPrivacy? = null

        constructor(x: Channel) : this() {
            this.channelArn = x.channelArn
            this.createdBy = x.createdBy
            this.createdTimestamp = x.createdTimestamp
            this.lastMessageTimestamp = x.lastMessageTimestamp
            this.lastUpdatedTimestamp = x.lastUpdatedTimestamp
            this.metadata = x.metadata
            this.mode = x.mode
            this.name = x.name
            this.privacy = x.privacy
        }

        override fun build(): Channel = Channel(this)
        override fun channelArn(channelArn: String): FluentBuilder = apply { this.channelArn = channelArn }
        override fun createdBy(createdBy: Identity): FluentBuilder = apply { this.createdBy = createdBy }
        override fun createdTimestamp(createdTimestamp: Instant): FluentBuilder = apply { this.createdTimestamp = createdTimestamp }
        override fun lastMessageTimestamp(lastMessageTimestamp: Instant): FluentBuilder = apply { this.lastMessageTimestamp = lastMessageTimestamp }
        override fun lastUpdatedTimestamp(lastUpdatedTimestamp: Instant): FluentBuilder = apply { this.lastUpdatedTimestamp = lastUpdatedTimestamp }
        override fun metadata(metadata: String): FluentBuilder = apply { this.metadata = metadata }
        override fun mode(mode: ChannelMode): FluentBuilder = apply { this.mode = mode }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun privacy(privacy: ChannelPrivacy): FluentBuilder = apply { this.privacy = privacy }
    }
}
