// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of a channel member.
 */
class ChannelMembership private constructor(builder: BuilderImpl) {
    /**
     * The ARN of the member's channel.
     */
    val channelArn: String? = builder.channelArn
    /**
     * The time at which the channel membership was created.
     */
    val createdTimestamp: Instant? = builder.createdTimestamp
    /**
     * The identifier of the member who invited another member.
     */
    val invitedBy: Identity? = builder.invitedBy
    /**
     * The time at which a channel membership was last updated.
     */
    val lastUpdatedTimestamp: Instant? = builder.lastUpdatedTimestamp
    /**
     * The data of the channel member.
     */
    val member: Identity? = builder.member
    /**
     * The membership type set for the channel member.
     */
    val type: ChannelMembershipType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ChannelMembership = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ChannelMembership(")
        append("channelArn=$channelArn,")
        append("createdTimestamp=$createdTimestamp,")
        append("invitedBy=$invitedBy,")
        append("lastUpdatedTimestamp=$lastUpdatedTimestamp,")
        append("member=$member,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelArn?.hashCode() ?: 0
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (invitedBy?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (member?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ChannelMembership

        if (channelArn != other.channelArn) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (invitedBy != other.invitedBy) return false
        if (lastUpdatedTimestamp != other.lastUpdatedTimestamp) return false
        if (member != other.member) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ChannelMembership = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ChannelMembership
        /**
         * The ARN of the member's channel.
         */
        fun channelArn(channelArn: String): FluentBuilder
        /**
         * The time at which the channel membership was created.
         */
        fun createdTimestamp(createdTimestamp: Instant): FluentBuilder
        /**
         * The identifier of the member who invited another member.
         */
        fun invitedBy(invitedBy: Identity): FluentBuilder
        /**
         * The time at which a channel membership was last updated.
         */
        fun lastUpdatedTimestamp(lastUpdatedTimestamp: Instant): FluentBuilder
        /**
         * The data of the channel member.
         */
        fun member(member: Identity): FluentBuilder
        /**
         * The membership type set for the channel member.
         */
        fun type(type: ChannelMembershipType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ARN of the member's channel.
         */
        var channelArn: String?
        /**
         * The time at which the channel membership was created.
         */
        var createdTimestamp: Instant?
        /**
         * The identifier of the member who invited another member.
         */
        var invitedBy: Identity?
        /**
         * The time at which a channel membership was last updated.
         */
        var lastUpdatedTimestamp: Instant?
        /**
         * The data of the channel member.
         */
        var member: Identity?
        /**
         * The membership type set for the channel member.
         */
        var type: ChannelMembershipType?

        fun build(): ChannelMembership
        /**
         * construct an [aws.sdk.kotlin.services.chime.model.Identity] inside the given [block]
         */
        fun invitedBy(block: Identity.DslBuilder.() -> kotlin.Unit) {
            this.invitedBy = Identity.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.chime.model.Identity] inside the given [block]
         */
        fun member(block: Identity.DslBuilder.() -> kotlin.Unit) {
            this.member = Identity.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var channelArn: String? = null
        override var createdTimestamp: Instant? = null
        override var invitedBy: Identity? = null
        override var lastUpdatedTimestamp: Instant? = null
        override var member: Identity? = null
        override var type: ChannelMembershipType? = null

        constructor(x: ChannelMembership) : this() {
            this.channelArn = x.channelArn
            this.createdTimestamp = x.createdTimestamp
            this.invitedBy = x.invitedBy
            this.lastUpdatedTimestamp = x.lastUpdatedTimestamp
            this.member = x.member
            this.type = x.type
        }

        override fun build(): ChannelMembership = ChannelMembership(this)
        override fun channelArn(channelArn: String): FluentBuilder = apply { this.channelArn = channelArn }
        override fun createdTimestamp(createdTimestamp: Instant): FluentBuilder = apply { this.createdTimestamp = createdTimestamp }
        override fun invitedBy(invitedBy: Identity): FluentBuilder = apply { this.invitedBy = invitedBy }
        override fun lastUpdatedTimestamp(lastUpdatedTimestamp: Instant): FluentBuilder = apply { this.lastUpdatedTimestamp = lastUpdatedTimestamp }
        override fun member(member: Identity): FluentBuilder = apply { this.member = member }
        override fun type(type: ChannelMembershipType): FluentBuilder = apply { this.type = type }
    }
}
