// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of a message in a channel.
 */
class ChannelMessage private constructor(builder: BuilderImpl) {
    /**
     * The ARN of the channel.
     */
    val channelArn: String? = builder.channelArn
    /**
     * The message content.
     */
    val content: String? = builder.content
    /**
     * The time at which the message was created.
     */
    val createdTimestamp: Instant? = builder.createdTimestamp
    /**
     * The time at which a message was edited.
     */
    val lastEditedTimestamp: Instant? = builder.lastEditedTimestamp
    /**
     * The time at which a message was updated.
     */
    val lastUpdatedTimestamp: Instant? = builder.lastUpdatedTimestamp
    /**
     * The ID of a message.
     */
    val messageId: String? = builder.messageId
    /**
     * The message metadata.
     */
    val metadata: String? = builder.metadata
    /**
     * The persistence setting for a channel message.
     */
    val persistence: ChannelMessagePersistenceType? = builder.persistence
    /**
     * Hides the content of a message.
     */
    val redacted: Boolean = builder.redacted
    /**
     * The message sender.
     */
    val sender: Identity? = builder.sender
    /**
     * The message type.
     */
    val type: ChannelMessageType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ChannelMessage = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ChannelMessage(")
        append("channelArn=$channelArn,")
        append("content=*** Sensitive Data Redacted ***,")
        append("createdTimestamp=$createdTimestamp,")
        append("lastEditedTimestamp=$lastEditedTimestamp,")
        append("lastUpdatedTimestamp=$lastUpdatedTimestamp,")
        append("messageId=$messageId,")
        append("metadata=*** Sensitive Data Redacted ***,")
        append("persistence=$persistence,")
        append("redacted=$redacted,")
        append("sender=$sender,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelArn?.hashCode() ?: 0
        result = 31 * result + (content?.hashCode() ?: 0)
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lastEditedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (messageId?.hashCode() ?: 0)
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (persistence?.hashCode() ?: 0)
        result = 31 * result + (redacted.hashCode())
        result = 31 * result + (sender?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ChannelMessage

        if (channelArn != other.channelArn) return false
        if (content != other.content) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (lastEditedTimestamp != other.lastEditedTimestamp) return false
        if (lastUpdatedTimestamp != other.lastUpdatedTimestamp) return false
        if (messageId != other.messageId) return false
        if (metadata != other.metadata) return false
        if (persistence != other.persistence) return false
        if (redacted != other.redacted) return false
        if (sender != other.sender) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ChannelMessage = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ChannelMessage
        /**
         * The ARN of the channel.
         */
        fun channelArn(channelArn: String): FluentBuilder
        /**
         * The message content.
         */
        fun content(content: String): FluentBuilder
        /**
         * The time at which the message was created.
         */
        fun createdTimestamp(createdTimestamp: Instant): FluentBuilder
        /**
         * The time at which a message was edited.
         */
        fun lastEditedTimestamp(lastEditedTimestamp: Instant): FluentBuilder
        /**
         * The time at which a message was updated.
         */
        fun lastUpdatedTimestamp(lastUpdatedTimestamp: Instant): FluentBuilder
        /**
         * The ID of a message.
         */
        fun messageId(messageId: String): FluentBuilder
        /**
         * The message metadata.
         */
        fun metadata(metadata: String): FluentBuilder
        /**
         * The persistence setting for a channel message.
         */
        fun persistence(persistence: ChannelMessagePersistenceType): FluentBuilder
        /**
         * Hides the content of a message.
         */
        fun redacted(redacted: Boolean): FluentBuilder
        /**
         * The message sender.
         */
        fun sender(sender: Identity): FluentBuilder
        /**
         * The message type.
         */
        fun type(type: ChannelMessageType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ARN of the channel.
         */
        var channelArn: String?
        /**
         * The message content.
         */
        var content: String?
        /**
         * The time at which the message was created.
         */
        var createdTimestamp: Instant?
        /**
         * The time at which a message was edited.
         */
        var lastEditedTimestamp: Instant?
        /**
         * The time at which a message was updated.
         */
        var lastUpdatedTimestamp: Instant?
        /**
         * The ID of a message.
         */
        var messageId: String?
        /**
         * The message metadata.
         */
        var metadata: String?
        /**
         * The persistence setting for a channel message.
         */
        var persistence: ChannelMessagePersistenceType?
        /**
         * Hides the content of a message.
         */
        var redacted: Boolean
        /**
         * The message sender.
         */
        var sender: Identity?
        /**
         * The message type.
         */
        var type: ChannelMessageType?

        fun build(): ChannelMessage
        /**
         * construct an [aws.sdk.kotlin.services.chime.model.Identity] inside the given [block]
         */
        fun sender(block: Identity.DslBuilder.() -> kotlin.Unit) {
            this.sender = Identity.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var channelArn: String? = null
        override var content: String? = null
        override var createdTimestamp: Instant? = null
        override var lastEditedTimestamp: Instant? = null
        override var lastUpdatedTimestamp: Instant? = null
        override var messageId: String? = null
        override var metadata: String? = null
        override var persistence: ChannelMessagePersistenceType? = null
        override var redacted: Boolean = false
        override var sender: Identity? = null
        override var type: ChannelMessageType? = null

        constructor(x: ChannelMessage) : this() {
            this.channelArn = x.channelArn
            this.content = x.content
            this.createdTimestamp = x.createdTimestamp
            this.lastEditedTimestamp = x.lastEditedTimestamp
            this.lastUpdatedTimestamp = x.lastUpdatedTimestamp
            this.messageId = x.messageId
            this.metadata = x.metadata
            this.persistence = x.persistence
            this.redacted = x.redacted
            this.sender = x.sender
            this.type = x.type
        }

        override fun build(): ChannelMessage = ChannelMessage(this)
        override fun channelArn(channelArn: String): FluentBuilder = apply { this.channelArn = channelArn }
        override fun content(content: String): FluentBuilder = apply { this.content = content }
        override fun createdTimestamp(createdTimestamp: Instant): FluentBuilder = apply { this.createdTimestamp = createdTimestamp }
        override fun lastEditedTimestamp(lastEditedTimestamp: Instant): FluentBuilder = apply { this.lastEditedTimestamp = lastEditedTimestamp }
        override fun lastUpdatedTimestamp(lastUpdatedTimestamp: Instant): FluentBuilder = apply { this.lastUpdatedTimestamp = lastUpdatedTimestamp }
        override fun messageId(messageId: String): FluentBuilder = apply { this.messageId = messageId }
        override fun metadata(metadata: String): FluentBuilder = apply { this.metadata = metadata }
        override fun persistence(persistence: ChannelMessagePersistenceType): FluentBuilder = apply { this.persistence = persistence }
        override fun redacted(redacted: Boolean): FluentBuilder = apply { this.redacted = redacted }
        override fun sender(sender: Identity): FluentBuilder = apply { this.sender = sender }
        override fun type(type: ChannelMessageType): FluentBuilder = apply { this.type = type }
    }
}
