// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary of the messages in a Channel.
 */
class ChannelMessageSummary private constructor(builder: BuilderImpl) {
    /**
     * The content of the message.
     */
    val content: String? = builder.content
    /**
     * The time at which the message summary was created.
     */
    val createdTimestamp: Instant? = builder.createdTimestamp
    /**
     * The time at which a message was last edited.
     */
    val lastEditedTimestamp: Instant? = builder.lastEditedTimestamp
    /**
     * The time at which a message was last updated.
     */
    val lastUpdatedTimestamp: Instant? = builder.lastUpdatedTimestamp
    /**
     * The ID of the message.
     */
    val messageId: String? = builder.messageId
    /**
     * The metadata of the message.
     */
    val metadata: String? = builder.metadata
    /**
     * Indicates whether a message was redacted.
     */
    val redacted: Boolean = builder.redacted
    /**
     * The message sender.
     */
    val sender: Identity? = builder.sender
    /**
     * The type of message.
     */
    val type: ChannelMessageType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ChannelMessageSummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ChannelMessageSummary(")
        append("content=*** Sensitive Data Redacted ***,")
        append("createdTimestamp=$createdTimestamp,")
        append("lastEditedTimestamp=$lastEditedTimestamp,")
        append("lastUpdatedTimestamp=$lastUpdatedTimestamp,")
        append("messageId=$messageId,")
        append("metadata=*** Sensitive Data Redacted ***,")
        append("redacted=$redacted,")
        append("sender=$sender,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = content?.hashCode() ?: 0
        result = 31 * result + (createdTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lastEditedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (messageId?.hashCode() ?: 0)
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (redacted.hashCode())
        result = 31 * result + (sender?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ChannelMessageSummary

        if (content != other.content) return false
        if (createdTimestamp != other.createdTimestamp) return false
        if (lastEditedTimestamp != other.lastEditedTimestamp) return false
        if (lastUpdatedTimestamp != other.lastUpdatedTimestamp) return false
        if (messageId != other.messageId) return false
        if (metadata != other.metadata) return false
        if (redacted != other.redacted) return false
        if (sender != other.sender) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ChannelMessageSummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ChannelMessageSummary
        /**
         * The content of the message.
         */
        fun content(content: String): FluentBuilder
        /**
         * The time at which the message summary was created.
         */
        fun createdTimestamp(createdTimestamp: Instant): FluentBuilder
        /**
         * The time at which a message was last edited.
         */
        fun lastEditedTimestamp(lastEditedTimestamp: Instant): FluentBuilder
        /**
         * The time at which a message was last updated.
         */
        fun lastUpdatedTimestamp(lastUpdatedTimestamp: Instant): FluentBuilder
        /**
         * The ID of the message.
         */
        fun messageId(messageId: String): FluentBuilder
        /**
         * The metadata of the message.
         */
        fun metadata(metadata: String): FluentBuilder
        /**
         * Indicates whether a message was redacted.
         */
        fun redacted(redacted: Boolean): FluentBuilder
        /**
         * The message sender.
         */
        fun sender(sender: Identity): FluentBuilder
        /**
         * The type of message.
         */
        fun type(type: ChannelMessageType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The content of the message.
         */
        var content: String?
        /**
         * The time at which the message summary was created.
         */
        var createdTimestamp: Instant?
        /**
         * The time at which a message was last edited.
         */
        var lastEditedTimestamp: Instant?
        /**
         * The time at which a message was last updated.
         */
        var lastUpdatedTimestamp: Instant?
        /**
         * The ID of the message.
         */
        var messageId: String?
        /**
         * The metadata of the message.
         */
        var metadata: String?
        /**
         * Indicates whether a message was redacted.
         */
        var redacted: Boolean
        /**
         * The message sender.
         */
        var sender: Identity?
        /**
         * The type of message.
         */
        var type: ChannelMessageType?

        fun build(): ChannelMessageSummary
        /**
         * construct an [aws.sdk.kotlin.services.chime.model.Identity] inside the given [block]
         */
        fun sender(block: Identity.DslBuilder.() -> kotlin.Unit) {
            this.sender = Identity.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var content: String? = null
        override var createdTimestamp: Instant? = null
        override var lastEditedTimestamp: Instant? = null
        override var lastUpdatedTimestamp: Instant? = null
        override var messageId: String? = null
        override var metadata: String? = null
        override var redacted: Boolean = false
        override var sender: Identity? = null
        override var type: ChannelMessageType? = null

        constructor(x: ChannelMessageSummary) : this() {
            this.content = x.content
            this.createdTimestamp = x.createdTimestamp
            this.lastEditedTimestamp = x.lastEditedTimestamp
            this.lastUpdatedTimestamp = x.lastUpdatedTimestamp
            this.messageId = x.messageId
            this.metadata = x.metadata
            this.redacted = x.redacted
            this.sender = x.sender
            this.type = x.type
        }

        override fun build(): ChannelMessageSummary = ChannelMessageSummary(this)
        override fun content(content: String): FluentBuilder = apply { this.content = content }
        override fun createdTimestamp(createdTimestamp: Instant): FluentBuilder = apply { this.createdTimestamp = createdTimestamp }
        override fun lastEditedTimestamp(lastEditedTimestamp: Instant): FluentBuilder = apply { this.lastEditedTimestamp = lastEditedTimestamp }
        override fun lastUpdatedTimestamp(lastUpdatedTimestamp: Instant): FluentBuilder = apply { this.lastUpdatedTimestamp = lastUpdatedTimestamp }
        override fun messageId(messageId: String): FluentBuilder = apply { this.messageId = messageId }
        override fun metadata(metadata: String): FluentBuilder = apply { this.metadata = metadata }
        override fun redacted(redacted: Boolean): FluentBuilder = apply { this.redacted = redacted }
        override fun sender(sender: Identity): FluentBuilder = apply { this.sender = sender }
        override fun type(type: ChannelMessageType): FluentBuilder = apply { this.type = type }
    }
}
