// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary of the details of a Channel.
 */
class ChannelSummary private constructor(builder: BuilderImpl) {
    /**
     * The ARN of the channel.
     */
    val channelArn: String? = builder.channelArn
    /**
     * The time at which the last message in a channel was sent.
     */
    val lastMessageTimestamp: Instant? = builder.lastMessageTimestamp
    /**
     * The metadata of the channel.
     */
    val metadata: String? = builder.metadata
    /**
     * The mode of the channel.
     */
    val mode: ChannelMode? = builder.mode
    /**
     * The name of the channel.
     */
    val name: String? = builder.name
    /**
     * The privacy setting of the channel.
     */
    val privacy: ChannelPrivacy? = builder.privacy

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ChannelSummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ChannelSummary(")
        append("channelArn=$channelArn,")
        append("lastMessageTimestamp=$lastMessageTimestamp,")
        append("metadata=*** Sensitive Data Redacted ***,")
        append("mode=$mode,")
        append("name=*** Sensitive Data Redacted ***,")
        append("privacy=$privacy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelArn?.hashCode() ?: 0
        result = 31 * result + (lastMessageTimestamp?.hashCode() ?: 0)
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (privacy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ChannelSummary

        if (channelArn != other.channelArn) return false
        if (lastMessageTimestamp != other.lastMessageTimestamp) return false
        if (metadata != other.metadata) return false
        if (mode != other.mode) return false
        if (name != other.name) return false
        if (privacy != other.privacy) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ChannelSummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ChannelSummary
        /**
         * The ARN of the channel.
         */
        fun channelArn(channelArn: String): FluentBuilder
        /**
         * The time at which the last message in a channel was sent.
         */
        fun lastMessageTimestamp(lastMessageTimestamp: Instant): FluentBuilder
        /**
         * The metadata of the channel.
         */
        fun metadata(metadata: String): FluentBuilder
        /**
         * The mode of the channel.
         */
        fun mode(mode: ChannelMode): FluentBuilder
        /**
         * The name of the channel.
         */
        fun name(name: String): FluentBuilder
        /**
         * The privacy setting of the channel.
         */
        fun privacy(privacy: ChannelPrivacy): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ARN of the channel.
         */
        var channelArn: String?
        /**
         * The time at which the last message in a channel was sent.
         */
        var lastMessageTimestamp: Instant?
        /**
         * The metadata of the channel.
         */
        var metadata: String?
        /**
         * The mode of the channel.
         */
        var mode: ChannelMode?
        /**
         * The name of the channel.
         */
        var name: String?
        /**
         * The privacy setting of the channel.
         */
        var privacy: ChannelPrivacy?

        fun build(): ChannelSummary
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var channelArn: String? = null
        override var lastMessageTimestamp: Instant? = null
        override var metadata: String? = null
        override var mode: ChannelMode? = null
        override var name: String? = null
        override var privacy: ChannelPrivacy? = null

        constructor(x: ChannelSummary) : this() {
            this.channelArn = x.channelArn
            this.lastMessageTimestamp = x.lastMessageTimestamp
            this.metadata = x.metadata
            this.mode = x.mode
            this.name = x.name
            this.privacy = x.privacy
        }

        override fun build(): ChannelSummary = ChannelSummary(this)
        override fun channelArn(channelArn: String): FluentBuilder = apply { this.channelArn = channelArn }
        override fun lastMessageTimestamp(lastMessageTimestamp: Instant): FluentBuilder = apply { this.lastMessageTimestamp = lastMessageTimestamp }
        override fun metadata(metadata: String): FluentBuilder = apply { this.metadata = metadata }
        override fun mode(mode: ChannelMode): FluentBuilder = apply { this.mode = mode }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun privacy(privacy: ChannelPrivacy): FluentBuilder = apply { this.privacy = privacy }
    }
}
