// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model



class CreateChannelRequest private constructor(builder: BuilderImpl) {
    /**
     * The ARN of the channel request.
     */
    val appInstanceArn: String? = builder.appInstanceArn
    /**
     * The AppInstanceUserArn of the user that makes the API call.
     */
    val chimeBearer: String? = builder.chimeBearer
    /**
     * The client token for the request. An Idempotency token.
     */
    val clientRequestToken: String? = builder.clientRequestToken
    /**
     * The metadata of the creation request. Limited to 1KB and UTF-8.
     */
    val metadata: String? = builder.metadata
    /**
     * The channel mode: UNRESTRICTED or RESTRICTED. Administrators,
     * moderators, and channel members can add themselves and other members to unrestricted
     * channels. Only administrators and moderators can add members to restricted channels.
     */
    val mode: ChannelMode? = builder.mode
    /**
     * The name of the channel.
     */
    val name: String? = builder.name
    /**
     * The channel's privacy level: PUBLIC or PRIVATE. Private
     * channels aren't discoverable by users outside the channel. Public channels are discoverable
     * by anyone in the AppInstance.
     */
    val privacy: ChannelPrivacy? = builder.privacy
    /**
     * The tags for the creation request.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateChannelRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateChannelRequest(")
        append("appInstanceArn=$appInstanceArn,")
        append("chimeBearer=$chimeBearer,")
        append("clientRequestToken=*** Sensitive Data Redacted ***,")
        append("metadata=*** Sensitive Data Redacted ***,")
        append("mode=$mode,")
        append("name=*** Sensitive Data Redacted ***,")
        append("privacy=$privacy,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appInstanceArn?.hashCode() ?: 0
        result = 31 * result + (chimeBearer?.hashCode() ?: 0)
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (privacy?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateChannelRequest

        if (appInstanceArn != other.appInstanceArn) return false
        if (chimeBearer != other.chimeBearer) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (metadata != other.metadata) return false
        if (mode != other.mode) return false
        if (name != other.name) return false
        if (privacy != other.privacy) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateChannelRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateChannelRequest
        /**
         * The ARN of the channel request.
         */
        fun appInstanceArn(appInstanceArn: String): FluentBuilder
        /**
         * The AppInstanceUserArn of the user that makes the API call.
         */
        fun chimeBearer(chimeBearer: String): FluentBuilder
        /**
         * The client token for the request. An Idempotency token.
         */
        fun clientRequestToken(clientRequestToken: String): FluentBuilder
        /**
         * The metadata of the creation request. Limited to 1KB and UTF-8.
         */
        fun metadata(metadata: String): FluentBuilder
        /**
         * The channel mode: UNRESTRICTED or RESTRICTED. Administrators,
         * moderators, and channel members can add themselves and other members to unrestricted
         * channels. Only administrators and moderators can add members to restricted channels.
         */
        fun mode(mode: ChannelMode): FluentBuilder
        /**
         * The name of the channel.
         */
        fun name(name: String): FluentBuilder
        /**
         * The channel's privacy level: PUBLIC or PRIVATE. Private
         * channels aren't discoverable by users outside the channel. Public channels are discoverable
         * by anyone in the AppInstance.
         */
        fun privacy(privacy: ChannelPrivacy): FluentBuilder
        /**
         * The tags for the creation request.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ARN of the channel request.
         */
        var appInstanceArn: String?
        /**
         * The AppInstanceUserArn of the user that makes the API call.
         */
        var chimeBearer: String?
        /**
         * The client token for the request. An Idempotency token.
         */
        var clientRequestToken: String?
        /**
         * The metadata of the creation request. Limited to 1KB and UTF-8.
         */
        var metadata: String?
        /**
         * The channel mode: UNRESTRICTED or RESTRICTED. Administrators,
         * moderators, and channel members can add themselves and other members to unrestricted
         * channels. Only administrators and moderators can add members to restricted channels.
         */
        var mode: ChannelMode?
        /**
         * The name of the channel.
         */
        var name: String?
        /**
         * The channel's privacy level: PUBLIC or PRIVATE. Private
         * channels aren't discoverable by users outside the channel. Public channels are discoverable
         * by anyone in the AppInstance.
         */
        var privacy: ChannelPrivacy?
        /**
         * The tags for the creation request.
         */
        var tags: List<Tag>?

        fun build(): CreateChannelRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var appInstanceArn: String? = null
        override var chimeBearer: String? = null
        override var clientRequestToken: String? = null
        override var metadata: String? = null
        override var mode: ChannelMode? = null
        override var name: String? = null
        override var privacy: ChannelPrivacy? = null
        override var tags: List<Tag>? = null

        constructor(x: CreateChannelRequest) : this() {
            this.appInstanceArn = x.appInstanceArn
            this.chimeBearer = x.chimeBearer
            this.clientRequestToken = x.clientRequestToken
            this.metadata = x.metadata
            this.mode = x.mode
            this.name = x.name
            this.privacy = x.privacy
            this.tags = x.tags
        }

        override fun build(): CreateChannelRequest = CreateChannelRequest(this)
        override fun appInstanceArn(appInstanceArn: String): FluentBuilder = apply { this.appInstanceArn = appInstanceArn }
        override fun chimeBearer(chimeBearer: String): FluentBuilder = apply { this.chimeBearer = chimeBearer }
        override fun clientRequestToken(clientRequestToken: String): FluentBuilder = apply { this.clientRequestToken = clientRequestToken }
        override fun metadata(metadata: String): FluentBuilder = apply { this.metadata = metadata }
        override fun mode(mode: ChannelMode): FluentBuilder = apply { this.mode = mode }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun privacy(privacy: ChannelPrivacy): FluentBuilder = apply { this.privacy = privacy }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
