// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model



class CreateMediaCapturePipelineRequest private constructor(builder: BuilderImpl) {
    /**
     * The token assigned to the client making the pipeline request.
     */
    val clientRequestToken: String? = builder.clientRequestToken
    /**
     * The ARN of the sink type.
     */
    val sinkArn: String? = builder.sinkArn
    /**
     * Destination type to which the media artifacts are saved. You must use an S3 bucket.
     */
    val sinkType: MediaPipelineSinkType? = builder.sinkType
    /**
     * ARN of the source from which the media artifacts are captured.
     */
    val sourceArn: String? = builder.sourceArn
    /**
     * Source type from which the media artifacts will be captured. A Chime SDK Meeting
     * is the only supported source.
     */
    val sourceType: MediaPipelineSourceType? = builder.sourceType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateMediaCapturePipelineRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateMediaCapturePipelineRequest(")
        append("clientRequestToken=*** Sensitive Data Redacted ***,")
        append("sinkArn=*** Sensitive Data Redacted ***,")
        append("sinkType=$sinkType,")
        append("sourceArn=*** Sensitive Data Redacted ***,")
        append("sourceType=$sourceType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (sinkArn?.hashCode() ?: 0)
        result = 31 * result + (sinkType?.hashCode() ?: 0)
        result = 31 * result + (sourceArn?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateMediaCapturePipelineRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (sinkArn != other.sinkArn) return false
        if (sinkType != other.sinkType) return false
        if (sourceArn != other.sourceArn) return false
        if (sourceType != other.sourceType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateMediaCapturePipelineRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateMediaCapturePipelineRequest
        /**
         * The token assigned to the client making the pipeline request.
         */
        fun clientRequestToken(clientRequestToken: String): FluentBuilder
        /**
         * The ARN of the sink type.
         */
        fun sinkArn(sinkArn: String): FluentBuilder
        /**
         * Destination type to which the media artifacts are saved. You must use an S3 bucket.
         */
        fun sinkType(sinkType: MediaPipelineSinkType): FluentBuilder
        /**
         * ARN of the source from which the media artifacts are captured.
         */
        fun sourceArn(sourceArn: String): FluentBuilder
        /**
         * Source type from which the media artifacts will be captured. A Chime SDK Meeting
         * is the only supported source.
         */
        fun sourceType(sourceType: MediaPipelineSourceType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The token assigned to the client making the pipeline request.
         */
        var clientRequestToken: String?
        /**
         * The ARN of the sink type.
         */
        var sinkArn: String?
        /**
         * Destination type to which the media artifacts are saved. You must use an S3 bucket.
         */
        var sinkType: MediaPipelineSinkType?
        /**
         * ARN of the source from which the media artifacts are captured.
         */
        var sourceArn: String?
        /**
         * Source type from which the media artifacts will be captured. A Chime SDK Meeting
         * is the only supported source.
         */
        var sourceType: MediaPipelineSourceType?

        fun build(): CreateMediaCapturePipelineRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientRequestToken: String? = null
        override var sinkArn: String? = null
        override var sinkType: MediaPipelineSinkType? = null
        override var sourceArn: String? = null
        override var sourceType: MediaPipelineSourceType? = null

        constructor(x: CreateMediaCapturePipelineRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.sinkArn = x.sinkArn
            this.sinkType = x.sinkType
            this.sourceArn = x.sourceArn
            this.sourceType = x.sourceType
        }

        override fun build(): CreateMediaCapturePipelineRequest = CreateMediaCapturePipelineRequest(this)
        override fun clientRequestToken(clientRequestToken: String): FluentBuilder = apply { this.clientRequestToken = clientRequestToken }
        override fun sinkArn(sinkArn: String): FluentBuilder = apply { this.sinkArn = sinkArn }
        override fun sinkType(sinkType: MediaPipelineSinkType): FluentBuilder = apply { this.sinkType = sinkType }
        override fun sourceArn(sourceArn: String): FluentBuilder = apply { this.sourceArn = sourceArn }
        override fun sourceType(sourceType: MediaPipelineSourceType): FluentBuilder = apply { this.sourceType = sourceType }
    }
}
