// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.chime.model



class CreateProxySessionRequest private constructor(builder: BuilderImpl) {
    /**
     * The proxy session capabilities.
     */
    val capabilities: List<Capability>? = builder.capabilities
    /**
     * The number of minutes allowed for the proxy session.
     */
    val expiryMinutes: Int? = builder.expiryMinutes
    /**
     * The preference for matching the country or area code of the proxy phone number with that of the first participant.
     */
    val geoMatchLevel: GeoMatchLevel? = builder.geoMatchLevel
    /**
     * The country and area code for the proxy phone number.
     */
    val geoMatchParams: GeoMatchParams? = builder.geoMatchParams
    /**
     * The name of the proxy session.
     */
    val name: String? = builder.name
    /**
     * The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.
     */
    val numberSelectionBehavior: NumberSelectionBehavior? = builder.numberSelectionBehavior
    /**
     * The participant phone numbers.
     */
    val participantPhoneNumbers: List<String>? = builder.participantPhoneNumbers
    /**
     * The Amazon Chime voice connector ID.
     */
    val voiceConnectorId: String? = builder.voiceConnectorId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateProxySessionRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateProxySessionRequest(")
        append("capabilities=$capabilities,")
        append("expiryMinutes=$expiryMinutes,")
        append("geoMatchLevel=$geoMatchLevel,")
        append("geoMatchParams=$geoMatchParams,")
        append("name=*** Sensitive Data Redacted ***,")
        append("numberSelectionBehavior=$numberSelectionBehavior,")
        append("participantPhoneNumbers=$participantPhoneNumbers,")
        append("voiceConnectorId=$voiceConnectorId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = capabilities?.hashCode() ?: 0
        result = 31 * result + (expiryMinutes ?: 0)
        result = 31 * result + (geoMatchLevel?.hashCode() ?: 0)
        result = 31 * result + (geoMatchParams?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (numberSelectionBehavior?.hashCode() ?: 0)
        result = 31 * result + (participantPhoneNumbers?.hashCode() ?: 0)
        result = 31 * result + (voiceConnectorId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateProxySessionRequest

        if (capabilities != other.capabilities) return false
        if (expiryMinutes != other.expiryMinutes) return false
        if (geoMatchLevel != other.geoMatchLevel) return false
        if (geoMatchParams != other.geoMatchParams) return false
        if (name != other.name) return false
        if (numberSelectionBehavior != other.numberSelectionBehavior) return false
        if (participantPhoneNumbers != other.participantPhoneNumbers) return false
        if (voiceConnectorId != other.voiceConnectorId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateProxySessionRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateProxySessionRequest
        /**
         * The proxy session capabilities.
         */
        fun capabilities(capabilities: List<Capability>): FluentBuilder
        /**
         * The number of minutes allowed for the proxy session.
         */
        fun expiryMinutes(expiryMinutes: Int): FluentBuilder
        /**
         * The preference for matching the country or area code of the proxy phone number with that of the first participant.
         */
        fun geoMatchLevel(geoMatchLevel: GeoMatchLevel): FluentBuilder
        /**
         * The country and area code for the proxy phone number.
         */
        fun geoMatchParams(geoMatchParams: GeoMatchParams): FluentBuilder
        /**
         * The name of the proxy session.
         */
        fun name(name: String): FluentBuilder
        /**
         * The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.
         */
        fun numberSelectionBehavior(numberSelectionBehavior: NumberSelectionBehavior): FluentBuilder
        /**
         * The participant phone numbers.
         */
        fun participantPhoneNumbers(participantPhoneNumbers: List<String>): FluentBuilder
        /**
         * The Amazon Chime voice connector ID.
         */
        fun voiceConnectorId(voiceConnectorId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The proxy session capabilities.
         */
        var capabilities: List<Capability>?
        /**
         * The number of minutes allowed for the proxy session.
         */
        var expiryMinutes: Int?
        /**
         * The preference for matching the country or area code of the proxy phone number with that of the first participant.
         */
        var geoMatchLevel: GeoMatchLevel?
        /**
         * The country and area code for the proxy phone number.
         */
        var geoMatchParams: GeoMatchParams?
        /**
         * The name of the proxy session.
         */
        var name: String?
        /**
         * The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.
         */
        var numberSelectionBehavior: NumberSelectionBehavior?
        /**
         * The participant phone numbers.
         */
        var participantPhoneNumbers: List<String>?
        /**
         * The Amazon Chime voice connector ID.
         */
        var voiceConnectorId: String?

        fun build(): CreateProxySessionRequest
        /**
         * construct an [aws.sdk.kotlin.services.chime.model.GeoMatchParams] inside the given [block]
         */
        fun geoMatchParams(block: GeoMatchParams.DslBuilder.() -> kotlin.Unit) {
            this.geoMatchParams = GeoMatchParams.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var capabilities: List<Capability>? = null
        override var expiryMinutes: Int? = null
        override var geoMatchLevel: GeoMatchLevel? = null
        override var geoMatchParams: GeoMatchParams? = null
        override var name: String? = null
        override var numberSelectionBehavior: NumberSelectionBehavior? = null
        override var participantPhoneNumbers: List<String>? = null
        override var voiceConnectorId: String? = null

        constructor(x: CreateProxySessionRequest) : this() {
            this.capabilities = x.capabilities
            this.expiryMinutes = x.expiryMinutes
            this.geoMatchLevel = x.geoMatchLevel
            this.geoMatchParams = x.geoMatchParams
            this.name = x.name
            this.numberSelectionBehavior = x.numberSelectionBehavior
            this.participantPhoneNumbers = x.participantPhoneNumbers
            this.voiceConnectorId = x.voiceConnectorId
        }

        override fun build(): CreateProxySessionRequest = CreateProxySessionRequest(this)
        override fun capabilities(capabilities: List<Capability>): FluentBuilder = apply { this.capabilities = capabilities }
        override fun expiryMinutes(expiryMinutes: Int): FluentBuilder = apply { this.expiryMinutes = expiryMinutes }
        override fun geoMatchLevel(geoMatchLevel: GeoMatchLevel): FluentBuilder = apply { this.geoMatchLevel = geoMatchLevel }
        override fun geoMatchParams(geoMatchParams: GeoMatchParams): FluentBuilder = apply { this.geoMatchParams = geoMatchParams }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun numberSelectionBehavior(numberSelectionBehavior: NumberSelectionBehavior): FluentBuilder = apply { this.numberSelectionBehavior = numberSelectionBehavior }
        override fun participantPhoneNumbers(participantPhoneNumbers: List<String>): FluentBuilder = apply { this.participantPhoneNumbers = participantPhoneNumbers }
        override fun voiceConnectorId(voiceConnectorId: String): FluentBuilder = apply { this.voiceConnectorId = voiceConnectorId }
    }
}
